/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.devmodules.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ServerString;
import org.netbeans.modules.j2ee.deployment.impl.TargetModule;
import org.netbeans.modules.j2ee.deployment.impl.TargetServer;
import org.netbeans.modules.j2ee.deployment.impl.projects.DeploymentTargetImpl;
import org.netbeans.modules.j2ee.deployment.impl.ui.ProgressUI;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public final class Deployment {
    private static boolean alsoStartTargets = true;
    private static Deployment instance = null;

    public static synchronized Deployment getDefault() {
        if (instance == null) {
            instance = new Deployment();
        }
        return instance;
    }

    private Deployment() {
    }

    public String deploy(J2eeModuleProvider jmp, boolean debugmode, String clientModuleUrl, String clientUrlPart, boolean forceRedeploy) throws DeploymentException {
        return this.deploy(jmp, debugmode, clientModuleUrl, clientUrlPart, forceRedeploy, null);
    }

    public String deploy(J2eeModuleProvider jmp, boolean debugmode, String clientModuleUrl, String clientUrlPart, boolean forceRedeploy, Logger logger) throws DeploymentException {
        DeploymentTargetImpl target = new DeploymentTargetImpl(jmp, clientModuleUrl);
        TargetModuleID[] modules = null;
        J2eeModule module = target.getModule();
        String title = NbBundle.getMessage(Deployment.class, (String)"LBL_Deploying", (Object)jmp.getDeploymentName());
        ProgressUI progress = new ProgressUI(title, false, logger);
        try {
            progress.start();
            ServerString server = target.getServer();
            if (module == null) {
                String msg = NbBundle.getMessage(Deployment.class, (String)"MSG_NoJ2eeModule");
                throw new DeploymentException(msg);
            }
            if (server == null || server.getServerInstance() == null) {
                String msg = NbBundle.getMessage(Deployment.class, (String)"MSG_NoTargetServer");
                throw new DeploymentException(msg);
            }
            boolean serverReady = false;
            TargetServer targetserver = new TargetServer(target);
            if (alsoStartTargets || debugmode) {
                targetserver.startTargets(debugmode, progress);
            } else {
                server.getServerInstance().start(progress);
            }
            jmp.deployDatasources();
            modules = targetserver.deploy(progress, forceRedeploy);
            targetserver.notifyIncrementalDeployment(modules);
            if (modules == null || modules.length <= 0) {
                String msg = NbBundle.getMessage(Deployment.class, (String)"MSG_ModuleNotDeployed");
                throw new DeploymentException(msg);
            }
            target.setTargetModules((TargetModule[])modules);
            String string = target.getClientUrl(clientUrlPart);
            return string;
        }
        catch (Exception ex) {
            String msg = NbBundle.getMessage(Deployment.class, (String)"MSG_DeployFailed", (Object)ex.getLocalizedMessage());
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            throw new DeploymentException(msg, ex);
        }
        finally {
            if (progress != null) {
                progress.finish();
            }
        }
    }

    public String[] getServerInstanceIDs() {
        return InstanceProperties.getInstanceList();
    }

    public String[] getServerInstanceIDs(Object[] moduleTypes) {
        return this.getServerInstanceIDs(moduleTypes, null, null);
    }

    public String[] getServerInstanceIDs(Object[] moduleTypes, String specVersion) {
        return this.getServerInstanceIDs(moduleTypes, specVersion, null);
    }

    public String[] getServerInstanceIDs(Object[] moduleTypes, String specVersion, String[] tools) {
        ArrayList<String> result = new ArrayList<String>();
        String[] serverInstanceIDs = this.getServerInstanceIDs();
        for (int i = 0; i < serverInstanceIDs.length; ++i) {
            J2eePlatform platform = this.getJ2eePlatform(serverInstanceIDs[i]);
            if (platform == null) continue;
            boolean isOk = true;
            if (moduleTypes != null) {
                Set platModuleTypes = platform.getSupportedModuleTypes();
                for (int j = 0; j < moduleTypes.length; ++j) {
                    if (platModuleTypes.contains(moduleTypes[j])) continue;
                    isOk = false;
                }
            }
            if (isOk && specVersion != null) {
                Set platSpecVers = platform.getSupportedSpecVersions();
                isOk = specVersion.equals("1.3") ? platSpecVers.contains("1.3") || platSpecVers.contains("1.4") : platSpecVers.contains(specVersion);
            }
            if (isOk && tools != null) {
                for (int j = 0; j < tools.length; ++j) {
                    if (platform.isToolSupported(tools[j])) continue;
                    isOk = false;
                }
            }
            if (!isOk) continue;
            result.add(serverInstanceIDs[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getServerInstanceDisplayName(String id) {
        return ServerRegistry.getInstance().getServerInstance(id).getDisplayName();
    }

    public String getServerID(String instanceId) {
        ServerInstance si = ServerRegistry.getInstance().getServerInstance(instanceId);
        if (si != null) {
            return si.getServer().getShortName();
        }
        return null;
    }

    public String getDefaultServerInstanceID() {
        ServerInstance si;
        ServerString defInst = ServerRegistry.getInstance().getDefaultInstance();
        if (defInst != null && (si = defInst.getServerInstance()) != null) {
            return si.getUrl();
        }
        return null;
    }

    public String[] getInstancesOfServer(String id) {
        Server server;
        if (id != null && (server = ServerRegistry.getInstance().getServer(id)) != null) {
            ServerInstance[] sis = ServerRegistry.getInstance().getServer(id).getInstances();
            String[] ids = new String[sis.length];
            for (int i = 0; i < sis.length; ++i) {
                ids[i] = sis[i].getUrl();
            }
            return ids;
        }
        return new String[0];
    }

    public String[] getServerIDs() {
        Collection c = ServerRegistry.getInstance().getServers();
        String[] ids = new String[c.size()];
        Iterator iter = c.iterator();
        for (int i = 0; i < c.size(); ++i) {
            Server s = (Server)iter.next();
            ids[i] = s.getShortName();
        }
        return ids;
    }

    public J2eePlatform getJ2eePlatform(String serverInstanceID) {
        ServerInstance serInst = ServerRegistry.getInstance().getServerInstance(serverInstanceID);
        if (serInst == null) {
            return null;
        }
        return J2eePlatform.create(serInst);
    }

    public String getServerDisplayName(String id) {
        return ServerRegistry.getInstance().getServer(id).getDisplayName();
    }

    public final void addInstanceListener(InstanceListener l) {
        ServerRegistry.getInstance().addInstanceListener(l);
    }

    public final void removeInstanceListener(InstanceListener l) {
        ServerRegistry.getInstance().removeInstanceListener(l);
    }

    public static interface Logger {
        public void log(String var1);
    }

    public static final class DeploymentException
    extends Exception {
        private DeploymentException(String msg) {
            super(msg);
        }

        private DeploymentException(Throwable t) {
            super(t);
        }

        private DeploymentException(String s, Throwable t) {
            super(s, t);
        }

        public String toString() {
            String s = this.getClass().getName();
            String message = this.getLocalizedMessage();
            return message != null ? message : s;
        }
    }
}

