/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.docscan;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import org.netbeans.modules.tasklist.client.Suggestion;
import org.netbeans.modules.tasklist.client.SuggestionAgent;
import org.netbeans.modules.tasklist.client.SuggestionManager;
import org.netbeans.modules.tasklist.core.TLUtils;
import org.netbeans.modules.tasklist.docscan.Cache;
import org.netbeans.modules.tasklist.docscan.Settings;
import org.netbeans.modules.tasklist.docscan.SourceCodeCommentParser;
import org.netbeans.modules.tasklist.docscan.TaskTag;
import org.netbeans.modules.tasklist.providers.DocumentSuggestionProvider;
import org.netbeans.modules.tasklist.providers.SuggestionContext;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.WeakSet;

public final class SourceTaskProvider
extends DocumentSuggestionProvider
implements PropertyChangeListener {
    static final String TYPE = "nb-tasklist-scannedtask";
    private WeakSet agents = new WeakSet();
    private SuggestionContext env;
    private Settings settings;

    public String getType() {
        return TYPE;
    }

    public void notifyFinish() {
        Cache.store();
        this.settings = null;
    }

    public void notifyPrepare() {
        this.settings = (Settings)Settings.findObject((Class)Settings.class, (boolean)true);
    }

    public void notifyRun() {
        this.settings().addPropertyChangeListener(this);
    }

    public void notifyStop() {
        this.settings().removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if (("taskTags".equals(ev.getPropertyName()) || "skipComments".equals(ev.getPropertyName())) && this.env == null) {
            return;
        }
    }

    public List scan(SuggestionContext env) {
        SuggestionManager manager = SuggestionManager.getDefault();
        if (!manager.isEnabled(TYPE)) {
            return null;
        }
        try {
            List cached;
            if (!DataObject.find((FileObject)env.getFileObject()).isModified() && (cached = Cache.get(env)) != null) {
                return cached;
            }
        }
        catch (DataObjectNotFoundException e) {
            // empty catch block
        }
        boolean skipCode = this.settings().getSkipComments();
        List tasks = skipCode ? this.scanCommentsOnly(env) : this.scanAll(env);
        Cache.put(env, tasks);
        return tasks;
    }

    private List scanCommentsOnly(SuggestionContext env) {
        ArrayList<Suggestion> newTasks = new ArrayList<Suggestion>();
        String suffix = env.getFileObject().getExt();
        SourceCodeCommentParser sccp = suffix.equalsIgnoreCase("java") || suffix.equalsIgnoreCase("c") || suffix.equalsIgnoreCase("cpp") ? new SourceCodeCommentParser("//", "/*", "*/") : (suffix.equalsIgnoreCase("html") || suffix.equalsIgnoreCase("htm") || suffix.equalsIgnoreCase("xml") ? new SourceCodeCommentParser("<!--", "-->") : (suffix.equalsIgnoreCase("jsp") ? new SourceCodeCommentParser("<%--", "--%>") : (suffix.equalsIgnoreCase("sh") ? new SourceCodeCommentParser("#") : new SourceCodeCommentParser())));
        CharSequence text = env.getCharSequence();
        sccp.setDocument(env);
        SourceCodeCommentParser.CommentRegion reg = new SourceCodeCommentParser.CommentRegion();
        TaskTag matchTag = null;
        try {
            Matcher matcher = this.settings.getTaskTags().getScanRegexp().matcher(text);
            int len = text.length();
            int lineno = 1;
            int index = 0;
            int idx = 0;
            if (!sccp.nextRegion(reg)) {
                return newTasks;
            }
            while (index < len && matcher.find(index)) {
                boolean goahead;
                int begin = matcher.start();
                int end = matcher.end();
                boolean toosoon = false;
                do {
                    goahead = true;
                    if (begin < reg.start) {
                        toosoon = true;
                        continue;
                    }
                    if (begin <= reg.stop) continue;
                    goahead = false;
                    if (sccp.nextRegion(reg)) continue;
                    return newTasks;
                } while (!goahead);
                if (toosoon) {
                    index = end;
                    continue;
                }
                matchTag = this.getTag(text, begin, end);
                int c = 97;
                int nonwhite = begin;
                while (begin >= index) {
                    char c2 = text.charAt(begin);
                    c = c2;
                    if (c2 == '\n') break;
                    if (c != 32 && c != 9) {
                        nonwhite = begin;
                    }
                    --begin;
                }
                begin = nonwhite;
                nonwhite = end;
                while (end < len && (c = (int)text.charAt(end)) != 10 && c != 13) {
                    if (c != 32 && c != 9) {
                        nonwhite = end;
                    }
                    ++end;
                }
                while (idx <= begin) {
                    if (text.charAt(idx) == '\n') {
                        ++lineno;
                    }
                    ++idx;
                }
                index = end;
                String description = ((Object)text.subSequence(begin, nonwhite + 1)).toString();
                DataObject dataObject = DataObject.find((FileObject)env.getFileObject());
                Line line = TLUtils.getLineByNumber((DataObject)dataObject, (int)lineno);
                Suggestion task = this.prepareSuggestion(matchTag, description, line);
                newTasks.add(task);
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return newTasks;
    }

    private List scanAll(SuggestionContext env) {
        ArrayList<Suggestion> newTasks = new ArrayList<Suggestion>();
        CharSequence text = env.getCharSequence();
        TaskTag matchTag = null;
        try {
            int index = 0;
            int lineno = 1;
            int len = text.length();
            Matcher matcher = this.settings().getTaskTags().getScanRegexp().matcher(text);
            while (index < len && matcher.find(index)) {
                int begin;
                int end = matcher.end();
                matchTag = this.getTag(text, begin, end);
                int c = 97;
                int nonwhite = begin;
                for (begin = matcher.start(); begin >= index; --begin) {
                    char c2 = text.charAt(begin);
                    c = c2;
                    if (c2 == '\n') break;
                    if (c == 32 || c == 9) continue;
                    nonwhite = begin;
                }
                begin = nonwhite;
                nonwhite = end;
                while (end < len && (c = (int)text.charAt(end)) != 10 && c != 13) {
                    if (c != 32 && c != 9) {
                        nonwhite = end;
                    }
                    ++end;
                }
                for (int idx = index; idx <= begin; ++idx) {
                    if (text.charAt(idx) != '\n') continue;
                    ++lineno;
                }
                index = end;
                String description = ((Object)text.subSequence(begin, nonwhite + 1)).toString();
                DataObject dataObject = DataObject.find((FileObject)env.getFileObject());
                Line line = TLUtils.getLineByNumber((DataObject)dataObject, (int)lineno);
                Suggestion task = this.prepareSuggestion(matchTag, description, line);
                newTasks.add(task);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newTasks;
    }

    private Suggestion prepareSuggestion(TaskTag matchTag, String description, Line line) {
        SuggestionAgent agent;
        Suggestion suggestion = null;
        if (line != null && (agent = this.getAgent(line)) != null) {
            suggestion = agent.getSuggestion();
            agent.setSummary(description);
            if (matchTag != null) {
                agent.setPriority(matchTag.getPriority());
            }
        }
        if (suggestion == null) {
            SuggestionManager manager = SuggestionManager.getDefault();
            SuggestionAgent agent2 = manager.createSuggestion(null, TYPE, description, null, (Object)this);
            agent2.setLine(line);
            if (matchTag != null) {
                agent2.setPriority(matchTag.getPriority());
            }
            this.agents.add((Object)agent2);
            suggestion = agent2.getSuggestion();
        }
        return suggestion;
    }

    private TaskTag getTag(CharSequence text, int start, int end) {
        TaskTag tag = this.settings().getTaskTags().getTag(text, start + 1, end - start - 1);
        return tag;
    }

    private Settings settings() {
        if (this.settings == null) {
            this.settings = (Settings)Settings.findObject((Class)Settings.class, (boolean)true);
        }
        return this.settings;
    }

    private SuggestionAgent getAgent(Line l) {
        Iterator it = this.agents.iterator();
        while (it.hasNext()) {
            SuggestionAgent next = (SuggestionAgent)it.next();
            if (next == null || !l.equals(next.getSuggestion().getLine())) continue;
            return next;
        }
        return null;
    }
}

