/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.dd.api.ejb.MethodParams;
import org.netbeans.modules.j2ee.dd.api.ejb.Query;
import org.netbeans.modules.j2ee.dd.api.ejb.QueryMethod;
import org.netbeans.modules.j2ee.ddloaders.multiview.EntityHelper;
import org.netbeans.modules.j2ee.ddloaders.multiview.Utils;

public class QueryMethodHelper {
    final Query query;
    private final EntityHelper entityHelper;
    private boolean isSelectMethod;
    private Method implementationMethod;
    public Method remoteMethod;
    public Method localMethod;
    static final /* synthetic */ boolean $assertionsDisabled;

    public QueryMethodHelper(EntityHelper helper, Query query) {
        this.query = query;
        this.entityHelper = helper;
        this.isSelectMethod = query.getQueryMethod().getMethodName().startsWith("ejbSelect");
        this.init();
    }

    protected void init() {
        QueryMethod queryMethod = this.query.getQueryMethod();
        List parameters = this.getQueryMethodParams(queryMethod);
        String methodName = queryMethod.getMethodName();
        JavaClass beanClass = this.entityHelper.getBeanClass();
        this.implementationMethod = beanClass == null ? null : beanClass.getMethod(methodName, parameters, false);
        this.remoteMethod = QueryMethodHelper.getMethod(this.entityHelper.getHomeInterfaceClass(), methodName, parameters);
        this.localMethod = QueryMethodHelper.getMethod(this.entityHelper.getLocalHomeInterfaceClass(), methodName, parameters);
    }

    private static Method getMethod(JavaClass javaClass, String methodName, List parameters) {
        return javaClass == null ? null : javaClass.getMethod(methodName, parameters, false);
    }

    public String getMethodName() {
        return this.query.getQueryMethod().getMethodName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReturnType() {
        JMIUtils.beginJmiTransaction();
        try {
            Method method = this.getImplementationMethod();
            if (method != null) {
                Type type = method.getType();
                if (type == null) {
                    String string = null;
                    return string;
                }
                String string = type.getName();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            JMIUtils.endJmiTransaction();
        }
    }

    public boolean returnsCollection() {
        return "java.util.Collection".equals(this.getReturnType());
    }

    public String getResultInterface() {
        JavaClass localHomeClass = this.entityHelper.getLocalHomeInterfaceClass();
        JavaClass homeClass = this.entityHelper.getHomeInterfaceClass();
        QueryMethod queryMethod = this.query.getQueryMethod();
        List parameters = this.getQueryMethodParams(queryMethod);
        String methodName = queryMethod.getMethodName();
        boolean hasLocal = localHomeClass != null && localHomeClass.getMethod(methodName, parameters, false) != null;
        boolean hasRemote = homeClass != null && homeClass.getMethod(methodName, parameters, false) != null;
        String remote = "remote";
        String local = "local";
        if (hasLocal) {
            if (hasRemote) {
                return local + "+" + remote;
            }
            return local;
        }
        if (hasRemote) {
            return remote;
        }
        return "-";
    }

    private List getQueryMethodParams(QueryMethod queryMethod) {
        String[] methodParam = queryMethod.getMethodParams().getMethodParam();
        LinkedList<Type> params = new LinkedList<Type>();
        for (int i = 0; i < methodParam.length; ++i) {
            params.add(JMIUtils.resolveType((String)methodParam[i]));
        }
        return params;
    }

    public void removeQuery() {
        this.init();
        Utils.removeMethod(this.entityHelper.getBeanClass(), this.implementationMethod);
        Utils.removeMethod(this.entityHelper.getLocalHomeInterfaceClass(), this.localMethod);
        Utils.removeMethod(this.entityHelper.getHomeInterfaceClass(), this.remoteMethod);
        this.entityHelper.removeQuery(this.query);
    }

    public Method getPrototypeMethod() {
        Method prototypeMethod = JMIUtils.createMethod(null);
        Method implementationMethod = this.getImplementationMethod();
        if (implementationMethod == null) {
            QueryMethod queryMethod = this.query.getQueryMethod();
            prototypeMethod.setName(queryMethod.getMethodName());
            MethodParams queryParams = queryMethod.getMethodParams();
            List parameters = prototypeMethod.getParameters();
            int n = queryParams.sizeMethodParam();
            for (int i = 0; i < n; ++i) {
                parameters.add(JMIUtils.createParameter((Method)prototypeMethod, (String)("p" + i), (Type)JMIUtils.resolveType((String)queryParams.getMethodParam(i)), (boolean)false));
            }
            return prototypeMethod;
        }
        prototypeMethod.setName(implementationMethod.getName());
        prototypeMethod.setType(implementationMethod.getType());
        JMIUtils.replaceParameters((Method)prototypeMethod, (List)implementationMethod.getParameters());
        return prototypeMethod;
    }

    public Method getImplementationMethod() {
        Method prototypeMethod = null;
        if (this.isSelectMethod) {
            prototypeMethod = this.implementationMethod;
        } else if (this.localMethod != null) {
            prototypeMethod = this.localMethod;
        } else if (this.remoteMethod != null) {
            prototypeMethod = this.remoteMethod;
        }
        return prototypeMethod != null && prototypeMethod.isValid() ? prototypeMethod : null;
    }

    public void updateFinderMethod(Method prototype, Query query, boolean singleReturn, boolean publishToLocal, boolean publishToRemote) {
        prototype.setModifiers(0);
        this.localMethod = publishToLocal ? this.setMethod(this.localMethod, prototype, singleReturn, false) : this.removeMethod(this.localMethod, false);
        this.remoteMethod = publishToRemote ? this.setMethod(this.remoteMethod, prototype, singleReturn, true) : this.removeMethod(this.remoteMethod, true);
        this.updateQuery(query);
    }

    private void updateQuery(Query query) {
        this.query.setQueryMethod(query.getQueryMethod());
        this.query.setDescription(query.getDefaultDescription());
        this.query.setEjbQl(query.getEjbQl());
        this.entityHelper.modelUpdatedFromUI();
    }

    private Method setMethod(Method method, Method prototype, boolean singleReturn, boolean remote) {
        JavaClass interfaceClass = this.getHomeClass(remote);
        if (!$assertionsDisabled && interfaceClass == null) {
            throw new AssertionError();
        }
        this.setReturn(prototype, singleReturn, remote);
        if (method == null) {
            Utils.addMethod(interfaceClass, (Method)prototype.duplicate(), remote);
            method = Utils.getMethod(interfaceClass, prototype);
        } else {
            QueryMethodHelper.updateMethod(method, prototype);
        }
        return method;
    }

    private Method removeMethod(Method method, boolean remote) {
        Utils.removeMethod(this.getHomeClass(remote), method);
        return null;
    }

    private JavaClass getHomeClass(boolean remote) {
        return remote ? this.entityHelper.getHomeInterfaceClass() : this.entityHelper.getLocalHomeInterfaceClass();
    }

    private void setReturn(Method prototype, boolean singleReturn, boolean remote) {
        String interfaceName;
        String string = interfaceName = remote ? this.entityHelper.getRemote() : this.entityHelper.getLocal();
        String typeName = singleReturn ? interfaceName : Collection.class.getName();
        prototype.setType(JMIUtils.resolveType((String)typeName));
    }

    public void updateSelectMethod(Method prototype, Query query) {
        prototype.setModifiers(1025);
        if (this.implementationMethod == null) {
            JavaClass beanClass = this.entityHelper.getBeanClass();
            if (!$assertionsDisabled && beanClass == null) {
                throw new AssertionError();
            }
            Utils.addMethod(beanClass, prototype);
            this.implementationMethod = prototype;
        } else {
            QueryMethodHelper.updateMethod(this.implementationMethod, prototype);
        }
        this.updateQuery(query);
    }

    private static void updateMethod(Method method, Method prototype) {
        if (method != null) {
            method.setName(prototype.getName());
            method.setType(prototype.getType());
            List newParameters = prototype.getParameters();
            JMIUtils.replaceParameters((Method)method, (List)newParameters);
            Iterator it = prototype.getExceptions().iterator();
            while (it.hasNext()) {
                JMIUtils.addException((Method)method, (String)((JavaClass)it.next()).getName());
            }
            method.setModifiers(prototype.getModifiers());
        }
    }

    public QueryMethod getQueryMethod() {
        return this.query.getQueryMethod();
    }

    public String getEjbQl() {
        return this.query.getEjbQl();
    }

    public String getDefaultDescription() {
        return this.query.getDefaultDescription();
    }

    static {
        $assertionsDisabled = !QueryMethodHelper.class.desiredAssertionStatus();
    }
}

