/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jmi.reflect.JmiException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.multiview.PropertyChangeSource;
import org.netbeans.modules.j2ee.ddloaders.multiview.Utils;
import org.netbeans.modules.j2ee.ejbcore.api.codegeneration.EjbGenerationUtil;
import org.netbeans.modules.j2ee.ejbcore.api.codegeneration.EntityAndSessionGenerator;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.AbstractMethodController;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;

public abstract class EntityAndSessionHelper
implements PropertyChangeListener,
PropertyChangeSource {
    protected final EntityAndSession ejb;
    protected final EjbJarMultiViewDataObject ejbJarMultiViewDataObject;
    protected final FileObject ejbJarFile;
    protected ClassPath sourceClassPath;
    private List listeners = new LinkedList();
    public AbstractMethodController abstractMethodController;
    static /* synthetic */ Class class$java$rmi$RemoteException;

    public EntityAndSessionHelper(EjbJarMultiViewDataObject ejbJarMultiViewDataObject, EntityAndSession ejb) {
        this.ejb = ejb;
        this.ejbJarMultiViewDataObject = ejbJarMultiViewDataObject;
        this.ejbJarFile = ejbJarMultiViewDataObject.getPrimaryFile();
        this.sourceClassPath = Utils.getSourceClassPath(this.ejbJarFile);
        ejbJarMultiViewDataObject.getEjbJar().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public JavaClass getLocalBusinessInterfaceClass() {
        return this.abstractMethodController.getBeanInterface(true, true);
    }

    public JavaClass getRemoteBusinessInterfaceClass() {
        return this.abstractMethodController.getBeanInterface(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInterfaces(boolean local) {
        JMIUtils.beginJmiTransaction((boolean)true);
        boolean rollback = true;
        try {
            if (local) {
                Utils.removeClass(this.sourceClassPath, this.ejb.getLocalHome());
                this.removeBeanInterface(this.ejb.getLocal());
                JavaClass businessInterfaceClass = this.getLocalBusinessInterfaceClass();
                if (businessInterfaceClass != null) {
                    this.removeBeanInterface(businessInterfaceClass.getName());
                }
            } else {
                Utils.removeClass(this.sourceClassPath, this.ejb.getHome());
                this.removeBeanInterface(this.ejb.getRemote());
                JavaClass businessInterfaceClass = this.getRemoteBusinessInterfaceClass();
                if (businessInterfaceClass != null) {
                    this.removeBeanInterface(businessInterfaceClass.getName());
                }
            }
            rollback = false;
        }
        finally {
            JMIUtils.endJmiTransaction((boolean)rollback);
        }
        if (local) {
            this.ejb.setLocal(null);
            this.ejb.setLocalHome(null);
        } else {
            this.ejb.setRemote(null);
            this.ejb.setHome(null);
        }
        this.modelUpdatedFromUI();
    }

    public void modelUpdatedFromUI() {
        this.ejbJarMultiViewDataObject.modelUpdatedFromUI();
    }

    private void removeBeanInterface(String name) {
        JMIUtils.removeInterface((JavaClass)this.getBeanClass(), (String)name);
        Utils.removeClass(this.sourceClassPath, name);
    }

    public String getEjbClass() {
        return this.ejb.getEjbClass();
    }

    public String getLocal() {
        return this.ejb.getLocal();
    }

    public String getLocalHome() {
        return this.ejb.getLocalHome();
    }

    public String getRemote() {
        return this.ejb.getRemote();
    }

    public String getHome() {
        return this.ejb.getHome();
    }

    public String getBusinessInterfaceName(boolean local) {
        String componentInterfaceName;
        JavaClass beanInterface = this.abstractMethodController.getBeanInterface(local, true);
        if (beanInterface == null) {
            return null;
        }
        String name = beanInterface.getName();
        String string = componentInterfaceName = local ? this.ejb.getLocal() : this.ejb.getRemote();
        if (componentInterfaceName == null || componentInterfaceName.equals(name)) {
            return null;
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInterfaces(boolean local) {
        EntityAndSessionGenerator generator = this.getGenerator();
        String packageName = Utils.getPackage(this.ejb.getEjbClass());
        FileObject packageFile = Utils.getPackageFile(this.sourceClassPath, packageName);
        String ejbName = this.ejb.getEjbName();
        try {
            JMIUtils.beginJmiTransaction((boolean)true);
            boolean rollback = true;
            try {
                String homeInterfaceName;
                String componentInterfaceName;
                if (local) {
                    componentInterfaceName = EjbGenerationUtil.getLocalName((String)packageName, (String)ejbName);
                    homeInterfaceName = EjbGenerationUtil.getLocalHomeName((String)packageName, (String)ejbName);
                    String oppositeComponentInterfaceName = this.ejb.getRemote();
                    String oppositeHomeInterfaceName = this.ejb.getHome();
                    componentInterfaceName = generator.generateLocal(packageName, packageFile, componentInterfaceName, ejbName);
                    if (oppositeComponentInterfaceName != null && oppositeHomeInterfaceName != null) {
                        EntityAndSessionHelper.generateHomeInterface(oppositeHomeInterfaceName, homeInterfaceName, oppositeComponentInterfaceName, componentInterfaceName, false, packageFile);
                    } else {
                        homeInterfaceName = generator.generateLocalHome(packageName, packageFile, homeInterfaceName, componentInterfaceName, ejbName);
                        String businessInterfaceName = EjbGenerationUtil.getLocalBusinessInterfaceName((String)packageName, (String)ejbName);
                        generator.generateBusinessInterfaces(packageName, packageFile, businessInterfaceName, ejbName, this.ejb.getEjbClass(), componentInterfaceName);
                    }
                } else {
                    componentInterfaceName = EjbGenerationUtil.getRemoteName((String)packageName, (String)ejbName);
                    homeInterfaceName = EjbGenerationUtil.getHomeName((String)packageName, (String)ejbName);
                    String oppositeComponentInterfaceName = this.ejb.getLocal();
                    String oppositeHomeInterfaceName = this.ejb.getLocalHome();
                    componentInterfaceName = generator.generateRemote(packageName, packageFile, componentInterfaceName, ejbName);
                    if (oppositeComponentInterfaceName != null && oppositeHomeInterfaceName != null) {
                        EntityAndSessionHelper.generateHomeInterface(oppositeHomeInterfaceName, homeInterfaceName, oppositeComponentInterfaceName, componentInterfaceName, true, packageFile);
                    } else {
                        homeInterfaceName = generator.generateHome(packageName, packageFile, homeInterfaceName, componentInterfaceName, ejbName);
                        String businessInterfaceName = EjbGenerationUtil.getBusinessInterfaceName((String)packageName, (String)ejbName);
                        generator.generateBusinessInterfaces(packageName, packageFile, businessInterfaceName, ejbName, this.ejb.getEjbClass(), componentInterfaceName);
                    }
                }
                if (local) {
                    this.ejb.setLocal(componentInterfaceName);
                    this.ejb.setLocalHome(homeInterfaceName);
                } else {
                    this.ejb.setRemote(componentInterfaceName);
                    this.ejb.setHome(homeInterfaceName);
                }
                rollback = false;
            }
            catch (JmiException jmie) {
                ErrorManager.getDefault().notify((Throwable)jmie);
            }
            finally {
                JMIUtils.endJmiTransaction((boolean)rollback);
            }
            this.modelUpdatedFromUI();
        }
        catch (IOException e) {
            Utils.notifyError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateHomeInterface(String oldHome, String newHome, String oldBusiness, String newBusiness, boolean remote, FileObject foForClasspath) throws IOException {
        boolean rollback = true;
        try {
            FileObject oldIfFO;
            JMIUtils.beginJmiTransaction((boolean)true);
            JavaClass oldIfClass = JMIUtils.findClass((String)oldHome, (FileObject)foForClasspath);
            if (oldIfClass != null && (oldIfFO = JavaModel.getFileObject((Resource)oldIfClass.getResource())) != null) {
                JavaClass newIfClass = JMIUtils.createClass((JavaClass)oldIfClass, (String)newHome);
                newIfClass.setModifiers(513);
                FileObject newIfFo = oldIfFO.getParent().createData(newIfClass.getSimpleName(), oldIfFO.getExt());
                Resource resource = JavaModel.getResource((FileObject)newIfFo);
                resource.setPackageName(oldIfClass.getResource().getPackageName());
                resource.getClassifiers().add(newIfClass);
                Iterator it = oldIfClass.getResource().getImports().iterator();
                while (it.hasNext()) {
                    Import imp = (Import)it.next();
                    resource.addImport((Import)imp.duplicate());
                }
                if (remote) {
                    newIfClass.getInterfaceNames().add(JMIUtils.createMultipartId((Feature)newIfClass, (String)"javax.ejb.EJBHome"));
                    newIfClass.setJavadocText("This is the remote home interface for " + newIfClass.getSimpleName() + " enterprise bean");
                } else {
                    newIfClass.getInterfaceNames().add(JMIUtils.createMultipartId((Feature)newIfClass, (String)"javax.ejb.EJBLocalHome"));
                    newIfClass.setJavadocText("This is the local home interface for " + newIfClass.getSimpleName() + " enterprise bean");
                }
                it = EntityAndSessionHelper.getImportantHomeMethods(oldIfClass).iterator();
                while (it.hasNext()) {
                    Method originalMethod = (Method)it.next();
                    Method method = JMIUtils.duplicate((Method)originalMethod);
                    method.setModifiers(0);
                    if (oldBusiness != null && newBusiness != null && method.getType().getName().indexOf(oldBusiness.substring(oldBusiness.lastIndexOf(".") + 1)) != -1) {
                        method.setTypeName((TypeReference)JMIUtils.createMultipartId((Feature)method, (String)newBusiness));
                    }
                    if (remote) {
                        JMIUtils.addException((Method)method, (String)(class$java$rmi$RemoteException == null ? EntityAndSessionHelper.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException).getName());
                    }
                    newIfClass.getContents().add(method);
                }
            }
            rollback = false;
        }
        catch (JmiException jmie) {
            ErrorManager.getDefault().notify((Throwable)jmie);
        }
        finally {
            JMIUtils.endJmiTransaction((boolean)rollback);
        }
    }

    private static Collection getImportantHomeMethods(JavaClass homeInterface) {
        ArrayList<Method> result = new ArrayList<Method>();
        Iterator it = homeInterface.getContents().iterator();
        while (it.hasNext()) {
            Method method;
            ClassMember classMember = (ClassMember)((ClassMember)it.next()).duplicate();
            if (!(classMember instanceof Method) || !Modifier.isInterface(homeInterface.getModifiers()) || !(method = (Method)classMember).getName().startsWith("create") && !method.getName().equals("findByPrimaryKey") || result.contains(method)) continue;
            result.add(method);
        }
        return result;
    }

    protected abstract EntityAndSessionGenerator getGenerator();

    public JavaClass getLocalHomeInterfaceClass() {
        return this.abstractMethodController.getBeanInterface(true, false);
    }

    public JavaClass getHomeInterfaceClass() {
        return this.abstractMethodController.getBeanInterface(false, false);
    }

    protected Node createEntityNode() {
        return Utils.createEntityNode(this.ejbJarFile, this.sourceClassPath, (Entity)this.ejb);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((PropertyChangeListener)iterator.next()).propertyChange(evt);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    public JavaClass getBeanClass() {
        return this.abstractMethodController.getBeanClass();
    }
}

