/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Frame;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.SplitConstraint;
import org.netbeans.core.windows.TopComponentGroupImpl;
import org.netbeans.core.windows.ViewRequest;
import org.netbeans.core.windows.ViewRequestor;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WindowSystemSnapshot;
import org.netbeans.core.windows.model.Model;
import org.netbeans.core.windows.model.ModelElement;
import org.netbeans.core.windows.model.ModelFactory;
import org.netbeans.core.windows.persistence.PersistenceManager;
import org.netbeans.core.windows.view.ControllerHandler;
import org.openide.windows.TopComponent;

final class Central
implements ControllerHandler {
    private final Model model = ModelFactory.createWindowSystemModel();
    private final ViewRequestor viewRequestor = new ViewRequestor(this);

    public void topComponentRequestAttention(ModeImpl mode, TopComponent tc) {
        String modeName = this.getModeName(mode);
        this.viewRequestor.scheduleRequest(new ViewRequest(modeName, 63, tc, tc));
    }

    public void topComponentCancelRequestAttention(ModeImpl mode, TopComponent tc) {
        String modeName = this.getModeName(mode);
        this.viewRequestor.scheduleRequest(new ViewRequest(modeName, 64, tc, tc));
    }

    public void setVisible(boolean visible) {
        if (this.isVisible() == visible) {
            return;
        }
        this.model.setVisible(visible);
        this.viewRequestor.scheduleRequest(new ViewRequest(null, 0, null, visible));
    }

    public void setMainWindowBoundsJoined(Rectangle mainWindowBoundsJoined) {
        if (mainWindowBoundsJoined == null) {
            return;
        }
        Rectangle old = this.getMainWindowBoundsJoined();
        if (old.equals(mainWindowBoundsJoined)) {
            return;
        }
        this.model.setMainWindowBoundsJoined(mainWindowBoundsJoined);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 1, old, mainWindowBoundsJoined));
        }
    }

    public void setMainWindowBoundsSeparated(Rectangle mainWindowBoundsSeparated) {
        if (mainWindowBoundsSeparated == null) {
            return;
        }
        Rectangle old = this.getMainWindowBoundsSeparated();
        if (old.equals(mainWindowBoundsSeparated)) {
            return;
        }
        this.model.setMainWindowBoundsSeparated(mainWindowBoundsSeparated);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 2, old, mainWindowBoundsSeparated));
        }
    }

    public void setMainWindowFrameStateJoined(int frameState) {
        int old = this.getMainWindowFrameStateJoined();
        if (old == frameState) {
            return;
        }
        this.model.setMainWindowFrameStateJoined(frameState);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 3, new Integer(old), new Integer(frameState)));
        }
    }

    public void setMainWindowFrameStateSeparated(int frameState) {
        int old = this.getMainWindowFrameStateSeparated();
        if (old == frameState) {
            return;
        }
        this.model.setMainWindowFrameStateSeparated(frameState);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 4, new Integer(old), new Integer(frameState)));
        }
    }

    public void setActiveMode(ModeImpl activeMode) {
        ModeImpl old = this.getActiveMode();
        if (activeMode == old) {
            boolean right;
            ModeImpl impl = this.model.getSlidingMode("bottom");
            boolean bottom = impl == null || impl.getSelectedTopComponent() == null;
            impl = this.model.getSlidingMode("left");
            boolean left = impl == null || impl.getSelectedTopComponent() == null;
            impl = this.model.getSlidingMode("right");
            boolean bl = right = impl == null || impl.getSelectedTopComponent() == null;
            if (bottom && left && right) {
                return;
            }
        }
        this.model.setActiveMode(activeMode);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 9, old, activeMode));
        }
        WindowManagerImpl.getInstance().doFirePropertyChange("activeMode", old, activeMode);
        if (activeMode != null) {
            WindowManagerImpl.notifyRegistryTopComponentActivated(activeMode.getSelectedTopComponent());
        } else {
            WindowManagerImpl.notifyRegistryTopComponentActivated(null);
        }
    }

    public void setEditorAreaBounds(Rectangle editorAreaBounds) {
        if (editorAreaBounds == null) {
            return;
        }
        Rectangle old = this.getEditorAreaBounds();
        if (old.equals(editorAreaBounds)) {
            return;
        }
        this.model.setEditorAreaBounds(editorAreaBounds);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 7, old, editorAreaBounds));
        }
    }

    public void setEditorAreaConstraints(SplitConstraint[] editorAreaConstraints) {
        Object[] old = this.getEditorAreaConstraints();
        if (Arrays.equals(old, editorAreaConstraints)) {
            return;
        }
        this.model.setEditorAreaConstraints(editorAreaConstraints);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 8, old, editorAreaConstraints));
        }
    }

    public void setEditorAreaState(int editorAreaState) {
        int old = this.getEditorAreaState();
        if (editorAreaState == old) {
            return;
        }
        int requiredState = editorAreaState == 0 ? 0 : 1;
        Iterator it = this.getModes().iterator();
        while (it.hasNext()) {
            ModeImpl mode = (ModeImpl)it.next();
            if (mode.getKind() == 0 && mode.getState() != requiredState) {
                Rectangle bounds;
                this.model.setModeState(mode, requiredState);
                if (editorAreaState == 1 && (bounds = this.model.getModeBounds(mode)).isEmpty()) {
                    this.model.setModeBounds(mode, this.model.getModeBoundsSeparatedHelp(mode));
                }
            }
            if (mode.getKind() != 2 || editorAreaState != 1) continue;
            TopComponent[] tcs = mode.getTopComponents();
            for (int i = 0; i < tcs.length; ++i) {
                String tcID = WindowManagerImpl.getInstance().findTopComponentID(tcs[i]);
                ModeImpl targetMode = this.model.getModeTopComponentPreviousMode(mode, tcID);
                if (targetMode == null || !this.model.getModes().contains(targetMode)) {
                    SplitConstraint[] constraints = this.model.getModeTopComponentPreviousConstraints(mode, tcID);
                    constraints = constraints == null ? new SplitConstraint[]{} : constraints;
                    targetMode = WindowManagerImpl.getInstance().createModeImpl(ModeImpl.getUnusedModeName(), 0, false);
                    this.model.setModeState(targetMode, requiredState);
                    this.model.addMode(targetMode, constraints);
                }
                this.moveTopComponentsIntoMode(targetMode, new TopComponent[]{tcs[i]});
            }
        }
        if (editorAreaState == 1) {
            Rectangle mainWindowBoundsSeparated;
            Rectangle editorAreaBounds = this.model.getEditorAreaBounds();
            if (editorAreaBounds.isEmpty()) {
                this.model.setEditorAreaBounds(this.model.getEditorAreaBoundsHelp());
            }
            if ((mainWindowBoundsSeparated = this.model.getMainWindowBoundsSeparated()).isEmpty()) {
                this.model.setMainWindowBoundsSeparated(this.model.getMainWindowBoundsSeparatedHelp());
            }
        }
        this.model.setEditorAreaState(editorAreaState);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 5, new Integer(old), new Integer(editorAreaState)));
        }
        WindowManagerImpl.getInstance().doFirePropertyChange("editorAreaState", new Integer(old), new Integer(editorAreaState));
    }

    public void setEditorAreaFrameState(int frameState) {
        int old = this.getEditorAreaFrameState();
        if (old == frameState) {
            return;
        }
        this.model.setEditorAreaFrameState(frameState);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 6, new Integer(old), new Integer(frameState)));
        }
    }

    public void setMaximizedMode(ModeImpl maximizedMode) {
        ModeImpl old = this.getMaximizedMode();
        if (maximizedMode == old) {
            return;
        }
        this.model.setMaximizedMode(maximizedMode);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 11, old, maximizedMode));
        }
        WindowManagerImpl.getInstance().doFirePropertyChange("maximizedMode", old, maximizedMode);
    }

    public void setModeConstraints(ModeImpl mode, SplitConstraint[] modeConstraints) {
        Object[] old = this.getModeConstraints(mode);
        if (Arrays.equals(modeConstraints, old)) {
            return;
        }
        this.model.setModeConstraints(mode, modeConstraints);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 14, old, modeConstraints));
        }
    }

    public void addMode(ModeImpl mode, SplitConstraint[] modeConstraints) {
        SplitConstraint[] old = this.getModeConstraints(mode);
        if (modeConstraints == null && old == null || modeConstraints != null && modeConstraints.equals(old)) {
            return;
        }
        this.model.addMode(mode, modeConstraints);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 12, null, mode));
        }
        WindowManagerImpl.getInstance().doFirePropertyChange("modes", null, null);
    }

    public void removeMode(ModeImpl mode) {
        if (!this.getModes().contains(mode)) {
            return;
        }
        this.model.removeMode(mode);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 13, null, mode));
        }
        WindowManagerImpl.getInstance().doFirePropertyChange("modes", null, null);
    }

    public void setToolbarConfigName(String toolbarConfigName) {
        String old = this.getToolbarConfigName();
        if (old.equals(toolbarConfigName)) {
            return;
        }
        this.model.setToolbarConfigName(toolbarConfigName);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 10, old, toolbarConfigName));
        }
    }

    public void updateUI() {
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 61, null, null));
        }
    }

    public void setProjectName(String projectName) {
        this.model.setProjectName(projectName);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 62, null, projectName));
        }
    }

    private void closeMode(ModeImpl mode) {
        if (mode == null) {
            return;
        }
        TopComponent[] tcs = this.getModeOpenedTopComponents(mode).toArray(new TopComponent[0]);
        for (int i = 0; i < tcs.length; ++i) {
            TopComponent tc = tcs[i];
            if (WindowManagerImpl.getInstance().isTopComponentPersistentWhenClosed(tc)) {
                this.model.addModeClosedTopComponent(mode, tc);
                continue;
            }
            this.model.removeModeTopComponent(mode, tc);
            String id = WindowManagerImpl.getInstance().findTopComponentID(tc);
            PersistenceManager.getDefault().removeGlobalTopComponentID(id);
        }
        ModeImpl oldActive = this.getActiveMode();
        ModeImpl newActive = mode == oldActive ? this.setSomeModeActive() : oldActive;
        boolean modeRemoved = false;
        if (!mode.isPermanent() && this.model.getModeTopComponents(mode).isEmpty() && this.doCheckSlidingModes(mode)) {
            this.model.removeMode(mode);
            modeRemoved = true;
        }
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(mode, 45, null, null));
        }
        for (int i = 0; i < tcs.length; ++i) {
            WindowManagerImpl.getInstance().notifyTopComponentClosed(tcs[i]);
        }
        if (oldActive != newActive) {
            WindowManagerImpl.getInstance().doFirePropertyChange("activeMode", oldActive, newActive);
        }
        if (modeRemoved) {
            WindowManagerImpl.getInstance().doFirePropertyChange("modes", null, null);
        }
        if (newActive != null) {
            WindowManagerImpl.notifyRegistryTopComponentActivated(newActive.getSelectedTopComponent());
        } else {
            WindowManagerImpl.notifyRegistryTopComponentActivated(null);
        }
    }

    private ModeImpl setSomeModeActive() {
        Iterator it = this.getModes().iterator();
        while (it.hasNext()) {
            ModeImpl mode = (ModeImpl)it.next();
            if (mode.getOpenedTopComponents().isEmpty() || 2 == mode.getKind()) continue;
            this.model.setActiveMode(mode);
            return mode;
        }
        this.model.setActiveMode(null);
        return this.model.getActiveMode();
    }

    public void setModeBounds(ModeImpl mode, Rectangle bounds) {
        if (bounds == null) {
            return;
        }
        Rectangle old = this.getModeBounds(mode);
        if (old.equals(bounds)) {
            return;
        }
        this.model.setModeBounds(mode, bounds);
        if (this.isVisible() && this.getEditorAreaState() == 1) {
            this.viewRequestor.scheduleRequest(new ViewRequest(mode, 20, old, bounds));
        }
        mode.doFirePropertyChange("bounds", old, bounds);
    }

    public void setModeFrameState(ModeImpl mode, int frameState) {
        int old = this.getModeFrameState(mode);
        if (frameState == old) {
            return;
        }
        this.model.setModeFrameState(mode, frameState);
        if (this.isVisible() && this.getEditorAreaState() == 1) {
            this.viewRequestor.scheduleRequest(new ViewRequest(mode, 21, new Integer(old), new Integer(frameState)));
        }
    }

    public void setModeSelectedTopComponent(ModeImpl mode, TopComponent selected) {
        if (!(mode.getKind() == 2 && selected == null || this.getModeOpenedTopComponents(mode).contains(selected))) {
            return;
        }
        TopComponent old = this.getModeSelectedTopComponent(mode);
        if (selected == old) {
            return;
        }
        this.model.setModeSelectedTopComponent(mode, selected);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(mode, 22, old, selected));
        }
        if (mode == this.getActiveMode()) {
            WindowManagerImpl.notifyRegistryTopComponentActivated(selected);
        }
    }

    public void addModeOpenedTopComponent(ModeImpl mode, TopComponent tc) {
        if (this.getModeOpenedTopComponents(mode).contains(tc)) {
            return;
        }
        this.removeTopComponentFromOtherModes(mode, tc);
        this.model.addModeOpenedTopComponent(mode, tc);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(mode, 23, null, tc));
        }
        WindowManagerImpl.getInstance().notifyTopComponentOpened(tc);
    }

    public void insertModeOpenedTopComponent(ModeImpl mode, TopComponent tc, int index) {
        List openedTcs = this.getModeOpenedTopComponents(mode);
        if (index >= 0 && !openedTcs.isEmpty() && openedTcs.size() > index && openedTcs.get(index) == tc) {
            return;
        }
        this.removeTopComponentFromOtherModes(mode, tc);
        this.model.insertModeOpenedTopComponent(mode, tc, index);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(mode, 23, null, tc));
        }
    }

    public void addModeClosedTopComponent(ModeImpl mode, TopComponent tc) {
        boolean opened = this.getModeOpenedTopComponents(mode).contains(tc);
        if (opened && !tc.canClose()) {
            return;
        }
        if (this.containsModeTopComponent(mode, tc) && !opened) {
            return;
        }
        this.removeTopComponentFromOtherModes(mode, tc);
        this.model.addModeClosedTopComponent(mode, tc);
        ModeImpl oldActive = this.getActiveMode();
        ModeImpl newActive = this.model.getModeOpenedTopComponents(mode).isEmpty() && mode == oldActive ? this.setSomeModeActive() : oldActive;
        if (this.model.getMaximizedMode() == mode && this.model.getModeOpenedTopComponents(mode).isEmpty()) {
            this.model.setMaximizedMode(null);
        }
        if (this.isVisible() && opened) {
            this.viewRequestor.scheduleRequest(new ViewRequest(mode, 24, null, tc));
        }
        if (opened) {
            WindowManagerImpl.getInstance().notifyTopComponentClosed(tc);
        }
        if (oldActive != newActive) {
            WindowManagerImpl.getInstance().doFirePropertyChange("activeMode", oldActive, newActive);
        }
        if (newActive != null) {
            WindowManagerImpl.notifyRegistryTopComponentActivated(newActive.getSelectedTopComponent());
        } else {
            WindowManagerImpl.notifyRegistryTopComponentActivated(null);
        }
    }

    public void addModeUnloadedTopComponent(ModeImpl mode, String tcID) {
        this.model.addModeUnloadedTopComponent(mode, tcID);
    }

    public void setUnloadedSelectedTopComponent(ModeImpl mode, String tcID) {
        this.model.setModeUnloadedSelectedTopComponent(mode, tcID);
    }

    public List getModeOpenedTopComponentsIDs(ModeImpl mode) {
        return this.model.getModeOpenedTopComponentsIDs(mode);
    }

    public List getModeClosedTopComponentsIDs(ModeImpl mode) {
        return this.model.getModeClosedTopComponentsIDs(mode);
    }

    public List getModeTopComponentsIDs(ModeImpl mode) {
        return this.model.getModeTopComponentsIDs(mode);
    }

    private boolean removeTopComponentFromOtherModes(ModeImpl mode, TopComponent tc) {
        boolean tcRemoved = false;
        Iterator it = this.model.getModes().iterator();
        while (it.hasNext()) {
            ModeImpl m = (ModeImpl)it.next();
            if (m == mode || !this.model.containsModeTopComponent(m, tc)) continue;
            tcRemoved = true;
            this.model.removeModeTopComponent(m, tc);
            boolean modeRemoved = false;
            if (!m.isPermanent() && m.isEmpty() && this.doCheckSlidingModes(m) && mode.getKind() != 2) {
                this.model.removeMode(m);
                modeRemoved = true;
            }
            if (!modeRemoved) continue;
            WindowManagerImpl.getInstance().doFirePropertyChange("modes", null, null);
        }
        return tcRemoved;
    }

    public void removeModeTopComponent(ModeImpl mode, TopComponent tc) {
        if (!this.containsModeTopComponent(mode, tc)) {
            return;
        }
        boolean viewChange = this.getModeOpenedTopComponents(mode).contains(tc);
        if (viewChange && !tc.canClose()) {
            return;
        }
        this.model.removeModeTopComponent(mode, tc);
        String id = WindowManagerImpl.getInstance().findTopComponentID(tc);
        PersistenceManager.getDefault().removeGlobalTopComponentID(id);
        ModeImpl oldActive = this.getActiveMode();
        ModeImpl newActive = this.model.getModeOpenedTopComponents(mode).isEmpty() && mode == oldActive ? this.setSomeModeActive() : oldActive;
        if (this.model.getMaximizedMode() == mode && this.model.getModeOpenedTopComponents(mode).isEmpty()) {
            this.model.setMaximizedMode(null);
        }
        boolean modeRemoved = false;
        if (!mode.isPermanent() && this.model.getModeTopComponents(mode).isEmpty() && this.doCheckSlidingModes(mode)) {
            this.model.removeMode(mode);
            modeRemoved = true;
        }
        if (viewChange && this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(mode, 24, null, tc));
        }
        if (viewChange) {
            WindowManagerImpl.getInstance().notifyTopComponentClosed(tc);
        }
        if (oldActive != newActive) {
            WindowManagerImpl.getInstance().doFirePropertyChange("activeMode", oldActive, newActive);
        }
        if (modeRemoved) {
            WindowManagerImpl.getInstance().doFirePropertyChange("modes", null, null);
        }
        if (newActive != null) {
            WindowManagerImpl.notifyRegistryTopComponentActivated(newActive.getSelectedTopComponent());
        } else {
            WindowManagerImpl.notifyRegistryTopComponentActivated(null);
        }
    }

    private boolean doCheckSlidingModes(ModeImpl mode) {
        ModeImpl impl;
        String tcID;
        int i;
        TopComponent[] tcs;
        ModeImpl slid = this.model.getSlidingMode("bottom");
        if (slid != null) {
            tcs = slid.getTopComponents();
            for (i = 0; i < tcs.length; ++i) {
                tcID = WindowManagerImpl.getInstance().findTopComponentID(tcs[i]);
                impl = this.model.getModeTopComponentPreviousMode(slid, tcID);
                if (impl != mode) continue;
                return false;
            }
        }
        if ((slid = this.model.getSlidingMode("left")) != null) {
            tcs = slid.getTopComponents();
            for (i = 0; i < tcs.length; ++i) {
                tcID = WindowManagerImpl.getInstance().findTopComponentID(tcs[i]);
                impl = this.model.getModeTopComponentPreviousMode(slid, tcID);
                if (impl != mode) continue;
                return false;
            }
        }
        if ((slid = this.model.getSlidingMode("right")) != null) {
            tcs = slid.getTopComponents();
            for (i = 0; i < tcs.length; ++i) {
                tcID = WindowManagerImpl.getInstance().findTopComponentID(tcs[i]);
                impl = this.model.getModeTopComponentPreviousMode(slid, tcID);
                if (impl != mode) continue;
                return false;
            }
        }
        return true;
    }

    public void removeModeClosedTopComponentID(ModeImpl mode, String tcID) {
        this.model.removeModeClosedTopComponentID(mode, tcID);
    }

    public boolean isGroupOpened(TopComponentGroupImpl tcGroup) {
        return this.model.isGroupOpened(tcGroup);
    }

    public void openGroup(TopComponentGroupImpl tcGroup) {
        TopComponent tc;
        if (this.isGroupOpened(tcGroup)) {
            return;
        }
        HashSet<TopComponent> openedBeforeTopComponents = new HashSet<TopComponent>();
        Set tcs = tcGroup.getTopComponents();
        Iterator it = tcs.iterator();
        while (it.hasNext()) {
            TopComponent tc2 = (TopComponent)it.next();
            if (!tc2.isOpened()) continue;
            openedBeforeTopComponents.add(tc2);
        }
        tcs = tcGroup.getOpeningSet();
        ArrayList<TopComponent> openedTcs = new ArrayList<TopComponent>();
        Iterator it2 = tcs.iterator();
        while (it2.hasNext()) {
            tc = (TopComponent)it2.next();
            if (tc.isOpened()) continue;
            WindowManagerImpl wm = WindowManagerImpl.getInstance();
            ModeImpl mode = (ModeImpl)wm.findMode(tc);
            if (mode == null) {
                mode = wm.getDefaultViewMode();
            }
            this.model.addModeOpenedTopComponent(mode, tc);
            openedTcs.add(tc);
        }
        this.model.openGroup(tcGroup, new HashSet(openedTcs), openedBeforeTopComponents);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(tcGroup, 42, null, openedTcs.toArray(new TopComponent[0])));
        }
        it2 = openedTcs.iterator();
        while (it2.hasNext()) {
            tc = (TopComponent)it2.next();
            WindowManagerImpl.getInstance().notifyTopComponentOpened(tc);
        }
    }

    public void closeGroup(TopComponentGroupImpl tcGroup) {
        TopComponent tc;
        if (!this.isGroupOpened(tcGroup)) {
            return;
        }
        Set tcs = tcGroup.getClosingSet();
        ArrayList<TopComponent> closedTcs = new ArrayList<TopComponent>();
        Set openedTcsByGroup = this.model.getGroupOpenedTopComponents(tcGroup);
        Set openedTcsBefore = this.model.getGroupOpenedBeforeTopComponents(tcGroup);
        Iterator it = this.model.getGroupTopComponents(tcGroup).iterator();
        while (it.hasNext()) {
            tc = (TopComponent)it.next();
            boolean wasOpenedBefore = openedTcsBefore.contains(tc);
            boolean openedByGroup = openedTcsByGroup.contains(tc);
            if (tc.isOpened()) {
                if (wasOpenedBefore || openedByGroup) continue;
                this.model.addGroupOpeningTopComponent(tcGroup, tc);
                continue;
            }
            if (!wasOpenedBefore && !openedByGroup) continue;
            this.model.removeGroupOpeningTopComponent(tcGroup, tc);
        }
        it = tcs.iterator();
        while (it.hasNext()) {
            ModeImpl mode;
            tc = (TopComponent)it.next();
            if (!tc.isOpened() || openedTcsBefore.contains(tc)) continue;
            boolean ignore = false;
            Iterator it2 = this.model.getTopComponentGroups().iterator();
            while (it2.hasNext()) {
                TopComponentGroupImpl group = (TopComponentGroupImpl)it2.next();
                if (group == tcGroup || !group.isOpened() || !group.getOpeningSet().contains(tc)) continue;
                ignore = true;
                break;
            }
            if (ignore || (mode = (ModeImpl)WindowManagerImpl.getInstance().findMode(tc)) == null) continue;
            if (WindowManagerImpl.getInstance().isTopComponentPersistentWhenClosed(tc)) {
                this.model.addModeClosedTopComponent(mode, tc);
            } else {
                this.model.removeModeTopComponent(mode, tc);
                String id = WindowManagerImpl.getInstance().findTopComponentID(tc);
                PersistenceManager.getDefault().removeGlobalTopComponentID(id);
            }
            closedTcs.add(tc);
        }
        this.model.closeGroup(tcGroup);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(tcGroup, 43, null, closedTcs.toArray(new TopComponent[0])));
        }
        it = closedTcs.iterator();
        while (it.hasNext()) {
            tc = (TopComponent)it.next();
            WindowManagerImpl.getInstance().notifyTopComponentClosed(tc);
        }
    }

    public void addTopComponentGroup(TopComponentGroupImpl tcGroup) {
        this.model.addTopComponentGroup(tcGroup);
    }

    public void removeTopComponentGroup(TopComponentGroupImpl tcGroup) {
        this.model.removeTopComponentGroup(tcGroup);
    }

    public boolean addGroupUnloadedTopComponent(TopComponentGroupImpl tcGroup, String tcID) {
        return this.model.addGroupUnloadedTopComponent(tcGroup, tcID);
    }

    public boolean removeGroupUnloadedTopComponent(TopComponentGroupImpl tcGroup, String tcID) {
        return this.model.removeGroupUnloadedTopComponent(tcGroup, tcID);
    }

    public boolean addGroupUnloadedOpeningTopComponent(TopComponentGroupImpl tcGroup, String tcID) {
        return this.model.addGroupUnloadedOpeningTopComponent(tcGroup, tcID);
    }

    public boolean removeGroupUnloadedOpeningTopComponent(TopComponentGroupImpl tcGroup, String tcID) {
        return this.model.removeGroupUnloadedOpeningTopComponent(tcGroup, tcID);
    }

    public boolean addGroupUnloadedClosingTopComponent(TopComponentGroupImpl tcGroup, String tcID) {
        return this.model.addGroupUnloadedClosingTopComponent(tcGroup, tcID);
    }

    public boolean removeGroupUnloadedClosingTopComponent(TopComponentGroupImpl tcGroup, String tcID) {
        return this.model.removeGroupUnloadedClosingTopComponent(tcGroup, tcID);
    }

    public boolean addGroupUnloadedOpenedTopComponent(TopComponentGroupImpl tcGroup, String tcID) {
        if (!this.isGroupOpened(tcGroup)) {
            return false;
        }
        return this.model.addGroupUnloadedOpenedTopComponent(tcGroup, tcID);
    }

    public Set getGroupOpenedTopComponents(TopComponentGroupImpl tcGroup) {
        return this.model.getGroupOpenedTopComponents(tcGroup);
    }

    public Set getGroupTopComponentsIDs(TopComponentGroupImpl tcGroup) {
        return this.model.getGroupTopComponentsIDs(tcGroup);
    }

    public Set getGroupOpeningSetIDs(TopComponentGroupImpl tcGroup) {
        return this.model.getGroupOpeningSetIDs(tcGroup);
    }

    public Set getGroupClosingSetIDs(TopComponentGroupImpl tcGroup) {
        return this.model.getGroupClosingSetIDs(tcGroup);
    }

    public Set getGroupOpenedTopComponentsIDs(TopComponentGroupImpl tcGroup) {
        return this.model.getGroupOpenedTopComponentsIDs(tcGroup);
    }

    public boolean isVisible() {
        return this.model.isVisible();
    }

    public Set getModes() {
        return this.model.getModes();
    }

    public Rectangle getMainWindowBoundsJoined() {
        return this.model.getMainWindowBoundsJoined();
    }

    public Rectangle getMainWindowBoundsSeparated() {
        return this.model.getMainWindowBoundsSeparated();
    }

    public int getMainWindowFrameStateJoined() {
        return this.model.getMainWindowFrameStateJoined();
    }

    public int getMainWindowFrameStateSeparated() {
        return this.model.getMainWindowFrameStateSeparated();
    }

    public ModeImpl getActiveMode() {
        return this.model.getActiveMode();
    }

    public Rectangle getEditorAreaBounds() {
        return this.model.getEditorAreaBounds();
    }

    public SplitConstraint[] getEditorAreaConstraints() {
        return this.model.getEditorAreaConstraints();
    }

    public int getEditorAreaState() {
        return this.model.getEditorAreaState();
    }

    public int getEditorAreaFrameState() {
        return this.model.getEditorAreaFrameState();
    }

    public ModeImpl getMaximizedMode() {
        return this.model.getMaximizedMode();
    }

    public SplitConstraint[] getModeConstraints(ModeImpl mode) {
        return this.model.getModeConstraints(mode);
    }

    public String getToolbarConfigName() {
        return this.model.getToolbarConfigName();
    }

    public String getModeName(ModeImpl mode) {
        return this.model.getModeName(mode);
    }

    public Rectangle getModeBounds(ModeImpl mode) {
        return this.model.getModeBounds(mode);
    }

    public int getModeState(ModeImpl mode) {
        return this.model.getModeState(mode);
    }

    public int getModeKind(ModeImpl mode) {
        return this.model.getModeKind(mode);
    }

    public String getModeSide(ModeImpl mode) {
        return this.model.getModeSide(mode);
    }

    public int getModeFrameState(ModeImpl mode) {
        return this.model.getModeFrameState(mode);
    }

    public boolean isModePermanent(ModeImpl mode) {
        return this.model.isModePermanent(mode);
    }

    public boolean isModeEmpty(ModeImpl mode) {
        return this.model.isModeEmpty(mode);
    }

    public boolean containsModeTopComponent(ModeImpl mode, TopComponent tc) {
        return this.model.containsModeTopComponent(mode, tc);
    }

    public TopComponent getModeSelectedTopComponent(ModeImpl mode) {
        return this.model.getModeSelectedTopComponent(mode);
    }

    public List getModeTopComponents(ModeImpl mode) {
        return this.model.getModeTopComponents(mode);
    }

    public List getModeOpenedTopComponents(ModeImpl mode) {
        return this.model.getModeOpenedTopComponents(mode);
    }

    public Set getTopComponentGroups() {
        return this.model.getTopComponentGroups();
    }

    public String getGroupName(TopComponentGroupImpl tcGroup) {
        return this.model.getGroupName(tcGroup);
    }

    public Set getGroupTopComponents(TopComponentGroupImpl tcGroup) {
        return this.model.getGroupTopComponents(tcGroup);
    }

    public Set getGroupOpeningTopComponents(TopComponentGroupImpl tcGroup) {
        return this.model.getGroupOpeningTopComponents(tcGroup);
    }

    public Set getGroupClosingTopComponents(TopComponentGroupImpl tcGroup) {
        return this.model.getGroupClosingTopComponents(tcGroup);
    }

    public void topComponentDisplayNameChanged(ModeImpl mode, TopComponent tc) {
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(mode, 31, null, tc));
        }
    }

    public void topComponentDisplayNameAnnotation(ModeImpl mode, TopComponent tc) {
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(mode, 32, null, tc));
        }
    }

    public void topComponentToolTipChanged(ModeImpl mode, TopComponent tc) {
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(mode, 33, null, tc));
        }
    }

    public void topComponentIconChanged(ModeImpl mode, TopComponent tc) {
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(mode, 34, null, tc));
        }
    }

    public void attachTopComponentsToSide(TopComponent[] tcs, ModeImpl attachMode, String side) {
        this.attachTopComponentsToSide(tcs, attachMode, side, true);
    }

    private void attachTopComponentsToSide(TopComponent[] tcs, ModeImpl attachMode, String side, boolean fireEvents) {
        if (tcs == null || tcs.length == 0) {
            return;
        }
        ModeImpl newMode = WindowManagerImpl.getInstance().createModeImpl(ModeImpl.getUnusedModeName(), attachMode.getKind(), false);
        if (!newMode.canContain(tcs[0])) {
            return;
        }
        this.model.addModeToSide(newMode, attachMode, side);
        this.attachTopComponentsHelper(tcs, newMode, fireEvents);
    }

    private void attachTopComponentsAroundDesktop(TopComponent[] tcs, String side, boolean fireEvents) {
        if (tcs == null || tcs.length == 0) {
            return;
        }
        ModeImpl newMode = WindowManagerImpl.getInstance().createModeImpl(ModeImpl.getUnusedModeName(), 0, false);
        if (!newMode.canContain(tcs[0])) {
            return;
        }
        this.model.addModeAround(newMode, side);
        this.attachTopComponentsHelper(tcs, newMode, fireEvents);
    }

    private void attachTopComponentsAroundEditor(TopComponent[] tcs, String side, boolean fireEvents) {
        if (tcs == null || tcs.length == 0) {
            return;
        }
        ModeImpl newMode = WindowManagerImpl.getInstance().createModeImpl(ModeImpl.getUnusedModeName(), 0, false);
        if (!newMode.canContain(tcs[0])) {
            return;
        }
        this.model.addModeAroundEditor(newMode, side);
        this.attachTopComponentsHelper(tcs, newMode, fireEvents);
    }

    private void attachTopComponentsIntoNewMode(TopComponent[] tcs, Rectangle bounds) {
        if (tcs == null || tcs.length == 0) {
            return;
        }
        ModeImpl newMode = WindowManagerImpl.getInstance().createModeImpl(ModeImpl.getUnusedModeName(), 0, false);
        newMode.setBounds(bounds);
        if (!newMode.canContain(tcs[0])) {
            return;
        }
        this.model.addMode(newMode, new SplitConstraint[]{new SplitConstraint(1, 100, 0.5)});
        this.attachTopComponentsHelper(tcs, newMode, true);
    }

    private void attachTopComponentsHelper(TopComponent[] tcs, ModeImpl newMode, boolean fireEvents) {
        for (int i = 0; i < tcs.length; ++i) {
            TopComponent tc = tcs[i];
            this.removeTopComponentFromOtherModes(newMode, tc);
            this.model.addModeOpenedTopComponent(newMode, tc);
        }
        ModeImpl oldActiveMode = this.getActiveMode();
        this.model.setActiveMode(newMode);
        this.model.setModeSelectedTopComponent(newMode, tcs[0]);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(tcs[0], 41, null, newMode));
        }
        if (!fireEvents) {
            return;
        }
        WindowManagerImpl.notifyRegistryTopComponentActivated(tcs[0]);
        WindowManagerImpl.getInstance().doFirePropertyChange("modes", null, null);
        if (oldActiveMode != newMode) {
            WindowManagerImpl.getInstance().doFirePropertyChange("activeMode", oldActiveMode, newMode);
        }
    }

    public void activateModeTopComponent(ModeImpl mode, TopComponent tc) {
        if (!this.getModeOpenedTopComponents(mode).contains(tc)) {
            return;
        }
        ModeImpl oldActiveMode = this.getActiveMode();
        if (oldActiveMode != null && oldActiveMode.equals(mode) && tc != null && tc.equals(this.model.getModeSelectedTopComponent(mode))) {
            return;
        }
        this.model.setActiveMode(mode);
        this.model.setModeSelectedTopComponent(mode, tc);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(mode, 44, null, tc));
        }
        WindowManagerImpl.notifyRegistryTopComponentActivated(tc);
        if (oldActiveMode != mode) {
            WindowManagerImpl.getInstance().doFirePropertyChange("activeMode", oldActiveMode, mode);
        }
    }

    public boolean isDragInProgress() {
        return this.viewRequestor.isDragInProgress();
    }

    public Frame getMainWindow() {
        return this.viewRequestor.getMainWindow();
    }

    public String guessSlideSide(TopComponent tc) {
        return this.viewRequestor.guessSlideSide(tc);
    }

    public void createModeModel(ModeImpl mode, String name, int state, int kind, boolean permanent) {
        this.model.createModeModel(mode, name, state, kind, permanent);
    }

    public void createGroupModel(TopComponentGroupImpl tcGroup, String name, boolean opened) {
        this.model.createGroupModel(tcGroup, name, opened);
    }

    public WindowSystemSnapshot createWindowSystemSnapshot() {
        return this.model.createWindowSystemSnapshot();
    }

    public void userActivatedMode(ModeImpl mode) {
        if (mode != null) {
            this.setActiveMode(mode);
        }
    }

    public void userActivatedModeWindow(ModeImpl mode) {
        if (mode != null) {
            this.setActiveMode(mode);
        }
    }

    public void userActivatedEditorWindow() {
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        TopComponent[] tcs = wm.getRecentViewList();
        for (int i = 0; i < tcs.length; ++i) {
            TopComponent tc = tcs[i];
            ModeImpl mode = (ModeImpl)wm.findMode(tc);
            if (mode == null || mode.getKind() != 1 || mode.getOpenedTopComponents().isEmpty()) continue;
            this.setActiveMode(mode);
            return;
        }
        ModeImpl mode = wm.getDefaultEditorMode();
        if (mode != null && !mode.getOpenedTopComponents().isEmpty()) {
            this.setActiveMode(mode);
        } else {
            this.setActiveMode(null);
        }
    }

    public void userActivatedTopComponent(ModeImpl mode, TopComponent selected) {
        if (mode != null) {
            this.setModeSelectedTopComponent(mode, selected);
        }
    }

    public void userResizedMainWindow(Rectangle bounds) {
        if (this.getEditorAreaState() == 0) {
            this.model.setMainWindowBoundsJoined(bounds);
        } else {
            this.model.setMainWindowBoundsSeparated(bounds);
        }
    }

    public void userResizedMainWindowBoundsSeparatedHelp(Rectangle bounds) {
        if (this.getEditorAreaState() == 0 && this.getMainWindowBoundsSeparated().isEmpty()) {
            this.model.setMainWindowBoundsUserSeparatedHelp(bounds);
        }
    }

    public void userResizedEditorArea(Rectangle bounds) {
        this.model.setEditorAreaBounds(bounds);
    }

    public void userResizedEditorAreaBoundsHelp(Rectangle bounds) {
        if (this.getEditorAreaState() == 0 && this.getEditorAreaBounds().isEmpty()) {
            this.model.setEditorAreaBoundsUserHelp(bounds);
        }
    }

    public void userResizedModeBounds(ModeImpl mode, Rectangle bounds) {
        Rectangle old = this.model.getModeBounds(mode);
        this.model.setModeBounds(mode, bounds);
        mode.doFirePropertyChange("bounds", old, bounds);
    }

    public void userResizedModeBoundsSeparatedHelp(ModeImpl mode, Rectangle bounds) {
        this.model.setModeBoundsSeparatedHelp(mode, bounds);
    }

    public void userChangedFrameStateMainWindow(int frameState) {
        if (this.getEditorAreaState() == 0) {
            this.model.setMainWindowFrameStateJoined(frameState);
        } else {
            this.model.setMainWindowFrameStateSeparated(frameState);
        }
    }

    public void userChangedFrameStateEditorArea(int frameState) {
        this.model.setEditorAreaFrameState(frameState);
    }

    public void userChangedFrameStateMode(ModeImpl mode, int frameState) {
        this.model.setModeFrameState(mode, frameState);
    }

    public void userChangedSplit(ModelElement[] snapshots, double[] splitWeights) {
        this.model.setSplitWeights(snapshots, splitWeights);
    }

    public void userClosedTopComponent(ModeImpl mode, TopComponent tc) {
        if (WindowManagerImpl.getInstance().isTopComponentPersistentWhenClosed(tc)) {
            this.addModeClosedTopComponent(mode, tc);
        } else {
            this.removeModeTopComponent(mode, tc);
        }
        if (mode.getOpenedTopComponents().isEmpty() && mode == this.getMaximizedMode()) {
            this.setMaximizedMode(null);
        }
    }

    public void userClosedMode(ModeImpl mode) {
        if (mode != null) {
            this.closeMode(mode);
            if (mode.getOpenedTopComponents().isEmpty() && mode == this.getMaximizedMode()) {
                this.setMaximizedMode(null);
            }
        }
    }

    public void userDroppedTopComponents(ModeImpl mode, TopComponent[] tcs) {
        this.updateViewAfterDnD(this.moveTopComponentsIntoMode(mode, tcs));
    }

    public void userDroppedTopComponents(ModeImpl mode, TopComponent[] tcs, int index) {
        this.updateViewAfterDnD(this.moveTopComponentsIntoMode(mode, tcs, index));
    }

    public void userDroppedTopComponents(ModeImpl mode, TopComponent[] tcs, String side) {
        this.attachTopComponentsToSide(tcs, mode, side, false);
        this.updateViewAfterDnD(true);
    }

    public void userDroppedTopComponentsIntoEmptyEditor(TopComponent[] tcs) {
        ModeImpl mode = (ModeImpl)WindowManagerImpl.getInstance().findMode("editor");
        this.moveTopComponentsIntoMode(mode, tcs);
        this.updateViewAfterDnD(true);
    }

    public void userDroppedTopComponentsAround(TopComponent[] tcs, String side) {
        this.attachTopComponentsAroundDesktop(tcs, side, false);
        this.updateViewAfterDnD(true);
    }

    public void userDroppedTopComponentsAroundEditor(TopComponent[] tcs, String side) {
        this.attachTopComponentsAroundEditor(tcs, side, false);
        this.updateViewAfterDnD(true);
    }

    public void userDroppedTopComponentsIntoFreeArea(TopComponent[] tcs, Rectangle bounds) {
        if (this.getEditorAreaState() == 0) {
            return;
        }
        this.attachTopComponentsIntoNewMode(tcs, bounds);
        this.updateViewAfterDnD(true);
    }

    private boolean moveTopComponentsIntoMode(ModeImpl mode, TopComponent[] tcs) {
        return this.moveTopComponentsIntoMode(mode, tcs, -1);
    }

    private boolean moveTopComponentsIntoMode(ModeImpl mode, TopComponent[] tcs, int index) {
        boolean moved = false;
        boolean intoSliding = mode.getKind() == 2;
        ModeImpl prevMode = null;
        for (int i = 0; i < tcs.length; ++i) {
            TopComponent tc = tcs[i];
            String tcID = WindowManagerImpl.getInstance().findTopComponentID(tc);
            if (!mode.canContain(tc)) continue;
            Iterator it = this.model.getModes().iterator();
            while (it.hasNext()) {
                ModeImpl m = (ModeImpl)it.next();
                if (!this.model.containsModeTopComponent(m, tc)) continue;
                if (m.getKind() == 2) {
                    prevMode = this.model.getModeTopComponentPreviousMode(m, tcID);
                    break;
                }
                prevMode = m;
                break;
            }
            if (this.removeTopComponentFromOtherModes(mode, tc)) {
                moved = true;
            }
            if (index > -1) {
                this.model.insertModeOpenedTopComponent(mode, tc, index);
            } else {
                this.model.addModeOpenedTopComponent(mode, tc);
            }
            if (prevMode == null || !intoSliding) continue;
            this.model.setModeTopComponentPreviousMode(mode, tcID, prevMode);
            this.model.setModeTopComponentPreviousConstraints(mode, tcID, this.model.getModeConstraints(prevMode));
        }
        if (!intoSliding) {
            this.model.setActiveMode(mode);
            this.model.setModeSelectedTopComponent(mode, tcs[tcs.length - 1]);
        } else {
            if (prevMode != null && prevMode == this.getActiveMode() && prevMode.getOpenedTopComponents().isEmpty()) {
                this.setSomeModeActive();
            }
            if (mode.getBounds().width == 0 && mode.getBounds().height == 0) {
                mode.setBounds(tcs[tcs.length - 1].getBounds());
            }
        }
        return moved;
    }

    private void updateViewAfterDnD(boolean unmaximize) {
        if (unmaximize && this.getMaximizedMode() != null) {
            this.model.setMaximizedMode(null);
        }
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 46, null, null));
        }
    }

    public void addSlidingMode(ModeImpl mode, ModeImpl original, String side) {
        ModeImpl targetMode = this.model.getSlidingMode(side);
        if (targetMode != null) {
            return;
        }
        targetMode = WindowManagerImpl.getInstance().createModeImpl(ModeImpl.getUnusedModeName(), 2, false);
        this.model.addSlidingMode(mode, side);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 12, null, mode));
        }
        WindowManagerImpl.getInstance().doFirePropertyChange("modes", null, null);
    }

    public void userEnabledAutoHide(TopComponent tc, ModeImpl source, String targetSide) {
        ModeImpl targetMode = this.model.getSlidingMode(targetSide);
        if (targetMode == null) {
            targetMode = WindowManagerImpl.getInstance().createModeImpl(ModeImpl.getUnusedModeName(), 2, false);
            this.model.addSlidingMode(targetMode, targetSide);
            this.model.setModeBounds(targetMode, new Rectangle(tc.getBounds()));
        }
        ModeImpl oldActive = this.getActiveMode();
        this.moveTopComponentsIntoMode(targetMode, new TopComponent[]{tc});
        ModeImpl newActive = this.getActiveMode();
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 47, null, null));
        }
        if (oldActive != newActive) {
            WindowManagerImpl.getInstance().doFirePropertyChange("activeMode", oldActive, newActive);
        }
        if (newActive != null) {
            WindowManagerImpl.notifyRegistryTopComponentActivated(newActive.getSelectedTopComponent());
        } else {
            WindowManagerImpl.notifyRegistryTopComponentActivated(null);
        }
    }

    public void userResizedSlidingMode(ModeImpl mode, Rectangle rect) {
        this.model.setModeBounds(mode, new Rectangle(rect));
    }

    public void userDisabledAutoHide(TopComponent tc, ModeImpl source) {
        String tcID;
        ModeImpl targetMode;
        if (this.getMaximizedMode() != null) {
            this.model.setMaximizedMode(null);
        }
        if ((targetMode = this.getModeTopComponentPreviousMode(tcID = WindowManagerImpl.getInstance().findTopComponentID(tc), source)) == null || !this.model.getModes().contains(targetMode)) {
            SplitConstraint[] constraints = this.model.getModeTopComponentPreviousConstraints(source, tcID);
            constraints = constraints == null ? new SplitConstraint[]{} : constraints;
            targetMode = WindowManagerImpl.getInstance().createModeImpl(ModeImpl.getUnusedModeName(), 0, false);
            this.model.addMode(targetMode, constraints);
        }
        this.moveTopComponentsIntoMode(targetMode, new TopComponent[]{tc});
        if (source.isEmpty()) {
            this.model.removeMode(source);
        }
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 48, null, null));
        }
        WindowManagerImpl.getInstance().doFirePropertyChange("activeMode", null, this.getActiveMode());
    }

    public ModeImpl getModeTopComponentPreviousMode(String tcID, ModeImpl currentSlidingMode) {
        return this.model.getModeTopComponentPreviousMode(currentSlidingMode, tcID);
    }

    public void setModeTopComponentPreviousMode(String tcID, ModeImpl currentSlidingMode, ModeImpl prevMode) {
        this.model.setModeTopComponentPreviousMode(currentSlidingMode, tcID, prevMode);
    }

    private static void debugLog(String message) {
        Debug.log(Central.class, message);
    }
}

