/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.clientproject.api.AppClientProjectGenerator;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.EarProjectGenerator;
import org.netbeans.modules.j2ee.earproject.EarProjectType;
import org.netbeans.modules.j2ee.earproject.ui.FoldersListSettings;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.modules.j2ee.earproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.j2ee.ejbjarproject.api.EjbJarProjectGenerator;
import org.netbeans.modules.web.project.api.WebProjectCreateData;
import org.netbeans.modules.web.project.api.WebProjectUtilities;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewEarProjectWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private static final long serialVersionUID = 1L;
    static final String PROP_NAME_INDEX = "nameIndex";
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    transient WizardDescriptor wiz;

    private WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new PanelConfigureProject(PROP_NAME_INDEX, NbBundle.getBundle(NewEarProjectWizardIterator.class), new HelpCtx(this.getClass()))};
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(NewEarProjectWizardIterator.class, (String)"LBL_NWP1_ProjectTitleName")};
    }

    public Set instantiate() throws IOException {
        File dirF = (File)this.wiz.getProperty("projdir");
        String name = (String)this.wiz.getProperty("name");
        String serverInstanceID = (String)this.wiz.getProperty("serverInstanceID");
        String j2eeLevel = (String)this.wiz.getProperty("j2eeLevel");
        Boolean createWAR = (Boolean)this.wiz.getProperty("createWAR");
        String warName = null;
        if (createWAR.booleanValue()) {
            warName = (String)this.wiz.getProperty("warName");
        }
        Boolean createJAR = (Boolean)this.wiz.getProperty("createJAR");
        String ejbJarName = null;
        if (createJAR.booleanValue()) {
            ejbJarName = (String)this.wiz.getProperty("jarName");
        }
        Boolean createCAR = (Boolean)this.wiz.getProperty("createCAR");
        String carName = null;
        String mainClass = null;
        if (createCAR.booleanValue()) {
            carName = (String)this.wiz.getProperty("carName");
            mainClass = (String)this.wiz.getProperty("mainClass");
        }
        String platformName = (String)this.wiz.getProperty("setJavaPlatform");
        String sourceLevel = (String)this.wiz.getProperty("setSourceLevel");
        FoldersListSettings.getDefault().setLastUsedServer(serverInstanceID);
        return NewEarProjectWizardIterator.testableInstantiate(dirF, name, j2eeLevel, serverInstanceID, warName, ejbJarName, carName, mainClass, platformName, sourceLevel);
    }

    static Set<FileObject> testableInstantiate(File dirF, String name, String j2eeLevel, String serverInstanceID, String warName, String ejbJarName, String carName, String mainClass, String platformName, String sourceLevel) throws IOException {
        LinkedHashSet<FileObject> resultSet = new LinkedHashSet<FileObject>();
        AntProjectHelper h = EarProjectGenerator.createProject(dirF, name, j2eeLevel, serverInstanceID, sourceLevel);
        FileObject dir = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)dirF));
        Project p = ProjectManager.getDefault().findProject(dir);
        EarProject earProject = (EarProject)p.getLookup().lookup(EarProject.class);
        if (null != earProject) {
            Application app = null;
            try {
                app = DDProvider.getDefault().getDDRoot(earProject.getAppModule().getDeploymentDescriptor());
                app.setDisplayName(name);
                app.write(earProject.getAppModule().getDeploymentDescriptor());
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().log(ioe.getLocalizedMessage());
            }
        }
        resultSet.add(dir);
        AuxiliaryConfiguration aux = h.createAuxiliaryConfiguration();
        ReferenceHelper refHelper = new ReferenceHelper(h, aux, h.getStandardPropertyEvaluator());
        EarProjectProperties epp = new EarProjectProperties((EarProject)p, refHelper, new EarProjectType());
        Project webProject = null;
        if (null != warName) {
            File webAppDir = new File(dirF, warName);
            WebProjectCreateData createData = new WebProjectCreateData();
            createData.setProjectDir(FileUtil.normalizeFile((File)webAppDir));
            createData.setName(warName);
            createData.setServerInstanceID(serverInstanceID);
            createData.setSourceStructure("BluePrints");
            createData.setJavaEEVersion(EarProjectGenerator.checkJ2eeVersion(j2eeLevel, serverInstanceID, J2eeModule.WAR));
            createData.setContextPath('/' + warName);
            createData.setJavaPlatformName(platformName);
            createData.setSourceLevel(sourceLevel);
            AntProjectHelper webHelper = WebProjectUtilities.createProject((WebProjectCreateData)createData);
            FileObject webAppDirFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)webAppDir));
            webProject = ProjectManager.getDefault().findProject(webAppDirFO);
            epp.addJ2eeSubprojects(new Project[]{webProject});
            resultSet.add(webAppDirFO);
        }
        Project appClient = null;
        if (null != carName) {
            File carDir = new File(dirF, carName);
            AntProjectHelper clientHelper = AppClientProjectGenerator.createProject((File)FileUtil.normalizeFile((File)carDir), (String)carName, (String)mainClass, (String)EarProjectGenerator.checkJ2eeVersion(j2eeLevel, serverInstanceID, J2eeModule.CLIENT), (String)serverInstanceID);
            if (platformName != null || sourceLevel != null) {
                AppClientProjectGenerator.setPlatform((AntProjectHelper)clientHelper, (String)platformName, (String)sourceLevel);
            }
            FileObject carDirFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)carDir));
            appClient = ProjectManager.getDefault().findProject(carDirFO);
            epp.addJ2eeSubprojects(new Project[]{appClient});
            resultSet.add(carDirFO);
        }
        if (null != ejbJarName) {
            File ejbJarDir = new File(dirF, ejbJarName);
            AntProjectHelper ejbHelper = EjbJarProjectGenerator.createProject((File)FileUtil.normalizeFile((File)ejbJarDir), (String)ejbJarName, (String)EarProjectGenerator.checkJ2eeVersion(j2eeLevel, serverInstanceID, J2eeModule.EJB), (String)serverInstanceID);
            if (platformName != null || sourceLevel != null) {
                EjbJarProjectGenerator.setPlatform((AntProjectHelper)ejbHelper, (String)platformName, (String)sourceLevel);
            }
            FileObject ejbJarDirFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)ejbJarDir));
            Project ejbJarProject = ProjectManager.getDefault().findProject(ejbJarDirFO);
            epp.addJ2eeSubprojects(new Project[]{ejbJarProject});
            resultSet.add(ejbJarDirFO);
            EarProjectGenerator.addEJBToClassPaths(ejbJarProject, appClient, webProject);
        }
        NewEarProjectWizardIterator.updateModuleURI(warName, carName, epp);
        NewEarProjectWizardIterator.setProjectChooserFolder(dirF);
        return resultSet;
    }

    static void setProjectChooserFolder(File dirF) {
        File parentF;
        File file = parentF = dirF != null ? dirF.getParentFile() : null;
        if (parentF != null && parentF.exists()) {
            ProjectChooser.setProjectsFolder((File)parentF);
        }
    }

    private static void updateModuleURI(String warName, String carName, EarProjectProperties epp) {
        String clientModuleURI = null;
        if (warName != null) {
            String[] webURIs = epp.getWebUris();
            assert (webURIs.length == 1) : "Exactly one application client may be generated during creation. Is: " + webURIs.length;
            clientModuleURI = webURIs[0];
        } else if (carName != null) {
            String[] appClientURIs = epp.getAppClientUris();
            assert (appClientURIs.length == 1) : "Exactly one application client may be generated during creation. Is: " + appClientURIs.length;
            clientModuleURI = appClientURIs[0];
        }
        if (clientModuleURI != null) {
            epp.put("client.module.uri", clientModuleURI);
            epp.store();
        }
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        if (this.wiz != null) {
            this.wiz.putProperty("projdir", null);
            this.wiz.putProperty("name", null);
        }
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage(NewEarProjectWizardIterator.class, (String)"LBL_WizardStepsCount"), this.index + 1, this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    FileObject getIndexJSPFO(FileObject webRoot, String indexJSP) {
        return webRoot.getFileObject(indexJSP.replace('.', '/'), "jsp");
    }
}

