/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.earproject.classpath.BootClassPathImplementation;
import org.netbeans.modules.j2ee.earproject.classpath.ProjectClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

public final class ClassPathProviderImpl
implements ClassPathProvider,
PropertyChangeListener {
    private static final int TYPE_NORMAL = 0;
    private static final int TYPE_BUILT_UNPACKED = 2;
    private static final int TYPE_BUILT_JAR = 3;
    private static final int TYPE_OTHER = -1;
    private static final String BUILD_CLASSES_DIR = "build.classes.dir";
    private static final String DIST_JAR = "dist.jar";
    private static final String DOC_BASE_DIR = "web.docbase.dir";
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final Reference<ClassPath>[] cache = new SoftReference[8];
    private final Map<String, FileObject> dirCache = new HashMap<String, FileObject>();

    public ClassPathProviderImpl(AntProjectHelper helper, PropertyEvaluator evaluator) {
        this.helper = helper;
        this.evaluator = evaluator;
        evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)evaluator));
    }

    private synchronized FileObject getDir(String propname) {
        String prop;
        FileObject fo = this.dirCache.get(propname);
        if (!(fo != null && fo.isValid() || (prop = this.evaluator.getProperty(propname)) == null)) {
            fo = this.helper.resolveFileObject(prop);
            this.dirCache.put(propname, fo);
        }
        return fo;
    }

    private FileObject getBuildClassesDir() {
        return this.getDir(BUILD_CLASSES_DIR);
    }

    private FileObject getDistJar() {
        return this.getDir(DIST_JAR);
    }

    private FileObject getDocumentBaseDir() {
        return this.getDir(DOC_BASE_DIR);
    }

    private int getType(FileObject file) {
        FileObject dir = this.getDocumentBaseDir();
        if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
            return 2;
        }
        dir = this.getBuildClassesDir();
        if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
            return 3;
        }
        dir = this.getDistJar();
        if (dir != null && dir.equals(FileUtil.getArchiveFile((FileObject)file))) {
            return 3;
        }
        return -1;
    }

    private ClassPath getCompileTimeClasspath(FileObject file) {
        int type = this.getType(file);
        return this.getCompileTimeClasspath(type);
    }

    private ClassPath getCompileTimeClasspath(int type) {
        if (type < 0 || type > 2) {
            return null;
        }
        if (type == 2) {
            type = 0;
        }
        ClassPath cp = null;
        if (this.cache[3 + type] == null || (cp = this.cache[3 + type].get()) == null) {
            if (type == 0) {
                cp = ClassPathFactory.createClassPath((ClassPathImplementation)new ProjectClassPathImplementation(this.helper, "${javac.classpath}:${build.classes.dir}", this.evaluator, false));
            }
            this.cache[3 + type] = new SoftReference<ClassPath>(cp);
        }
        return cp;
    }

    private ClassPath getRunTimeClasspath(FileObject file) {
        int type = this.getType(file);
        if (type < 0 || type > 4) {
            return null;
        }
        switch (type) {
            case 2: {
                type = 0;
                break;
            }
            case 3: 
            case 4: {
                type -= 3;
            }
        }
        ClassPath cp = null;
        if (this.cache[6 + type] == null || (cp = this.cache[6 + type].get()) == null) {
            if (type == 0) {
                cp = ClassPathFactory.createClassPath((ClassPathImplementation)new ProjectClassPathImplementation(this.helper, "debug.classpath", this.evaluator));
            }
            this.cache[6 + type] = new SoftReference<ClassPath>(cp);
        }
        return cp;
    }

    private ClassPath getSourcepath(FileObject file) {
        int type = this.getType(file);
        return this.getSourcepath(type);
    }

    private ClassPath getSourcepath(int type) {
        if (type < 0 || type > 2) {
            return null;
        }
        ClassPath cp = null;
        if (this.cache[type] == null || (cp = this.cache[type].get()) == null) {
            if (type == 2) {
                cp = ClassPathFactory.createClassPath((ClassPathImplementation)new ProjectClassPathImplementation(this.helper, DOC_BASE_DIR, this.evaluator));
            }
            this.cache[type] = new SoftReference<ClassPath>(cp);
        }
        return cp;
    }

    private ClassPath getBootClassPath() {
        ClassPath cp = null;
        if (this.cache[7] == null || (cp = this.cache[7].get()) == null) {
            cp = ClassPathFactory.createClassPath((ClassPathImplementation)new BootClassPathImplementation(this.evaluator));
            this.cache[7] = new SoftReference<ClassPath>(cp);
        }
        return cp;
    }

    public ClassPath findClassPath(FileObject file, String type) {
        if (type.equals("classpath/compile")) {
            return this.getCompileTimeClasspath(file);
        }
        if (type.equals("classpath/execute")) {
            return this.getRunTimeClasspath(file);
        }
        if (type.equals("classpath/boot")) {
            return this.getBootClassPath();
        }
        return null;
    }

    public ClassPath[] getProjectClassPaths(String type) {
        if ("classpath/boot".equals(type)) {
            return new ClassPath[]{this.getBootClassPath()};
        }
        if ("classpath/compile".equals(type)) {
            ClassPath[] l = new ClassPath[]{this.getCompileTimeClasspath(0)};
            return l;
        }
        assert (false);
        return null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.dirCache.remove(evt.getPropertyName());
    }
}

