/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class UpdateHelper {
    private static final boolean TRANSPARENT_UPDATE = Boolean.getBoolean("webproject.transparentUpdate");
    private static final String BUILD_NUMBER = System.getProperty("netbeans.buildnumber");
    private final Project project;
    private final AntProjectHelper helper;
    private final AuxiliaryConfiguration cfg;
    private final GeneratedFilesHelper genFileHelper;
    private final Notifier notifier;
    private boolean alreadyAskedInWriteAccess;
    private Boolean isCurrent;
    private Element cachedElement;
    private static final String TAG_FILE = "file";
    private static final String TAG_LIBRARY = "library";
    private static final String ATTR_FILES = "files";
    private static final String ATTR_DIRS = "dirs";
    private ProjectUpdateListener projectUpdateListener;

    UpdateHelper(Project project, AntProjectHelper helper, AuxiliaryConfiguration cfg, GeneratedFilesHelper genFileHelper, Notifier notifier) {
        if (project == null || helper == null || cfg == null || genFileHelper == null || notifier == null) {
            throw new IllegalArgumentException("Constructor argument(s) is(are) null");
        }
        this.project = project;
        this.helper = helper;
        this.cfg = cfg;
        this.genFileHelper = genFileHelper;
        this.notifier = notifier;
    }

    public EditableProperties getProperties(String path) {
        return this.helper.getProperties(path);
    }

    public void putProperties(final String path, final EditableProperties props) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                if (UpdateHelper.this.isCurrent() || !"nbproject/project.properties".equals(path)) {
                    UpdateHelper.this.helper.putProperties(path, props);
                } else if (UpdateHelper.this.canUpdate()) {
                    try {
                        UpdateHelper.this.saveUpdate(props);
                        UpdateHelper.this.helper.putProperties(path, props);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                }
            }
        });
    }

    public Element getPrimaryConfigurationData(final boolean shared) {
        return (Element)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                if (!shared || UpdateHelper.this.isCurrent()) {
                    return UpdateHelper.this.helper.getPrimaryConfigurationData(shared);
                }
                return UpdateHelper.this.getUpdatedSharedConfigurationData();
            }
        });
    }

    public void putPrimaryConfigurationData(final Element element, final boolean shared) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                if (!shared || UpdateHelper.this.isCurrent()) {
                    UpdateHelper.this.helper.putPrimaryConfigurationData(element, shared);
                } else if (UpdateHelper.this.canUpdate()) {
                    try {
                        UpdateHelper.this.saveUpdate(null);
                        UpdateHelper.this.helper.putPrimaryConfigurationData(element, shared);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                }
            }
        });
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }

    public boolean requestSave() throws IOException {
        if (this.isCurrent()) {
            return true;
        }
        if (!this.canUpdate()) {
            return false;
        }
        this.saveUpdate(null);
        return true;
    }

    public synchronized boolean isCurrent() {
        if (this.isCurrent == null) {
            this.isCurrent = this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/j2ee-earproject/1", true) == null ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.isCurrent;
    }

    private boolean canUpdate() {
        if (TRANSPARENT_UPDATE) {
            return true;
        }
        if (this.alreadyAskedInWriteAccess) {
            return false;
        }
        boolean canUpdate = this.notifier.canUpdate();
        if (!canUpdate) {
            this.alreadyAskedInWriteAccess = true;
            ProjectManager.mutex().postReadRequest(new Runnable(){

                public void run() {
                    UpdateHelper.this.alreadyAskedInWriteAccess = false;
                }
            });
        }
        return canUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveUpdate(EditableProperties props) throws IOException {
        this.helper.putPrimaryConfigurationData(this.getUpdatedSharedConfigurationData(), true);
        this.cfg.removeConfigurationFragment("data", "http://www.netbeans.org/ns/j2ee-earproject/1", true);
        ProjectManager.getDefault().saveProject(this.project);
        UpdateHelper updateHelper = this;
        synchronized (updateHelper) {
            this.isCurrent = Boolean.TRUE;
        }
    }

    private synchronized Element getUpdatedSharedConfigurationData() {
        if (this.cachedElement == null) {
            String ns = "http://www.netbeans.org/ns/j2ee-earproject/2";
            Element oldRoot = this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/j2ee-earproject/1", true);
            if (oldRoot != null) {
                Document doc = oldRoot.getOwnerDocument();
                Element newRoot = doc.createElementNS("http://www.netbeans.org/ns/j2ee-earproject/2", "data");
                UpdateHelper.copyDocument(doc, oldRoot, newRoot);
                NodeList libList = newRoot.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-earproject/2", TAG_LIBRARY);
                for (int i = 0; i < libList.getLength(); ++i) {
                    if (libList.item(i).getNodeType() != 1) continue;
                    Element library = (Element)libList.item(i);
                    Node webFile = library.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-earproject/2", TAG_FILE).item(0);
                    String webFileText = UpdateHelper.findText(webFile);
                    if (!(webFileText = webFileText.substring(2, webFileText.length() - 1)).startsWith("libs.")) continue;
                    String libName = webFileText.substring(5, webFileText.indexOf(".classpath"));
                    List roots = LibraryManager.getDefault().getLibrary(libName).getContent("classpath");
                    ArrayList<FileObject> files = new ArrayList<FileObject>();
                    ArrayList<FileObject> dirs = new ArrayList<FileObject>();
                    for (URL rootUrl : roots) {
                        FileObject root = URLMapper.findFileObject((URL)rootUrl);
                        if ("jar".equals(rootUrl.getProtocol())) {
                            root = FileUtil.getArchiveFile((FileObject)root);
                        }
                        if (root == null) continue;
                        if (root.isData()) {
                            files.add(root);
                            continue;
                        }
                        dirs.add(root);
                    }
                    if (files.size() > 0) {
                        library.setAttribute(ATTR_FILES, "" + files.size());
                    }
                    if (dirs.size() <= 0) continue;
                    library.setAttribute(ATTR_DIRS, "" + dirs.size());
                }
                this.cachedElement = newRoot;
            }
        }
        return this.cachedElement;
    }

    private static void copyDocument(Document doc, Element from, Element to) {
        NodeList nl = from.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nl.item(i);
            Node newNode = null;
            switch (node.getNodeType()) {
                case 1: {
                    Element oldElement = (Element)node;
                    newNode = doc.createElementNS("http://www.netbeans.org/ns/j2ee-earproject/2", oldElement.getTagName());
                    NamedNodeMap m = oldElement.getAttributes();
                    Element newElement = (Element)newNode;
                    for (int index = 0; index < m.getLength(); ++index) {
                        Node attr = m.item(index);
                        newElement.setAttribute(attr.getNodeName(), attr.getNodeValue());
                    }
                    UpdateHelper.copyDocument(doc, oldElement, (Element)newNode);
                    break;
                }
                case 3: {
                    Text oldText = (Text)node;
                    newNode = doc.createTextNode(oldText.getData());
                    break;
                }
                case 8: {
                    Comment oldComment = (Comment)node;
                    newNode = doc.createComment(oldComment.getData());
                }
            }
            if (newNode == null) continue;
            to.appendChild(newNode);
        }
    }

    public static Notifier createDefaultNotifier() {
        return new Notifier(){

            public boolean canUpdate() {
                JButton updateOption = new JButton(NbBundle.getMessage(UpdateHelper.class, (String)"CTL_UpdateOption"));
                return DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(UpdateHelper.class, (String)"TXT_ProjectUpdate", (Object)BUILD_NUMBER), NbBundle.getMessage(UpdateHelper.class, (String)"TXT_ProjectUpdateTitle"), -1, 2, new Object[]{updateOption, NotifyDescriptor.CANCEL_OPTION}, (Object)updateOption)) == updateOption;
            }
        };
    }

    private static String findText(Node parent) {
        NodeList l = parent.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            if (l.item(i).getNodeType() != 3) continue;
            Text text = (Text)l.item(i);
            return text.getNodeValue();
        }
        return null;
    }

    public void setProjectUpdateListener(ProjectUpdateListener l) {
        this.projectUpdateListener = l;
    }

    public static interface ProjectUpdateListener {
        public void projectUpdated();
    }

    public static interface Notifier {
        public boolean canUpdate();
    }
}

