/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.UpdateHelper;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.WebModuleProvider;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class EarActionProvider
implements ActionProvider {
    private static final String COMMAND_COMPILE = "compile";
    private static final String COMMAND_VERIFY = "verify";
    private static final String[] supportedActions = new String[]{"build", "clean", "rebuild", "run", "debug", "redeploy", "verify", "delete", "copy", "move", "rename"};
    EarProject project;
    private final UpdateHelper updateHelper;
    Map<String, String[]> commands = new HashMap<String, String[]>();

    public EarActionProvider(EarProject project, UpdateHelper updateHelper) {
        this.commands.put("build", new String[]{"dist"});
        this.commands.put("clean", new String[]{"clean"});
        this.commands.put("rebuild", new String[]{"clean", "dist"});
        this.commands.put("run", new String[]{"run"});
        this.commands.put("debug", new String[]{"debug"});
        this.commands.put("redeploy", new String[]{"run-deploy"});
        this.commands.put("debug", new String[]{"debug"});
        this.commands.put(COMMAND_COMPILE, new String[]{COMMAND_COMPILE});
        this.commands.put(COMMAND_VERIFY, new String[]{COMMAND_VERIFY});
        this.updateHelper = updateHelper;
        this.project = project;
    }

    private FileObject findBuildXml() {
        return this.project.getProjectDirectory().getFileObject(this.project.getBuildXmlName());
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    public void invokeAction(final String command, final Lookup context) throws IllegalArgumentException {
        if ("delete".equals(command)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(command)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("move".equals(command)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("rename".equals(command)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
        Runnable action = new Runnable(){

            public void run() {
                Properties p = new Properties();
                String[] targetNames = EarActionProvider.this.getTargetNames(command, context, p);
                if (targetNames == null) {
                    return;
                }
                if (targetNames.length == 0) {
                    targetNames = null;
                }
                if (p.keySet().size() == 0) {
                    p = null;
                }
                try {
                    ActionUtils.runTarget((FileObject)EarActionProvider.this.findBuildXml(), (String[])targetNames, (Properties)p);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        };
        action.run();
    }

    String[] getTargetNames(String command, Lookup context, Properties p) throws IllegalArgumentException {
        String[] targetNames = this.commands.get(command);
        if (command.equals("run") || command.equals("redeploy")) {
            if (!this.isSelectedServer()) {
                return null;
            }
            if (this.isDebugged()) {
                p.setProperty("is.debugged", "true");
            }
            if (command.equals("redeploy")) {
                p.setProperty("forceRedeploy", "true");
            } else {
                p.setProperty("forceRedeploy", "false");
            }
        } else if (command.equals("debug")) {
            SubprojectProvider spp;
            if (!this.isSelectedServer()) {
                return null;
            }
            if (this.project.evaluator().getProperty("app.client") != null) {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(EarActionProvider.class, (String)"MSG_Server_State_Question"), 3);
                nd.setOptionType(0);
                nd.setOptions(new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION});
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == NotifyDescriptor.YES_OPTION) {
                    nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(EarActionProvider.class, (String)"MSG_Server_State"), 1);
                    Object o = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    return null;
                }
            }
            if (this.isDebugged()) {
                p.setProperty("is.debugged", "true");
            }
            if (null != (spp = (SubprojectProvider)this.project.getLookup().lookup(SubprojectProvider.class))) {
                StringBuilder edbd = new StringBuilder();
                Set s = spp.getSubprojects();
                for (Project proj : s) {
                    FileObject fo;
                    WebModule wm;
                    WebModuleProvider wmp = (WebModuleProvider)proj.getLookup().lookup(WebModuleProvider.class);
                    if (null == wmp || null == (wm = wmp.findWebModule(proj.getProjectDirectory())) || null == (fo = wm.getDocumentBase())) continue;
                    edbd.append(FileUtil.toFile((FileObject)fo).getAbsolutePath() + ":");
                }
                p.setProperty("ear.docbase.dirs", edbd.toString());
            }
        } else if (targetNames == null) {
            throw new IllegalArgumentException(command);
        }
        return targetNames;
    }

    public boolean isActionEnabled(String command, Lookup context) {
        if (this.findBuildXml() == null) {
            return false;
        }
        if (command.equals(COMMAND_VERIFY)) {
            J2eeModuleProvider provider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
            return provider != null && provider.hasVerifierSupport();
        }
        return true;
    }

    private boolean isDebugged() {
        J2eeModuleProvider jmp = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        if (null == jmp) {
            return false;
        }
        ServerDebugInfo sdi = jmp.getServerDebugInfo();
        if (null == sdi) {
            return false;
        }
        Session[] sessions = DebuggerManager.getDebuggerManager().getSessions();
        for (int i = 0; i < sessions.length; ++i) {
            Object o;
            Session s = sessions[i];
            if (s == null || (o = s.lookupFirst(null, AttachingDICookie.class)) == null) continue;
            AttachingDICookie attCookie = (AttachingDICookie)o;
            if (!(sdi.getTransport().equals("dt_shmem") ? attCookie.getSharedMemoryName().equalsIgnoreCase(sdi.getShmemName()) : attCookie.getHostName() != null && attCookie.getHostName().equalsIgnoreCase(sdi.getHost()) && attCookie.getPortNumber() == sdi.getPort())) continue;
            return true;
        }
        return false;
    }

    private boolean isSelectedServer() {
        String[] servInstIDs;
        String id;
        String instance = this.updateHelper.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("j2ee.server.instance");
        if (instance != null && (id = Deployment.getDefault().getServerID(instance)) != null) {
            return true;
        }
        String serverType = this.updateHelper.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("j2ee.server.type");
        if (serverType != null && (servInstIDs = Deployment.getDefault().getInstancesOfServer(serverType)).length > 0) {
            EarProjectProperties.setServerInstance(this.project, this.updateHelper, servInstIDs[0]);
            return true;
        }
        String msg = NbBundle.getMessage(EarActionProvider.class, (String)"MSG_No_Server_Selected");
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 2));
        return false;
    }
}

