/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.diff.DiffAction;
import org.netbeans.modules.diff.builtin.Patch;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.util.io.ReaderInputStream;

public class PatchAction
extends NodeAction {
    private static final String PATCHING_IO_ENCODING = "ISO-8859-1";

    public PatchAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage((Class)PatchAction.class, (String)"CTL_PatchActionName");
    }

    public boolean enable(Node[] nodes) {
        FileObject fo;
        if (nodes.length == 1 && (fo = DiffAction.getFileFromNode(nodes[0])) != null) {
            try {
                return fo.getURL().getProtocol().equals("file");
            }
            catch (FileStateInvalidException fsiex) {
                return false;
            }
        }
        return false;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction(Node[] nodes) {
        final FileObject fo = DiffAction.getFileFromNode(nodes[0]);
        if (fo != null) {
            final File patch = this.getPatchFor(fo);
            if (patch == null) {
                return;
            }
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    Patch.FileDifferences[] fileDiffs;
                    String patchContext = null;
                    try {
                        String encoding = PatchAction.PATCHING_IO_ENCODING;
                        String MAGIC = "# This patch file was generated by NetBeans IDE";
                        BufferedReader r = new BufferedReader(new FileReader(patch));
                        String line = r.readLine();
                        if (MAGIC.equals(line)) {
                            String MAGIC2;
                            encoding = "utf8";
                            line = r.readLine();
                            int idx = line.indexOf(MAGIC2 = "paths are relative to: ");
                            if (idx != -1) {
                                patchContext = line.substring(idx + MAGIC2.length());
                            }
                        }
                        r.close();
                        byte[] buffer = new byte[MAGIC.length()];
                        FileInputStream in = new FileInputStream(patch);
                        int read = ((InputStream)in).read(buffer);
                        ((InputStream)in).close();
                        if (read != -1 && MAGIC.equals(new String(buffer, "utf8"))) {
                            encoding = "utf8";
                        }
                        fileDiffs = Patch.parse(new InputStreamReader((InputStream)new FileInputStream(patch), encoding));
                    }
                    catch (IOException ioex) {
                        ErrorManager.getDefault().annotate((Throwable)ioex, NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)"EXC_PatchParsingFailed", (Object)ioex.getLocalizedMessage()));
                        ErrorManager.getDefault().notify(1, (Throwable)ioex);
                        ErrorManager.getDefault().notify(256, (Throwable)ioex);
                        return;
                    }
                    int numDiffs = 0;
                    for (int i = 0; i < fileDiffs.length; ++i) {
                        numDiffs += fileDiffs[i].getDifferences().length;
                    }
                    if (numDiffs == 0) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)"MSG_NoDifferences", (Object)patch.getName())));
                        return;
                    }
                    PatchAction.this.applyFileDiffs(fileDiffs, fo, patchContext);
                }
            });
        }
    }

    private File getPatchFor(FileObject fo) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, (File)new File(System.getProperty("user.home")));
        chooser.setFileSelectionMode(0);
        String title = NbBundle.getMessage((Class)PatchAction.class, (String)(fo.isData() ? "TITLE_SelectPatchForFile" : "TITLE_SelectPatchForFolder"), (Object)fo.getNameExt());
        chooser.setDialogTitle(title);
        FileFilter patchFilter = new FileFilter(){

            public boolean accept(File f) {
                return f.getName().endsWith("diff") || f.getName().endsWith("patch") || f.isDirectory();
            }

            public String getDescription() {
                return "Patch Files (*.diff, *.patch)";
            }
        };
        chooser.addChoosableFileFilter(patchFilter);
        chooser.setFileFilter(patchFilter);
        chooser.setApproveButtonText(NbBundle.getMessage((Class)PatchAction.class, (String)"BTN_Patch"));
        chooser.setApproveButtonMnemonic(NbBundle.getMessage((Class)PatchAction.class, (String)"BTN_Patch_mnc").charAt(0));
        chooser.setApproveButtonToolTipText(NbBundle.getMessage((Class)PatchAction.class, (String)"BTN_Patch_tooltip"));
        HelpCtx ctx = new HelpCtx(PatchAction.class.getName());
        DialogDescriptor descriptor = new DialogDescriptor((Object)chooser, title, true, new Object[0], null, 0, ctx, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PatchAction.class, (String)"ACSD_PatchDialog"));
        ChooserListener listener = new ChooserListener(dialog, chooser);
        chooser.addActionListener(listener);
        dialog.setVisible(true);
        return listener.getFile();
    }

    private void applyFileDiffs(Patch.FileDifferences[] fileDiffs, FileObject fo, String patchContext) {
        ArrayList<String> notFoundFileNames = new ArrayList<String>();
        ArrayList<FileObject> appliedFiles = new ArrayList<FileObject>();
        HashMap<FileObject, FileObject> backups = new HashMap<FileObject, FileObject>();
        boolean patchFailed = false;
        for (int i = 0; i < fileDiffs.length; ++i) {
            String indexName;
            FileObject targetFileObject = fo.isData() ? fo : ((indexName = fileDiffs[i].getIndexName()) != null ? fo.getFileObject(indexName) : PatchAction.findChild(fo, fileDiffs[i].getFileName()));
            if (targetFileObject == null) {
                Difference[] diffs = fileDiffs[i].getDifferences();
                String filePath = fileDiffs[i].getIndexName();
                if (diffs.length == 1 && diffs[0].getFirstStart() == 0 && filePath != null) {
                    try {
                        targetFileObject = FileUtil.createData((FileObject)fo, (String)filePath);
                    }
                    catch (IOException e) {
                        ErrorManager err = ErrorManager.getDefault();
                        err.annotate((Throwable)e, "Patch can not create new file, skipping...");
                        err.notify(1, (Throwable)e);
                    }
                }
            }
            if (targetFileObject == null) {
                indexName = fileDiffs[i].getIndexName();
                if (indexName != null) {
                    notFoundFileNames.add(FileUtil.getFileDisplayName((FileObject)fo) + '/' + indexName);
                    continue;
                }
                notFoundFileNames.add("sourceHostPath:" + fileDiffs[i].getFileName());
                continue;
            }
            FileObject backup = this.createFileBackup(targetFileObject);
            if (this.applyDiffsTo(fileDiffs[i].getDifferences(), targetFileObject)) {
                appliedFiles.add(targetFileObject);
                backups.put(targetFileObject, backup);
                targetFileObject.refresh(true);
                continue;
            }
            patchFailed = true;
        }
        if (notFoundFileNames.size() > 0) {
            if (notFoundFileNames.size() == fileDiffs.length) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)(patchContext == null ? NbBundle.getMessage((Class)PatchAction.class, (String)"MSG_WrongPatch") : NbBundle.getMessage((Class)PatchAction.class, (String)"MSG_WrongPatch_Hint", (Object)patchContext))));
            } else {
                StringBuffer files = new StringBuffer();
                for (int i = 0; i < notFoundFileNames.size(); ++i) {
                    files.append(notFoundFileNames.get(i).toString());
                    if (i >= notFoundFileNames.size() - 1) continue;
                    files.append(", ");
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)PatchAction.class, (String)"MSG_NotFoundFiles", (Object)files)));
            }
        }
        if (appliedFiles.size() > 0) {
            String message = patchFailed ? NbBundle.getMessage((Class)PatchAction.class, (String)"MSG_PatchAppliedPartially") : NbBundle.getMessage((Class)PatchAction.class, (String)"MSG_PatchAppliedSuccessfully");
            Object notifyResult = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)message, 0));
            if (NotifyDescriptor.YES_OPTION.equals(notifyResult)) {
                this.showDiffs(appliedFiles, backups);
            }
            PatchAction.removeBackups(appliedFiles, backups);
        }
    }

    private static FileObject findChild(FileObject folder, String child) {
        child = child.replace(File.separatorChar, '/');
        StringTokenizer tokenizer = new StringTokenizer(child, "/");
        FileObject ch = null;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            ch = folder.getFileObject(token);
            if (ch == null || !ch.isFolder()) continue;
            folder = ch;
            ch = null;
        }
        return ch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject createFileBackup(FileObject fo) {
        FileObject parent = fo.getParent();
        FileLock lock = null;
        InputStream in = null;
        OutputStream out = null;
        try {
            FileObject orig = parent.getFileObject(fo.getNameExt(), "orig");
            if (orig == null) {
                orig = parent.createData(fo.getNameExt(), "orig");
            }
            in = fo.getInputStream();
            lock = orig.lock();
            out = orig.getOutputStream(lock);
            FileUtil.copy((InputStream)in, (OutputStream)out);
            FileObject fileObject = orig;
            return fileObject;
        }
        catch (IOException ioex) {
            FileObject fileObject = null;
            return fileObject;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ioex) {}
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean applyDiffsTo(Difference[] diffs, FileObject fo) {
        File tmp;
        block55: {
            FileLock lock;
            OutputStream out;
            InputStream in;
            block53: {
                block49: {
                    try {
                        tmp = FileUtil.normalizeFile((File)File.createTempFile("patch", "tmp"));
                    }
                    catch (IOException ioex) {
                        ErrorManager.getDefault().notify((Throwable)ioex);
                        return false;
                    }
                    tmp.deleteOnExit();
                    in = null;
                    InputStreamReader r = null;
                    out = null;
                    r = new InputStreamReader(fo.getInputStream(), PATCHING_IO_ENCODING);
                    Reader patched = Patch.apply(diffs, r);
                    in = new ReaderInputStream(patched, PATCHING_IO_ENCODING);
                    out = new FileOutputStream(tmp);
                    FileUtil.copy((InputStream)in, (OutputStream)out);
                    Object var12_10 = null;
                    try {
                        if (r != null) {
                            ((Reader)r).close();
                        }
                    }
                    catch (IOException ioex2) {
                        ErrorManager.getDefault().notify(1, (Throwable)ioex2);
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException ioex2) {
                        ErrorManager.getDefault().notify(1, (Throwable)ioex2);
                    }
                    try {
                        if (out != null) {
                            out.close();
                        }
                        break block49;
                    }
                    catch (IOException ioex2) {
                        ErrorManager.getDefault().notify(1, (Throwable)ioex2);
                    }
                    break block49;
                    {
                        catch (IOException ioex) {
                            String msg = NbBundle.getMessage((Class)PatchAction.class, (String)"EXC_PatchApplicationFailed", (Object)ioex.getLocalizedMessage(), (Object)fo.getNameExt());
                            NotifyDescriptor.Message dd = new NotifyDescriptor.Message((Object)msg);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                            ErrorManager.getDefault().log(msg);
                            tmp.delete();
                            boolean bl = false;
                            Object var12_11 = null;
                            try {
                                if (r != null) {
                                    ((Reader)r).close();
                                }
                            }
                            catch (IOException ioex2) {
                                ErrorManager.getDefault().notify(1, (Throwable)ioex2);
                            }
                            try {
                                if (in != null) {
                                    in.close();
                                }
                            }
                            catch (IOException ioex2) {
                                ErrorManager.getDefault().notify(1, (Throwable)ioex2);
                            }
                            try {
                                if (out != null) {
                                    out.close();
                                }
                            }
                            catch (IOException ioex2) {
                                ErrorManager.getDefault().notify(1, (Throwable)ioex2);
                            }
                            return bl;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_12 = null;
                        try {
                            if (r != null) {
                                ((Reader)r).close();
                            }
                        }
                        catch (IOException ioex2) {
                            ErrorManager.getDefault().notify(1, (Throwable)ioex2);
                        }
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (IOException ioex2) {
                            ErrorManager.getDefault().notify(1, (Throwable)ioex2);
                        }
                        try {
                            if (out != null) {
                                out.close();
                            }
                        }
                        catch (IOException ioex2) {
                            ErrorManager.getDefault().notify(1, (Throwable)ioex2);
                        }
                        throw throwable;
                    }
                }
                lock = null;
                in = new FileInputStream(tmp);
                lock = fo.lock();
                out = fo.getOutputStream(lock);
                FileUtil.copy((InputStream)in, (OutputStream)out);
                Object var15_22 = null;
                if (lock == null) break block53;
                lock.releaseLock();
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ioex3) {
                ErrorManager.getDefault().notify(1, (Throwable)ioex3);
            }
            try {
                if (out != null) {
                    out.close();
                }
                break block55;
            }
            catch (IOException ioex3) {
                ErrorManager.getDefault().notify(1, (Throwable)ioex3);
            }
            break block55;
            {
                catch (IOException ioex) {
                    ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)ioex, NbBundle.getMessage((Class)PatchAction.class, (String)"EXC_CopyOfAppliedPatchFailed", (Object)fo.getNameExt())));
                    boolean bl = false;
                    Object var15_23 = null;
                    if (lock != null) {
                        lock.releaseLock();
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException ioex3) {
                        ErrorManager.getDefault().notify(1, (Throwable)ioex3);
                    }
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException ioex3) {
                        ErrorManager.getDefault().notify(1, (Throwable)ioex3);
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var15_24 = null;
                if (lock != null) {
                    lock.releaseLock();
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ioex3) {
                    ErrorManager.getDefault().notify(1, (Throwable)ioex3);
                }
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException ioex3) {
                    ErrorManager.getDefault().notify(1, (Throwable)ioex3);
                }
                throw throwable;
            }
        }
        tmp.delete();
        return true;
    }

    private void showDiffs(ArrayList files, HashMap backups) {
        for (int i = 0; i < files.size(); ++i) {
            FileObject file = (FileObject)files.get(i);
            FileObject backup = (FileObject)backups.get(file);
            DiffAction.performAction(backup, file, file);
        }
    }

    private static void removeBackups(List files, Map backups) {
        StringBuffer filenames = new StringBuffer();
        StringBuffer exceptions = new StringBuffer();
        for (int i = 0; i < files.size(); ++i) {
            FileObject targetFileObject = (FileObject)files.get(i);
            FileObject backup = (FileObject)backups.get(targetFileObject);
            if (targetFileObject.getSize() == 0L) {
                try {
                    targetFileObject.delete();
                }
                catch (IOException e) {
                    ErrorManager err = ErrorManager.getDefault();
                    err.annotate((Throwable)e, "Patch can not delete file, skipping...");
                    err.notify(1, (Throwable)e);
                }
            }
            try {
                backup.delete();
                continue;
            }
            catch (IOException ex) {
                filenames.append(FileUtil.getFileDisplayName((FileObject)backup));
                filenames.append("\n");
                exceptions.append(ex.getLocalizedMessage());
                exceptions.append("\n");
            }
        }
        if (filenames.length() > 0) {
            ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)new IOException(), NbBundle.getMessage((Class)PatchAction.class, (String)"EXC_CannotRemoveBackup", (Object)filenames, (Object)exceptions)));
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(PatchAction.class);
    }

    class ChooserListener
    implements ActionListener {
        private Dialog dialog;
        private JFileChooser chooser;
        private File file = null;

        public ChooserListener(Dialog dialog, JFileChooser chooser) {
            this.dialog = dialog;
            this.chooser = chooser;
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command == "ApproveSelection") {
                if (this.dialog != null) {
                    this.file = this.chooser.getSelectedFile();
                    this.dialog.setVisible(false);
                }
            } else if (this.dialog != null) {
                this.file = null;
                this.dialog.setVisible(false);
            }
        }

        public File getFile() {
            return this.file;
        }
    }
}

