/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2ee.blueprints.ui.rating;

import com.sun.j2ee.blueprints.ui.rating.RatingComponent;
import com.sun.j2ee.blueprints.ui.util.BaseRenderer;
import com.sun.j2ee.blueprints.ui.util.Util;
import java.beans.Beans;
import java.io.IOException;
import java.net.URL;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import org.apache.shale.remoting.Mechanism;
import org.apache.shale.remoting.XhtmlHelper;

public class RatingRenderer
extends BaseRenderer {
    private static final int MODE_TOGGLE_CODE = -2;
    private static final String NOT_INTERESTED_OFF_IMAGE = "/META-INF/rating/images/notInterestedOff.gif";
    private static final String NOT_INTERESTED_ON_IMAGE = "/META-INF/rating/images/notInterestedOn.gif";
    private static final String STAR_FULL_IMAGE = "/META-INF/rating/images/starFull.gif";
    private static final String AVERAGE_STAR_FULL_IMAGE = "/META-INF/rating/images/avgStarFull.gif";
    private static final String AVERAGE_STAR_HALF_IMAGE = "/META-INF/rating/images/avgStarHalf.gif";
    private static final String STAR_EMPTY_IMAGE = "/META-INF/rating/images/starEmpty.gif";
    private static final String CLEAR_OFF_IMAGE = "/META-INF/rating/images/clearOff.gif";
    private static final String CLEAR_ON_IMAGE = "/META-INF/rating/images/clearOn.gif";
    private static final String MODE_NORMAL_IMAGE = "/META-INF/rating/images/whoMe.gif";
    private static final String MODE_AVERAGE_IMAGE = "/META-INF/rating/images/whoAvg.gif";
    private static final String CSS_RESOURCE = "/META-INF/rating/styles.css";
    private static final String SCRIPT_RESOURCE = "/META-INF/rating/script.js";
    private static final String RENDER_ONCE = "com.sun.j2ee.blueprints.ui.rating.RENDER_ONCE";
    private static final String RESPONSE_HANDLER = "/bpui_rating_handler/writeAjaxResponse";
    private static XhtmlHelper helper = new XhtmlHelper();

    private void appendDefaultImageInfo(FacesContext context, UIComponent component, StringBuffer sb, String imageInfosKey, String[] jarPaths, String width, String height) {
        sb.append("bpui.rating.defaults.imageInfos[");
        sb.append("\"");
        sb.append(imageInfosKey);
        sb.append("\"");
        sb.append("] = new bpui.rating.ImageInfo(null, new Array(");
        for (int i = 0; i < jarPaths.length; ++i) {
            String imageUrl = this.getImageUrl(context, component, jarPaths[i]);
            sb.append("\"");
            sb.append(imageUrl);
            sb.append("\"");
            if (i >= jarPaths.length - 1) continue;
            sb.append(", ");
        }
        sb.append("), ");
        sb.append(width);
        sb.append(", ");
        sb.append(height);
        sb.append(");");
        sb.append("\n");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String imageUrl;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = component.getClientId(context);
        RatingComponent rating = null;
        if (component instanceof RatingComponent) {
            rating = (RatingComponent)component;
        } else {
            ClassLoader cl;
            System.err.println("RatingRenderer.encodeBegin: expected type " + RatingComponent.class + " but found " + component.getClass());
            System.err.println("RatingRenderer.encodeBegin: class loader hierarchy, starting with RatingComponent.class.getClassLoader():");
            for (cl = RatingComponent.class.getClassLoader(); cl != null; cl = cl.getParent()) {
                System.err.println(cl);
            }
            System.err.println();
            System.err.println("RatingRenderer.encodeBegin: class loader hierarchy, starting with component.getClass().getClassLoader():");
            for (cl = component.getClass().getClassLoader(); cl != null; cl = cl.getParent()) {
                System.err.println(cl);
            }
            System.err.println();
        }
        if (Beans.isDesignTime()) {
            URL cssURL = component.getClass().getResource(CSS_RESOURCE);
            writer.startElement("link", component);
            writer.writeAttribute("type", (Object)"text/css", null);
            writer.writeAttribute("rel", (Object)"stylesheet", null);
            writer.writeURIAttribute("href", (Object)cssURL, null);
            writer.endElement("link");
        } else {
            String[] stringArray;
            String[] stringArray2;
            String[] stringArray3;
            helper.linkStylesheet(context, component, writer, Mechanism.CLASS_RESOURCE, CSS_RESOURCE);
            helper.linkJavascript(context, component, writer, Mechanism.CLASS_RESOURCE, "/META-INF/common/script.js");
            Util.renderDojoLoading(context, component, writer);
            helper.linkJavascript(context, component, writer, Mechanism.CLASS_RESOURCE, SCRIPT_RESOURCE);
            writer.startElement("script", null);
            StringBuffer sb = new StringBuffer();
            if (!context.getExternalContext().getRequestMap().containsKey(RENDER_ONCE)) {
                context.getExternalContext().getRequestMap().put(RENDER_ONCE, Boolean.TRUE);
                sb.append("bpui.rating.defaults = new bpui.rating.DefaultInfo();");
                sb.append("\n");
                String imageInfosKey = "star";
                String[] jarPaths = new String[]{STAR_FULL_IMAGE, AVERAGE_STAR_FULL_IMAGE, AVERAGE_STAR_HALF_IMAGE, STAR_EMPTY_IMAGE};
                String width = "19";
                String height = "15";
                this.appendDefaultImageInfo(context, component, sb, imageInfosKey, jarPaths, width, height);
                imageInfosKey = "notInterested";
                jarPaths = new String[]{NOT_INTERESTED_OFF_IMAGE, NOT_INTERESTED_ON_IMAGE};
                width = "17";
                this.appendDefaultImageInfo(context, component, sb, imageInfosKey, jarPaths, width, height);
                imageInfosKey = "clear";
                jarPaths = new String[]{CLEAR_OFF_IMAGE, CLEAR_ON_IMAGE};
                width = "19";
                this.appendDefaultImageInfo(context, component, sb, imageInfosKey, jarPaths, width, height);
                imageInfosKey = "modeToggle";
                jarPaths = new String[]{MODE_NORMAL_IMAGE, MODE_AVERAGE_IMAGE};
                width = "30";
                this.appendDefaultImageInfo(context, component, sb, imageInfosKey, jarPaths, width, height);
                sb.append("bpui.rating.preloadDefaultImages(bpui.rating.defaults);");
                sb.append("\n");
                writer.write(sb.toString());
                sb.setLength(0);
                String callback = helper.mapResourceId(context, Mechanism.DYNAMIC_RESOURCE, RESPONSE_HANDLER);
                sb.append("bpui.rating.unparameterizedUrl = \"");
                sb.append(callback);
                sb.append("\";");
                sb.append("\n");
                sb.append("bpui.rating.messages[\"bindError\"] = \"");
                sb.append(Util.getMessage("rating.bindError"));
                sb.append("\";");
                sb.append("\n");
                sb.append("bpui.rating.messages[\"unboundGrade\"] = \"");
                sb.append(Util.getMessage("rating.unboundGrade"));
                sb.append("\";");
                sb.append("\n");
                sb.append("bpui.rating.messages[\"unboundInAverageMode\"] = \"");
                sb.append(Util.getMessage("rating.unboundInAverageMode"));
                sb.append("\";");
                sb.append("\n");
                writer.write(sb.toString());
                sb.setLength(0);
            }
            ValueBinding gradeBinding = rating.getValueBinding("grade");
            ValueBinding averageGradeBinding = rating.getValueBinding("averageGrade");
            sb.append("new bpui.rating.Instance(");
            sb.append("\"");
            sb.append(clientId);
            sb.append("\"");
            sb.append(", ");
            sb.append(rating.getMaxGrade());
            sb.append(", ");
            sb.append(rating.isInAverageMode());
            sb.append(", ");
            sb.append(rating.getGrade());
            sb.append(", ");
            sb.append(rating.getAverageGrade());
            sb.append(", ");
            if (gradeBinding != null && gradeBinding.getExpressionString() != null) {
                sb.append("\"");
                sb.append(gradeBinding.getExpressionString());
                sb.append("\"");
            } else {
                sb.append("null");
            }
            sb.append(", ");
            if (averageGradeBinding != null && averageGradeBinding.getExpressionString() != null) {
                sb.append("\"");
                sb.append(averageGradeBinding.getExpressionString());
                sb.append("\"");
            } else {
                sb.append("null");
            }
            sb.append(");");
            sb.append("\n");
            writer.write(sb.toString());
            sb = null;
            String[] whichs = new String[]{null, "notInterested", "clear", "modeToggle"};
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = rating.getHoverTexts();
            if (rating.getNotInterestedHoverText() == null) {
                stringArray3 = null;
            } else {
                String[] stringArray4 = new String[1];
                stringArray3 = stringArray4;
                stringArray4[0] = rating.getNotInterestedHoverText();
            }
            stringArrayArray[1] = stringArray3;
            if (rating.getClearHoverText() == null) {
                stringArray2 = null;
            } else {
                String[] stringArray5 = new String[1];
                stringArray2 = stringArray5;
                stringArray5[0] = rating.getClearHoverText();
            }
            stringArrayArray[2] = stringArray2;
            if (rating.getNormalModeHoverText() != null || rating.getAverageModeHoverText() != null) {
                String[] stringArray6 = new String[2];
                stringArray6[0] = rating.getNormalModeHoverText();
                stringArray = stringArray6;
                stringArray6[1] = rating.getAverageModeHoverText();
            } else {
                stringArray = null;
            }
            stringArrayArray[3] = stringArray;
            String[][] customHoverTextArrays = stringArrayArray;
            for (int i = 0; i < whichs.length; ++i) {
                if (customHoverTextArrays[i] == null) continue;
                writer.write("bpui.rating.state[\"");
                writer.write(clientId);
                if (whichs[i] == null) {
                    writer.write("\"].setStarCustomHoverTexts(new Array(");
                } else {
                    writer.write("\"].setCustomHoverTexts(\"");
                    writer.write(whichs[i]);
                    writer.write("\", new Array(");
                }
                String[] customHoverTexts = customHoverTextArrays[i];
                for (int j = 0; j < customHoverTexts.length; ++j) {
                    if (customHoverTexts[j] == null) {
                        writer.write("null");
                    } else {
                        writer.write("\"");
                        writer.writeText((Object)customHoverTexts[j], null);
                        writer.write("\"");
                    }
                    if (j >= customHoverTexts.length - 1) continue;
                    writer.write(", ");
                }
                writer.write("));\n");
            }
            String[] otherTextProperties = new String[]{"gradeAcknowledgedText", "normalModeAcknowledgedText", "averageModeAcknowledgedText", "normalModeText", "averageModeText"};
            String[] otherTexts = new String[]{rating.getGradeAcknowledgedText(), rating.getNormalModeAcknowledgedText(), rating.getAverageModeAcknowledgedText(), rating.getNormalModeText(), rating.getAverageModeText()};
            for (int i = 0; i < otherTexts.length; ++i) {
                if (otherTexts[i] == null) continue;
                writer.write("bpui.rating.state[\"");
                writer.write(clientId);
                writer.write("\"].");
                writer.write(otherTextProperties[i]);
                writer.write(" = \"");
                writer.writeText((Object)otherTexts[i], null);
                writer.write("\";\n");
            }
            if (rating.isGradeReadOnly()) {
                writer.write("bpui.rating.state[\"");
                writer.write(clientId);
                writer.write("\"].gradeReadOnly = true;\n");
            }
            if (rating.isModeReadOnly()) {
                writer.write("bpui.rating.state[\"");
                writer.write(clientId);
                writer.write("\"].modeReadOnly = true;\n");
            }
            if (rating.getOnGrade() != null && rating.getOnGrade().length() > 0) {
                writer.write("bpui.rating.state[\"");
                writer.write(clientId);
                writer.write("\"].onGrade = ");
                writer.writeText((Object)rating.getOnGrade(), "onGrade");
                writer.write("\n");
            }
            if (rating.getOnModeToggle() != null && rating.getOnModeToggle().length() > 0) {
                writer.write("bpui.rating.state[\"");
                writer.write(clientId);
                writer.write("\"].onModeToggle = ");
                writer.writeText((Object)rating.getOnModeToggle(), "onModeToggle");
                writer.write("\n");
            }
            if (rating.getOnMouse() != null && rating.getOnMouse().length() > 0) {
                writer.write("bpui.rating.state[\"");
                writer.write(clientId);
                writer.write("\"].onMouse = ");
                writer.writeText((Object)rating.getOnMouse(), "onMouse");
                writer.write("\n");
            }
            String[] otherBindings = new String[]{"normalModeText", "averageModeText", "gradeReadOnly", "inAverageMode"};
            for (int i = 0; i < otherBindings.length; ++i) {
                ValueBinding binding = rating.getValueBinding(otherBindings[i]);
                if (binding == null || binding.getExpressionString() == null) continue;
                writer.write("bpui.rating.state[\"");
                writer.write(clientId);
                writer.write("\"].bindings[\"");
                writer.write(otherBindings[i]);
                writer.write("\"] = \"");
                writer.writeText((Object)binding.getExpressionString(), null);
                writer.write("\";\n");
            }
            writer.endElement("script");
            writer.write("\n");
        }
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)clientId, null);
        String style = rating.getStyle();
        String styleClass = rating.getStyleClass();
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        writer.write("\n");
        if (rating.isIncludeText()) {
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)(clientId + "_text"), null);
            writer.writeAttribute("class", (Object)"bpui_rating_text", null);
            String text = null;
            if (rating.isInAverageMode() && rating.getAverageModeText() != null) {
                text = rating.getAverageModeText();
            } else if (!rating.isInAverageMode() && rating.getNormalModeText() != null) {
                text = rating.getNormalModeText();
            }
            if (text == null) {
                writer.write("&nbsp;");
            } else {
                writer.write(text);
            }
            writer.endElement("div");
            writer.write("\n");
        }
        writer.startElement("table", component);
        writer.writeAttribute("id", (Object)(clientId + "_controlArea"), null);
        writer.writeAttribute("class", (Object)"bpui_rating_controlArea", null);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.write("\n");
        writer.startElement("tr", null);
        writer.write("\n");
        String doMousePrefix = "bpui.rating.doMouse(\"";
        String doJoiner = "\", ";
        String doMouseCompositePrefix = doMousePrefix + clientId + doJoiner;
        String doClickPrefix = "bpui.rating.doClick(\"";
        String doClickCompositePrefix = doClickPrefix + clientId + doJoiner;
        String doMouseOverSuffix = ", true)";
        String doMouseOutSuffix = ", false)";
        String doClickSuffix = ")";
        if (rating.isIncludeNotInterested()) {
            writer.startElement("td", null);
            writer.writeAttribute("id", (Object)(clientId + "_notInterestedArea"), null);
            writer.writeAttribute("class", (Object)"bpui_rating_notInterestedArea", null);
            writer.writeAttribute("width", (Object)"17", null);
            writer.writeAttribute("height", (Object)"15", null);
            writer.startElement("img", null);
            writer.writeAttribute("id", (Object)(clientId + "_notInterestedImage"), null);
            String jarPath = rating.getGrade() == -1 && !rating.isInAverageMode() ? NOT_INTERESTED_ON_IMAGE : NOT_INTERESTED_OFF_IMAGE;
            imageUrl = this.getImageUrl(context, component, jarPath);
            writer.writeAttribute("src", (Object)imageUrl, null);
            writer.writeAttribute("width", (Object)"17", null);
            writer.writeAttribute("height", (Object)"15", null);
            writer.writeAttribute("border", (Object)"0", null);
            writer.writeAttribute("onmouseover", (Object)(doMouseCompositePrefix + -1 + doMouseOverSuffix), null);
            writer.writeAttribute("onclick", (Object)(doClickCompositePrefix + -1 + doClickSuffix), null);
            writer.writeAttribute("onmouseout", (Object)(doMouseCompositePrefix + -1 + doMouseOutSuffix), null);
            writer.endElement("img");
            writer.endElement("td");
            writer.write("\n");
        }
        for (int i = 1; i <= rating.getMaxGrade(); ++i) {
            writer.startElement("td", null);
            writer.writeAttribute("id", (Object)(clientId + "_starArea" + i), null);
            writer.writeAttribute("class", (Object)"bpui_rating_starArea", null);
            writer.writeAttribute("width", (Object)"19", null);
            writer.writeAttribute("height", (Object)"15", null);
            writer.startElement("img", null);
            writer.writeAttribute("id", (Object)(clientId + "_starImage" + i), null);
            double diff = rating.isInAverageMode() ? rating.getAverageGrade() - (double)i : (double)(rating.getGrade() - i);
            String jarPath = null;
            jarPath = diff < -0.5 ? STAR_EMPTY_IMAGE : (diff < 0.0 ? (rating.isInAverageMode() ? AVERAGE_STAR_HALF_IMAGE : STAR_EMPTY_IMAGE) : (rating.isInAverageMode() ? AVERAGE_STAR_FULL_IMAGE : STAR_FULL_IMAGE));
            String imageUrl2 = this.getImageUrl(context, component, jarPath);
            writer.writeAttribute("src", (Object)imageUrl2, null);
            writer.writeAttribute("width", (Object)"19", null);
            writer.writeAttribute("height", (Object)"15", null);
            writer.writeAttribute("border", (Object)"0", null);
            writer.writeAttribute("onmouseover", (Object)(doMouseCompositePrefix + i + doMouseOverSuffix), null);
            writer.writeAttribute("onclick", (Object)(doClickCompositePrefix + i + doClickSuffix), null);
            writer.writeAttribute("onmouseout", (Object)(doMouseCompositePrefix + i + doMouseOutSuffix), null);
            writer.endElement("img");
            writer.endElement("td");
            writer.write("\n");
        }
        if (rating.isIncludeClear() || rating.isIncludeModeToggle()) {
            writer.startElement("td", null);
            writer.writeAttribute("id", (Object)(clientId + "_spacerArea"), null);
            writer.writeAttribute("class", (Object)"bpui_rating_spacerArea", null);
            writer.writeAttribute("width", (Object)"10", null);
            writer.writeAttribute("height", (Object)"15", null);
            writer.endElement("td");
            writer.write("\n");
        }
        if (rating.isIncludeClear()) {
            writer.startElement("td", null);
            writer.writeAttribute("id", (Object)(clientId + "_clearArea"), null);
            writer.writeAttribute("class", (Object)"bpui_rating_clearArea", null);
            writer.writeAttribute("width", (Object)"19", null);
            writer.writeAttribute("height", (Object)"15", null);
            writer.startElement("img", null);
            writer.writeAttribute("id", (Object)(clientId + "_clearImage"), null);
            String jarPath = CLEAR_OFF_IMAGE;
            imageUrl = this.getImageUrl(context, component, jarPath);
            writer.writeAttribute("src", (Object)imageUrl, null);
            writer.writeAttribute("width", (Object)"19", null);
            writer.writeAttribute("height", (Object)"15", null);
            writer.writeAttribute("border", (Object)"0", null);
            writer.writeAttribute("onmouseover", (Object)(doMouseCompositePrefix + 0 + doMouseOverSuffix), null);
            writer.writeAttribute("onclick", (Object)(doClickCompositePrefix + 0 + doClickSuffix), null);
            writer.writeAttribute("onmouseout", (Object)(doMouseCompositePrefix + 0 + doMouseOutSuffix), null);
            writer.endElement("img");
            writer.endElement("td");
            writer.write("\n");
        }
        if (rating.isIncludeModeToggle()) {
            writer.startElement("td", null);
            writer.writeAttribute("id", (Object)(clientId + "_modeToggleArea"), null);
            writer.writeAttribute("class", (Object)"bpui_rating_modeToggleArea", null);
            writer.writeAttribute("width", (Object)"30", null);
            writer.writeAttribute("height", (Object)"15", null);
            writer.startElement("img", null);
            writer.writeAttribute("id", (Object)(clientId + "_modeToggleImage"), null);
            String jarPath = rating.isInAverageMode() ? MODE_AVERAGE_IMAGE : MODE_NORMAL_IMAGE;
            imageUrl = this.getImageUrl(context, component, jarPath);
            writer.writeAttribute("src", (Object)imageUrl, null);
            writer.writeAttribute("width", (Object)"30", null);
            writer.writeAttribute("height", (Object)"15", null);
            writer.writeAttribute("border", (Object)"0", null);
            writer.writeAttribute("onmouseover", (Object)(doMouseCompositePrefix + -2 + doMouseOverSuffix), null);
            writer.writeAttribute("onclick", (Object)(doClickCompositePrefix + -2 + doClickSuffix), null);
            writer.writeAttribute("onmouseout", (Object)(doMouseCompositePrefix + -2 + doMouseOutSuffix), null);
            writer.endElement("img");
            writer.endElement("td");
            writer.write("\n");
        }
        writer.endElement("tr");
        writer.write("\n");
        writer.endElement("table");
        writer.write("\n");
        writer.endElement("div");
        writer.write("\n");
    }

    private String getImageUrl(FacesContext context, UIComponent component, String jarPath) {
        if (Beans.isDesignTime()) {
            return component.getClass().getResource(jarPath).toString();
        }
        return helper.mapResourceId(context, Mechanism.CLASS_RESOURCE, jarPath);
    }
}

