/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2ee.blueprints.ui.maplocator;

import com.sun.j2ee.blueprints.ui.maplocator.GeoCoder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.http.HttpServletResponse;

public class MapLocatorPhaseListener
implements PhaseListener {
    private static final String SCRIPT_VIEW_ID = "ajax-maplocator-script.js";
    private static final String PROXY_HOST = "com.sun.faces.proxyHost";
    private static final String PROXY_PORT = "com.sun.faces.proxyPort";
    private static final String SCRIPT_LOCATION = "META-INF/maplocator/script.js";

    public void afterPhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        String rootId = context.getViewRoot().getViewId();
        if (rootId.endsWith(SCRIPT_VIEW_ID)) {
            this.handleResourceRequest(event, SCRIPT_LOCATION, "text/javascript");
        } else {
            String locationParam = (String)event.getFacesContext().getExternalContext().getRequestParameterMap().get("location");
            if (locationParam != null) {
                this.handleAjaxRequest(event, locationParam);
            }
        }
    }

    private void handleResourceRequest(PhaseEvent event, String resource, String contentType) {
        URL url = MapLocatorPhaseListener.getCurrentLoader(this).getResource(resource);
        URLConnection conn = null;
        InputStream stream = null;
        BufferedReader bufReader = null;
        HttpServletResponse response = (HttpServletResponse)event.getFacesContext().getExternalContext().getResponse();
        OutputStreamWriter outWriter = null;
        String curLine = null;
        try {
            outWriter = new OutputStreamWriter((OutputStream)response.getOutputStream(), response.getCharacterEncoding());
            conn = url.openConnection();
            conn.setUseCaches(false);
            stream = conn.getInputStream();
            bufReader = new BufferedReader(new InputStreamReader(stream));
            response.setContentType(contentType);
            response.setStatus(200);
            while (null != (curLine = bufReader.readLine())) {
                outWriter.write(curLine + "\n");
            }
            outWriter.flush();
            outWriter.close();
            event.getFacesContext().responseComplete();
        }
        catch (Exception e) {
            String message = "Can't load resource:" + url.toExternalForm();
            System.err.println(message);
            e.printStackTrace();
        }
    }

    private void handleAjaxRequest(PhaseEvent event, String locationParam) {
        FacesContext context = event.getFacesContext();
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        String proxyHost = context.getExternalContext().getInitParameter(PROXY_HOST);
        String proxyPort = context.getExternalContext().getInitParameter(PROXY_PORT);
        String result = null;
        try {
            result = GeoCoder.locate(proxyHost, proxyPort, locationParam);
            response.setContentType("text/xml");
            response.setHeader("Cache-Control", "no-cache");
            response.setStatus(200);
            if (result != null) {
                response.getWriter().write(result);
            }
            event.getFacesContext().responseComplete();
        }
        catch (Exception e) {
            response.setContentType("text/xml");
            response.setHeader("Cache-Control", "no-cache");
            String errorMsg = "<Error>" + e.getMessage() + "</Error>";
            response.setStatus(200);
            try {
                response.getWriter().write(errorMsg);
            }
            catch (IOException ioe) {
                System.err.println(ioe.getMessage());
                e.printStackTrace();
            }
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public void beforePhase(PhaseEvent event) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    public static ClassLoader getCurrentLoader(Object fallbackClass) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return loader;
    }
}

