/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2ee.blueprints.ui.autocomplete;

import com.sun.j2ee.blueprints.ui.autocomplete.CompletionResult;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AutoCompletePhaseListener
implements PhaseListener {
    static final int MAX_RESULTS_RETURNED = 10;
    private static final String AJAX_VIEW_ID = "auto-complete-pl.faces";

    public void afterPhase(PhaseEvent event) {
        try {
            String rootId = event.getFacesContext().getViewRoot().getViewId();
            if (rootId.indexOf(AJAX_VIEW_ID) != -1) {
                this.handleAjaxRequest(event);
            }
        }
        catch (Exception e) {
            System.out.println("AutoCompletePhaseListener afterPhase() threw an exception!");
            e.printStackTrace(System.out);
        }
    }

    private void handleAjaxRequest(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        Object object = context.getExternalContext().getRequest();
        if (!(object instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)object;
        String prefix = request.getParameter("prefix");
        String method = request.getParameter("method");
        StringBuffer sb = new StringBuffer();
        boolean namesAdded = false;
        try {
            CompletionResult results = this.getCompletionItems(context, method, prefix);
            List items = results.getItems();
            int n = Math.min(10, items.size());
            if (n > 0) {
                sb.append("<items>");
                Iterator it = items.iterator();
                while (it.hasNext()) {
                    sb.append("<item>");
                    sb.append(it.next().toString());
                    sb.append("</item>");
                }
                sb.append("</items>");
                response.setContentType("text/xml");
                response.setHeader("Cache-Control", "no-cache");
                response.getWriter().write(sb.toString());
            } else {
                response.setStatus(204);
            }
            event.getFacesContext().responseComplete();
            return;
        }
        catch (EvaluationException ee) {
            ee.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private CompletionResult getCompletionItems(FacesContext context, String methodExpr, String prefix) {
        if (UIComponentTag.isValueReference((String)methodExpr)) {
            Class[] argTypes = new Class[]{FacesContext.class, String.class, CompletionResult.class};
            MethodBinding vb = context.getApplication().createMethodBinding(methodExpr, argTypes);
            CompletionResult result = new CompletionResult();
            Object[] args = new Object[]{context, prefix, result};
            vb.invoke(context, args);
            return result;
        }
        throw new FacesException("Method binding expression '" + methodExpr + "' is not an expression");
    }

    public void beforePhase(PhaseEvent event) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }
}

