/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.BasicTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.DefaultTabLayoutModel;
import org.netbeans.swing.tabcontrol.plaf.ScrollingTabLayoutModel;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.netbeans.swing.tabcontrol.plaf.TabState;

public abstract class BasicScrollingTabDisplayerUI
extends BasicTabDisplayerUI {
    protected AbstractButton[] controlButtons;
    protected LayoutManager layoutManager;
    private Rectangle scratch = new Rectangle();
    private int lastKnownModelSize = Integer.MAX_VALUE;
    static SoftReference ctx = null;

    public BasicScrollingTabDisplayerUI(TabDisplayer displayer) {
        super(displayer);
    }

    protected final TabLayoutModel createLayoutModel() {
        DefaultTabLayoutModel dtlm = new DefaultTabLayoutModel(this.displayer.getModel(), this.displayer);
        return new ScrollingTabLayoutModel(dtlm, this.selectionModel, this.displayer.getModel());
    }

    protected TabState createTabState() {
        return new ScrollingTabState();
    }

    protected HierarchyListener createHierarchyListener() {
        return new ScrollingHierarchyListener();
    }

    public void makeTabVisible(int tab) {
        if (this.scroll().makeVisible(tab, this.getTabsAreaWidth())) {
            this.getTabsVisibleArea(this.scratch);
            this.displayer.repaint(this.scratch.x, this.scratch.y, this.scratch.width, this.scratch.height);
        }
    }

    protected final int getTabsAreaWidth() {
        int result = this.displayer.getWidth();
        Insets ins = this.getTabAreaInsets();
        return result - (ins.left + ins.right);
    }

    protected final int getLastVisibleTab() {
        if (this.displayer.getModel().size() == 0) {
            return -1;
        }
        return this.scroll().getLastVisibleTab(this.getTabsAreaWidth());
    }

    protected final int getFirstVisibleTab() {
        if (this.displayer.getModel().size() == 0) {
            return -1;
        }
        return this.scroll().getFirstVisibleTab(this.getTabsAreaWidth());
    }

    protected void install() {
        super.install();
        this.layoutManager = this.createLayout();
        this.controlButtons = this.createControlButtons();
        this.installControlButtons();
        ((ScrollingTabLayoutModel)this.layoutModel).setPixelsToAddToSelection(this.defaultRenderer.getPixelsToAddToSelection());
    }

    protected void uninstall() {
        super.uninstall();
        this.displayer.setLayout(null);
        this.displayer.removeAll();
    }

    protected abstract LayoutManager createLayout();

    protected abstract AbstractButton[] createControlButtons();

    protected ComponentListener createComponentListener() {
        return new ScrollingDisplayerComponentListener();
    }

    protected void modelChanged() {
        int modelSize;
        this.scroll().clearCachedData();
        int index = this.selectionModel.getSelectedIndex();
        if (index >= this.scroll().getCachedFirstVisibleTab() && index < this.scroll().getCachedLastVisibleTab()) {
            this.makeTabVisible(this.selectionModel.getSelectedIndex());
        }
        if ((modelSize = this.displayer.getModel().size()) < this.lastKnownModelSize) {
            this.scroll().ensureAvailableSpaceUsed(true);
        }
        this.lastKnownModelSize = modelSize;
        super.modelChanged();
    }

    protected void installControlButtons() {
        this.displayer.setLayout(this.layoutManager);
        for (int i = 0; i < this.controlButtons.length; ++i) {
            this.displayer.add(this.controlButtons[i]);
        }
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    protected final ScrollingTabLayoutModel scroll() {
        return (ScrollingTabLayoutModel)this.layoutModel;
    }

    protected void processMouseWheelEvent(MouseWheelEvent e) {
        int i = e.getWheelRotation();
        this.tabState.clearTransientStates();
        int offset = this.scroll().getOffset();
        if (i > 0 && offset < this.displayer.getModel().size() - 1) {
            if (this.scroll().isLastTabClipped()) {
                this.scroll().setOffset(offset + 1);
            }
        } else if (i < 0) {
            if (offset >= 0) {
                this.scroll().setOffset(offset - 1);
            }
        } else {
            return;
        }
        this.displayer.repaint();
    }

    public static Graphics2D getOffscreenGraphics() {
        BufferedImage result = null;
        if (ctx != null) {
            result = (BufferedImage)ctx.get();
        }
        if (result == null) {
            result = new BufferedImage(10, 10, 1);
            ctx = new SoftReference<BufferedImage>(result);
        }
        return (Graphics2D)result.getGraphics();
    }

    protected static class OnPressButton
    extends JButton {
        public OnPressButton(Action a) {
            super(a);
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void processMouseEvent(MouseEvent me) {
            super.processMouseEvent(me);
            if (this.isEnabled()) {
                if (me.getID() == 501) {
                    Icon defaultIcon = this.getIcon();
                    Icon pressedIcon = this.getPressedIcon();
                    if (null != defaultIcon && null != pressedIcon) {
                        this.setIcon(pressedIcon);
                        this.setPressedIcon(defaultIcon);
                    }
                    this.getAction().actionPerformed(new ActionEvent(this, 1001, "pressed"));
                    return;
                }
            }
            if (!this.isEnabled()) return;
            if (me.getID() != 502) return;
            Icon defaultIcon = this.getPressedIcon();
            Icon pressedIcon = this.getIcon();
            if (null == defaultIcon) return;
            if (null == pressedIcon) return;
            this.setIcon(defaultIcon);
            this.setPressedIcon(pressedIcon);
        }
    }

    protected static class TimerButton
    extends JButton
    implements ActionListener {
        Timer timer = null;
        Image disabledImage = null;
        Image enabledImage = null;
        boolean useCachedPainting = true;
        int count = 0;

        public TimerButton(Action a) {
            this(a, true);
        }

        public TimerButton(Action a, boolean useCachedPainting) {
            super(a);
            this.useCachedPainting = useCachedPainting;
        }

        private Timer getTimer() {
            if (this.timer == null) {
                this.timer = new Timer(400, this);
                this.timer.setRepeats(true);
            }
            return this.timer;
        }

        public void actionPerformed(ActionEvent e) {
            ++this.count;
            if (this.count > 2) {
                if (this.count > 5) {
                    this.timer.setDelay(75);
                } else {
                    this.timer.setDelay(200);
                }
            }
            this.performAction();
        }

        private void performAction() {
            if (!this.isEnabled()) {
                this.stopTimer();
                return;
            }
            this.getAction().actionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
        }

        private void startTimer() {
            this.performAction();
            Timer t = this.getTimer();
            if (t.isRunning()) {
                return;
            }
            this.repaint();
            t.setDelay(400);
            t.start();
        }

        private void stopTimer() {
            if (this.timer != null) {
                this.timer.stop();
            }
            this.repaint();
            this.count = 0;
        }

        /*
         * Unable to fully structure code
         */
        protected void processMouseEvent(MouseEvent me) {
            if (!this.isEnabled()) ** GOTO lbl-1000
            if (me.getID() == 501) {
                this.startTimer();
            } else if (me.getID() == 502) {
                this.stopTimer();
            }
            super.processMouseEvent(me);
        }

        protected void processFocusEvent(FocusEvent fe) {
            super.processFocusEvent(fe);
            if (fe.getID() == 1005) {
                this.stopTimer();
            }
        }

        protected void paintComponent(Graphics g) {
            if (this.useCachedPainting) {
                boolean enabled = this.isEnabled();
                if (enabled && this.enabledImage == null || !enabled && this.disabledImage == null) {
                    GraphicsConfiguration gc = this.getGraphicsConfiguration();
                    BufferedImage intermediateImage = gc.createCompatibleImage(16, 18, 2);
                    Graphics2D gImg = (Graphics2D)((Image)intermediateImage).getGraphics();
                    Composite old = gImg.getComposite();
                    gImg.setComposite(AlphaComposite.Src);
                    gImg.setColor(new Color(0, 0, 0, 0));
                    gImg.fillRect(0, 0, 16, 18);
                    gImg.setClip(0, 0, 16, 18);
                    gImg.setComposite(old);
                    super.paintComponent(gImg);
                    gImg.dispose();
                    if (enabled) {
                        this.enabledImage = intermediateImage;
                    } else {
                        this.disabledImage = intermediateImage;
                    }
                }
                g.drawImage(enabled ? this.enabledImage : this.disabledImage, 0, 0, null);
            } else {
                super.paintComponent(g);
            }
        }
    }

    protected class ScrollingHierarchyListener
    extends AbstractTabDisplayerUI.DisplayerHierarchyListener {
        protected ScrollingHierarchyListener() {
        }

        public void hierarchyChanged(HierarchyEvent e) {
            super.hierarchyChanged(e);
            if ((e.getChangeFlags() & 4L) != 0L && BasicScrollingTabDisplayerUI.this.displayer.isShowing() && BasicScrollingTabDisplayerUI.this.tabState != null && BasicScrollingTabDisplayerUI.this.selectionModel != null) {
                BasicScrollingTabDisplayerUI.this.tabState.setActive(BasicScrollingTabDisplayerUI.this.displayer.isActive());
                BasicScrollingTabDisplayerUI.this.makeTabVisible(BasicScrollingTabDisplayerUI.this.selectionModel.getSelectedIndex());
            }
        }
    }

    protected class ScrollingDisplayerComponentListener
    extends ComponentAdapter {
        protected ScrollingDisplayerComponentListener() {
        }

        public void componentResized(ComponentEvent e) {
            BasicScrollingTabDisplayerUI.this.makeTabVisible(BasicScrollingTabDisplayerUI.this.selectionModel.getSelectedIndex());
        }
    }

    protected class ScrollingTabState
    extends BasicTabDisplayerUI.BasicTabState {
        protected ScrollingTabState() {
            super(BasicScrollingTabDisplayerUI.this);
        }

        public int getState(int tabIndex) {
            int result = super.getState(tabIndex);
            int first = BasicScrollingTabDisplayerUI.this.getFirstVisibleTab();
            int last = BasicScrollingTabDisplayerUI.this.getLastVisibleTab();
            if (tabIndex < first || tabIndex > last) {
                return 64;
            }
            if (first == last && first == tabIndex && BasicScrollingTabDisplayerUI.this.displayer.getModel().size() > 1) {
                result |= 3;
            } else if (BasicScrollingTabDisplayerUI.this.getTabsAreaWidth() < BasicScrollingTabDisplayerUI.this.scroll().getMinimumLeftClippedWidth() + BasicScrollingTabDisplayerUI.this.scroll().getMinimumRightClippedWidth() && tabIndex == first && last == first - 1 && BasicScrollingTabDisplayerUI.this.displayer.getModel().size() > 1 && BasicScrollingTabDisplayerUI.this.scroll().isLastTabClipped()) {
                result |= 2;
            } else {
                if (tabIndex == first && BasicScrollingTabDisplayerUI.this.scroll().getOffset() == first) {
                    result |= 2;
                }
                if (tabIndex == last && BasicScrollingTabDisplayerUI.this.scroll().isLastTabClipped()) {
                    result |= 1;
                }
            }
            return result;
        }
    }
}

