/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import org.netbeans.api.debugger.jpda.JPDABreakpoint;

public final class MethodBreakpoint
extends JPDABreakpoint {
    public static final String PROP_METHOD_NAME = "methodName";
    public static final String PROP_BREAKPOINT_TYPE = "breakpointtType";
    public static final String PROP_CONDITION = "condition";
    public static final String PROP_CLASS_FILTERS = "classFilters";
    public static final String PROP_CLASS_EXCLUSION_FILTERS = "classExclusionFilters";
    public static final int TYPE_METHOD_ENTRY = 1;
    public static final int TYPE_METHOD_EXIT = 2;
    private String[] classFilters = new String[0];
    private String[] classExclusionFilters = new String[0];
    private String methodName = "";
    private int breakpointType = 1;
    private String condition = "";

    private MethodBreakpoint() {
    }

    public static MethodBreakpoint create(String className, String methodName) {
        MethodBreakpoint b = new MethodBreakpoint();
        b.setClassFilters(new String[]{className});
        b.setMethodName(methodName);
        return b;
    }

    public static MethodBreakpoint create() {
        MethodBreakpoint b = new MethodBreakpoint();
        return b;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String mn) {
        if (mn != null) {
            mn = mn.trim();
        }
        if (mn == this.methodName || mn != null && this.methodName != null && this.methodName.equals(mn)) {
            return;
        }
        String old = this.methodName;
        this.methodName = mn;
        this.firePropertyChange(PROP_METHOD_NAME, old, mn);
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String cond) {
        if (cond != null) {
            cond = cond.trim();
        }
        String old = this.condition;
        this.condition = cond;
        this.firePropertyChange(PROP_CONDITION, old, cond);
    }

    public int getBreakpointType() {
        return this.breakpointType;
    }

    public void setBreakpointType(int breakpointType) {
        if (breakpointType == this.breakpointType) {
            return;
        }
        if ((breakpointType & 3) == 0) {
            throw new IllegalArgumentException();
        }
        int old = this.breakpointType;
        this.breakpointType = breakpointType;
        this.firePropertyChange(PROP_BREAKPOINT_TYPE, new Integer(old), new Integer(breakpointType));
    }

    public String[] getClassFilters() {
        return this.classFilters;
    }

    public void setClassFilters(String[] classFilters) {
        if (classFilters == this.classFilters) {
            return;
        }
        String[] old = this.classFilters;
        this.classFilters = classFilters;
        this.firePropertyChange(PROP_CLASS_FILTERS, old, classFilters);
    }

    public String[] getClassExclusionFilters() {
        return this.classExclusionFilters;
    }

    public void setClassExclusionFilters(String[] classExclusionFilters) {
        if (classExclusionFilters == this.classExclusionFilters) {
            return;
        }
        String[] old = this.classExclusionFilters;
        this.classExclusionFilters = classExclusionFilters;
        this.firePropertyChange(PROP_CLASS_EXCLUSION_FILTERS, old, classExclusionFilters);
    }

    public String toString() {
        return "MethodBreakpoint " + this.classFilters + "." + this.methodName;
    }
}

