/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class VerifyClassLinkage
extends Task {
    private File jar;
    private boolean failOnError = true;
    private boolean warnOnDefaultPackage = true;
    private Path classpath = new Path(this.getProject());

    public Path createClasspath() {
        return this.classpath.createPath();
    }

    public void setJar(File jar) {
        this.jar = jar;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setWarnOnDefaultPackage(boolean warnOnDefaultPackage) {
        this.warnOnDefaultPackage = warnOnDefaultPackage;
    }

    public void execute() throws BuildException {
        if (this.jar == null) {
            throw new BuildException("Must specify a JAR file", this.getLocation());
        }
        try {
            HashMap<String, Boolean> loadable = new HashMap<String, Boolean>();
            HashMap classfiles = new HashMap();
            this.read(this.jar, classfiles, new HashSet());
            for (String clazz : classfiles.keySet()) {
                loadable.put(clazz, Boolean.TRUE);
                if (!this.warnOnDefaultPackage || clazz.indexOf(47) != -1) continue;
                this.log("Warning: class '" + clazz + "' found in default package", 1);
            }
            AntClassLoader loader = new AntClassLoader(ClassLoader.getSystemClassLoader().getParent(), this.getProject(), this.classpath, true);
            for (Map.Entry entry : classfiles.entrySet()) {
                String clazz = (String)entry.getKey();
                byte[] data = (byte[])entry.getValue();
                this.verify(clazz, data, loadable, (ClassLoader)loader);
            }
        }
        catch (IOException e) {
            throw new BuildException("While verifying " + this.jar + " or its Class-Path extensions: " + e, (Throwable)e, this.getLocation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(File jar, Map classfiles, Set alreadyRead) throws IOException {
        if (!alreadyRead.add(jar)) {
            this.log("Already read " + jar, 3);
            return;
        }
        this.log("Reading " + jar, 3);
        JarFile jf = new JarFile(jar);
        try {
            String cp;
            Enumeration<JarEntry> e = jf.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class")) continue;
                String clazz = name.substring(0, name.length() - 6);
                ByteArrayOutputStream baos = new ByteArrayOutputStream(Math.max((int)entry.getSize(), 0));
                InputStream is = jf.getInputStream(entry);
                try {
                    int read;
                    byte[] buf = new byte[4096];
                    while ((read = is.read(buf)) != -1) {
                        baos.write(buf, 0, read);
                    }
                }
                finally {
                    is.close();
                }
                classfiles.put(clazz, baos.toByteArray());
            }
            Manifest mf = jf.getManifest();
            if (mf != null && (cp = mf.getMainAttributes().getValue(Attributes.Name.CLASS_PATH)) != null) {
                String[] uris = cp.trim().split("[, ]+");
                for (int i = 0; i < uris.length; ++i) {
                    File otherJar = new File(jar.toURI().resolve(uris[i]));
                    if (!otherJar.isFile()) continue;
                    this.read(otherJar, classfiles, alreadyRead);
                }
            }
        }
        finally {
            jf.close();
        }
    }

    private static void skip(DataInput input, int bytes) throws IOException {
        int skipped = input.skipBytes(bytes);
        if (skipped != bytes) {
            throw new IOException();
        }
    }

    private void verify(String clazz, byte[] data, Map loadable, ClassLoader loader) throws IOException, BuildException {
        int i;
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(data));
        VerifyClassLinkage.skip(input, 8);
        int size = input.readUnsignedShort() - 1;
        String[] utf8Strings = new String[size];
        boolean[] isClassName = new boolean[size];
        block7: for (i = 0; i < size; ++i) {
            byte tag = input.readByte();
            switch (tag) {
                case 1: {
                    utf8Strings[i] = input.readUTF();
                    continue block7;
                }
                case 7: {
                    int index = input.readUnsignedShort() - 1;
                    if (index >= size) {
                        throw new IOException("CONSTANT_Class index " + index + " too big for size of pool " + size);
                    }
                    isClassName[index] = true;
                    continue block7;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    VerifyClassLinkage.skip(input, 4);
                    continue block7;
                }
                case 8: {
                    VerifyClassLinkage.skip(input, 2);
                    continue block7;
                }
                case 5: 
                case 6: {
                    VerifyClassLinkage.skip(input, 8);
                    ++i;
                    continue block7;
                }
                default: {
                    throw new IOException("Unrecognized constant pool tag " + tag + " at index " + i + "; running UTF-8 strings: " + Arrays.asList(utf8Strings));
                }
            }
        }
        this.log("UTF-8 strings: " + Arrays.asList(utf8Strings), 4);
        for (i = 0; i < size; ++i) {
            if (!isClassName[i]) continue;
            String vmname = utf8Strings[i];
            while (vmname.charAt(0) == '[') {
                vmname = vmname.substring(1);
            }
            if (vmname.length() == 1) continue;
            String clazz2 = vmname.charAt(vmname.length() - 1) == ';' && vmname.charAt(0) == 'L' ? vmname.substring(1, vmname.length() - 1) : vmname;
            Boolean exists = (Boolean)loadable.get(clazz2);
            if (exists == null) {
                exists = loader.getResource(clazz2 + ".class") != null;
                loadable.put(clazz2, exists);
            }
            if (exists.booleanValue()) continue;
            String message = clazz.replace('/', '.') + " cannot access " + clazz2.replace('/', '.');
            if (this.failOnError) {
                throw new BuildException(message, this.getLocation());
            }
            this.log("Warning: " + message, 1);
        }
    }
}

