/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.netbeans.nbbuild.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ModuleTracking {
    private static final String ELEMENT_MODULE_TRACKING = "tracking";
    private static final String ELEMENT_MODULE = "module";
    private static final String ATTR_MODULE_NAME = "name";
    private static final String ELEMENT_FILE = "file";
    private static final String ATTR_FILE_NAME = "name";
    private static final String ATTR_CODE_NAME = "codename";
    private static final String ATTR_MODULE_PATH = "path";
    private static final String ATTR_NBM_HOME_PAGE = "nbmhomepage";
    private static final String ATTR_NBM_FILE_NAME = "nbmfilename";
    private static final String ATTR_NBM_NEEDS_RESTART = "nbmneedsrestart";
    private static final String ATTR_NBM_IS_GLOBAL = "nbmisglobal";
    private static final String ATTR_NBM_RELEASE_DATE = "nbmreleasedate";
    private static final String ATTR_NBM_MODULE_AUTHOR = "nbmmoduleauthor";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String TRACKING_FILE = "module_tracking.xml";
    private boolean pError = false;
    private File trackingFile = null;
    private String nbPath = null;
    private Tracking tracking = null;

    public ModuleTracking(String nbPath) {
        this.nbPath = nbPath;
        File directory = new File(nbPath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        this.trackingFile = new File(directory, TRACKING_FILE);
        this.read();
    }

    public void putModule(String name, String codename, String path, String nbmfilename, String nbmhomepage, String nbmneedsrestart, String nbmreleasedate, String nbmmoduleauthor, String nbmisglobal, String[] files) {
        if (name == null) {
            return;
        }
        Module modByName = this.tracking.getModule(name);
        Module modByCodeName = this.tracking.getModuleByCodeName(codename);
        Module module = null;
        if (modByName != null) {
            module = modByName;
        } else if (modByCodeName != null) {
            module = modByCodeName;
        }
        if (module == null) {
            module = new Module();
            module.setName(name);
            module.setCodeName(codename);
            module.setPath(path);
            this.tracking.addModule(module);
        }
        if (module.getNbmFileName().equals("")) {
            module.setNbmFileName(nbmfilename);
        }
        if (module.getNbmHomePage().equals("")) {
            module.setNbmHomePage(nbmhomepage);
        }
        if (module.getNbmModuleAuthor().equals("")) {
            module.setNbmModuleAuthor(nbmmoduleauthor);
        }
        if (module.getNbmNeedsRestart().equals("")) {
            module.setNbmNeedsRestart(nbmneedsrestart);
        }
        if (module.getNbmReleaseDate().equals("")) {
            module.setNbmReleaseDate(nbmreleasedate);
        }
        if (module.getNbmIsGlobal().equals("")) {
            module.setNbmIsGlobal(nbmisglobal);
        }
        module.putFiles(files);
    }

    public Map getModules() {
        return this.tracking.getModules();
    }

    public Hashtable getModulesByCodeName() {
        return this.tracking.getModulesByCodeName();
    }

    public Iterator getFilesForModule(String name) {
        Module module = this.tracking.getModule(name);
        if (module == null) {
            return null;
        }
        String[] files = new String[module.getFiles().size()];
        return module.getFiles().iterator();
    }

    public String getModulePath(String name) {
        Module module = this.tracking.getModule(name);
        if (module == null) {
            return null;
        }
        return module.getPath();
    }

    void write() {
        Document document = XMLUtil.createDocument(ELEMENT_MODULE_TRACKING);
        Element e_module_tracking = document.getDocumentElement();
        for (Module mod : this.tracking.getModules().values()) {
            Element e_module = document.createElement(ELEMENT_MODULE);
            assert (mod.getName() != null) : mod.getCodeName();
            e_module.setAttribute("name", mod.getName());
            e_module.setAttribute(ATTR_CODE_NAME, mod.getCodeName());
            e_module.setAttribute(ATTR_MODULE_PATH, mod.getPath());
            e_module.setAttribute(ATTR_NBM_FILE_NAME, mod.getNbmFileName());
            e_module.setAttribute(ATTR_NBM_HOME_PAGE, mod.getNbmHomePage());
            e_module.setAttribute(ATTR_NBM_MODULE_AUTHOR, mod.getNbmModuleAuthor());
            e_module.setAttribute(ATTR_NBM_NEEDS_RESTART, mod.getNbmNeedsRestart());
            e_module.setAttribute(ATTR_NBM_IS_GLOBAL, mod.getNbmIsGlobal());
            e_module.setAttribute(ATTR_NBM_RELEASE_DATE, mod.getNbmReleaseDate());
            e_module_tracking.appendChild(e_module);
            for (String file : mod.getFiles()) {
                Element e_file = document.createElement(ELEMENT_FILE);
                e_file.setAttribute("name", file.replace(File.separatorChar, '/'));
                e_module.appendChild(e_file);
            }
        }
        try {
            FileOutputStream os = new FileOutputStream(this.trackingFile);
            XMLUtil.write(document, os);
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.trackingFile.delete();
            throw new BuildException("Could not write update tracking file " + this.trackingFile.getAbsolutePath(), (Throwable)e);
        }
    }

    private void read() {
        if (this.trackingFile.exists()) {
            Document document;
            try {
                FileInputStream is = new FileInputStream(this.trackingFile);
                InputSource xmlInputSource = new InputSource(is);
                document = XMLUtil.parse(xmlInputSource, false, false, new ErrorCatcher(), null);
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (SAXException e) {
                System.out.println("Module tracking file " + this.trackingFile.getAbsolutePath() + " is not well formatted XML document");
                e.printStackTrace();
                return;
            }
            catch (IOException e) {
                System.out.println("I/O error when accessing module tracking file " + this.trackingFile.getAbsolutePath());
                e.printStackTrace();
                return;
            }
            Element element = document.getDocumentElement();
            if (element != null && element.getTagName().equals(ELEMENT_MODULE_TRACKING)) {
                this.scanElement_module_tracking(element);
            }
        }
        if (this.tracking == null) {
            this.tracking = new Tracking();
        }
    }

    void scanElement_module_tracking(Element element) {
        this.tracking = new Tracking();
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(nodeElement = (Element)node).getTagName().equals(ELEMENT_MODULE)) continue;
            this.scanElement_module(nodeElement, this.tracking);
        }
    }

    void scanElement_module(Element element, Tracking tracking) {
        Module module = new Module();
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("name")) {
                module.setName(attr.getValue());
            }
            if (attr.getName().equals(ATTR_CODE_NAME)) {
                module.setCodeName(attr.getValue());
            }
            if (attr.getName().equals(ATTR_MODULE_PATH)) {
                module.setPath(attr.getValue());
            }
            if (attr.getName().equals(ATTR_NBM_HOME_PAGE)) {
                module.setNbmHomePage(attr.getValue());
            }
            if (attr.getName().equals(ATTR_NBM_FILE_NAME)) {
                module.setNbmFileName(attr.getValue());
            }
            if (attr.getName().equals(ATTR_NBM_NEEDS_RESTART)) {
                module.setNbmNeedsRestart(attr.getValue());
            }
            if (attr.getName().equals(ATTR_NBM_IS_GLOBAL)) {
                module.setNbmIsGlobal(attr.getValue());
            }
            if (attr.getName().equals(ATTR_NBM_RELEASE_DATE)) {
                module.setNbmReleaseDate(attr.getValue());
            }
            if (!attr.getName().equals(ATTR_NBM_MODULE_AUTHOR)) continue;
            module.setNbmModuleAuthor(attr.getValue());
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(nodeElement = (Element)node).getTagName().equals(ELEMENT_FILE)) continue;
            this.scanElement_file(nodeElement, module);
        }
        tracking.addModule(module);
    }

    void scanElement_file(Element element, Module module) {
        String file = null;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (!attr.getName().equals("name")) continue;
            file = attr.getValue();
        }
        module.addFile(file.replace(File.separatorChar, '/'));
    }

    class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        private void message(String level, SAXParseException e) {
            ModuleTracking.this.pError = true;
        }

        public void error(SAXParseException e) {
            ModuleTracking.this.pError = true;
        }

        public void warning(SAXParseException e) {
        }

        public void fatalError(SAXParseException e) {
            ModuleTracking.this.pError = true;
        }
    }

    public class Module {
        private String name;
        private String codename;
        private String path;
        private String nbmhomepage = "";
        private String nbmfilename = "";
        private String nbmneedsrestart = "";
        private String nbmisglobal = "";
        private String nbmreleasedate = "";
        private String nbmmoduleauthor = "";
        private List files = new ArrayList();

        String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = name;
        }

        String getCodeName() {
            return this.codename;
        }

        void setCodeName(String codename) {
            this.codename = codename;
        }

        String getPath() {
            return this.path;
        }

        void setPath(String path) {
            this.path = path;
        }

        String getNbmHomePage() {
            if (this.nbmhomepage == null) {
                return "";
            }
            return this.nbmhomepage;
        }

        void setNbmHomePage(String nbmh) {
            if (nbmh != null) {
                this.nbmhomepage = nbmh;
            }
        }

        String getNbmFileName() {
            if (this.nbmfilename == null) {
                return "";
            }
            return this.nbmfilename;
        }

        void setNbmFileName(String nbmfn) {
            if (nbmfn != null) {
                this.nbmfilename = nbmfn;
            }
        }

        String getNbmNeedsRestart() {
            if (this.nbmneedsrestart == null) {
                return "";
            }
            return this.nbmneedsrestart;
        }

        void setNbmNeedsRestart(String nbmnr) {
            if (nbmnr != null) {
                this.nbmneedsrestart = nbmnr;
            }
        }

        void setNbmIsGlobal(String isGlobal) {
            if (isGlobal != null) {
                this.nbmisglobal = isGlobal;
            }
        }

        String getNbmIsGlobal() {
            return this.nbmisglobal;
        }

        String getNbmReleaseDate() {
            if (this.nbmreleasedate == null) {
                return "";
            }
            return this.nbmreleasedate;
        }

        void setNbmReleaseDate(String nbmrd) {
            if (nbmrd != null) {
                this.nbmreleasedate = nbmrd;
            }
        }

        String getNbmModuleAuthor() {
            if (this.nbmmoduleauthor == null) {
                return "";
            }
            return this.nbmmoduleauthor;
        }

        void setNbmModuleAuthor(String nbmma) {
            if (nbmma != null) {
                this.nbmmoduleauthor = nbmma;
            }
        }

        List getFiles() {
            return this.files;
        }

        void setFiles(List files) {
            this.files = files;
        }

        public void addFile(String filename) {
            this.files.add(filename.replace(File.separatorChar, '/'));
        }

        public void putFiles(String[] list) {
            for (int i = 0; i < list.length; ++i) {
                if (this.files.contains(list[i].replace(File.separatorChar, '/'))) continue;
                this.files.add(list[i].replace(File.separatorChar, '/'));
            }
        }
    }

    public class Tracking {
        private Map modules = new HashMap();
        private Hashtable modulesByCodeName = new Hashtable();

        Map getModules() {
            return this.modules;
        }

        Hashtable getModulesByCodeName() {
            return this.modulesByCodeName;
        }

        void setModulesByCodeName(Hashtable modules) {
            this.modulesByCodeName = modules;
        }

        public void addModule(Module module) {
            this.modules.put(module.getName(), module);
            this.modulesByCodeName.put(module.getCodeName(), module);
        }

        public Module getModule(String name) {
            return (Module)this.modules.get(name);
        }

        public Module getModuleByCodeName(String codename) {
            return (Module)this.modulesByCodeName.get(codename);
        }
    }
}

