/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;

public class ServiceLocatorStrategy {
    private static final String CREATE = ".create()";
    private ClassPath cp;
    private String cName;

    private ServiceLocatorStrategy(ClassPath cp, String s) {
        this.cp = cp;
        this.cName = s;
    }

    public String genLocalEjbStringLookup(String jndiName, String homeName, JavaClass targetClass, boolean create) {
        String initString = this.initString("getLocalHome", jndiName, targetClass, "");
        return "return " + this.addCast(create, homeName, initString, CREATE) + ";";
    }

    public String genRemoteEjbStringLookup(String jndiName, String homeCls, JavaClass targetClass, boolean create) {
        String initString = this.initString("getRemoteHome", jndiName, targetClass, "," + homeCls + ".class");
        return "return " + this.addCast(create, homeCls, initString, CREATE) + ";";
    }

    public String genDestinationLookup(String jndiName, JavaClass targetClass) {
        return this.initString("getDestination", jndiName, targetClass, "");
    }

    public String genJMSFactory(String jndiName, JavaClass targetClass) {
        return this.initString("getConnectionFactory", jndiName, targetClass, "");
    }

    public String genDataSource(String jndiName, JavaClass targetClass) {
        return this.initString("getDataSource", jndiName, targetClass, "");
    }

    public String genMailSession(String jndiName, JavaClass targetClass) {
        return this.initString("getSession", jndiName, targetClass, "");
    }

    public static ServiceLocatorStrategy create(Project p, FileObject srcFile, String serviceLocator) {
        ClassPathProvider cpp = (ClassPathProvider)p.getLookup().lookup(ClassPathProvider.class);
        assert (cpp != null) : "project doesn't have class path provider";
        ClassPath cp = cpp.findClassPath(srcFile, "classpath/source");
        assert (cp != null) : "project doesn't have a source classpath";
        ClassPath ccp = cpp.findClassPath(srcFile, "classpath/compile");
        assert (cpp != null) : "project doesn't have a compile classpath";
        ClassPath aggregate = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{cp, ccp});
        return new ServiceLocatorStrategy(aggregate, serviceLocator);
    }

    private ClassPath buildClassPathFromImportedProject(FileObject fo) {
        Project p = FileOwnerQuery.getOwner((FileObject)fo);
        assert (p != null) : "cannot find project for file";
        ClassPathProvider cpp = (ClassPathProvider)p.getLookup().lookup(ClassPathProvider.class);
        assert (cpp != null) : "project doesn't have class path provider";
        Sources s = ProjectUtils.getSources((Project)p);
        SourceGroup[] groups = s.getSourceGroups("java");
        ClassPath cp = ClassPathSupport.createClassPath((List)Collections.EMPTY_LIST);
        for (int i = 0; i < groups.length; ++i) {
            FileObject root = groups[i].getRootFolder();
            if (root.getChildren().length <= 0) continue;
            ClassPath tcp = cpp.findClassPath(root.getChildren()[0], "classpath/source");
            cp = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{tcp, cp});
        }
        return cp;
    }

    private String addCast(boolean cast, String clName, String current, String inv) {
        String newValue = current;
        newValue = "(" + clName + ") " + current;
        if (cast) {
            newValue = "(" + newValue + ")" + inv;
        }
        return newValue;
    }

    private String initString(String methodName, String jndiName, JavaClass ce, String otherParams) {
        String initString = null;
        JavaClass serviceLocator = this.findClass(this.cp);
        Method staticCreation = null;
        if (serviceLocator != null) {
            staticCreation = this.getStaticLocator(serviceLocator);
        }
        initString = staticCreation != null ? this.cName + "." + staticCreation.getName() + "()." + methodName + "(\"java:comp/env/" + jndiName + "\"" + otherParams + ")" : this.findOrCreateArtifacts(ce) + "()." + methodName + "(\"java:comp/env/" + jndiName + "\"" + otherParams + ")";
        return initString;
    }

    private String findOrCreateArtifacts(JavaClass target) {
        String methodName = null;
        Method[] methods = JMIUtils.getMethods((JavaClass)target);
        for (int i = 0; i < methods.length; ++i) {
            String returnValue = methods[i].getType().getName();
            if (!returnValue.equals(this.cName) || methods[i].getParameters().size() != 0) continue;
            methodName = methods[i].getName();
            break;
        }
        if (methodName == null) {
            Field fe = JMIUtils.createField((JavaClass)target, (String)"serviceLocator", (String)this.cName);
            fe.setModifiers(2);
            target.getContents().add(fe);
            Method me = JMIUtils.createMethod((JavaClass)target);
            me.setType(fe.getType());
            me.setName("getServiceLocator");
            me.setModifiers(2);
            String body = "if (" + fe.getName() + " == null) {\n" + fe.getName() + " = new " + this.cName + "();\n" + "}\n" + "return " + fe.getName() + ";\n";
            me.setBodyText(body);
            target.getContents().add(me);
            methodName = me.getName();
        }
        return methodName;
    }

    private JavaClass findClass(ClassPath cp) {
        return JMIUtils.findClass((String)this.cName, (ClassPath)cp);
    }

    private Method getStaticLocator(JavaClass ce) {
        Method[] methods = JMIUtils.getMethods((JavaClass)ce);
        String cName = ce.getName();
        for (int i = 0; i < methods.length; ++i) {
            if (!Modifier.isStatic(methods[i].getModifiers()) || !Modifier.isPublic(methods[i].getModifiers()) || !methods[i].getType().getName().equals(cName)) continue;
            return methods[i];
        }
        return null;
    }
}

