/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestination;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.AssemblyDescriptor;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.JMSDestination;

public class MessageDestinationPanelController {
    public Object[] getJMSProjectRepresentation() {
        Project[] proj = OpenProjects.getDefault().getOpenProjects();
        LinkedList<ProjectView> l = new LinkedList<ProjectView>();
        for (int i = 0; i < proj.length; ++i) {
            if (EjbJar.getEjbJars((Project)proj[i]).length <= 0) continue;
            l.add(new ProjectView(proj[i]));
        }
        return l.toArray(new ProjectView[l.size()]);
    }

    public org.netbeans.modules.j2ee.dd.api.ejb.EjbJar getEjbJar(Object item) throws IOException {
        Project p = ((ProjectView)item).getProject();
        EjbJar apiEjbJar = EjbJar.getEjbJars((Project)p)[0];
        return DDProvider.getDefault().getMergedDDRoot(apiEjbJar.getMetadataUnit());
    }

    public List extractEjbProjectDestinations(org.netbeans.modules.j2ee.dd.api.ejb.EjbJar dd, Object selectedItem) {
        Project p = ((ProjectView)selectedItem).getProject();
        LinkedList<JMSDestination> l = new LinkedList<JMSDestination>();
        AssemblyDescriptor ad = dd.getSingleAssemblyDescriptor();
        if (ad != null) {
            try {
                MessageDestination[] destination = ad.getMessageDestination();
                if (destination != null) {
                    for (int i = 0; i < destination.length; ++i) {
                        String name = destination[i].getMessageDestinationName();
                        String type = this.findEjbBinding(name, dd);
                        if (type == null) continue;
                        l.add(new JMSDestination(name, p, type));
                    }
                }
            }
            catch (VersionNotSupportedException vnse) {
                // empty catch block
            }
        }
        return l;
    }

    private String findEjbBinding(String destinationName, org.netbeans.modules.j2ee.dd.api.ejb.EjbJar dd) {
        if (dd.getEnterpriseBeans() == null || dd.getEnterpriseBeans().getEjbs() == null) {
            return null;
        }
        MessageDriven[] md = dd.getEnterpriseBeans().getMessageDriven();
        if (md != null) {
            for (int i = 0; i < md.length; ++i) {
                try {
                    if ((md[i].getMessagingType() == null || md[i].getMessagingType().equals("javax.jms.MessageListener")) && destinationName.equals(md[i].getMessageDestinationLink())) {
                        return md[i].getMessageDestinationType();
                    }
                    continue;
                }
                catch (VersionNotSupportedException vnse) {
                    // empty catch block
                }
            }
        }
        Ejb[] ejb = dd.getEnterpriseBeans().getEjbs();
        for (int i = 0; i < ejb.length; ++i) {
            try {
                MessageDestinationRef[] refs = ejb[i].getMessageDestinationRef();
                String type = this.findDestinationRef(destinationName, refs);
                if (type == null) continue;
                return type;
            }
            catch (VersionNotSupportedException vnse) {
                // empty catch block
            }
        }
        return null;
    }

    private String findDestinationRef(String destination, MessageDestinationRef[] refs) {
        String type = null;
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                boolean jms;
                boolean consumes = "Consumes".equals(refs[i].getMessageDestinationUsage());
                String destinationType = refs[i].getMessageDestinationType();
                boolean bl = jms = "javax.jms.Queue".equals(destinationType) || "javax.jms.Topic".equals(destinationType);
                if (!consumes || !jms || !destination.equals(refs[i].getMessageDestinationLink())) continue;
                type = destinationType;
            }
        }
        return type;
    }

    private static class ProjectView {
        private Project p;

        public ProjectView(Project p) {
            this.p = p;
        }

        public String toString() {
            return ProjectUtils.getInformation((Project)this.p).getDisplayName();
        }

        public Project getProject() {
            return this.p;
        }
    }
}

