/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared;

import java.io.IOException;
import java.util.ArrayList;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestination;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.AssemblyDescriptor;
import org.netbeans.modules.j2ee.dd.api.ejb.ContainerTransaction;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelation;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelationshipRole;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.netbeans.modules.j2ee.dd.api.ejb.Method;
import org.netbeans.modules.j2ee.dd.api.ejb.MethodPermission;
import org.netbeans.modules.j2ee.dd.api.ejb.Relationships;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.dnd.EjbReferenceImpl;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class EjbViewController {
    private final Ejb model;
    private final org.netbeans.modules.j2ee.dd.api.ejb.EjbJar module;
    private final Project myProject;
    private final ClassPath srcPath;

    public EjbViewController(Ejb model, org.netbeans.modules.j2ee.dd.api.ejb.EjbJar module, ClassPath src) {
        this.model = model;
        this.module = module;
        this.srcPath = src;
        this.myProject = FileOwnerQuery.getOwner((FileObject)this.srcPath.getRoots()[0]);
    }

    public String getDisplayName() {
        String name = this.model.getDefaultDisplayName();
        if (name == null) {
            name = this.model.getEjbName();
        }
        return name;
    }

    public void delete(boolean deleteClasses) throws IOException {
        EnterpriseBeans beans = this.module.getEnterpriseBeans();
        J2eeModuleProvider pwm = (J2eeModuleProvider)this.myProject.getLookup().lookup(J2eeModuleProvider.class);
        pwm.getConfigSupport().ensureConfigurationReady();
        this.deleteTraces();
        if (this.model instanceof MessageDriven) {
            try {
                AssemblyDescriptor assemblyDescriptor = this.module.getSingleAssemblyDescriptor();
                String mdLinkName = ((MessageDriven)this.model).getMessageDestinationLink();
                MessageDestination[] messageDestinations = assemblyDescriptor.getMessageDestination();
                for (int i = 0; i < messageDestinations.length; ++i) {
                    if (!messageDestinations[i].getMessageDestinationName().equals(mdLinkName)) continue;
                    assemblyDescriptor.removeMessageDestination(messageDestinations[i]);
                    break;
                }
            }
            catch (VersionNotSupportedException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        beans.removeEjb(this.model);
        this.writeDD();
        if (deleteClasses) {
            this.deleteClasses();
        }
    }

    public EjbReference createEjbReference() {
        AntArtifact[] antArtifacts = AntArtifactQuery.findArtifactsByType((Project)this.myProject, (String)"jar");
        AntArtifact moduleJarTarget = antArtifacts == null || antArtifacts.length == 0 ? null : antArtifacts[0];
        return new EjbReferenceImpl(moduleJarTarget, (EntityAndSession)this.model);
    }

    private FileObject findBeanFo() {
        return this.srcPath.findResource(this.model.getEjbClass().replace('.', '/') + ".java");
    }

    public DataObject getBeanDo() {
        FileObject src = this.findBeanFo();
        try {
            if (src != null) {
                return DataObject.find((FileObject)src);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public JavaClass getBeanClass() {
        return (JavaClass)JMIUtils.resolveType((String)this.model.getEjbClass());
    }

    public String getRemoteStringRepresentation(String ejbType) {
        assert (this.model instanceof EntityAndSession);
        EntityAndSession refModel = (EntityAndSession)this.model;
        String s = "\t<ejb-ref>\n\t\t<ejb-ref-name>ejb/" + this.model.getEjbName() + "</ejb-ref-name>\n" + "\t\t<ejb-ref-type>" + ejbType + "</ejb-ref-type>\n" + "\t\t<home>" + refModel.getHome() + "</home>\n" + "\t\t<remote>" + refModel.getRemote() + "</remote>\n" + "\t</ejb-ref>\n";
        return s;
    }

    public String getLocalStringRepresentation(String ejbType) {
        assert (this.model instanceof EntityAndSession);
        EntityAndSession refModel = (EntityAndSession)this.model;
        String s = "\t<ejb-local-ref>\n\t\t<ejb-ref-name>ejb/" + this.model.getEjbName() + "</ejb-ref-name>\n" + "\t\t<ejb-ref-type>" + ejbType + "</ejb-ref-type>\n" + "\t\t<local-home>" + refModel.getLocalHome() + "</local-home>\n" + "\t\t<local>" + refModel.getLocal() + "</local>\n" + "\t</ejb-local-ref>\n";
        return s;
    }

    private void writeDD() throws IOException {
        EjbJar apiEjbJar = EjbJar.getEjbJar((FileObject)this.srcPath.getRoots()[0]);
        FileObject ddFile = apiEjbJar.getDeploymentDescriptor();
        DDProvider.getDefault().getMergedDDRoot(apiEjbJar.getMetadataUnit()).write(ddFile);
    }

    private boolean isEjbUsed(EjbRelationshipRole role, String ejbName) {
        return role != null && role.getRelationshipRoleSource() != null && ejbName.equals(role.getRelationshipRoleSource().getEjbName());
    }

    private void deleteRelationships(String ejbName) {
        EjbRelation[] relations;
        Relationships r = this.module.getSingleRelationships();
        if (r != null && (relations = r.getEjbRelation()) != null) {
            for (int i = 0; i < relations.length; ++i) {
                if (!this.isEjbUsed(relations[i].getEjbRelationshipRole(), ejbName) && !this.isEjbUsed(relations[i].getEjbRelationshipRole2(), ejbName)) continue;
                r.removeEjbRelation(relations[i]);
            }
            if (r.sizeEjbRelation() == 0) {
                this.module.setRelationships(null);
            }
        }
    }

    private void deleteTraces() {
        String ejbName = this.model.getEjbName();
        String ejbNameCompare = ejbName + "";
        this.deleteRelationships(ejbName);
        AssemblyDescriptor ad = this.module.getSingleAssemblyDescriptor();
        if (ad != null) {
            ContainerTransaction[] ct = ad.getContainerTransaction();
            for (int i = 0; i < ct.length; ++i) {
                Method[] methods = ct[i].getMethod();
                methods = methods == null ? new Method[]{} : methods;
                for (int method = 0; method < methods.length; ++method) {
                    if (!ejbNameCompare.equals(methods[method].getEjbName())) continue;
                    ct[i].removeMethod(methods[method]);
                    if (ct[i].sizeMethod() != 0) continue;
                    ad.removeContainerTransaction(ct[i]);
                }
            }
            MethodPermission[] permissions = ad.getMethodPermission();
            for (int i = 0; i < permissions.length; ++i) {
                Method[] methods = permissions[i].getMethod();
                methods = methods == null ? new Method[]{} : methods;
                for (int method = 0; method < methods.length; ++method) {
                    if (!ejbNameCompare.equals(methods[method].getEjbName())) continue;
                    permissions[i].removeMethod(methods[method]);
                    if (permissions[i].sizeMethod() != 0) continue;
                    ad.removeMethodPermission(permissions[i]);
                }
            }
        }
    }

    private FileObject getFileObject(String className) {
        assert (className != null) : "cannot find null className";
        return this.srcPath.findResource(className.replace('.', '/') + ".java");
    }

    private void deleteClasses() {
        ArrayList<FileObject> classFileObjects = new ArrayList<FileObject>();
        classFileObjects.add(this.getFileObject(this.model.getEjbClass()));
        if (this.model instanceof EntityAndSession) {
            EntityAndSession entityAndSessionfModel = (EntityAndSession)this.model;
            if (entityAndSessionfModel.getLocalHome() != null) {
                classFileObjects.add(this.getFileObject(entityAndSessionfModel.getLocalHome()));
                classFileObjects.add(this.getFileObject(entityAndSessionfModel.getLocal()));
                classFileObjects.add(this.getFileObject(entityAndSessionfModel.getLocal() + "Business"));
            }
            if (entityAndSessionfModel.getHome() != null) {
                classFileObjects.add(this.getFileObject(entityAndSessionfModel.getHome()));
                classFileObjects.add(this.getFileObject(entityAndSessionfModel.getRemote()));
                classFileObjects.add(this.getFileObject(entityAndSessionfModel.getRemote() + "Business"));
            }
        }
        for (int i = 0; i < classFileObjects.size(); ++i) {
            FileObject fo = (FileObject)classFileObjects.get(i);
            if (fo == null) continue;
            try {
                DataObject dataObject = DataObject.find((FileObject)fo);
                assert (dataObject != null) : "cannot find DataObject for " + fo.getPath();
                if (dataObject == null) continue;
                dataObject.delete();
                continue;
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify(256, (Throwable)ioe);
            }
        }
    }
}

