/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.api.methodcontroller;

import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.AbstractMethodController;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.MethodType;

class SessionGenerateFromImplVisitor
implements MethodType.MethodTypeVisitor,
AbstractMethodController.GenerateFromImpl {
    private Method intfMethod;
    private JavaClass destination;
    private JavaClass home;
    private JavaClass component;

    SessionGenerateFromImplVisitor() {
    }

    public void getInterfaceMethodFromImpl(MethodType m, JavaClass home, JavaClass component) {
        this.home = home;
        this.component = component;
        m.accept(this);
    }

    public Method getInterfaceMethod() {
        return this.intfMethod;
    }

    public JavaClass getDestinationInterface() {
        return this.destination;
    }

    public void visit(MethodType.BusinessMethodType bmt) {
        this.intfMethod = JMIUtils.duplicate((Method)bmt.getMethodElement());
        this.destination = this.component;
    }

    public void visit(MethodType.CreateMethodType cmt) {
        this.intfMethod = JMIUtils.duplicate((Method)cmt.getMethodElement());
        String origName = this.intfMethod.getName();
        String newName = this.chopAndUpper(origName, "ejb");
        this.intfMethod.setName(newName);
        this.intfMethod.setType(JMIUtils.resolveType((String)this.home.getName()));
        this.destination = this.home;
    }

    public void visit(MethodType.HomeMethodType hmt) {
        assert (false) : "session beans do not have home methods";
    }

    public void visit(MethodType.FinderMethodType fmt) {
        assert (false) : "session beans do not have finder methods";
    }

    private String chopAndUpper(String fullName, String chop) {
        StringBuffer sb = new StringBuffer(fullName);
        sb.delete(0, chop.length());
        sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
        return sb.toString();
    }
}

