/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.valve;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.LabelValueBean;
import org.apache.webapp.admin.Lists;
import org.apache.webapp.admin.valve.AccessLogValveForm;
import org.apache.webapp.admin.valve.RemoteAddrValveForm;
import org.apache.webapp.admin.valve.RemoteHostValveForm;
import org.apache.webapp.admin.valve.RequestDumperValveForm;
import org.apache.webapp.admin.valve.SingleSignOnValveForm;

public class AddValveAction
extends Action {
    private ArrayList types = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        MessageResources resources = this.getResources(request);
        String[] valveTypes = new String[]{"AccessLogValve", "RemoteAddrValve", "RemoteHostValve", "RequestDumperValve", "SingleSignOn"};
        String parent = request.getParameter("parent");
        String type = request.getParameter("type");
        if (type == null) {
            type = "AccessLogValve";
        }
        this.types = new ArrayList();
        this.types.add(new LabelValueBean(type, "AddValve.do?parent=" + URLEncoder.encode(parent, "UTF-8") + "&type=" + type));
        for (int i = 0; i < valveTypes.length; ++i) {
            if (type.equalsIgnoreCase(valveTypes[i])) continue;
            this.types.add(new LabelValueBean(valveTypes[i], "AddValve.do?parent=" + URLEncoder.encode(parent, "UTF-8") + "&type=" + valveTypes[i]));
        }
        if ("AccessLogValve".equalsIgnoreCase(type)) {
            this.createAccessLogger(session, parent);
        } else if ("RemoteAddrValve".equalsIgnoreCase(type)) {
            this.createRemoteAddrValve(session, parent);
        } else if ("RemoteHostValve".equalsIgnoreCase(type)) {
            this.createRemoteHostValve(session, parent);
        } else if ("RequestDumperValve".equalsIgnoreCase(type)) {
            this.createRequestDumperValve(session, parent);
        } else {
            this.createSingleSignOnValve(session, parent);
        }
        return mapping.findForward(type);
    }

    private void createAccessLogger(HttpSession session, String parent) {
        AccessLogValveForm valveFm = new AccessLogValveForm();
        session.setAttribute("accessLogValveForm", (Object)valveFm);
        valveFm.setAdminAction("Create");
        valveFm.setObjectName("");
        valveFm.setParentObjectName(parent);
        String valveType = "AccessLogValve";
        valveFm.setNodeLabel("Valve (" + valveType + ")");
        valveFm.setValveType(valveType);
        valveFm.setPattern("");
        valveFm.setDirectory("logs");
        valveFm.setPrefix("access_log.");
        valveFm.setSuffix("");
        valveFm.setResolveHosts("false");
        valveFm.setRotatable("true");
        valveFm.setBooleanVals(Lists.getBooleanValues());
        valveFm.setValveTypeVals(this.types);
    }

    private void createRemoteAddrValve(HttpSession session, String parent) {
        RemoteAddrValveForm valveFm = new RemoteAddrValveForm();
        session.setAttribute("remoteAddrValveForm", (Object)valveFm);
        valveFm.setAdminAction("Create");
        valveFm.setObjectName("");
        valveFm.setParentObjectName(parent);
        String valveType = "RemoteAddrValve";
        valveFm.setNodeLabel("Valve (" + valveType + ")");
        valveFm.setValveType(valveType);
        valveFm.setAllow("");
        valveFm.setDeny("");
        valveFm.setValveTypeVals(this.types);
    }

    private void createRemoteHostValve(HttpSession session, String parent) {
        RemoteHostValveForm valveFm = new RemoteHostValveForm();
        session.setAttribute("remoteHostValveForm", (Object)valveFm);
        valveFm.setAdminAction("Create");
        valveFm.setObjectName("");
        valveFm.setParentObjectName(parent);
        String valveType = "RemoteHostValve";
        valveFm.setNodeLabel("Valve (" + valveType + ")");
        valveFm.setValveType(valveType);
        valveFm.setAllow("");
        valveFm.setDeny("");
        valveFm.setValveTypeVals(this.types);
    }

    private void createRequestDumperValve(HttpSession session, String parent) {
        RequestDumperValveForm valveFm = new RequestDumperValveForm();
        session.setAttribute("requestDumperValveForm", (Object)valveFm);
        valveFm.setAdminAction("Create");
        valveFm.setObjectName("");
        valveFm.setParentObjectName(parent);
        String valveType = "RequestDumperValve";
        valveFm.setNodeLabel("Valve (" + valveType + ")");
        valveFm.setValveType(valveType);
        valveFm.setValveTypeVals(this.types);
    }

    private void createSingleSignOnValve(HttpSession session, String parent) {
        SingleSignOnValveForm valveFm = new SingleSignOnValveForm();
        session.setAttribute("singleSignOnValveForm", (Object)valveFm);
        valveFm.setAdminAction("Create");
        valveFm.setObjectName("");
        valveFm.setParentObjectName(parent);
        String valveType = "SingleSignOn";
        valveFm.setNodeLabel("Valve (" + valveType + ")");
        valveFm.setValveType(valveType);
        valveFm.setValveTypeVals(this.types);
    }
}

