/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.resources;

import java.io.IOException;
import java.util.Locale;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.resources.EnvEntryForm;
import org.apache.webapp.admin.resources.ResourceUtils;

public final class SaveEnvEntryAction
extends Action {
    private MBeanServer mserver = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.mserver == null) {
            this.mserver = ((ApplicationServlet)this.getServlet()).getServer();
        }
        MessageResources resources = this.getResources(request);
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        if (this.isCancelled(request)) {
            return mapping.findForward("List EnvEntries Setup");
        }
        if (!this.isTokenValid(request)) {
            response.sendError(400, resources.getMessage(locale, "users.error.token"));
            return null;
        }
        EnvEntryForm envEntryForm = (EnvEntryForm)form;
        String objectName = envEntryForm.getObjectName();
        if (objectName == null) {
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
            Object[] params = new Object[]{envEntryForm.getName(), envEntryForm.getEntryType(), envEntryForm.getValue()};
            String resourcetype = envEntryForm.getResourcetype();
            String path = envEntryForm.getPath();
            String host = envEntryForm.getHost();
            String domain = envEntryForm.getDomain();
            ObjectName oname = null;
            try {
                if (resourcetype.equals("Global")) {
                    oname = new ObjectName(domain + ":type=Environment" + ",resourcetype=Global" + ",name=" + params[0]);
                } else if (resourcetype.equals("Context")) {
                    oname = new ObjectName(domain + ":type=Environment" + ",resourcetype=Context" + ",path=" + path + ",host=" + host + ",name=" + params[0]);
                }
                if (this.mserver.isRegistered(oname)) {
                    ActionErrors errors = new ActionErrors();
                    errors.add("name", new ActionError("resources.invalid.env"));
                    this.saveErrors(request, errors);
                    return new ActionForward(mapping.getInput());
                }
                oname = ResourceUtils.getNamingResourceObjectName(domain, resourcetype, path, host);
                objectName = (String)this.mserver.invoke(oname, "addEnvironment", params, signature);
            }
            catch (Exception e) {
                this.getServlet().log(resources.getMessage(locale, "users.error.invoke", (Object)"addEnvironment"), (Throwable)e);
                response.sendError(500, resources.getMessage(locale, "users.error.invoke", (Object)"addEnvironment"));
                return null;
            }
        }
        String attribute = null;
        try {
            ObjectName oname = new ObjectName(objectName);
            attribute = "override";
            this.mserver.setAttribute(oname, new Attribute(attribute, new Boolean(envEntryForm.getOverride())));
            attribute = "description";
            this.mserver.setAttribute(oname, new Attribute(attribute, envEntryForm.getDescription()));
            attribute = "type";
            this.mserver.setAttribute(oname, new Attribute(attribute, envEntryForm.getEntryType()));
            attribute = "value";
            this.mserver.setAttribute(oname, new Attribute(attribute, envEntryForm.getValue()));
        }
        catch (Exception e) {
            this.getServlet().log(resources.getMessage(locale, "users.error.set.attribute", (Object)attribute), (Throwable)e);
            response.sendError(500, resources.getMessage(locale, "users.error.set.attribute", (Object)attribute));
            return null;
        }
        return mapping.findForward("EnvEntries List Setup");
    }
}

