/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.webapp.admin.TreeControlNode;

public class TreeControl
implements Serializable {
    protected HashMap registry = new HashMap();
    protected TreeControlNode selected = null;
    protected TreeControlNode root = null;

    public TreeControl() {
        this.setRoot(null);
    }

    public TreeControl(TreeControlNode root) {
        this.setRoot(root);
    }

    public TreeControlNode getRoot() {
        return this.root;
    }

    protected void setRoot(TreeControlNode root) {
        if (this.root != null) {
            this.removeNode(this.root);
        }
        if (root != null) {
            this.addNode(root);
        }
        root.setLast(true);
        this.root = root;
    }

    public int getWidth() {
        if (this.root == null) {
            return 0;
        }
        return this.getWidth(this.root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeControlNode findNode(String name) {
        HashMap hashMap = this.registry;
        synchronized (hashMap) {
            return (TreeControlNode)this.registry.get(name);
        }
    }

    public void selectNode(String name) {
        if (this.selected != null) {
            this.selected.setSelected(false);
            this.selected = null;
        }
        this.selected = this.findNode(name);
        if (this.selected != null) {
            this.selected.setSelected(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNode(TreeControlNode node) throws IllegalArgumentException {
        HashMap hashMap = this.registry;
        synchronized (hashMap) {
            String name = node.getName();
            if (this.registry.containsKey(name)) {
                throw new IllegalArgumentException("Name '" + name + "' is not unique");
            }
            node.setTree(this);
            this.registry.put(name, node);
        }
    }

    int getWidth(TreeControlNode node) {
        int width = node.getWidth();
        if (!node.isExpanded()) {
            return width;
        }
        TreeControlNode[] children = node.findChildren();
        for (int i = 0; i < children.length; ++i) {
            int current = this.getWidth(children[i]);
            if (current <= width) continue;
            width = current;
        }
        return width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeNode(TreeControlNode node) {
        HashMap hashMap = this.registry;
        synchronized (hashMap) {
            TreeControlNode[] children = node.findChildren();
            for (int i = 0; i < children.length; ++i) {
                this.removeNode(children[i]);
            }
            TreeControlNode parent = node.getParent();
            if (parent != null) {
                parent.removeChild(node);
            }
            node.setParent(null);
            node.setTree(null);
            if (node == this.root) {
                this.root = null;
            }
            this.registry.remove(node.getName());
        }
    }
}

