/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletRequest;
import org.apache.webapp.admin.LabelValueBean;

public class Lists {
    private static List verbosityLevels = new ArrayList();
    private static List booleanValues;
    private static List clientAuthValues;

    protected Lists() {
    }

    public static List getVerbosityLevels() {
        return verbosityLevels;
    }

    public static List getBooleanValues() {
        return booleanValues;
    }

    public static List getClientAuthValues() {
        return clientAuthValues;
    }

    public static List getConnectors(MBeanServer mbserver, ObjectName service) throws Exception {
        StringBuffer sb = new StringBuffer(service.getDomain());
        sb.append(":type=Connector,*");
        ObjectName search = new ObjectName(sb.toString());
        ArrayList<String> connectors = new ArrayList<String>();
        Iterator<ObjectName> names = mbserver.queryNames(search, null).iterator();
        while (names.hasNext()) {
            connectors.add(((Object)names.next()).toString());
        }
        Collections.sort(connectors);
        return connectors;
    }

    public static List getConnectors(MBeanServer mbserver, String service) throws Exception {
        return Lists.getConnectors(mbserver, new ObjectName(service));
    }

    public static List getContexts(MBeanServer mbserver, ObjectName host) throws Exception {
        StringBuffer sb = new StringBuffer(host.getDomain());
        sb.append(":j2eeType=WebModule,*");
        ObjectName search = new ObjectName(sb.toString());
        ArrayList<String> contexts = new ArrayList<String>();
        Iterator<ObjectName> names = mbserver.queryNames(search, null).iterator();
        String name = null;
        ObjectName oname = null;
        String hostPrefix = "//" + host.getKeyProperty("host");
        String hostAttr = null;
        while (names.hasNext()) {
            name = ((Object)names.next()).toString();
            oname = new ObjectName(name);
            hostAttr = oname.getKeyProperty("name");
            if (!hostAttr.startsWith(hostPrefix)) continue;
            contexts.add(name);
        }
        Collections.sort(contexts);
        return contexts;
    }

    public static List getDefaultContexts(MBeanServer mbserver, String container) throws Exception {
        return Lists.getDefaultContexts(mbserver, new ObjectName(container));
    }

    public static List getDefaultContexts(MBeanServer mbserver, ObjectName container) throws Exception {
        StringBuffer sb = new StringBuffer(container.getDomain());
        sb.append(":type=DefaultContext");
        String type = container.getKeyProperty("type");
        String host = container.getKeyProperty("host");
        if ("Host".equals(type)) {
            host = container.getKeyProperty("host");
        }
        if (host != null) {
            sb.append(",host=");
            sb.append(host);
        }
        ObjectName search = new ObjectName(sb.toString());
        ArrayList<String> defaultContexts = new ArrayList<String>();
        Iterator<ObjectName> names = mbserver.queryNames(search, null).iterator();
        while (names.hasNext()) {
            String name = ((Object)names.next()).toString();
            defaultContexts.add(name);
        }
        Collections.sort(defaultContexts);
        return defaultContexts;
    }

    public static List getContexts(MBeanServer mbserver, String host) throws Exception {
        return Lists.getContexts(mbserver, new ObjectName(host));
    }

    public static List getHosts(MBeanServer mbserver, ObjectName service) throws Exception {
        StringBuffer sb = new StringBuffer(service.getDomain());
        sb.append(":type=Host,*");
        ObjectName search = new ObjectName(sb.toString());
        ArrayList<String> hosts = new ArrayList<String>();
        Iterator<ObjectName> names = mbserver.queryNames(search, null).iterator();
        while (names.hasNext()) {
            hosts.add(((Object)names.next()).toString());
        }
        Collections.sort(hosts);
        return hosts;
    }

    public static List getHosts(MBeanServer mbserver, String service) throws Exception {
        return Lists.getHosts(mbserver, new ObjectName(service));
    }

    public static List getRealms(MBeanServer mbserver, ObjectName container) throws Exception {
        ObjectName search = Lists.getSearchObject(container, "Realm");
        ArrayList<String> realms = new ArrayList<String>();
        Iterator<ObjectName> names = mbserver.queryNames(search, null).iterator();
        while (names.hasNext()) {
            realms.add(((Object)names.next()).toString());
        }
        Collections.sort(realms);
        return realms;
    }

    public static List getRealms(MBeanServer mbserver, String container) throws Exception {
        return Lists.getRealms(mbserver, new ObjectName(container));
    }

    public static List getValves(MBeanServer mbserver, ObjectName container) throws Exception {
        StringBuffer sb = new StringBuffer(container.getDomain());
        sb.append(":type=Valve");
        String type = container.getKeyProperty("type");
        String j2eeType = container.getKeyProperty("j2eeType");
        sb.append(",*");
        String host = "";
        String path = "";
        String name = container.getKeyProperty("name");
        if (name != null && name.length() > 0) {
            name = name.substring(2);
            int i = name.indexOf("/");
            host = name.substring(0, i);
            path = name.substring(i);
        } else if ("Host".equals(type)) {
            host = container.getKeyProperty("host");
        }
        ObjectName search = new ObjectName(sb.toString());
        ArrayList<String> valves = new ArrayList<String>();
        Iterator<ObjectName> names = mbserver.queryNames(search, null).iterator();
        while (names.hasNext()) {
            ObjectName valve = names.next();
            String vpath = valve.getKeyProperty("path");
            String vhost = valve.getKeyProperty("host");
            String valveType = null;
            String className = (String)mbserver.getAttribute(valve, "className");
            int period = className.lastIndexOf(".");
            if (period >= 0) {
                valveType = className.substring(period + 1);
            }
            if (!"AccessLogValve".equalsIgnoreCase(valveType) && !"RemoteAddrValve".equalsIgnoreCase(valveType) && !"RemoteHostValve".equalsIgnoreCase(valveType) && !"RequestDumperValve".equalsIgnoreCase(valveType) && !"SingleSignOn".equalsIgnoreCase(valveType)) continue;
            if ("Service".equalsIgnoreCase(type) && vpath == null && vhost == null) {
                valves.add(valve.toString());
            }
            if ("Host".equalsIgnoreCase(type) && vpath == null && host.equalsIgnoreCase(vhost)) {
                valves.add(valve.toString());
            }
            if (!"WebModule".equalsIgnoreCase(j2eeType) || !path.equalsIgnoreCase(vpath) || !host.equalsIgnoreCase(vhost)) continue;
            valves.add(valve.toString());
        }
        Collections.sort(valves);
        return valves;
    }

    public static List getValves(MBeanServer mbserver, String container) throws Exception {
        return Lists.getValves(mbserver, new ObjectName(container));
    }

    public static List getServers(MBeanServer mbserver, String domain) throws Exception {
        ObjectName search = new ObjectName(domain + ":type=Server,*");
        ArrayList<String> servers = new ArrayList<String>();
        Iterator<ObjectName> names = mbserver.queryNames(search, null).iterator();
        while (names.hasNext()) {
            servers.add(((Object)names.next()).toString());
        }
        Collections.sort(servers);
        return servers;
    }

    public static List getServices(MBeanServer mbserver, ObjectName server) throws Exception {
        StringBuffer sb = new StringBuffer("*:type=Service,*");
        ObjectName search = new ObjectName(sb.toString());
        ArrayList<String> services = new ArrayList<String>();
        Iterator<ObjectName> names = mbserver.queryNames(search, null).iterator();
        while (names.hasNext()) {
            services.add(((Object)names.next()).toString());
        }
        Collections.sort(services);
        return services;
    }

    public static List getServices(MBeanServer mbserver, String server) throws Exception {
        return Lists.getServices(mbserver, new ObjectName(server));
    }

    public static String getAdminAppService(MBeanServer mbserver, String domain, HttpServletRequest request) throws Exception {
        String adminDomain = "Catalina";
        StringBuffer sb = new StringBuffer(adminDomain);
        sb.append(":type=Service,*");
        ObjectName search = new ObjectName(sb.toString());
        Iterator<ObjectName> names = mbserver.queryNames(search, null).iterator();
        String service = null;
        while (names.hasNext()) {
            service = names.next().getKeyProperty("serviceName");
        }
        return service;
    }

    public static String getAdminAppHost(MBeanServer mbserver, String domain, HttpServletRequest request) throws Exception {
        String adminDomain = "Catalina";
        StringBuffer sb = new StringBuffer(adminDomain);
        sb.append(":j2eeType=WebModule,*");
        ObjectName search = new ObjectName(sb.toString());
        Iterator<ObjectName> names = mbserver.queryNames(search, null).iterator();
        String contextPath = request.getContextPath();
        String host = null;
        String name = null;
        ObjectName oname = null;
        while (names.hasNext()) {
            int i;
            name = ((Object)names.next()).toString();
            oname = new ObjectName(name);
            host = oname.getKeyProperty("name");
            if (!contextPath.equals((host = host.substring(2)).substring(i = host.indexOf("/")))) continue;
            host = host.substring(0, i);
            return host;
        }
        return host;
    }

    public static ObjectName getSearchObject(ObjectName container, String type) throws Exception {
        StringBuffer sb = new StringBuffer(container.getDomain());
        sb.append(":type=" + type);
        String containerType = container.getKeyProperty("type");
        String name = container.getKeyProperty("name");
        if (name != null && name.length() > 0) {
            name = name.substring(2);
            int i = name.indexOf("/");
            String host = name.substring(0, i);
            String path = name.substring(i);
            sb.append(",path=");
            sb.append(path);
            sb.append(",host=");
            sb.append(host);
        } else if ("Host".equals(containerType)) {
            String host = container.getKeyProperty("host");
            sb.append(",host=");
            sb.append(host);
        }
        return new ObjectName(sb.toString());
    }

    static {
        verbosityLevels.add(new LabelValueBean("0", "0"));
        verbosityLevels.add(new LabelValueBean("1", "1"));
        verbosityLevels.add(new LabelValueBean("2", "2"));
        verbosityLevels.add(new LabelValueBean("3", "3"));
        verbosityLevels.add(new LabelValueBean("4", "4"));
        booleanValues = new ArrayList();
        booleanValues.add(new LabelValueBean("True", "true"));
        booleanValues.add(new LabelValueBean("False", "false"));
        clientAuthValues = new ArrayList();
        clientAuthValues.add(new LabelValueBean("True", "true"));
        clientAuthValues.add(new LabelValueBean("False", "false"));
        clientAuthValues.add(new LabelValueBean("Want", "want"));
    }
}

