/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.jaxws.project;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.xml.retriever.RetrieveEntry;
import org.netbeans.modules.xml.retriever.RetrieverImpl;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class WSUtils {
    public static FileObject retrieveResource(FileObject targetFolder, URI source) throws UnknownHostException, URISyntaxException, IOException {
        try {
            Map map;
            RetrieverImpl retriever = new RetrieverImpl();
            FileObject result = retriever.retrieveResource(targetFolder, source);
            if (result == null && (map = retriever.getRetrievedResourceExceptionMap()) != null) {
                Set keys = map.keySet();
                for (RetrieveEntry key : keys) {
                    Object exc = map.get(key);
                    if (exc instanceof IOException) {
                        throw (IOException)exc;
                    }
                    if (exc instanceof URISyntaxException) {
                        throw (URISyntaxException)exc;
                    }
                    if (!(exc instanceof Exception)) continue;
                    IOException ex = new IOException(NbBundle.getMessage(WSUtils.class, (String)"ERR_retrieveResource", (Object)key.getCurrentAddress()));
                    ex.initCause((Exception)exc);
                    throw ex;
                }
            }
            return result;
        }
        catch (RuntimeException ex) {
            throw (IOException)new IOException(ex.getLocalizedMessage()).initCause(ex);
        }
    }

    public static String findProperServiceName(String name, JaxWsModel jaxWsModel) {
        if (jaxWsModel.findServiceByName(name) == null) {
            return name;
        }
        int i = 1;
        String destName;
        while (jaxWsModel.findServiceByName(destName = name + "_" + i) != null) {
            ++i;
        }
        return destName;
    }

    public static void retrieveJaxWsFromResource(FileObject projectDir) throws IOException {
        final String jaxWsContent = WSUtils.readResource(WSUtils.class.getResourceAsStream("/org/netbeans/modules/websvc/jaxwsmodel/resources/jax-ws.xml"));
        final FileObject nbprojFo = projectDir.getFileObject("nbproject");
        assert (nbprojFo != null) : "Cannot find nbproject directory";
        FileSystem fs = nbprojFo.getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileObject jaxWsFo = FileUtil.createData((FileObject)nbprojFo, (String)"jax-ws.xml");
                FileLock lock = jaxWsFo.lock();
                try {
                    BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(jaxWsFo.getOutputStream(lock)));
                    bw.write(jaxWsContent);
                    bw.close();
                }
                finally {
                    lock.releaseLock();
                }
            }
        });
    }

    public static void retrieveHandlerConfigFromResource(final FileObject targetDir, final String handlerConfigName) throws IOException {
        final String handlerContent = WSUtils.readResource(WSUtils.class.getResourceAsStream("/org/netbeans/modules/websvc/jaxwsmodel/resources/handler.xml"));
        FileSystem fs = targetDir.getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileObject handlerFo = FileUtil.createData((FileObject)targetDir, (String)handlerConfigName);
                FileLock lock = handlerFo.lock();
                BufferedWriter bw = null;
                OutputStream os = null;
                try {
                    os = handlerFo.getOutputStream(lock);
                    bw = new BufferedWriter(new OutputStreamWriter(os));
                    bw.write(handlerContent);
                    bw.close();
                }
                finally {
                    if (bw != null) {
                        bw.close();
                    }
                    if (os != null) {
                        os.close();
                    }
                    if (lock != null) {
                        lock.releaseLock();
                    }
                }
            }
        });
    }

    public static void generateSunJaxwsFile(final FileObject targetDir) throws IOException {
        final String sunJaxwsContent = WSUtils.readResource(WSUtils.class.getResourceAsStream("/org/netbeans/modules/websvc/jaxwsmodel/resources/sun-jaxws.xml"));
        FileSystem fs = targetDir.getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileObject sunJaxwsFo = FileUtil.createData((FileObject)targetDir, (String)"sun-jaxws.xml");
                FileLock lock = sunJaxwsFo.lock();
                BufferedWriter bw = null;
                OutputStream os = null;
                OutputStreamWriter osw = null;
                try {
                    os = sunJaxwsFo.getOutputStream(lock);
                    osw = new OutputStreamWriter(os);
                    bw = new BufferedWriter(osw);
                    bw.write(sunJaxwsContent);
                }
                finally {
                    if (bw != null) {
                        bw.close();
                    }
                    if (os != null) {
                        os.close();
                    }
                    if (osw != null) {
                        osw.close();
                    }
                    if (lock != null) {
                        lock.releaseLock();
                    }
                }
            }
        });
    }

    private static String readResource(InputStream is) throws IOException {
        StringBuffer sb = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = br.readLine();
        while (line != null) {
            sb.append(line);
            sb.append(lineSep);
            line = br.readLine();
        }
        br.close();
        return sb.toString();
    }

    public static void removeImplClass(Project project, String implClass) {
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        String resource = implClass.replace('.', '/') + ".java";
        if (sources != null) {
            SourceGroup[] srcGroup = sources.getSourceGroups("java");
            for (int i = 0; i < srcGroup.length; ++i) {
                final FileObject srcRoot = srcGroup[i].getRootFolder();
                final FileObject implClassFo = srcRoot.getFileObject(resource);
                if (implClassFo == null) continue;
                try {
                    FileSystem fs = implClassFo.getFileSystem();
                    fs.runAtomicAction(new FileSystem.AtomicAction(){

                        public void run() {
                            WSUtils.deleteFile(implClassFo);
                            for (FileObject parent = implClassFo.getParent(); parent != srcRoot && parent.getChildren().length == 0; parent = parent.getParent()) {
                                FileObject fileToDelete = parent;
                                WSUtils.deleteFile(fileToDelete);
                            }
                        }
                    });
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteFile(FileObject f) {
        FileLock lock = null;
        try {
            DataFolder folder;
            lock = f.lock();
            if (f.isFolder() && (folder = DataFolder.findFolder((FileObject)f)) != null) {
                DataObject[] children = folder.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    SaveCookie save = (SaveCookie)children[i].getCookie(SaveCookie.class);
                    if (save == null) continue;
                    save.save();
                }
            }
            f.delete(lock);
        }
        catch (IOException e) {
            NotifyDescriptor.Message ndd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WSUtils.class, (String)"MSG_Unable_Delete_File", (Object)f.getNameExt()), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)ndd);
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }

    public static void copyFiles(FileObject sourceFolder, FileObject targetFolder) throws IOException {
        FileObject[] children = sourceFolder.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i].isFolder()) {
                FileObject folder = targetFolder.createFolder(children[i].getName());
                WSUtils.copyFiles(children[i], folder);
                continue;
            }
            children[i].copy(targetFolder, children[i].getName(), children[i].getExt());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject backupAndGenerateJaxWs(FileObject projectDir, FileObject oldJaxWs, RuntimeException reason) throws IOException {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(WSUtils.class, (String)"ERR_corruptedJaxWs", (Object)oldJaxWs.getPath(), (Object)reason.getMessage()), 0));
        FileObject parent = oldJaxWs.getParent();
        FileObject oldBackup = parent.getFileObject("jax-ws.xml.old");
        FileLock lock = null;
        if (oldBackup != null) {
            try {
                lock = oldBackup.lock();
                oldBackup.delete(lock);
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }
        try {
            lock = oldJaxWs.lock();
            oldJaxWs.rename(lock, "jax-ws.xml", "old");
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
        WSUtils.retrieveJaxWsFromResource(projectDir);
        return projectDir.getFileObject("nbproject/jax-ws.xml");
    }
}

