/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.netbeans.modules.tasklist.client.SuggestionManager;
import org.netbeans.modules.tasklist.suggestions.SuggestionManagerImpl;
import org.netbeans.modules.tasklist.suggestions.SuggestionType;
import org.netbeans.modules.tasklist.suggestions.SuggestionTypes;
import org.netbeans.modules.tasklist.suggestions.settings.ManagerSettings;
import org.openide.awt.Actions;
import org.openide.awt.JMenuPlus;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.Presenter;

public final class EnableAction
extends CallableSystemAction
implements Presenter.Menu {
    private static final long serialVersionUID = 1L;

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return NbBundle.getMessage((Class)EnableAction.class, (String)"EnableAction");
    }

    public JMenuItem getMenuPresenter() {
        JMenuPlus mainItem = new JMenuPlus();
        Actions.setMenuText((AbstractButton)mainItem, (String)this.getName(), (boolean)true);
        mainItem.addMenuListener(new MainItemListener());
        return mainItem;
    }

    public JMenuItem getPopupPresenter() {
        JMenuPlus mainItem = new JMenuPlus();
        Actions.setMenuText((AbstractButton)mainItem, (String)this.getName(), (boolean)true);
        mainItem.addMenuListener(new MainItemListener());
        return mainItem;
    }

    public void performAction() {
    }

    private static final class MainItemListener
    implements MenuListener,
    ActionListener {
        private static final String TYPE = "type";
        static final /* synthetic */ boolean $assertionsDisabled;

        private MainItemListener() {
        }

        public void menuCanceled(MenuEvent e) {
        }

        public void menuDeselected(MenuEvent e) {
            JMenu menu = (JMenu)e.getSource();
            menu.removeAll();
        }

        public void menuSelected(MenuEvent e) {
            JMenu menu = (JMenu)e.getSource();
            int n = 0;
            SuggestionTypes types = SuggestionTypes.getDefault();
            Iterator it = types.getAllTypes().iterator();
            while (it.hasNext()) {
                SuggestionType type = (SuggestionType)it.next();
                if (ManagerSettings.getDefault().isEnabled(type.getName())) continue;
                String category = type.getLocalizedName();
                menu.add(this.createMenuItem(category, type));
                ++n;
            }
            if (n == 0) {
                JMenuItem item = this.createMenuItem(NbBundle.getMessage((Class)(class$org$netbeans$modules$tasklist$suggestions$EnableAction == null ? (class$org$netbeans$modules$tasklist$suggestions$EnableAction = EnableAction.class$("org.netbeans.modules.tasklist.suggestions.EnableAction")) : class$org$netbeans$modules$tasklist$suggestions$EnableAction), (String)"Empty"), null);
                item.setEnabled(false);
                menu.add(item);
            }
        }

        private JMenuItem createMenuItem(String category, SuggestionType type) {
            JMenuItem curMenuItem = new JMenuItem(category);
            curMenuItem.addActionListener(this);
            if (type != null) {
                curMenuItem.putClientProperty(TYPE, type);
            }
            return curMenuItem;
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem item = (JMenuItem)e.getSource();
            SuggestionType type = (SuggestionType)item.getClientProperty(TYPE);
            if (!$assertionsDisabled && type == null) {
                throw new AssertionError();
            }
            SuggestionManagerImpl manager = (SuggestionManagerImpl)SuggestionManager.getDefault();
            manager.setEnabled(type.getName(), true, false);
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$tasklist$suggestions$EnableAction == null ? (class$org$netbeans$modules$tasklist$suggestions$EnableAction = EnableAction.class$("org.netbeans.modules.tasklist.suggestions.EnableAction")) : class$org$netbeans$modules$tasklist$suggestions$EnableAction).desiredAssertionStatus();
        }
    }
}

