/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.syncview;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.modules.versioning.system.cvss.Annotator;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.settings.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.ui.actions.DeleteLocalAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.SystemActionBridge;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.ResolveConflictsAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.ignore.IgnoreAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.AnnotationsAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.SearchHistoryAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.BranchAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.TagAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.GetCleanAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateAction;
import org.netbeans.modules.versioning.system.cvss.ui.syncview.ExcludeFromCommitAction;
import org.netbeans.modules.versioning.system.cvss.ui.syncview.OpenInEditorAction;
import org.netbeans.modules.versioning.system.cvss.ui.syncview.SyncFileNode;
import org.netbeans.modules.versioning.system.cvss.util.TableSorter;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.util.FilePathCellRenderer;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.explorer.view.NodeTableModel;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

class SyncTable
implements MouseListener,
ListSelectionListener,
AncestorListener {
    private NodeTableModel tableModel;
    private JTable table;
    private JScrollPane component;
    private SyncFileNode[] nodes = new SyncFileNode[0];
    private String[] tableColumns;
    private TableSorter sorter;
    private static final Map columnLabels = new HashMap(4);
    private static final Comparator NodeComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            Node.Property p1 = (Node.Property)o1;
            Node.Property p2 = (Node.Property)o2;
            String sk1 = (String)p1.getValue("sortkey");
            if (sk1 != null) {
                String sk2 = (String)p2.getValue("sortkey");
                return sk1.compareToIgnoreCase(sk2);
            }
            try {
                String s1 = (String)p1.getValue();
                String s2 = (String)p2.getValue();
                return s1.compareToIgnoreCase(s2);
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
                return 0;
            }
        }
    };
    static /* synthetic */ Class class$java$lang$String;

    public SyncTable() {
        ResourceBundle loc = NbBundle.getBundle((Class)SyncTable.class);
        columnLabels.put("sticky", new String[]{loc.getString("CTL_VersioningView_Column_Sticky_Title"), loc.getString("CTL_VersioningView_Column_Sticky_Desc")});
        columnLabels.put("name", new String[]{loc.getString("CTL_VersioningView_Column_File_Title"), loc.getString("CTL_VersioningView_Column_File_Desc")});
        columnLabels.put("status", new String[]{loc.getString("CTL_VersioningView_Column_Status_Title"), loc.getString("CTL_VersioningView_Column_Status_Desc")});
        columnLabels.put("path", new String[]{loc.getString("CTL_VersioningView_Column_Path_Title"), loc.getString("CTL_VersioningView_Column_Path_Desc")});
        this.tableModel = new NodeTableModel();
        this.sorter = new TableSorter((TableModel)this.tableModel);
        this.sorter.setColumnComparator(Node.Property.class, NodeComparator);
        this.table = new JTable(this.sorter);
        this.sorter.setTableHeader(this.table.getTableHeader());
        this.table.setRowHeight(this.table.getRowHeight() * 6 / 5);
        this.component = new JScrollPane(this.table, 22, 31);
        this.component.getViewport().setBackground(this.table.getBackground());
        Color borderColor = UIManager.getColor("scrollpane_border");
        if (borderColor == null) {
            borderColor = UIManager.getColor("controlShadow");
        }
        this.component.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, borderColor));
        this.table.addMouseListener(this);
        this.table.setDefaultRenderer(Node.Property.class, new SyncTableCellRenderer());
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.addAncestorListener(this);
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)SyncTable.class, (String)"ACSN_VersioningTable"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)SyncTable.class, (String)"ACSD_VersioningTable"));
        this.setColumns(new String[]{"name", "status", "path"});
    }

    void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                block5: {
                    int width;
                    block4: {
                        width = SyncTable.this.table.getWidth();
                        if (SyncTable.this.tableColumns.length != 3) break block4;
                        for (int i = 0; i < SyncTable.this.tableColumns.length; ++i) {
                            if ("path".equals(SyncTable.this.tableColumns[i])) {
                                SyncTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(width * 60 / 100);
                                continue;
                            }
                            SyncTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(width * 20 / 100);
                        }
                        break block5;
                    }
                    if (SyncTable.this.tableColumns.length != 4) break block5;
                    for (int i = 0; i < SyncTable.this.tableColumns.length; ++i) {
                        if ("path".equals(SyncTable.this.tableColumns[i])) {
                            SyncTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(width * 55 / 100);
                            continue;
                        }
                        SyncTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(width * 15 / 100);
                    }
                }
            }
        });
    }

    public void ancestorAdded(AncestorEvent event) {
        this.setDefaultColumnSizes();
    }

    public void ancestorMoved(AncestorEvent event) {
    }

    public void ancestorRemoved(AncestorEvent event) {
    }

    public SyncFileNode[] getDisplayedNodes() {
        int n = this.sorter.getRowCount();
        SyncFileNode[] ret = new SyncFileNode[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = this.nodes[this.sorter.modelIndex(i)];
        }
        return ret;
    }

    public JComponent getComponent() {
        return this.component;
    }

    final void setColumns(String[] columns) {
        if (Arrays.equals(columns, this.tableColumns)) {
            return;
        }
        this.setDefaultColumnSizes();
        this.setModelProperties(columns);
        this.tableColumns = columns;
        for (int i = 0; i < this.tableColumns.length; ++i) {
            this.sorter.setColumnComparator(i, null);
            this.sorter.setSortingStatus(i, 0);
            if (!"status".equals(this.tableColumns[i])) continue;
            this.sorter.setSortingStatus(i, 1);
            break;
        }
    }

    private void setModelProperties(String[] columns) {
        Node.Property[] properties = new Node.Property[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            String column = columns[i];
            String[] labels = (String[])columnLabels.get(column);
            properties[i] = new ColumnDescriptor(column, class$java$lang$String == null ? SyncTable.class$("java.lang.String") : class$java$lang$String, labels[0], labels[1]);
        }
        this.tableModel.setProperties(properties);
    }

    void setTableModel(SyncFileNode[] nodes) {
        this.nodes = nodes;
        this.tableModel.setNodes((Node[])nodes);
    }

    void focus() {
        this.table.requestFocus();
    }

    private void showPopup(MouseEvent e) {
        int row = this.table.rowAtPoint(e.getPoint());
        if (row != -1) {
            boolean makeRowSelected = true;
            int[] selectedrows = this.table.getSelectedRows();
            for (int i = 0; i < selectedrows.length; ++i) {
                if (row != selectedrows[i]) continue;
                makeRowSelected = false;
                break;
            }
            if (makeRowSelected) {
                this.table.getSelectionModel().setSelectionInterval(row, row);
            }
        }
        JPopupMenu menu = this.getPopup();
        menu.show(this.table, e.getX(), e.getY());
    }

    private JPopupMenu getPopup() {
        SystemActionBridge revertAction;
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = menu.add(new OpenInEditorAction());
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        menu.add(new JSeparator());
        item = menu.add(new SystemActionBridge((Action)SystemAction.get((Class)DiffAction.class), this.actionString("CTL_PopupMenuItem_Diff")));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        item = menu.add(new SystemActionBridge((Action)SystemAction.get((Class)UpdateAction.class), this.actionString("CTL_PopupMenuItem_Update")));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        item = menu.add(new SystemActionBridge((Action)SystemAction.get((Class)CommitAction.class), this.actionString("CTL_PopupMenuItem_Commit")));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        menu.add(new JSeparator());
        item = menu.add(new SystemActionBridge((Action)SystemAction.get((Class)TagAction.class), this.actionString("CTL_PopupMenuItem_Tag")));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        item = menu.add(new SystemActionBridge((Action)SystemAction.get((Class)BranchAction.class), this.actionString("CTL_PopupMenuItem_Branch")));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        menu.add(new JSeparator());
        item = menu.add(new SystemActionBridge((Action)SystemAction.get((Class)AnnotationsAction.class), ((AnnotationsAction)SystemAction.get((Class)AnnotationsAction.class)).visible(null) ? this.actionString("CTL_PopupMenuItem_HideAnnotations") : this.actionString("CTL_PopupMenuItem_ShowAnnotations")));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        item = menu.add(new SystemActionBridge((Action)SystemAction.get((Class)SearchHistoryAction.class), this.actionString("CTL_PopupMenuItem_SearchHistory")));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        menu.add(new JSeparator());
        item = menu.add(new ExcludeFromCommitAction());
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        boolean allLocallyNew = true;
        boolean allLocallyDeleted = true;
        FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
        File[] files = Utils.getCurrentContext(null).getFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            FileInformation info = cache.getStatus(file);
            if ((info.getStatus() & 0x1004) == 0) {
                allLocallyNew = false;
            }
            if (info.getStatus() == 2048 || info.getStatus() == 256) continue;
            allLocallyDeleted = false;
        }
        if (allLocallyNew) {
            SystemAction systemAction = SystemAction.get((Class)DeleteLocalAction.class);
            revertAction = new SystemActionBridge((Action)systemAction, this.actionString("CTL_PopupMenuItem_Delete"));
        } else {
            revertAction = allLocallyDeleted ? new SystemActionBridge((Action)SystemAction.get((Class)GetCleanAction.class), this.actionString("CTL_PopupMenuItem_RevertDelete")) : new SystemActionBridge((Action)SystemAction.get((Class)GetCleanAction.class), this.actionString("CTL_PopupMenuItem_GetClean"));
        }
        item = menu.add(revertAction);
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        item = menu.add(new SystemActionBridge((Action)SystemAction.get((Class)ResolveConflictsAction.class), this.actionString("CTL_PopupMenuItem_ResolveConflicts")));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        SystemActionBridge ignoreAction = new SystemActionBridge((Action)SystemAction.get((Class)IgnoreAction.class), ((IgnoreAction)SystemAction.get((Class)IgnoreAction.class)).getActionStatus(files) == 2 ? this.actionString("CTL_PopupMenuItem_Unignore") : this.actionString("CTL_PopupMenuItem_Ignore"));
        item = menu.add(ignoreAction);
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        return menu;
    }

    private String actionString(String key) {
        ResourceBundle actionsLoc = NbBundle.getBundle((Class)Annotator.class);
        return actionsLoc.getString(key);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && MouseUtils.isDoubleClick((MouseEvent)e)) {
            int row = this.table.rowAtPoint(e.getPoint());
            if (row == -1) {
                return;
            }
            Action action = this.nodes[row = this.sorter.modelIndex(row)].getPreferredAction();
            if (action == null || !action.isEnabled()) {
                action = new OpenInEditorAction();
            }
            if (action.isEnabled()) {
                action.actionPerformed(new ActionEvent(this, 0, ""));
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        ArrayList<SyncFileNode> selectedNodes = new ArrayList<SyncFileNode>();
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this.table);
        if (tc == null) {
            return;
        }
        int min = selectionModel.getMinSelectionIndex();
        if (min == -1) {
            tc.setActivatedNodes(new Node[0]);
        }
        int max = selectionModel.getMaxSelectionIndex();
        for (int i = min; i <= max; ++i) {
            if (!selectionModel.isSelectedIndex(i)) continue;
            int idx = this.sorter.modelIndex(i);
            selectedNodes.add(this.nodes[idx]);
        }
        tc.setActivatedNodes(selectedNodes.toArray(new Node[selectedNodes.size()]));
    }

    private class SyncTableCellRenderer
    extends DefaultTableCellRenderer {
        private FilePathCellRenderer pathRenderer = new FilePathCellRenderer();

        private SyncTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer;
            int modelColumnIndex = table.convertColumnIndexToModel(column);
            if (modelColumnIndex == 0) {
                SyncFileNode node = SyncTable.this.nodes[SyncTable.this.sorter.modelIndex(row)];
                if (!isSelected) {
                    value = "<html>" + node.getHtmlDisplayName();
                }
                if (CvsModuleConfig.getDefault().isExcludedFromCommit(node.getFile().getAbsolutePath())) {
                    String nodeName = node.getDisplayName();
                    value = isSelected ? "<html><s>" + nodeName + "</s></html>" : "<html><s>" + CvsVersioningSystem.getInstance().getAnnotator().annotateNameHtml(nodeName, node.getFileInformation(), null) + "</s>";
                }
            }
            if ((renderer = modelColumnIndex == 2 ? this.pathRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column)) instanceof JComponent) {
                String path = SyncTable.this.nodes[SyncTable.this.sorter.modelIndex(row)].getFile().getAbsolutePath();
                ((JComponent)renderer).setToolTipText(path);
            }
            return renderer;
        }
    }

    private static class ColumnDescriptor
    extends PropertySupport.ReadOnly {
        public ColumnDescriptor(String name, Class type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }
}

