/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.selectors;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.ProxySelector;
import org.openide.util.NbBundle;

public final class ProxyDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ProxyDescriptor DIRECT = new ProxyDescriptor(0, null, -1, null, null);
    public static final ProxyDescriptor SYSTEM = new ProxyDescriptor();
    public static final int TYPE_DIRECT = 0;
    public static final int TYPE_HTTP = 1;
    public static final int TYPE_SOCKS = 2;
    private int type;
    private int port;
    private String host;
    private String userName;
    private String password;
    private String description;
    private final boolean system;
    private transient ProxyDescriptor systemDescriptor;

    ProxyDescriptor(int type, String host, int port, String userName, String password) {
        this(type, host, port, userName, password, null);
    }

    ProxyDescriptor(int type, String host, int port, String userName, String password, String desc) {
        this.type = type;
        this.host = host;
        this.password = password;
        this.port = port;
        this.userName = userName;
        this.system = false;
        this.description = desc;
    }

    ProxyDescriptor() {
        this.system = true;
    }

    public int getType() {
        ProxyDescriptor desc = this;
        if (this.system && this.systemDescriptor == null) {
            this.systemDescriptor = ProxySelector.detectSystemProxy();
        }
        if (this.system) {
            desc = this.systemDescriptor;
        }
        if (desc == null) {
            return 0;
        }
        return desc.type;
    }

    public boolean isSystemProxyDescriptor() {
        return this.system;
    }

    public String getHost() {
        ProxyDescriptor desc = this;
        if (this.system && this.systemDescriptor == null) {
            this.systemDescriptor = ProxySelector.detectSystemProxy();
        }
        if (this.system) {
            desc = this.systemDescriptor;
        }
        return desc != null ? desc.host : null;
    }

    public int getPort() {
        ProxyDescriptor desc = this;
        if (this.system && this.systemDescriptor == null) {
            this.systemDescriptor = ProxySelector.detectSystemProxy();
        }
        if (this.system) {
            desc = this.systemDescriptor;
        }
        return desc != null ? desc.port : -1;
    }

    public String getUserName() {
        ProxyDescriptor desc = this;
        if (this.system && this.systemDescriptor == null) {
            this.systemDescriptor = ProxySelector.detectSystemProxy();
        }
        if (this.system) {
            desc = this.systemDescriptor;
        }
        return desc != null ? desc.userName : null;
    }

    public String getPassword() {
        ProxyDescriptor desc = this;
        if (this.system && this.systemDescriptor == null) {
            this.systemDescriptor = ProxySelector.detectSystemProxy();
        }
        if (this.system) {
            desc = this.systemDescriptor;
        }
        return desc != null ? desc.password : null;
    }

    public String getDescription() {
        ProxyDescriptor desc = this;
        if (this.system && this.systemDescriptor == null) {
            this.systemDescriptor = ProxySelector.detectSystemProxy();
        }
        if (this.system) {
            desc = this.systemDescriptor;
        }
        if (desc == null) {
            return NbBundle.getMessage((Class)ProxyDescriptor.class, (String)"BK2002");
        }
        return desc.description;
    }

    public boolean needsProxy(String hostName) {
        try {
            InetAddress address = InetAddress.getByName(hostName);
            boolean local = address.isLoopbackAddress();
            return !(local |= address.isSiteLocalAddress());
        }
        catch (UnknownHostException e) {
            return true;
        }
    }
}

