/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.update;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.DefaultFileInfoContainer;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.FileStatusProvider;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class UpdateExecutor
extends ExecutorSupport {
    private Set refreshedFiles = Collections.synchronizedSet(new HashSet());
    private boolean rwUpdate;
    private long updateStartTimestamp;

    public static UpdateExecutor[] splitCommand(UpdateCommand cmd, CvsVersioningSystem cvs, GlobalOptions options) {
        Command[] cmds = new Command[]{};
        if (cmd.getDisplayName() == null) {
            cmd.setDisplayName(NbBundle.getMessage((Class)UpdateExecutor.class, (String)"MSG_UpdateExecutor_CmdDisplayName"));
        }
        try {
            cmds = UpdateExecutor.prepareBasicCommand((BasicCommand)cmd);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
        UpdateExecutor[] executors = new UpdateExecutor[cmds.length];
        for (int i = 0; i < cmds.length; ++i) {
            Command command = cmds[i];
            executors[i] = new UpdateExecutor(cvs, (UpdateCommand)command, options);
        }
        return executors;
    }

    private UpdateExecutor(CvsVersioningSystem cvs, UpdateCommand cmd, GlobalOptions options) {
        super(cvs, (Command)cmd, options);
        this.rwUpdate = options == null || !options.isDoNoChanges();
    }

    protected void setup() {
        super.setup();
        this.updateStartTimestamp = System.currentTimeMillis();
    }

    public void fileInfoGenerated(FileInfoEvent e) {
        super.fileInfoGenerated(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commandFinished(ClientRuntime.Result result) {
        UpdateCommand ucmd = (UpdateCommand)this.cmd;
        this.cvs.setParameter(CvsVersioningSystem.PARAM_BATCH_REFRESH_RUNNING, Boolean.TRUE);
        File[] files = ucmd.getFiles();
        for (int i = 0; i < files.length; ++i) {
            this.cache.clearVirtualDirectoryContents(files[i], ucmd.isRecursive(), ucmd.getGlobalOptions().getExclusions());
        }
        HashSet filesystems = new HashSet(2);
        boolean hasConflict = false;
        Iterator i = this.toRefresh.iterator();
        while (i.hasNext()) {
            DefaultFileInfoContainer info = (DefaultFileInfoContainer)i.next();
            File file = info.getFile();
            if (this.refreshedFiles.contains(file)) continue;
            int c = info.getType().charAt(0);
            if (c == 80) {
                c = 85;
            }
            if (this.rwUpdate) {
                if (c == 85) {
                    c = 65536;
                }
                if (c == 71) {
                    c = 77;
                }
                if (c == 67) {
                    hasConflict = true;
                }
            }
            this.cache.refreshCached(file, c);
            this.refreshedFiles.add(file);
        }
        for (int i2 = 0; i2 < files.length; ++i2) {
            if (ucmd.isRecursive()) {
                this.refreshRecursively(files[i2]);
            } else {
                this.refreshFlat(files[i2]);
            }
            this.addFileSystem(filesystems, files[i2]);
            if (!files[i2].isFile()) continue;
            this.cache.refreshCached(files[i2].getParentFile(), 0);
        }
        this.cvs.setParameter(CvsVersioningSystem.PARAM_BATCH_REFRESH_RUNNING, null);
        if (hasConflict) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)UpdateExecutor.class, (String)"MSG_UpdateGeneratedConflicts_Prompt"), 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
        Iterator i3 = filesystems.iterator();
        while (i3.hasNext()) {
            Object var11_14;
            FileSystem fileSystem = (FileSystem)i3.next();
            try {
                CvsVersioningSystem.ignoreFilesystemEvents(true);
                fileSystem.refresh(true);
                var11_14 = null;
            }
            catch (Throwable throwable) {
                var11_14 = null;
                CvsVersioningSystem.ignoreFilesystemEvents(false);
                throw throwable;
            }
            CvsVersioningSystem.ignoreFilesystemEvents(false);
            {
            }
        }
        if (ucmd.getUpdateByRevision() != null || ucmd.isResetStickyOnes()) {
            FileStatusProvider.getInstance().refreshAllAnnotations(false, true);
        }
    }

    private void addFileSystem(Set filesystems, File file) {
        FileObject fo;
        while ((fo = FileUtil.toFileObject((File)file)) == null) {
            if ((file = file.getParentFile()) != null) continue;
            return;
        }
        try {
            filesystems.add(fo.getFileSystem());
        }
        catch (FileStateInvalidException e) {
            // empty catch block
        }
    }

    private void refreshRecursively(File file) {
        try {
            if (this.cvs.isIgnoredFilename(file)) {
                return;
            }
            if (this.cmd.getGlobalOptions().isExcluded(file)) {
                return;
            }
            if (file.isDirectory()) {
                if (this.cache.getStatus(file).getStatus() == 2) {
                    return;
                }
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.refreshRecursively(files[i]);
                }
                if (!this.refreshedFiles.contains(file)) {
                    this.cache.refreshCached(file, 0);
                }
            } else if (!this.refreshedFiles.contains(file)) {
                this.refreshFile(file);
            }
        }
        catch (Throwable e) {
            ErrorManager.getDefault().notify(e);
        }
    }

    private void refreshFlat(File file) {
        if (this.cvs.isIgnoredFilename(file)) {
            return;
        }
        if (this.cmd.getGlobalOptions().isExcluded(file)) {
            return;
        }
        if (this.refreshedFiles.contains(file)) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (this.cvs.isIgnoredFilename(files[i])) {
                    return;
                }
                if (this.refreshedFiles.contains(files[i])) {
                    return;
                }
                if (files[i].isDirectory()) continue;
                this.refreshFile(files[i]);
            }
            this.cache.refreshCached(file, 0);
        } else {
            this.refreshFile(file);
        }
    }

    private void refreshFile(File file) {
        long lastModified = file.lastModified();
        if (!this.cmd.hasFailed() && this.cache.getStatus(file.getParentFile()).getStatus() == 8 && lastModified > 0L && lastModified < this.updateStartTimestamp) {
            this.cache.refreshCached(file, 65536);
        } else {
            this.cache.refreshCached(file, 0);
        }
    }
}

