/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Attribute;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.FieldGroup;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.Initializer;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.modules.javacore.parser.AnnotationInfoMeasure;
import org.netbeans.modules.javacore.parser.AnnotationTypeInfoMeasure;
import org.netbeans.modules.javacore.parser.AnnotationValueInfoMeasure;
import org.netbeans.modules.javacore.parser.AttributeInfoMeasure;
import org.netbeans.modules.javacore.parser.ClassInfoMeasure;
import org.netbeans.modules.javacore.parser.ConstructorInfoMeasure;
import org.netbeans.modules.javacore.parser.EnumConstInfoMeasure;
import org.netbeans.modules.javacore.parser.EnumInfoMeasure;
import org.netbeans.modules.javacore.parser.FieldGroupInfoMeasure;
import org.netbeans.modules.javacore.parser.FieldInfoMeasure;
import org.netbeans.modules.javacore.parser.ImportInfoMeasure;
import org.netbeans.modules.javacore.parser.InitializerInfoMeasure;
import org.netbeans.modules.javacore.parser.Measure;
import org.netbeans.modules.javacore.parser.MethodInfoMeasure;
import org.netbeans.modules.javacore.parser.ParameterInfoMeasure;
import org.netbeans.modules.javacore.parser.TypeParamInfoMeasure;
import org.openide.ErrorManager;

public class ArrayMapper {
    private Object[] oldArr;
    private Object[] newArr;
    private int[] map;
    private List deleted;
    private List added;
    private boolean identical;

    public ArrayMapper(Object[] o, Object[] n) {
        this.oldArr = new Object[o.length];
        System.arraycopy(o, 0, this.oldArr, 0, o.length);
        this.newArr = n;
    }

    public int[] getMap() {
        if (this.map == null) {
            this.mapArray();
        }
        return this.map;
    }

    public boolean isIdentical() {
        if (this.map == null) {
            this.mapArray();
        }
        return this.identical;
    }

    public List getDeletedIndexes() {
        if (this.deleted == null) {
            if (this.map == null) {
                this.mapArray();
            }
            this.deleted = new ArrayList();
            for (int i = 0; i < this.oldArr.length; ++i) {
                Object obj = this.oldArr[i];
                if (obj == null) continue;
                this.deleted.add(new Integer(i));
            }
        }
        return this.deleted;
    }

    List getAdded() {
        if (this.added == null) {
            if (this.map == null) {
                this.mapArray();
            }
            this.added = new ArrayList();
            for (int i = 0; i < this.map.length; ++i) {
                if (this.map[i] != -1) continue;
                this.added.add(this.newArr[i]);
            }
        }
        return this.added;
    }

    private final void mapArray() {
        int oldIndex;
        int j;
        ArrayList distances = new ArrayList(this.oldArr.length * 2);
        int mapped = 0;
        int identicalObjects = 0;
        this.map = new int[this.newArr.length];
        Arrays.fill(this.map, -1);
        for (int i = 0; i < this.newArr.length; ++i) {
            Object newObj = this.newArr[i];
            ArrayList<DistanceInfo> currentDistances = new ArrayList<DistanceInfo>(this.oldArr.length / 2);
            for (j = 0; j < this.oldArr.length; ++j) {
                oldIndex = (i + j) % this.oldArr.length;
                Object oldObj = this.oldArr[oldIndex];
                if (oldObj == null) continue;
                int dis = ArrayMapper.getDistance(oldObj, newObj);
                if (dis == 0) {
                    if (i == oldIndex) {
                        ++identicalObjects;
                    }
                    this.map[i] = oldIndex;
                    this.oldArr[oldIndex] = null;
                    ++mapped;
                    break;
                }
                if (dis >= 1000) continue;
                currentDistances.add(new DistanceInfo(i, oldIndex, dis));
            }
            if (j != this.oldArr.length) continue;
            distances.addAll(currentDistances);
        }
        if (mapped != this.oldArr.length) {
            DistanceInfo[] sortedDistances = new DistanceInfo[distances.size()];
            Collections.sort(distances);
            sortedDistances = distances.toArray(sortedDistances);
            for (j = 0; j < sortedDistances.length; ++j) {
                DistanceInfo info = sortedDistances[j];
                oldIndex = info.oldIndex;
                if (this.oldArr[oldIndex] == null || this.map[info.newIndex] != -1) continue;
                if (info.newIndex == oldIndex) {
                    ++identicalObjects;
                }
                this.map[((DistanceInfo)info).newIndex] = oldIndex;
                this.oldArr[oldIndex] = null;
                if (++mapped == this.oldArr.length) break;
            }
        }
        this.identical = identicalObjects == this.oldArr.length && this.oldArr.length == this.newArr.length;
    }

    private static int getDistance(Object mdr, Object ast) {
        Measure measure = null;
        if (mdr instanceof EnumConstant) {
            measure = EnumConstInfoMeasure.INSTANCE;
        } else if (mdr instanceof Initializer) {
            measure = InitializerInfoMeasure.INSTANCE;
        } else if (mdr instanceof Import) {
            measure = ImportInfoMeasure.INSTANCE;
        } else if (mdr instanceof Parameter) {
            measure = ParameterInfoMeasure.INSTANCE;
        } else if (mdr instanceof FieldGroup) {
            measure = FieldGroupInfoMeasure.INSTANCE;
        } else if (mdr instanceof TypeParameter) {
            measure = TypeParamInfoMeasure.INSTANCE;
        } else if (mdr instanceof Field) {
            measure = FieldInfoMeasure.INSTANCE;
        } else if (mdr instanceof Method) {
            measure = MethodInfoMeasure.INSTANCE;
        } else if (mdr instanceof Constructor) {
            measure = ConstructorInfoMeasure.INSTANCE;
        } else if (mdr instanceof JavaEnum) {
            measure = EnumInfoMeasure.INSTANCE;
        } else if (mdr instanceof AnnotationType) {
            measure = AnnotationTypeInfoMeasure.INSTANCE;
        } else if (mdr instanceof Annotation) {
            measure = AnnotationInfoMeasure.INSTANCE;
        } else if (mdr instanceof Attribute) {
            measure = AttributeInfoMeasure.INSTANCE;
        } else if (mdr instanceof JavaClass) {
            measure = ClassInfoMeasure.INSTANCE;
        } else if (mdr instanceof AttributeValue) {
            measure = AnnotationValueInfoMeasure.INSTANCE;
        } else {
            ErrorManager.getDefault().log(4096, "Unknown type " + mdr.getClass());
            return 1000;
        }
        return measure.getDistance(mdr, ast);
    }

    public boolean hasPermutation() {
        int val = -1;
        int[] map = this.getMap();
        for (int i = 0; i < map.length; ++i) {
            int mp = map[i];
            if (mp == -1) continue;
            if (mp > val) {
                val = mp;
                continue;
            }
            return true;
        }
        return false;
    }

    private class DistanceInfo
    implements Comparable {
        private final int newIndex;
        private final int oldIndex;
        private final int distance;

        private DistanceInfo(int newI, int oldI, int dis) {
            this.newIndex = newI;
            this.oldIndex = oldI;
            this.distance = dis;
        }

        public final int compareTo(Object obj) {
            return this.distance - ((DistanceInfo)obj).distance;
        }
    }
}

