/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ChangeNotificationListener;

public class NotifierList
implements List {
    private List innerList;
    private ChangeNotificationListener notificationListener;

    public NotifierList(List innerList, ChangeNotificationListener notificationListener) {
        this.setInnerList(innerList);
        this.setNotificationListener(notificationListener);
    }

    public NotifierList(List innerList) {
        this.setInnerList(innerList);
        this.setNotificationListener(null);
    }

    public void setInnerList(List innerList) {
        this.innerList = innerList;
    }

    public void setNotificationListener(ChangeNotificationListener notificationListener) {
        this.notificationListener = notificationListener;
    }

    private void notifyChange(boolean add, Object o) {
        if (this.notificationListener != null) {
            this.notificationListener.notifyChange(add, o);
        }
    }

    private void notifyChange(boolean add, Collection c) {
        if (this.notificationListener != null) {
            this.notificationListener.notifyChange(add, c);
        }
    }

    public boolean remove(Object obj) {
        boolean result = this.innerList.remove(obj);
        if (result) {
            this.notifyChange(false, obj);
        }
        return result;
    }

    public Object set(int param, Object obj) {
        Object result = this.innerList.set(param, obj);
        this.notifyChange(true, obj);
        if (result != null) {
            this.notifyChange(false, result);
        }
        return result;
    }

    public Object remove(int param) {
        Object result = this.innerList.remove(param);
        if (result != null) {
            this.notifyChange(false, result);
        }
        return result;
    }

    public void add(int param, Object obj) {
        this.innerList.add(param, obj);
        this.notifyChange(true, obj);
    }

    public boolean add(Object obj) {
        boolean result = this.innerList.add(obj);
        this.notifyChange(true, obj);
        return result;
    }

    public ListIterator listIterator(int param) {
        return new NotifierListIterator(this.innerList.listIterator(param));
    }

    public Iterator iterator() {
        return new NotifierListIterator(this.innerList.listIterator());
    }

    public ListIterator listIterator() {
        return new NotifierListIterator(this.innerList.listIterator());
    }

    public List subList(int param, int param1) {
        return new NotifierList(this.innerList.subList(param, param1), this.notificationListener);
    }

    public boolean contains(Object obj) {
        return this.innerList.contains(obj);
    }

    public boolean containsAll(Collection collection) {
        return this.innerList.containsAll(collection);
    }

    public boolean addAll(Collection c) {
        boolean result = this.innerList.addAll(c);
        if (result) {
            this.notifyChange(true, c);
        }
        return result;
    }

    public void clear() {
        this.notifyChange(false, null);
        this.innerList.clear();
    }

    public boolean isEmpty() {
        return this.innerList.isEmpty();
    }

    public boolean removeAll(Collection c) {
        this.notifyChange(false, null);
        return this.innerList.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        this.notifyChange(false, null);
        return this.innerList.retainAll(c);
    }

    public int size() {
        return this.innerList.size();
    }

    public Object[] toArray() {
        return this.innerList.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.innerList.toArray(a);
    }

    public boolean addAll(int index, Collection c) {
        boolean result = this.innerList.addAll(index, c);
        if (result) {
            this.notifyChange(true, c);
        }
        return result;
    }

    public Object get(int index) {
        return this.innerList.get(index);
    }

    public int indexOf(Object o) {
        return this.innerList.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.innerList.lastIndexOf(o);
    }

    class NotifierListIterator
    implements ListIterator {
        private Object lastRead;
        private ListIterator innerIterator;

        NotifierListIterator(ListIterator iterator) {
            this.innerIterator = iterator;
        }

        public void remove() {
            this.innerIterator.remove();
            if (this.lastRead != null) {
                NotifierList.this.notifyChange(false, this.lastRead);
            }
        }

        public void add(Object obj) {
            this.innerIterator.add(obj);
            NotifierList.this.notifyChange(true, obj);
        }

        public void set(Object obj) {
            this.innerIterator.set(obj);
            NotifierList.this.notifyChange(true, obj);
            if (this.lastRead != null) {
                NotifierList.this.notifyChange(false, this.lastRead);
            }
        }

        public boolean hasNext() {
            return this.innerIterator.hasNext();
        }

        public boolean hasPrevious() {
            return this.innerIterator.hasPrevious();
        }

        public Object next() {
            this.lastRead = this.innerIterator.next();
            return this.lastRead;
        }

        public int nextIndex() {
            return this.innerIterator.nextIndex();
        }

        public Object previous() {
            this.lastRead = this.innerIterator.previous();
            return this.lastRead;
        }

        public int previousIndex() {
            return this.innerIterator.previousIndex();
        }
    }
}

