/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.lang.reflect.Modifier;
import java.util.List;
import java.util.ListIterator;
import javax.jmi.reflect.ConstraintViolationException;
import org.netbeans.jmi.javamodel.ArrayClass;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementPartKind;
import org.netbeans.jmi.javamodel.ElementPartKindEnum;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.FieldGroup;
import org.netbeans.jmi.javamodel.InitialValue;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaDoc;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.Token;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.jmiimpl.javamodel.DiffElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.FeatureImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.FieldGroupImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.IndentUtil;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.javacore.parser.ArrayRef;
import org.netbeans.modules.javacore.parser.ElementInfo;
import org.netbeans.modules.javacore.parser.FeatureInfo;
import org.netbeans.modules.javacore.parser.FieldInfo;
import org.netbeans.modules.javacore.parser.MDRParser;
import org.netbeans.modules.javacore.parser.TypeRef;
import org.openide.util.Utilities;

public abstract class FieldImpl
extends FeatureImpl
implements Field {
    private static final ElementInfo DEFAULT_INFO = new FieldInfo(null, 28, null, 0, null, -1, null);
    protected String initialValueText;
    protected InitialValue initialValue;
    private boolean initValueInited = false;
    private boolean elementsInited = false;
    private TypeReference typeName = null;
    private int dimCount = 0;
    private boolean internalSetDim = false;
    private static final int TYPE = 1;
    private static final int VARIABLE_DECLARATORS = 2;

    public FieldImpl(StorableObject s) {
        super(s);
    }

    public String toString() {
        return "field " + this.getName();
    }

    protected ElementInfo getDefaultInfo() {
        return DEFAULT_INFO;
    }

    public List getChildren() {
        List list = super.getChildren();
        FieldImpl.addIfNotNull(list, this.getTypeName());
        if (!this.isChanged(32) || this.initialValueText == null) {
            FieldImpl.addIfNotNull(list, this.getInitialValue());
        }
        return list;
    }

    public void fixImports(Element scope, Element original) {
        Field field = (Field)original;
        MetadataElement newInitVal = (MetadataElement)this.getInitialValue();
        InitialValue oldInitVal = field.getInitialValue();
        if (newInitVal != null && oldInitVal != null) {
            newInitVal.fixImports(scope, (Element)oldInitVal);
        }
        this.setTypeName(JavaModelUtil.resolveImportsForType(scope, field.getType()));
        this.setDimCount(0);
        super.fixImports(scope, original);
    }

    protected List getInitedChildren() {
        List list = super.getInitedChildren();
        if (this.elementsInited) {
            FieldImpl.addIfNotNull(list, this.typeName);
        }
        if (this.initValueInited && (!this.isChanged(32) || this.initialValueText == null)) {
            FieldImpl.addIfNotNull(list, this.initialValue);
        }
        return list;
    }

    protected void initASTElements() {
        this.elementsInited = false;
        if (!this.childrenInited) {
            this.initChildren();
        }
        FieldInfo info = (FieldInfo)this.getElementInfo();
        ASTree tree = info.getTypeAST(this);
        this.typeName = (TypeReference)this.initOrCreate((Element)this.typeName, tree);
        this.elementsInited = true;
    }

    protected void initChildren() {
        this.childrenInited = false;
        super.initChildren();
        this.childrenInited = true;
        if (this.elementsInited) {
            this.initASTElements();
        }
        if (this.initValueInited) {
            JMManager.getTransactionMutex().addBFeatureToInitQueue((Object)this);
        }
    }

    protected void resetChildren() {
        super.resetChildren();
        this.resetASTElements();
    }

    protected void setData(List annotations, int modifiers, String javadocText, JavaDoc javadoc, boolean isFinal, TypeReference typeName, int dimCount, InitialValue initialValue, String initialValueText) {
        super.setData(annotations, javadocText, javadoc);
        if (initialValueText == null) {
            this.changeChild(null, (Element)initialValue);
            this.initialValue = initialValue;
        } else {
            if (initialValue != null) {
                throw new ConstraintViolationException(null, null, "Cannot set both initialValue and initialValueText.");
            }
            this.initialValueText = initialValueText;
        }
        this.changeChild(null, (Element)typeName);
        this.typeName = typeName;
        this.dimCount = dimCount;
        this.setTypeRef(FieldImpl.typeReferenceToTypeRef((Element)typeName, dimCount));
        this.initValueInited = true;
        this.elementsInited = true;
    }

    public void initInitValue() {
        FieldInfo initValInfo;
        this.initValueInited = false;
        if (!this.elementsInited) {
            this.initASTElements();
        }
        if ((initValInfo = (FieldInfo)this.getElementInfo()) != null) {
            initValInfo.doAttribution(this);
            this.initialValue = (InitialValue)this.initOrCreate((Element)this.initialValue, this.extractInitialValue());
        }
        this.initValueInited = true;
    }

    protected void matchPersistent(ElementInfo info) {
        super.matchPersistent(info);
        boolean inFieldGroup = this.refImmediateComposite() instanceof FieldGroup;
        FieldInfo newInfo = (FieldInfo)info;
        if (newInfo.modifiers != this.getSourceModifiers()) {
            if (inFieldGroup) {
                this.super_setModifiers(newInfo.modifiers);
            } else {
                this.setModifiers(newInfo.modifiers);
            }
        }
        if (!this.isPersisted()) {
            this.setPersisted(true);
            this.persist();
            this.setTypeRef(newInfo.type);
            this.persistChildren(this.getPersistentList("annotations", this.super_getAnnotations()), ((FeatureInfo)info).annotations);
        } else {
            if (!Utilities.compareObjects((Object)newInfo.type, (Object)this.getTypeRef())) {
                if (this.refImmediateComposite() instanceof FieldGroup) {
                    this.setTypeRef(newInfo.type);
                } else {
                    this.setType(this.resolveType(newInfo.type));
                }
            }
            this.processMembers(this.getAnnotations(), newInfo.annotations);
        }
    }

    protected void matchModifiers(ElementInfo info) {
    }

    protected void matchElementInfo(ElementInfo newInfo) {
        super.matchElementInfo(newInfo);
        this.resetASTElements();
    }

    protected void resetASTElements() {
        if (this.elementsInited) {
            InitialValue temp;
            if (this.initialValue != null) {
                temp = this.initialValue;
                this.initialValue = null;
                this.changeChild((Element)temp, null);
                temp.refDelete();
            }
            if (this.typeName != null) {
                temp = this.typeName;
                this.typeName = null;
                this.changeChild((Element)temp, null);
                temp.refDelete();
            }
            this.initValueInited = false;
            this.elementsInited = false;
        }
    }

    public Type getType() {
        this.checkUpToDate();
        MetadataElement parent = (MetadataElement)this.refImmediateComposite();
        if (parent instanceof FieldGroup && parent.isChanged()) {
            FieldGroup group = (FieldGroup)parent;
            Type t = group.getType();
            int dims = this.getDimCount();
            if (dims > 0) {
                ArrayClass arrClass = ((JavaModelPackage)t.refImmediatePackage()).getArray();
                for (int i = 0; i < dims; ++i) {
                    t = arrClass.resolveArray(t);
                }
            }
            return t;
        }
        return this.resolveType(this.getTypeRef());
    }

    private void fireTypeNameChange(TypeReference typeReference) {
        TypeReference oldValue = null;
        TypeReference newValue = null;
        if (this.elementsInited && !this.disableChanges) {
            oldValue = this.getTypeName();
            newValue = typeReference;
        }
        this.fireAttrChange("typeName", oldValue, newValue);
    }

    public void setType(Type newValue) {
        TypeRef tr = FieldImpl.typeToTypeRef(newValue);
        TypeReference typeReference = null;
        if (!this.disableChanges) {
            this.updateDimCount(tr);
            typeReference = (TypeReference)this.typeRefToTypeReference(tr, this.getDimCount());
        }
        this.fireTypeNameChange(typeReference);
        this._setTypeName(typeReference, tr);
    }

    private void updateDimCount(TypeRef tr) {
        int dimCount = this.getDimCount();
        if (tr instanceof ArrayRef) {
            if (((ArrayRef)tr).dimCount < dimCount) {
                this._setDimCount(((ArrayRef)tr).dimCount);
            }
        } else if (dimCount > 0) {
            this._setDimCount(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setDimCount(int dimCount) {
        this.internalSetDim = true;
        try {
            this.setDimCount(dimCount);
        }
        finally {
            this.internalSetDim = false;
        }
    }

    public TypeReference getTypeName() {
        MetadataElement parent;
        this.checkUpToDate();
        if (!this.elementsInited) {
            this.initASTElements();
        }
        if ((parent = (MetadataElement)this.refImmediateComposite()) instanceof FieldGroup) {
            FieldGroup group = (FieldGroup)parent;
            return group.getTypeName();
        }
        return this.typeName;
    }

    public void setTypeName(TypeReference typeName) {
        this._setTypeName(typeName, FieldImpl.typeReferenceToTypeRef((Element)typeName, this.getDimCount()));
    }

    public void _setTypeName(TypeReference typeName, TypeRef typeRef) {
        if (!this.disableChanges) {
            this.objectChanged(64);
            if (typeName != this.typeName) {
                this.splitGroup();
            }
            this.changeChild((Element)this.getTypeName(), (Element)typeName);
            this.typeName = typeName;
        }
        this.setTypeRef(typeRef);
    }

    public void setModifiers(int newValue) {
        this.objectChanged(4);
        this.splitGroup();
        this.super_setModifiers(newValue);
    }

    public int getModifiers() {
        MetadataElement parent = (MetadataElement)this.refImmediateComposite();
        if (parent instanceof FieldGroup) {
            return ((FieldGroup)parent).getModifiers();
        }
        ClassDefinition cd = this.getDeclaringClass();
        int mods = super.getModifiers();
        if (cd instanceof JavaClass && ((JavaClass)cd).isInterface()) {
            return mods | 8 | 0x10;
        }
        return mods;
    }

    public void setJavadocText(String newValue) {
        super.setJavadocText(newValue);
        this.splitGroup();
    }

    private void splitGroup() {
        MetadataElement parent = (MetadataElement)this.refImmediateComposite();
        if (parent instanceof FieldGroup) {
            if (!this.elementsInited) {
                this.initASTElements();
            }
            FieldGroupImpl group = (FieldGroupImpl)parent;
            int modifiers = group.getSourceModifiers();
            Type type = this.getType();
            JavaModelPackage pkg = (JavaModelPackage)this.refImmediatePackage();
            TypeReference typeName = group.getTypeName();
            TypeReference typeNameCopy1 = (TypeReference)typeName.duplicate();
            TypeReference typeNameCopy2 = (TypeReference)typeName.duplicate();
            int i = group.getFields().indexOf((Object)this);
            ClassDefinition cls = (ClassDefinition)group.refImmediateComposite();
            int j = cls.getContents().indexOf((Object)group);
            if (i == group.getFields().size() - 1) {
                ++j;
            } else if (i != 0) {
                FieldGroup newGroup = pkg.getFieldGroup().createFieldGroup(null, null, group.getSourceModifiers(), null, null, null, null);
                newGroup.setTypeName(typeNameCopy1);
                ListIterator fields = group.getFields().listIterator(i + 1);
                while (fields.hasNext()) {
                    Field field = (Field)fields.next();
                    fields.remove();
                    newGroup.getFields().add(field);
                }
                cls.getContents().add(++j, newGroup);
            }
            group.getFields().remove((Object)this);
            cls.getContents().add(j, this);
            if (group.getFields().isEmpty()) {
                group.refDelete();
            }
            this.setTypeRef(FieldImpl.typeToTypeRef(type));
            this.typeName = typeNameCopy2;
            this.super_setModifiers(modifiers);
        }
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    public void setFinal(boolean newValue) {
        if (newValue) {
            this.setModifiers(this.getSourceModifiers() | 0x10);
        } else {
            this.setModifiers(this.getSourceModifiers() & 0xFFFFFFEF);
        }
    }

    public InitialValue getInitialValue() {
        this.checkUpToDate();
        if (this.isChanged(32) && this.initialValueText != null) {
            throw new ConstraintViolationException(null, null, "Cannot ask for initial value after the initial value text was changed.");
        }
        if (!this.initValueInited) {
            this.initInitValue();
        }
        return this.initialValue;
    }

    public void setInitialValue(InitialValue newValue) {
        if (!this.initValueInited) {
            this.initInitValue();
        }
        this.changeChild((Element)this.initialValue, (Element)newValue);
        this.initialValue = newValue;
        this.initialValueText = null;
        this.objectChanged(32);
    }

    public String getInitialValueText() {
        if (this.isChanged(32)) {
            if (this.initialValue != null) {
                throw new ConstraintViolationException(null, null, "Cannot ask for initial value text after the initial value was changed.");
            }
            return this.initialValueText;
        }
        return this.extractInitialValueText();
    }

    private ASTree extractVariableDeclarator() {
        ASTree fieldTree = this.getASTree();
        if (fieldTree != null && fieldTree.getType() != 70) {
            return fieldTree.getSubTrees()[2];
        }
        return fieldTree;
    }

    private ASTree extractInitialValue() {
        return this.extractVariableDeclarator().getSubTrees()[2];
    }

    private String extractInitialValueText() {
        MDRParser parser = this.getParser();
        if (parser == null) {
            return null;
        }
        ASTree initValue = this.extractInitialValue();
        if (initValue == null) {
            return null;
        }
        return parser.getText(initValue);
    }

    public void setInitialValueText(String newValue) {
        if (!this.elementsInited) {
            this.initASTElements();
        }
        if (this.initValueInited && this.initialValue != null) {
            this.changeChild((Element)this.initialValue, null);
        }
        this.objectChanged(32);
        this.initialValueText = newValue;
        this.initialValue = null;
        this.initValueInited = true;
    }

    String getRawText() {
        if (!this.initValueInited) {
            this.initInitValue();
        }
        StringBuffer buf = new StringBuffer();
        if (!(this.refImmediateComposite() instanceof FieldGroup)) {
            if (this.isNew()) {
                this.generateNewJavaDoc(buf);
            }
            this.generateNewModifiers(buf);
            if (this.getTypeName() != null) {
                buf.append(((MetadataElement)this.getTypeName()).getSourceText());
            } else {
                buf.append(this.getType().getName());
            }
            buf.append(' ');
        }
        buf.append(this.getName());
        this.appendDims(buf, this.getDimCount());
        if (this.initialValueText != null && this.initialValueText.trim().length() != 0) {
            this.formatElementPart(8, buf);
            buf.append(this.initialValueText);
        } else if (this.initialValue != null) {
            this.formatElementPart(8, buf);
            buf.append(((MetadataElement)this.initialValue).getSourceText());
        }
        if (!(this.refImmediateComposite() instanceof FieldGroup)) {
            if (this.isNew() || this.getASTree().getType() == 70) {
                buf.append(";");
            } else {
                buf.append(IndentUtil.reformatTokenWithPads(this, this.getASTree().getLastToken()));
            }
        }
        return buf.toString();
    }

    public void getDiff(List diffList) {
        MDRParser parser = this.getParser();
        ASTree tree = this.getASTree();
        ASTree[] children = tree.getSubTrees();
        this.replaceJavaDoc(diffList);
        if (tree.getType() != 70) {
            if (this.isChanged(4) || this.isChanged(32768)) {
                this.diffModifiers(diffList, children[1], parser);
            } else if (children[0] != null) {
                FieldInfo astInfo = (FieldInfo)this.getElementInfo();
                this.getCollectionDiff(diffList, parser, 32768, astInfo.annotations, this.getAnnotations(), parser.getToken(children[0].getLastToken()).getEndOffset(), " ");
            }
            this.getChildDiff(diffList, parser, children[1], (MetadataElement)this.getTypeName(), 64);
        }
        ASTree[] varDeclarator = tree.getType() == 70 ? tree.getSubTrees() : children[2].getSubTrees();
        if (this.isChanged(2)) {
            Token identifier = (Token)varDeclarator[0];
            int startOffset = identifier.getStartOffset();
            int endOffset = identifier.getEndOffset();
            diffList.add(new DiffElement(startOffset, endOffset, this.getName()));
        }
        if (this.isChanged(8192)) {
            this.replaceNode(diffList, parser, varDeclarator[1], this.appendDims(new StringBuffer(), this.getDimCount()).toString(), FieldImpl.getEndOffset(this.getParser(), varDeclarator[0]), "");
        }
        if (this.isChanged(32)) {
            String text;
            int startOffset = 0;
            int endOffset = 0;
            String string = text = this.initialValue == null ? this.initialValueText : ((MetadataElement)this.getInitialValue()).getSourceText();
            if (varDeclarator[2] != null) {
                if (text == null || text.trim().length() == 0) {
                    Token startToken = parser.getToken((varDeclarator[1] == null ? varDeclarator[0] : varDeclarator[1]).getLastToken());
                    startOffset = startToken.getEndOffset();
                } else {
                    Token startToken = parser.getToken(varDeclarator[2].getFirstToken());
                    startOffset = startToken.getStartOffset();
                }
                Token endToken = parser.getToken(varDeclarator[2].getLastToken());
                endOffset = endToken.getEndOffset();
            } else {
                Token lastTokenOfDecl = parser.getToken(tree.getLastToken());
                startOffset = tree.getType() == 70 ? lastTokenOfDecl.getEndOffset() : lastTokenOfDecl.getStartOffset();
                endOffset = startOffset;
                if (text != null) {
                    StringBuffer buf = new StringBuffer();
                    this.formatElementPart(8, buf);
                    text = buf + text;
                }
            }
            diffList.add(new DiffElement(startOffset, endOffset, text == null ? "" : text));
        } else if (this.initialValue != null && ((MetadataElement)this.initialValue).isChanged()) {
            ((MetadataElement)this.initialValue).getDiff(diffList);
        }
    }

    protected ASTree getPartStartTree(ElementPartKind part) {
        if (ElementPartKindEnum.HEADER.equals((Object)part)) {
            return this.getASTree();
        }
        return super.getPartStartTree(part);
    }

    protected ASTree getPartEndTree(ElementPartKind part) {
        if (ElementPartKindEnum.HEADER.equals((Object)part)) {
            ASTree[] headerParts = this.getASTree().getSubTrees();
            int i = 2;
            while (true) {
                ASTree result;
                if ((result = headerParts[i]) != null) {
                    return result;
                }
                --i;
            }
        }
        return super.getPartEndTree(part);
    }

    protected ASTree getPartTree(ElementPartKind part) {
        if (ElementPartKindEnum.NAME.equals((Object)part)) {
            if (this.getASTree().getType() == 28) {
                ASTree[] children = this.getASTree().getSubTrees();
                return children[2].getSubTrees()[0];
            }
            return this.getASTree();
        }
        throw new IllegalArgumentException("Invalid part for this element: " + part);
    }

    public void replaceChild(Element oldElement, Element newElement) {
        if (this.elementsInited && oldElement.equals(this.typeName)) {
            this.setTypeName((TypeReference)newElement);
            return;
        }
        if (this.initValueInited && oldElement.equals(this.initialValue)) {
            this.setInitialValue((InitialValue)newElement);
            return;
        }
        super.replaceChild(oldElement, newElement);
    }

    public int getDimCount() {
        ASTree dims;
        if (this.isChanged(8192)) {
            return this.dimCount;
        }
        ASTree tree = this.extractVariableDeclarator();
        if (tree != null && (dims = tree.getSubTrees()[1]) != null) {
            return (dims.getLastToken() - dims.getFirstToken() + 1) / 2;
        }
        return 0;
    }

    public void setDimCount(int dimCount) {
        this.objectChanged(8192);
        this.dimCount = dimCount;
        if (!this.internalSetDim) {
            this.setTypeRef(FieldImpl.typeReferenceToTypeRef((Element)this.getTypeName(), dimCount));
        }
    }

    void childChanged(MetadataElement mpi) {
        super.childChanged(mpi);
        if (this.elementsInited && mpi == this.typeName) {
            this.setTypeName((TypeReference)mpi);
        }
    }

    public Element duplicate(JavaModelPackage targetExtent) {
        String initValText;
        InitialValue initVal;
        if (this.isChanged(32) && this.initialValueText != null) {
            initVal = null;
            initValText = this.initialValueText;
        } else {
            initVal = (InitialValue)FieldImpl.duplicateElement((Element)this.getInitialValue(), targetExtent);
            initValText = null;
        }
        return targetExtent.getField().createField(this.getName(), FieldImpl.duplicateList(this.getAnnotations(), targetExtent), this.getModifiers(), null, (JavaDoc)FieldImpl.duplicateElement((Element)this.getJavadoc(), targetExtent), this.isFinal(), (TypeReference)FieldImpl.duplicateElement((Element)this.getTypeName(), targetExtent), this.getDimCount(), initVal, initValText);
    }

    protected void _delete() {
        if (this.elementsInited) {
            this.deleteChild((Element)this.typeName);
        }
        if (this.initValueInited) {
            this.deleteChild((Element)this.initialValue);
        }
        super._delete();
    }
}

