/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class MergedClassPathImplementation
implements ClassPathImplementation {
    public static final String PROP_UNRESOLVED_ROOTS = "unresolvedRoots";
    private Set roots;
    private PropertyChangeSupport support;
    private GlobalPathRegistry reg;
    private final ArrayList cachedResources;
    private List unresolvedRoots;
    private List missingRoots;
    private ClassPathMap resourceMap;
    private GlobalPathRegistryListener gprListener;
    private PropertyChangeListener pcListener = new PropertyChangeListener(){
        static final /* synthetic */ boolean $assertionsDisabled;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent event) {
            if (!$assertionsDisabled && event == null) {
                throw new AssertionError((Object)"event == null");
            }
            MergedClassPathImplementation mergedClassPathImplementation = MergedClassPathImplementation.this;
            synchronized (mergedClassPathImplementation) {
                MergedClassPathImplementation.this.roots = null;
            }
            if ("entries".equals(event.getPropertyName())) {
                MergedClassPathImplementation.this.updateEntries((ClassPath)event.getSource());
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$javacore$classpath$MergedClassPathImplementation == null ? (class$org$netbeans$modules$javacore$classpath$MergedClassPathImplementation = MergedClassPathImplementation.class$("org.netbeans.modules.javacore.classpath.MergedClassPathImplementation")) : class$org$netbeans$modules$javacore$classpath$MergedClassPathImplementation).desiredAssertionStatus();
        }
    };
    private WeakHashMap sfbResultListeners = new WeakHashMap(100);
    private static MergedClassPathImplementation instance;
    static final /* synthetic */ boolean $assertionsDisabled;

    private MergedClassPathImplementation() {
        this.support = new PropertyChangeSupport(this);
        this.cachedResources = new ArrayList();
        this.missingRoots = new ArrayList();
        this.reg = GlobalPathRegistry.getDefault();
        this.gprListener = new GlobalPathRegistryListener(){
            static final /* synthetic */ boolean $assertionsDisabled;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void pathsAdded(GlobalPathRegistryEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"event == null");
                }
                MergedClassPathImplementation mergedClassPathImplementation = MergedClassPathImplementation.this;
                synchronized (mergedClassPathImplementation) {
                    MergedClassPathImplementation.this.roots = null;
                }
                MergedClassPathImplementation.this.updateEntries(event);
                MergedClassPathImplementation.this.firePropertyChange(MergedClassPathImplementation.PROP_UNRESOLVED_ROOTS);
            }

            public void pathsRemoved(GlobalPathRegistryEvent event) {
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$modules$javacore$classpath$MergedClassPathImplementation == null ? (class$org$netbeans$modules$javacore$classpath$MergedClassPathImplementation = MergedClassPathImplementation.class$("org.netbeans.modules.javacore.classpath.MergedClassPathImplementation")) : class$org$netbeans$modules$javacore$classpath$MergedClassPathImplementation).desiredAssertionStatus();
            }
        };
        this.reg.addGlobalPathRegistryListener((GlobalPathRegistryListener)WeakListeners.create((Class)GlobalPathRegistryListener.class, (EventListener)this.gprListener, (Object)this.reg));
        if (!$assertionsDisabled && this.reg == null) {
            throw new AssertionError((Object)"GloabalPathRegistry.getDefault()==null");
        }
    }

    public synchronized List getResources() {
        return Collections.unmodifiableList((List)this.cachedResources.clone());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!$assertionsDisabled && listener == null) {
            throw new AssertionError((Object)"gprListener == null");
        }
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (!$assertionsDisabled && listener == null) {
            throw new AssertionError((Object)"gprListener == null");
        }
        this.support.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassPaths(ClassPath[] cps) {
        if (!$assertionsDisabled && cps == null) {
            throw new AssertionError((Object)"addClassPath called with null");
        }
        for (int i = 0; i < cps.length; ++i) {
            if (cps[i] == null) continue;
            this.addClassPath(cps[i]);
        }
        MergedClassPathImplementation mergedClassPathImplementation = this;
        synchronized (mergedClassPathImplementation) {
            this.roots = null;
        }
        this.firePropertyChange(PROP_UNRESOLVED_ROOTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRoot(URL url) {
        MergedClassPathImplementation mergedClassPathImplementation = this;
        synchronized (mergedClassPathImplementation) {
            if (this.unresolvedRoots == null) {
                this.initEntries();
            }
            PathResourceImplementation root = ClassPathSupport.createResource((URL)url);
            this.unresolvedRoots.add(root);
            this.roots = null;
        }
        this.firePropertyChange(PROP_UNRESOLVED_ROOTS);
    }

    public synchronized PathResourceImplementation[] getUnresolvedRoots() {
        if (this.unresolvedRoots == null) {
            this.initEntries();
        }
        return this.unresolvedRoots.toArray(new PathResourceImplementation[this.unresolvedRoots.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void classPathRootResolved(PathResourceImplementation impl) {
        MergedClassPathImplementation mergedClassPathImplementation = this;
        synchronized (mergedClassPathImplementation) {
            if (this.unresolvedRoots.remove(impl)) {
                this.cachedResources.add(impl);
            }
            this.roots = null;
        }
        this.firePropertyChange("resources");
    }

    public synchronized void removeRoot(PathResourceImplementation impl) {
        this.unresolvedRoots.remove(impl);
        this.missingRoots.add(impl.getRoots()[0]);
        this.roots = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMissingRoot(URL url) {
        boolean result = false;
        MergedClassPathImplementation mergedClassPathImplementation = this;
        synchronized (mergedClassPathImplementation) {
            while (this.missingRoots.remove(url)) {
                PathResourceImplementation resource = ClassPathSupport.createResource((URL)url);
                if (!$assertionsDisabled && resource == null) {
                    throw new AssertionError((Object)"ClassPathSupport.createResource() returned null");
                }
                this.unresolvedRoots.add(resource);
                result = true;
                this.roots = null;
            }
        }
        if (result) {
            this.firePropertyChange(PROP_UNRESOLVED_ROOTS);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMissingRoot(URL url) {
        boolean result = false;
        MergedClassPathImplementation mergedClassPathImplementation = this;
        synchronized (mergedClassPathImplementation) {
            PathResourceImplementation resource = ClassPathSupport.createResource((URL)url);
            while (this.cachedResources.remove(resource)) {
                this.missingRoots.add(url);
                result = true;
                this.roots = null;
            }
        }
        if (result) {
            this.firePropertyChange("resources");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRoot(URL url) {
        boolean result = false;
        MergedClassPathImplementation mergedClassPathImplementation = this;
        synchronized (mergedClassPathImplementation) {
            PathResourceImplementation resource = ClassPathSupport.createResource((URL)url);
            while (this.cachedResources.remove(resource)) {
                this.unresolvedRoots.add(resource);
                result = true;
                this.roots = null;
            }
        }
        if (result) {
            this.firePropertyChange("resources");
            this.firePropertyChange(PROP_UNRESOLVED_ROOTS);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUnresolvedRoots(List unresolvedRoots) {
        MergedClassPathImplementation mergedClassPathImplementation = this;
        synchronized (mergedClassPathImplementation) {
            this.unresolvedRoots.addAll(unresolvedRoots);
            this.roots = null;
        }
        this.firePropertyChange(PROP_UNRESOLVED_ROOTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void classPathRootResolved(URL url) {
        MergedClassPathImplementation mergedClassPathImplementation = this;
        synchronized (mergedClassPathImplementation) {
            Iterator it = this.unresolvedRoots.iterator();
            while (it.hasNext()) {
                PathResourceImplementation resource = (PathResourceImplementation)it.next();
                if (!resource.getRoots()[0].equals(url)) continue;
                it.remove();
                this.cachedResources.add(resource);
                break;
            }
            this.roots = null;
        }
        this.firePropertyChange("resources");
    }

    private synchronized void initEntries() {
        HashSet classPaths = new HashSet();
        this.roots = null;
        this.unresolvedRoots = new ArrayList();
        this.resourceMap = new ClassPathMap();
        classPaths.addAll(this.reg.getPaths("classpath/source"));
        classPaths.addAll(this.reg.getPaths("classpath/compile"));
        classPaths.addAll(this.reg.getPaths("classpath/boot"));
        Iterator it = classPaths.iterator();
        while (it.hasNext()) {
            ClassPath cp = (ClassPath)it.next();
            this.addClassPath(cp);
        }
    }

    private synchronized void updateEntries(GlobalPathRegistryEvent event) {
        if (this.cachedResources == null) {
            return;
        }
        Iterator it = event.getChangedPaths().iterator();
        while (it.hasNext()) {
            ClassPath cp = (ClassPath)it.next();
            this.addClassPath(cp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEntries(ClassPath cp) {
        List oldResources;
        boolean fire = false;
        MergedClassPathImplementation mergedClassPathImplementation = this;
        synchronized (mergedClassPathImplementation) {
            oldResources = (List)this.resourceMap.remove(cp);
            if (!$assertionsDisabled && oldResources == null) {
                throw new AssertionError((Object)"Change in unknown classpath");
            }
        }
        List newResources = this.addClassPathResources(cp);
        MergedClassPathImplementation mergedClassPathImplementation2 = this;
        synchronized (mergedClassPathImplementation2) {
            PathResourceImplementation resource;
            HashSet toRemove = new HashSet(oldResources);
            toRemove.removeAll(newResources);
            newResources.removeAll(oldResources);
            Iterator it = toRemove.iterator();
            while (it.hasNext()) {
                resource = (PathResourceImplementation)it.next();
                oldResources.remove(resource);
                if (!this.cachedResources.remove(resource)) {
                    if (this.unresolvedRoots.remove(resource)) continue;
                    this.missingRoots.remove(resource.getRoots()[0]);
                    continue;
                }
                fire = true;
            }
            it = newResources.iterator();
            while (it.hasNext()) {
                resource = (PathResourceImplementation)it.next();
                oldResources.add(resource);
            }
            this.resourceMap.put(cp, oldResources);
            this.unresolvedRoots.addAll(newResources);
        }
        if (fire) {
            this.firePropertyChange("resources");
        }
        this.firePropertyChange(PROP_UNRESOLVED_ROOTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClassPath(ClassPath cp) {
        MergedClassPathImplementation mergedClassPathImplementation = this;
        synchronized (mergedClassPathImplementation) {
            if (this.resourceMap == null) {
                this.initEntries();
            }
            if (this.resourceMap.containsKey(cp)) {
                return;
            }
        }
        List c = this.addClassPathResources(cp);
        MergedClassPathImplementation mergedClassPathImplementation2 = this;
        synchronized (mergedClassPathImplementation2) {
            if (!this.resourceMap.containsKey(cp)) {
                this.resourceMap.put(cp, c);
                this.unresolvedRoots.addAll(c);
                cp.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create((Class)PropertyChangeListener.class, (EventListener)this.pcListener, (Object)cp));
            }
        }
    }

    private void firePropertyChange(String propName) {
        this.support.firePropertyChange(propName, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List addClassPathResources(ClassPath cp) {
        List entries = null;
        SFBQListener listener = null;
        MergedClassPathImplementation mergedClassPathImplementation = this;
        synchronized (mergedClassPathImplementation) {
            WeakReference wr = (WeakReference)this.sfbResultListeners.get(cp);
            listener = wr == null ? null : wr.get();
            if (listener == null) {
                listener = new SFBQListener(cp);
                this.sfbResultListeners.put(cp, new WeakReference<SFBQListener>(listener));
            }
        }
        entries = cp.entries();
        ArrayList c = new ArrayList();
        Iterator et = entries.iterator();
        while (et.hasNext()) {
            ClassPath.Entry entry = (ClassPath.Entry)et.next();
            URL url = entry.getURL();
            if (!$assertionsDisabled && url == null) {
                throw new AssertionError((Object)"ClassPath.Entry.getURL() returned null");
            }
            MergedClassPathImplementation.addResources(url, listener, c);
        }
        return c;
    }

    private static void addResources(URL url, SFBQListener sfbResultListener, List resourceList) {
        PathResourceImplementation resource = ClassPathSupport.createResource((URL)url);
        if (!$assertionsDisabled && resource == null) {
            throw new AssertionError((Object)"ClassPathSupport.createResource() returned null");
        }
        boolean needsBinary = true;
        SourceForBinaryQuery.Result result = sfbResultListener.getResult(url);
        FileObject[] sources = result.getRoots();
        List<FileObject> sourcesL = Arrays.asList(sources);
        if (sourcesL.contains(null)) {
            ErrorManager.getDefault().log(16, "Warning: " + result.getClass().getName() + " illegally returned a null element from getResult(URL): " + sourcesL);
            return;
        }
        ArrayList<PathResourceImplementation> tempResult = new ArrayList<PathResourceImplementation>(sources.length);
        for (int i = 0; i < sources.length; ++i) {
            try {
                URL surl = sources[i].getURL();
                if ("file".equals(surl.getProtocol())) {
                    needsBinary = false;
                }
                PathResourceImplementation sresource = ClassPathSupport.createResource((URL)surl);
                if (!$assertionsDisabled && sresource == null) {
                    throw new AssertionError((Object)"ClassPathSupport.createResource() returned null");
                }
                tempResult.add(sresource);
                continue;
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        if (needsBinary) {
            resourceList.add(resource);
        }
        resourceList.addAll(tempResult);
    }

    public static synchronized MergedClassPathImplementation getDefault() {
        if (instance == null) {
            instance = new MergedClassPathImplementation();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getRoots() {
        List _cachedResources;
        MergedClassPathImplementation mergedClassPathImplementation = this;
        synchronized (mergedClassPathImplementation) {
            if (this.roots != null) {
                return this.roots;
            }
            _cachedResources = this.getResources();
        }
        HashSet<FileObject> _roots = new HashSet<FileObject>();
        Iterator it = _cachedResources.iterator();
        while (it.hasNext()) {
            PathResourceImplementation res = (PathResourceImplementation)it.next();
            URL[] urls = res.getRoots();
            for (int i = 0; i < urls.length; ++i) {
                FileObject obj = URLMapper.findFileObject((URL)urls[i]);
                if (obj == null) continue;
                _roots.add(obj);
            }
        }
        MergedClassPathImplementation mergedClassPathImplementation2 = this;
        synchronized (mergedClassPathImplementation2) {
            if (this.roots == null) {
                this.roots = Collections.unmodifiableSet(_roots);
            }
            return this.roots;
        }
    }

    public boolean contains(FileObject fo) {
        return this.findOwnerRoot(fo) != null;
    }

    public FileObject findOwnerRoot(FileObject fo) {
        Set roots = this.getRoots();
        for (FileObject f = fo; f != null; f = f.getParent()) {
            if (!roots.contains(f)) continue;
            return f;
        }
        return null;
    }

    static {
        $assertionsDisabled = !MergedClassPathImplementation.class.desiredAssertionStatus();
    }

    private class ClassPathMap {
        private List data = new ArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(Object key, Object value) {
            MergedClassPathImplementation mergedClassPathImplementation = MergedClassPathImplementation.this;
            synchronized (mergedClassPathImplementation) {
                WeakPair wp = new WeakPair(key, value);
                this.data.add(wp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(Object key) {
            if (key == null) {
                return null;
            }
            MergedClassPathImplementation mergedClassPathImplementation = MergedClassPathImplementation.this;
            synchronized (mergedClassPathImplementation) {
                Iterator it = this.data.iterator();
                while (it.hasNext()) {
                    WeakPair pair = (WeakPair)it.next();
                    Object wpk = pair.getKey();
                    if (!key.equals(wpk)) continue;
                    it.remove();
                    return pair.getValue();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsKey(Object key) {
            Iterator it;
            if (key == null) {
                return false;
            }
            MergedClassPathImplementation mergedClassPathImplementation = MergedClassPathImplementation.this;
            synchronized (mergedClassPathImplementation) {
                it = new ArrayList(this.data).iterator();
            }
            while (it.hasNext()) {
                WeakPair pair = (WeakPair)it.next();
                Object pk = pair.getKey();
                if (!key.equals(pk)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanUp(WeakPair toClean) {
            boolean fire = false;
            MergedClassPathImplementation mergedClassPathImplementation = MergedClassPathImplementation.this;
            synchronized (mergedClassPathImplementation) {
                Iterator it = this.data.iterator();
                while (it.hasNext()) {
                    WeakPair pair = (WeakPair)it.next();
                    if (pair != toClean) continue;
                    it.remove();
                    Iterator resIt = ((Collection)pair.getValue()).iterator();
                    while (resIt.hasNext()) {
                        PathResourceImplementation resource = (PathResourceImplementation)resIt.next();
                        if (!MergedClassPathImplementation.this.cachedResources.remove(resource)) {
                            if (MergedClassPathImplementation.this.unresolvedRoots.remove(resource)) continue;
                            MergedClassPathImplementation.this.missingRoots.remove(resource.getRoots()[0]);
                            continue;
                        }
                        fire = true;
                        MergedClassPathImplementation.this.roots = null;
                    }
                    break block3;
                }
            }
            if (fire) {
                MergedClassPathImplementation.this.firePropertyChange("resources");
            }
        }

        private class WeakPair
        extends WeakReference
        implements Runnable {
            private Object value;

            public WeakPair(Object key, Object value) {
                super(key, Utilities.activeReferenceQueue());
                this.value = value;
            }

            public Object getKey() {
                return this.get();
            }

            public Object getValue() {
                return this.value;
            }

            public void run() {
                ClassPathMap.this.cleanUp(this);
            }
        }
    }

    private class SFBQListener
    implements ChangeListener,
    PropertyChangeListener {
        private final WeakReference cp;
        private Map results;

        public SFBQListener(ClassPath cp) {
            this.cp = new WeakReference<ClassPath>(cp);
            cp.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void propertyChange(PropertyChangeEvent event) {
        }

        public SourceForBinaryQuery.Result getResult(URL url) {
            SourceForBinaryQuery.Result result;
            Reference ref;
            if (this.results == null) {
                this.results = new HashMap();
            }
            if ((ref = (Reference)this.results.get(url)) == null || (result = (SourceForBinaryQuery.Result)ref.get()) == null) {
                result = SourceForBinaryQuery.findSourceRoots((URL)url);
                this.results.put(url, new WeakReference<SourceForBinaryQuery.Result>(result));
                result.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)result));
            }
            return result;
        }

        public void stateChanged(ChangeEvent e) {
            ClassPath classPath = (ClassPath)this.cp.get();
            if (classPath != null) {
                MergedClassPathImplementation.this.updateEntries(classPath);
            }
        }
    }
}

