/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.filter;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.modules.tasklist.core.filter.AppliedFilterCondition;
import org.netbeans.modules.tasklist.core.filter.Filter;
import org.netbeans.modules.tasklist.core.filter.FilterCondition;
import org.netbeans.modules.tasklist.core.filter.SuggestionProperties;
import org.netbeans.modules.tasklist.core.filter.SuggestionProperty;
import org.netbeans.spi.settings.DOMConvertor;
import org.netbeans.spi.settings.Saver;
import org.openide.ErrorManager;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class FilterConvertor
extends DOMConvertor
implements PropertyChangeListener {
    private static final String ATTR_ALLTRUE = "allTrue";
    private static final String ELEM_FILTER = "Filter";
    private static final String ELEM_CONDITION = "Condition";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_PROPID = "propertyId";
    private Saver saver;

    protected FilterConvertor(String rootElement) {
        this("-//NetBeans org.netbeans.modules.tasklist//DTD " + rootElement + " 1.0//EN", "http://tasklist.netbeans.org/dtd/filter-1_0.dtd", rootElement);
    }

    protected FilterConvertor(String publicID, String systemID, String root) {
        super(publicID, systemID, root);
    }

    protected abstract Filter createFilter();

    protected SuggestionProperty getProperty(String propid) {
        return SuggestionProperties.getProperty(propid);
    }

    protected Object readElement(Element element) throws IOException, ClassNotFoundException {
        Filter f = this.createFilter();
        this.readFilter(element, f);
        return f;
    }

    protected void readFilter(Element element, Filter filter) throws IOException, ClassNotFoundException {
        filter.setMatchAll(Boolean.valueOf(element.getAttribute(ATTR_ALLTRUE)));
        filter.setName(element.getAttribute(ATTR_NAME));
        LinkedList<AppliedFilterCondition> conditions = new LinkedList<AppliedFilterCondition>();
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            FilterCondition fc = (FilterCondition)FilterConvertor.delegateRead((Element)((Element)child));
            String propid = ((Element)child).getAttribute(ATTR_PROPID);
            AppliedFilterCondition afc = new AppliedFilterCondition(this.getProperty(propid), fc);
            conditions.add(afc);
        }
        filter.setConditions(conditions);
    }

    protected void writeElement(Document document, Element element, Object obj) throws IOException, DOMException {
        Filter filter = (Filter)obj;
        this.writeFilter(document, element, filter);
    }

    protected void writeFilter(Document document, Element element, Filter filter) throws IOException, DOMException {
        element.setAttribute(ATTR_ALLTRUE, Boolean.toString(filter.matchAll()));
        element.setAttribute(ATTR_NAME, filter.getName());
        Iterator it = filter.getConditions().iterator();
        while (it.hasNext()) {
            AppliedFilterCondition afc = (AppliedFilterCondition)it.next();
            Element e = FilterConvertor.delegateWrite((Document)document, (Object)afc.getCondition());
            e.setAttribute(ATTR_PROPID, afc.getProperty().getID());
            element.appendChild(e);
        }
    }

    public void registerSaver(Object obj, Saver saver) {
        this.saver = saver;
        ((Filter)obj).addPropertyChangeListener(this);
    }

    public void unregisterSaver(Object obj, Saver saver) {
        if (saver == null || saver != this.saver) {
            ErrorManager.getDefault().notify(65536, (Throwable)new IllegalArgumentException("Wrong argument for unregisterSaver(Object=" + obj + ", Saver=" + saver + ")"));
        }
        ((Filter)obj).removePropertyChangeListener(this);
        this.saver = null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        try {
            this.saver.requestSave();
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }
}

