/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.export;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.netbeans.modules.tasklist.core.util.SimpleWizardPanel;
import org.openide.util.NbBundle;

public class OpenFilePanel
extends JPanel {
    private SimpleWizardPanel panel;
    private JFileChooser jFileChooser;

    public OpenFilePanel() {
        this.initComponents();
    }

    public void setWizardPanel(SimpleWizardPanel panel) {
        this.panel = panel;
    }

    private void initComponents() {
        this.jFileChooser = new JFileChooser();
        this.setLayout(new BorderLayout());
        this.setName(NbBundle.getBundle((Class)OpenFilePanel.class).getString("ChooseSource"));
        this.jFileChooser.setControlButtonsAreShown(false);
        this.jFileChooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                OpenFilePanel.this.jFileChooserPropertyChange(evt);
            }
        });
        this.add((Component)this.jFileChooser, "Center");
    }

    private void jFileChooserPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "SelectedFileChangedProperty") {
            this.check();
        }
    }

    public JFileChooser getFileChooser() {
        return this.jFileChooser;
    }

    public void setFile(File f) {
        this.jFileChooser.setSelectedFile(f);
        this.check();
    }

    public File getFile() {
        return this.jFileChooser.getSelectedFile();
    }

    private void check() {
        File f = this.jFileChooser.getSelectedFile();
        if (f == null) {
            this.panel.setErrorMessage(NbBundle.getMessage((Class)OpenFilePanel.class, (String)"EmptyFileName2"));
            return;
        }
        try {
            System.getSecurityManager().checkRead(f.getAbsolutePath());
            this.panel.setErrorMessage(null);
        }
        catch (SecurityException e) {
            this.panel.setErrorMessage(e.getLocalizedMessage());
        }
    }
}

