/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.editors;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;
import java.util.Date;
import javax.swing.JLabel;
import org.openide.ErrorManager;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public final class LineNumberPropertyEditor
extends PropertyEditorSupport {
    private static final JLabel LABEL = new JLabel();

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        if (box.width <= 3) {
            return;
        }
        gfx.translate(box.x, box.y);
        LABEL.setText(this.getAsText());
        LABEL.setSize(box.width - 3, box.height);
        LABEL.setForeground(gfx.getColor());
        LABEL.paint(gfx);
        gfx.translate(-box.x, -box.y);
    }

    public void setAsText(String text) throws IllegalArgumentException {
        try {
            if (text.trim().length() == 0) {
                this.setValue(new Integer(0));
            } else {
                this.setValue(new Integer(Integer.parseInt(text)));
            }
        }
        catch (NumberFormatException nfe) {
            String msg = NbBundle.getMessage((Class)LineNumberPropertyEditor.class, (String)"IllegalLineNumber", (Object[])new Object[]{text});
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 256, msg, msg, (Throwable)nfe, new Date());
            throw iae;
        }
    }

    public String getAsText() {
        int n;
        Object v = this.getValue();
        String s = v instanceof Line ? String.valueOf(((Line)v).getLineNumber() + 1) : (v instanceof Integer ? ((n = ((Integer)v).intValue()) <= 0 ? "" : String.valueOf(n)) : "");
        return s;
    }

    static {
        LABEL.setHorizontalAlignment(4);
    }
}

