/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.tasklist.core.ExpandAllAction;
import org.netbeans.modules.tasklist.core.FilterTaskNode;
import org.netbeans.modules.tasklist.core.SuggestionNodeProperty;
import org.netbeans.modules.tasklist.core.TLUtils;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskChildren;
import org.netbeans.modules.tasklist.core.TaskListener;
import org.netbeans.modules.tasklist.core.TaskProperties;
import org.netbeans.modules.tasklist.core.TaskTransfer;
import org.netbeans.modules.tasklist.core.filter.FilterAction;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.loaders.InstanceSupport;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;

public class TaskNode
extends AbstractNode {
    private static final Logger LOGGER = TLUtils.getLogger(TaskNode.class);
    protected final Task item;
    private Monitor monitor;

    public TaskNode(Task item, Children children) {
        super(children);
        this.item = item;
        this.init();
    }

    public TaskNode(Task item) {
        this(item, Children.LEAF);
    }

    public Node.Cookie getCookie(Class type) {
        if (type == Task.class) {
            return this.item;
        }
        return super.getCookie(type);
    }

    private void init() {
        this.setName(this.item.getSummary());
        this.monitor = new Monitor();
        this.item.addTaskListener(this.monitor);
        this.item.addPropertyChangeListener(this.monitor);
        DisposalListener dl = new DisposalListener();
        this.addNodeListener((NodeListener)dl);
        this.updateDisplayStuff();
        this.getCookieSet().add((Node.Cookie)new InstanceSupport.Instance((Object)this.item));
    }

    public TaskChildren getTaskChildren() {
        return (TaskChildren)this.getChildren();
    }

    public Node cloneNode() {
        TaskNode clon = new TaskNode(this.item);
        if (!clon.isLeaf()) {
            clon.setChildren((Children)((TaskChildren)((Object)this.getTaskChildren().clone())));
        }
        return clon;
    }

    protected TaskChildren createChildren() {
        return new TaskChildren(this.item);
    }

    protected final void updateDisplayStuff() {
        this.setDisplayName(this.item.getSummary());
        this.updateIcon();
    }

    protected void updateIcon() {
        this.setIconBase(this.item.getAction() != null ? "org/netbeans/modules/tasklist/core/lightbulb" : "org/netbeans/modules/tasklist/core/task");
    }

    public Image getIcon(int type) {
        if (this.item.getIcon() != null) {
            return this.item.getIcon();
        }
        return super.getIcon(type);
    }

    public Image getOpenedIcon(int type) {
        if (this.item.getIcon() != null) {
            return this.item.getIcon();
        }
        return super.getOpenedIcon(type);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(TaskNode.class);
    }

    protected SystemAction[] createActions() {
        return new SystemAction[]{null, SystemAction.get((Class)FilterAction.class), null, SystemAction.get((Class)ExpandAllAction.class), null, SystemAction.get((Class)CutAction.class), SystemAction.get((Class)CopyAction.class), SystemAction.get((Class)PasteAction.class), null, SystemAction.get((Class)DeleteAction.class), null, SystemAction.get((Class)PropertiesAction.class)};
    }

    public void destroy() throws IOException {
        this.item.removePropertyChangeListener(this.monitor);
        this.item.removeTaskListener(this.monitor);
        Enumeration en = this.getChildren().nodes();
        while (en.hasMoreElements()) {
            Node next = (Node)en.nextElement();
            next.destroy();
        }
        super.destroy();
    }

    public boolean canDestroy() {
        return true;
    }

    protected Sheet createSheet() {
        Sheet s = Sheet.createDefault();
        Sheet.Set ss = s.get("properties");
        ss.put((Node.Property)new SuggestionNodeProperty(this.item, TaskProperties.PROP_SUMMARY));
        return s;
    }

    public boolean canRename() {
        return true;
    }

    public void setName(String nue) {
        super.setName(nue);
        if (!nue.equals(this.item.getSummary())) {
            this.item.setSummary(nue);
        }
    }

    protected void createPasteTypes(Transferable t, List s) {
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return true;
    }

    public Transferable clipboardCopy() throws IOException {
        LOGGER.fine("entering");
        return new ExTransferable.Single(TaskTransfer.TODO_FLAVOR){

            protected Object getData() {
                return TaskNode.this.item.clone();
            }
        };
    }

    public Transferable clipboardCut() throws IOException {
        this.destroy();
        return this.clipboardCopy();
    }

    public static Node find(Node root, Task target) {
        Task item = TaskNode.getTask(root);
        if (item == target) {
            return root;
        }
        LinkedList<Task> ancestry = new LinkedList<Task>();
        for (Task p = target; p != null && p != item; p = p.getParent()) {
            ancestry.addFirst(p);
        }
        Node n = root;
        ListIterator it = ancestry.listIterator();
        while (it.hasNext()) {
            Task parent = (Task)it.next();
            Children c = n.getChildren();
            Node[] nc = c.getNodes();
            for (int i = 0; i < nc.length && TaskNode.getTask(n = nc[i]) != parent; ++i) {
            }
        }
        if (TaskNode.getTask(n) == target) {
            return n;
        }
        return null;
    }

    public static Task getTask(Node n) {
        if (n == null) {
            return null;
        }
        return (Task)n.getCookie(Task.class);
    }

    public static TaskNode getTaskNode(Node n) {
        if (n == null) {
            return null;
        }
        if (n instanceof TaskNode) {
            return (TaskNode)n;
        }
        if (n instanceof FilterTaskNode && (n = ((FilterTaskNode)n).getOriginal()) instanceof TaskNode) {
            return (TaskNode)n;
        }
        return null;
    }

    static {
        LOGGER.setLevel(Level.FINE);
    }

    private class Monitor
    implements TaskListener,
    PropertyChangeListener {
        static final /* synthetic */ boolean $assertionsDisabled;

        public void selectedTask(Task t) {
        }

        public void warpedTask(Task t) {
        }

        public void addedTask(Task t) {
            Children c;
            if (t.getParent().getKey() == TaskNode.this.item.getKey() && (c = TaskNode.this.getChildren()) == Children.LEAF) {
                if (!$assertionsDisabled && !TaskNode.this.item.hasSubtasks()) {
                    throw new AssertionError();
                }
                TaskNode.this.setChildren((Children)TaskNode.this.createChildren());
            }
        }

        public void removedTask(Task pt, Task t, int index) {
        }

        public void structureChanged(Task t) {
            Children c;
            if (t == null) {
                return;
            }
            if (t.getKey() == TaskNode.this.item.getKey() && (c = TaskNode.this.getChildren()) == Children.LEAF && TaskNode.this.item.hasSubtasks()) {
                TaskNode.this.setChildren((Children)TaskNode.this.createChildren());
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            TaskNode.this.updateDisplayStuff();
            TaskNode.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$tasklist$core$TaskNode == null ? (class$org$netbeans$modules$tasklist$core$TaskNode = TaskNode.class$("org.netbeans.modules.tasklist.core.TaskNode")) : class$org$netbeans$modules$tasklist$core$TaskNode).desiredAssertionStatus();
        }
    }

    private class DisposalListener
    extends NodeAdapter {
        public void nodeDestroyed(NodeEvent ev) {
            if (ev.getNode() == TaskNode.this) {
                TaskNode.this.item.removeTaskListener(TaskNode.this.monitor);
                TaskNode.this.item.removePropertyChangeListener(TaskNode.this.monitor);
            }
        }
    }
}

