/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;
import org.netbeans.modules.tasklist.core.ColumnProperty;
import org.netbeans.modules.tasklist.core.FilterTaskNode;
import org.netbeans.modules.tasklist.core.FilteredTaskChildren;
import org.netbeans.modules.tasklist.core.MyTreeTableView;
import org.netbeans.modules.tasklist.core.ObservableList;
import org.netbeans.modules.tasklist.core.TLUtils;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskAnnotation;
import org.netbeans.modules.tasklist.core.TaskEditorListener;
import org.netbeans.modules.tasklist.core.TaskList;
import org.netbeans.modules.tasklist.core.TaskListener;
import org.netbeans.modules.tasklist.core.TaskNode;
import org.netbeans.modules.tasklist.core.TaskSelector;
import org.netbeans.modules.tasklist.core.TaskViewListener;
import org.netbeans.modules.tasklist.core.columns.ColumnsConfiguration;
import org.netbeans.modules.tasklist.core.filter.Filter;
import org.netbeans.modules.tasklist.core.filter.FilterAction;
import org.netbeans.modules.tasklist.core.filter.FilterRepository;
import org.netbeans.modules.tasklist.core.filter.FilteredTopComponent;
import org.netbeans.modules.tasklist.core.filter.RemoveFilterAction;
import org.openide.ErrorManager;
import org.openide.actions.FindAction;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.InstanceCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.Visualizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public abstract class TaskListView
extends TopComponent
implements TaskListener,
ExplorerManager.Provider,
TaskSelector,
FilteredTopComponent {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER;
    private static transient Map views;
    private static int TOOLBAR_HEIGHT_ADJUSTMENT;
    private static int toolbarHeight;
    public static final String DEFAULT_FILTER_NAME;
    public static final String PROP_TASK_SUMMARY = "taskDesc";
    private static Map defColumns;
    protected transient Node rootNode = null;
    protected transient MyTreeTableView treeTable;
    protected transient ColumnProperty[] columns = null;
    private transient boolean initialized = false;
    protected transient String category = null;
    protected transient ObservableList tasklist = null;
    protected transient FilterRepository filters = null;
    protected transient Filter activeFilter = null;
    protected transient TaskAnnotation taskMarker = null;
    private transient Component centerCmp;
    private transient JPanel centerPanel;
    private transient Component northCmp;
    private transient boolean northCmpCreated;
    private transient JLabel miniStatus;
    private transient ExplorerManager manager;
    protected boolean persistent = false;
    private TaskEditorListener annotationManager = TaskEditorListener.getDefault();
    private Task unshowItem = null;
    private List listeningViews = null;
    private boolean lookupAttempted = false;
    private boolean wrapWarned = false;
    private TreeNode nextCandidate;
    private TreeNode prevCandidate;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void registerTaskListView(TaskListView view) {
        Class clazz = TaskListView.class;
        synchronized (clazz) {
            if (views == null) {
                views = new HashMap();
            }
            views.put(view.category, new WeakReference<TaskListView>(view));
        }
    }

    public static TaskListView getTaskListView(String category) {
        if (!$assertionsDisabled && category == null) {
            throw new AssertionError();
        }
        if (views == null) {
            return null;
        }
        Reference ref = (Reference)views.get(category);
        if (ref == null) {
            return null;
        }
        return (TaskListView)ref.get();
    }

    public TaskListView() {
        this.init_();
    }

    protected TaskListView(String category, String title, Image icon, boolean persistent, ObservableList tasklist) {
        this.init_();
        if (!$assertionsDisabled && category == null) {
            throw new AssertionError((Object)"category == null");
        }
        this.category = category;
        this.setName(title);
        this.persistent = persistent;
        this.setIcon(icon);
        TaskListView.registerTaskListView(this);
        this.setModel(tasklist);
    }

    private void init_() {
        this.manager = new ExplorerManager();
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.manager));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.manager, (boolean)true));
        map.put("jumpNext", new PrevNextAction(false));
        map.put("jumpPrev", new PrevNextAction(true));
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)map));
    }

    public int getPersistenceType() {
        if (this.persistent) {
            return 1;
        }
        return 2;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void updateFilterCount() {
        JLabel filterLabel = this.getMiniStatus();
        if (this.getFilter() == null) {
            filterLabel.setText("");
        } else {
            int all = TLUtils.getChildrenCountRecursively(this.rootNode);
            int shown = TLUtils.getChildrenCountRecursively(this.getExplorerManager().getExploredContext());
            filterLabel.setText(NbBundle.getMessage((Class)TaskListView.class, (String)"FilterCount", (Object)new Integer(shown), (Object)new Integer(all)));
        }
    }

    protected void setNorthComponentVisible(boolean v) {
        if (v) {
            Component cmp = this.getNorthComponent();
            if (cmp != null) {
                this.centerPanel.add(cmp, "North");
                this.centerPanel.validate();
            }
        } else if (this.northCmp != null && this.northCmp.getParent() != null) {
            this.northCmp.getParent().remove(this.northCmp);
        }
    }

    public boolean isNorthComponentVisible() {
        return this.northCmp != null && this.northCmp.getParent() != null;
    }

    protected Component getNorthComponent() {
        if (!this.northCmpCreated) {
            this.northCmp = this.createNorthComponent();
            this.northCmpCreated = true;
        }
        return this.northCmp;
    }

    protected Component createNorthComponent() {
        return new JLabel("");
    }

    protected JLabel getMiniStatus() {
        if (this.miniStatus == null) {
            this.miniStatus = this.createMiniStatus();
        }
        return this.miniStatus;
    }

    private JLabel createMiniStatus() {
        JLabel ret = new JLabel();
        Dimension dim = ret.getPreferredSize();
        dim.height = TaskListView.getToolbarHeight();
        ret.setPreferredSize(dim);
        return ret;
    }

    protected final void setMiniStatus(String text) {
        this.getMiniStatus().setText(text);
    }

    public static int getToolbarHeight() {
        if (toolbarHeight == -1) {
            BufferedImage image = new BufferedImage(1, 1, 10);
            Graphics2D g = image.createGraphics();
            UIDefaults def = UIManager.getLookAndFeelDefaults();
            int height = 0;
            String[] fonts = new String[]{"Label.font", "Button.font", "ToggleButton.font"};
            for (int i = 0; i < fonts.length; ++i) {
                Font f = def.getFont(fonts[i]);
                FontMetrics fm = g.getFontMetrics(f);
                height = Math.max(height, fm.getHeight());
            }
            toolbarHeight = height + TOOLBAR_HEIGHT_ADJUSTMENT;
        }
        return toolbarHeight;
    }

    public void showTaskInEditor(Task item, TaskAnnotation annotation) {
        if (annotation == null) {
            annotation = this.getAnnotation(item);
        }
        this.annotationManager.showTask(item, annotation);
    }

    public void hideTaskInEditor() {
        this.annotationManager.hideTask();
    }

    protected SystemAction[] getToolBarActions() {
        return null;
    }

    protected SystemAction[] getGlobalToolBarActions() {
        return null;
    }

    public TableColumnModel getColumnModel() {
        return this.treeTable.getHeaderModel();
    }

    public final ColumnProperty[] getColumns() {
        if (this.columns == null) {
            this.columns = this.createColumns();
        }
        return this.columns;
    }

    protected ColumnsConfiguration getDefaultColumns() {
        ColumnsConfiguration cc = (ColumnsConfiguration)defColumns.get(this.category);
        if (cc != null) {
            return cc;
        }
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject fo = fs.findResource("TaskList/" + this.category + "/columns.settings");
        if (!$assertionsDisabled && fo == null) {
            throw new AssertionError((Object)("Missing config TaskList/" + this.category + "/columns.settings"));
        }
        try {
            DataObject dobj = DataObject.find((FileObject)fo);
            InstanceCookie ic = (InstanceCookie)dobj.getCookie(InstanceCookie.class);
            cc = (ColumnsConfiguration)ic.instanceCreate();
        }
        catch (ClassNotFoundException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        catch (DataObjectNotFoundException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return cc;
    }

    protected void loadFilters() {
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject fo = fs.findResource("TaskList/" + this.category + "/filters.settings");
        if (!$assertionsDisabled && fo == null) {
            throw new AssertionError((Object)("Missing config TaskList/" + this.category + "/filters.settings"));
        }
        try {
            DataObject dobj = DataObject.find((FileObject)fo);
            InstanceCookie ic = (InstanceCookie)dobj.getCookie(InstanceCookie.class);
            this.filters = (FilterRepository)ic.instanceCreate();
            this.filters.setActive(null);
            if (this.filters.size() == 0) {
                Filter f = this.createFilter();
                f.setName(DEFAULT_FILTER_NAME);
                this.filters.add(f);
            }
        }
        catch (ClassNotFoundException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        catch (DataObjectNotFoundException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    protected void componentOpened() {
        JToolBar toolbar;
        LOGGER.fine("");
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        FindAction find = (FindAction)FindAction.get((Class)FindAction.class);
        FilterAction filter = (FilterAction)FilterAction.get((Class)FilterAction.class);
        this.getActionMap().put(find.getActionMapKey(), (Action)((Object)filter));
        this.setLayout(new BorderLayout());
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BorderLayout());
        this.centerCmp = this.createCenterComponent();
        this.centerPanel.add(this.centerCmp, "Center");
        this.add(this.centerPanel, "Center");
        this.loadColumnsConfiguration();
        JPanel toolbars = new JPanel();
        toolbars.setLayout(new FlowLayout(3, 0, 0));
        SystemAction[] actions = this.getGlobalToolBarActions();
        if (actions != null) {
            toolbar = SystemAction.createToolbarPresenter((SystemAction[])actions);
            toolbar.setFloatable(false);
            toolbar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            toolbar.setOrientation(1);
            toolbars.add(toolbar);
        }
        if ((actions = this.getToolBarActions()) != null) {
            toolbar = SystemAction.createToolbarPresenter((SystemAction[])actions);
            toolbar.setFloatable(false);
            toolbar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            toolbar.setOrientation(1);
            toolbars.add(toolbar);
        }
        this.add(toolbars, "West");
        this.setModel(this.tasklist);
    }

    protected Component createCenterComponent() {
        this.treeTable = new MyTreeTableView();
        if (this.columns == null) {
            this.columns = this.createColumns();
        }
        this.treeTable.setProperties((Node.Property[])this.columns);
        this.treeTable.setTreePreferredWidth(this.columns[0].getWidth());
        TableColumnModel tcm = this.treeTable.getHeaderModel();
        LOGGER.fine("number of columns " + tcm.getColumnCount());
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            TableColumn tc = tcm.getColumn(i);
            ColumnProperty cp = null;
            for (int j = 0; j < this.columns.length; ++j) {
                if (!this.columns[j].getDisplayName().equals(tc.getHeaderValue())) continue;
                cp = this.columns[j];
                break;
            }
            if (cp == null) continue;
            tc.setPreferredWidth(cp.width);
        }
        this.treeTable.getTable().getTableHeader().setReorderingAllowed(false);
        this.treeTable.setRootVisible(false);
        this.treeTable.setVerticalScrollBarPolicy(22);
        this.treeTable.setHorizontalScrollBarPolicy(30);
        return this.treeTable;
    }

    protected void componentClosed() {
        this.hideTaskInEditor();
        this.hideList();
        if (this.unshowItem != null) {
            this.removedTask(null, this.unshowItem, 0);
        }
        this.unregisterListeners();
        this.storeColumnsConfiguration();
    }

    protected void componentActivated() {
        super.componentActivated();
        if (!$assertionsDisabled && !this.initialized) {
            throw new AssertionError((Object)("#37438 dangling componentActivated event, no componentOpened() called at " + this));
        }
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)true);
        RemoveFilterAction removeFilter = (RemoveFilterAction)SystemAction.get((Class)RemoveFilterAction.class);
        removeFilter.enable();
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        if (!$assertionsDisabled && !this.initialized) {
            throw new AssertionError((Object)("#37438 dangling componentDeactivated event, no componentOpened() called at " + this));
        }
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
        this.storeColumnsConfiguration();
    }

    protected void storeColumnsConfiguration() {
        ColumnsConfiguration columns = this.getDefaultColumns();
        ColumnsConfiguration.loadColumnsFrom(this, columns);
    }

    protected void loadColumnsConfiguration() {
        ColumnsConfiguration cc = this.getDefaultColumns();
        ColumnsConfiguration.configureColumns(this, cc);
    }

    protected abstract Node createRootNode();

    protected void setModel(ObservableList list) {
        this.hideList();
        this.tasklist = list;
        if (list != null) {
            this.getModel().addTaskListener(this);
            this.setRoot();
        }
    }

    private void setRoot() {
        this.rootNode = this.createRootNode();
        this.rootNode.setDisplayName(this.getMainColumn(-1).getDisplayName());
        LOGGER.fine("root created " + this.rootNode);
        Node prevRoot = this.getExplorerManager().getRootContext();
        if (this.isFiltered()) {
            FilteredTaskChildren children = new FilteredTaskChildren(this, this.rootNode, this.getFilter());
            FilterTaskNode n = new FilterTaskNode(this.rootNode, (Children)children, false);
            this.getExplorerManager().setRootContext((Node)n);
        } else {
            this.getExplorerManager().setRootContext(this.rootNode);
        }
        try {
            if (prevRoot != null) {
                prevRoot.destroy();
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unexpected IOex in " + prevRoot);
        }
    }

    protected void hideList() {
        ObservableList prev = this.getModel();
        if (prev != null) {
            prev.removeTaskListener(this);
        }
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public HelpCtx getHelpCtx() {
        return TaskListView.getHelpCtx(this.getExplorerManager().getSelectedNodes(), this.getExplorerManager().getRootContext().getHelpCtx());
    }

    private static HelpCtx getHelpCtx(Node[] sel, HelpCtx def) {
        HelpCtx result = null;
        for (int i = 0; i < sel.length; ++i) {
            HelpCtx attempt = sel[i].getHelpCtx();
            if (attempt == null || attempt.equals((Object)HelpCtx.DEFAULT_HELP)) continue;
            if (result == null || result.equals((Object)attempt)) {
                result = attempt;
                continue;
            }
            result = null;
            break;
        }
        if (result != null) {
            return result;
        }
        return def;
    }

    public JTable getTable() {
        return this.treeTable.getTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int ver = objectInput.read();
        String selUID = (String)objectInput.readObject();
        if (ver == 4) {
            return;
        }
        int sortingColumn = objectInput.read();
        int sortAscendingInt = objectInput.read();
        int numVisible = objectInput.read();
        if (sortingColumn == 255) {
            sortingColumn = -1;
        }
        if (numVisible > 0) {
            int i;
            if (this.columns == null) {
                this.columns = this.createColumns();
            }
            int numColumns = this.columns.length;
            boolean[] columnVisible = new boolean[numColumns];
            for (i = 0; i < numColumns; ++i) {
                columnVisible[i] = false;
            }
            for (i = 0; i < numVisible; ++i) {
                int uid = objectInput.read();
                if (uid < numColumns && this.columns[uid].uid == uid) continue;
                for (int j = 0; j < numColumns && this.columns[j].uid != uid; ++j) {
                }
            }
        }
        if (ver >= 2) {
            this.category = (String)objectInput.readObject();
            objectInput.readObject();
            int persistentInt = objectInput.read();
            this.persistent = persistentInt != 0;
        } else {
            this.category = "usertasks";
        }
        Class clazz = TaskListView.class;
        synchronized (clazz) {
            if (views == null) {
                views = new HashMap();
            }
            views.put(this.category, new WeakReference<TaskListView>(this));
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (!this.persistent) {
            ErrorManager.getDefault().log(1, "Warning: This tasklist window (" + this.getName() + ") should not have been persisted!");
            return;
        }
        objectOutput.write(4);
        objectOutput.writeObject(null);
    }

    protected abstract ColumnProperty[] createColumns();

    protected ColumnProperty getMainColumn(int width) {
        return new ColumnProperty(0, PROP_TASK_SUMMARY, NbBundle.getMessage((Class)TaskListView.class, (String)"Description"), NbBundle.getMessage((Class)TaskListView.class, (String)"Description"), true, width);
    }

    public void select(final Task item) {
        if (!this.isShowing()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Node n = TaskNode.find(TaskListView.this.getExplorerManager().getRootContext(), item);
                Node[] sel = n == null ? new Node[]{} : new Node[]{n};
                try {
                    TaskListView.this.getExplorerManager().setSelectedNodes(sel);
                }
                catch (PropertyVetoException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
        });
    }

    public void expandAll() {
        if (this.treeTable != null) {
            this.treeTable.expandAll();
        }
    }

    public static TaskListView getCurrent() {
        TopComponent activated = WindowManager.getDefault().getRegistry().getActivated();
        if (activated instanceof TaskListView) {
            return (TaskListView)activated;
        }
        if (views == null) {
            return null;
        }
        Collection vs = views.values();
        Iterator it = vs.iterator();
        TaskListView first = null;
        while (it.hasNext()) {
            Reference ref = (Reference)it.next();
            TaskListView tlv = (TaskListView)ref.get();
            if (tlv == null) continue;
            if (tlv.isShowing()) {
                return tlv;
            }
            if (first != null) continue;
            first = tlv;
        }
        return first;
    }

    protected final List getListeningViews() {
        return this.listeningViews == null ? Collections.EMPTY_LIST : this.listeningViews;
    }

    void registerListeners() {
        Lookup.Template template;
        Lookup l = Lookup.getDefault();
        Iterator it = l.lookup(template = new Lookup.Template(TaskViewListener.class)).allInstances().iterator();
        if (it.hasNext()) {
            this.listeningViews = new ArrayList(4);
        }
        while (it.hasNext()) {
            TaskViewListener tl = (TaskViewListener)it.next();
            this.listeningViews.add(tl);
        }
    }

    private void unregisterListeners() {
        this.listeningViews = null;
    }

    public void showInMode() {
        Mode mode;
        if (!this.isOpened() && (mode = WindowManager.getDefault().findMode("output")) != null) {
            mode.dockInto((TopComponent)this);
        }
        this.open();
        this.requestVisible();
        this.requestActive();
    }

    public void selectedTask(Task item) {
        if (this.listeningViews != null) {
            this.unshowItem = item;
            int n = this.listeningViews.size();
            for (int i = 0; i < n; ++i) {
                TaskViewListener tl = (TaskViewListener)this.listeningViews.get(i);
                tl.showTask(item, this.getAnnotation(item));
            }
        }
    }

    public void warpedTask(Task item) {
        if (this.listeningViews != null) {
            this.unshowItem = item;
            int n = this.listeningViews.size();
            for (int i = 0; i < n; ++i) {
                TaskViewListener tl = (TaskViewListener)this.listeningViews.get(i);
                tl.showTask(item, null);
            }
        }
    }

    public void addedTask(Task t) {
    }

    public void removedTask(Task pt, Task task, int index) {
        if (task == this.unshowItem && this.listeningViews != null) {
            this.unshowItem = null;
            int n = this.listeningViews.size();
            for (int i = 0; i < n; ++i) {
                TaskViewListener tl = (TaskViewListener)this.listeningViews.get(i);
                tl.hideTask();
            }
        }
    }

    public void structureChanged(Task t) {
    }

    public TaskList getList() {
        ObservableList model = this.getModel();
        if (!$assertionsDisabled && !(model instanceof TaskList)) {
            throw new AssertionError((Object)("CCE " + model));
        }
        return (TaskList)model;
    }

    public ObservableList getModel() {
        return this.tasklist;
    }

    private synchronized Comparator getRowComparator(final Node.Property sortedByProperty, final boolean sortAscending, final boolean sortedByName, boolean noSorting) {
        Comparator rowComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 == o2) {
                    return -1;
                }
                Node n1 = (Node)o1;
                Node n2 = (Node)o2;
                if (sortedByProperty == null && !sortedByName) {
                    Node[] nodes = n1.getParentNode().getChildren().getNodes();
                    for (int i = 0; i < nodes.length; ++i) {
                        if (nodes[i].equals((Object)n1)) {
                            return -1;
                        }
                        if (!nodes[i].equals((Object)n2)) continue;
                        return 1;
                    }
                    return 0;
                }
                if (sortedByName) {
                    int res = n1.getDisplayName().compareTo(n2.getDisplayName());
                    return sortAscending ? res : -res;
                }
                Node.Property p1 = TaskListView.this.getNodeProperty(n1, sortedByProperty);
                Node.Property p2 = TaskListView.this.getNodeProperty(n2, sortedByProperty);
                if (p1 == null && p2 == null) {
                    return 0;
                }
                try {
                    int res;
                    if (p1 == null) {
                        res = -1;
                    } else if (p2 == null) {
                        res = 1;
                    } else {
                        Object v1 = p1.getValue();
                        Object v2 = p2.getValue();
                        if (v1 == null && v2 == null) {
                            return 0;
                        }
                        if (v1 == null) {
                            res = -1;
                        } else if (v2 == null) {
                            res = 1;
                        } else {
                            if (v1.getClass() != v2.getClass() || !(v1 instanceof Comparable)) {
                                v1 = v1.toString();
                                v2 = v2.toString();
                            }
                            res = ((Comparable)v1).compareTo(v2);
                        }
                    }
                    return sortAscending ? res : -res;
                }
                catch (Exception ex) {
                    return 0;
                }
            }
        };
        return rowComparator;
    }

    private Node.Property getNodeProperty(Node node, Node.Property prop) {
        Node.PropertySet[] propsets = node.getPropertySets();
        int n = propsets.length;
        for (int i = 0; i < n; ++i) {
            Node.Property[] props = propsets[i].getProperties();
            int m = props.length;
            for (int j = 0; j < m; ++j) {
                if (!props[j].equals((Object)prop)) continue;
                return props[j];
            }
        }
        return null;
    }

    public final Filter getFilter() {
        return this.activeFilter;
    }

    public FilterRepository getFilters() {
        if (this.filters == null) {
            this.loadFilters();
        }
        if (!$assertionsDisabled && this.filters == null) {
            throw new AssertionError((Object)"Missing FilterRepository");
        }
        return this.filters;
    }

    public abstract Filter createFilter();

    public final boolean isFiltered() {
        return this.getFilter() != null;
    }

    protected void setFiltered() {
        if (this.getFilter() != null) {
            ((RemoveFilterAction)SystemAction.get((Class)RemoveFilterAction.class)).enable();
        }
        try {
            this.getExplorerManager().setSelectedNodes(new Node[0]);
        }
        catch (PropertyVetoException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        this.setRoot();
        this.updateFilterCount();
    }

    public void setFilter(Filter filter) {
        if (filter == null || this.getFilters().contains(filter)) {
            this.getFilters().setActive(filter);
        }
        this.activeFilter = filter;
        this.setFiltered();
    }

    public List getSortedChildren(Node node, Node.Property sortedByProperty, boolean sortAscending, boolean sortedByName, boolean noSorting) {
        Node[] firstNodes = node.getChildren().getNodes();
        ArrayList<Node> nodes = new ArrayList<Node>(firstNodes.length);
        for (int i = 0; i < firstNodes.length; ++i) {
            nodes.add(firstNodes[i]);
        }
        Comparator comparator = this.getRowComparator(sortedByProperty, sortAscending, sortedByName, noSorting);
        Collections.sort(nodes, comparator);
        return nodes;
    }

    private static void invokeLater(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private TreeNode findNextVisitable(TreeNode last, boolean wrapAround) {
        TreeNode parent;
        TreeNode next = null;
        if (last.getChildCount() > 0) {
            next = last.getChildAt(0);
        } else {
            parent = last.getParent();
            if (parent == null) {
                if (parent.getChildCount() > 0) {
                    next = parent.getChildAt(0);
                }
            } else {
                int index = parent.getIndex(last);
                if (!$assertionsDisabled && index == -1) {
                    throw new AssertionError();
                }
                if (++index < last.getParent().getChildCount()) {
                    next = last.getParent().getChildAt(index);
                }
            }
        }
        if (next == null && wrapAround) {
            parent = last;
            while (parent.getParent() != null) {
                parent = parent.getParent();
            }
            if (parent.getChildCount() > 0) {
                next = parent.getChildAt(0);
            }
        }
        if (next == null) {
            return null;
        }
        if (TaskListView.isVisitable(next)) {
            return next;
        }
        return this.findNextVisitable(next, wrapAround);
    }

    private static boolean isVisitable(TreeNode node) {
        Node nextNode = Visualizer.findNode((Object)node);
        if (nextNode == null) {
            return false;
        }
        Task task = (Task)nextNode.getCookie(Task.class);
        return task != null && task.isVisitable();
    }

    private void selectNode(Node node) {
        if (node != null) {
            TaskAnnotation anno;
            Task nextTask = (Task)node.getCookie(Task.class);
            if (nextTask.getLine() != null && (anno = this.getAnnotation(nextTask)) != null) {
                this.showTaskInEditor(nextTask, anno);
            }
            this.select(nextTask);
        }
    }

    private static boolean isChildOf(TreeNode child, TreeNode root) {
        if (child == null) {
            return false;
        }
        if (child == root) {
            return true;
        }
        for (TreeNode parent = child.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != root) continue;
            return true;
        }
        return false;
    }

    private Node currentlySelected(boolean tail) {
        Node[] selected = this.getExplorerManager().getSelectedNodes();
        if (selected != null && selected.length != 0) {
            if (tail) {
                return selected[selected.length - 1];
            }
            return selected[0];
        }
        return null;
    }

    protected final void nextTask() {
        Node currentlySelected = this.currentlySelected(true);
        Node next = null;
        TreeNode nextVisitable = null;
        if (currentlySelected == null) {
            TreeNode root = Visualizer.findVisualizer((Node)this.getExplorerManager().getRootContext());
            if (TaskListView.isChildOf(this.nextCandidate, root)) {
                nextVisitable = TaskListView.isVisitable(this.nextCandidate) ? this.nextCandidate : this.findNextVisitable(this.nextCandidate, this.wrapWarned);
            } else {
                Node[] all = this.getExplorerManager().getRootContext().getChildren().getNodes();
                if (all != null && all.length > 0) {
                    nextVisitable = Visualizer.findVisualizer((Node)all[0]);
                }
            }
        } else {
            TreeNode curr;
            this.prevCandidate = curr = Visualizer.findVisualizer((Node)currentlySelected);
            nextVisitable = this.findNextVisitable(curr, this.wrapWarned);
        }
        if (nextVisitable != null) {
            this.nextCandidate = this.findNextVisitable(nextVisitable, false);
            next = Visualizer.findNode((Object)nextVisitable);
        } else {
            this.nextCandidate = null;
        }
        if (next == null && !this.wrapWarned) {
            String msg = NbBundle.getBundle((Class)TaskListView.class).getString("MSG_AtLastError");
            StatusDisplayer.getDefault().setStatusText(msg);
            Toolkit.getDefaultToolkit().beep();
            this.wrapWarned = true;
        } else {
            this.wrapWarned = false;
        }
        this.selectNode(next);
    }

    private TreeNode findPrevVisitable(TreeNode last, boolean wrapAround) {
        TreeNode prev;
        int index = last.getParent().getIndex(last);
        if (!$assertionsDisabled && index == -1) {
            throw new AssertionError();
        }
        if (--index >= 0) {
            prev = last.getParent().getChildAt(index);
        } else {
            prev = last.getParent();
            if (prev.getParent() == null) {
                prev = null;
            }
        }
        if (prev == null && wrapAround) {
            TreeNode parent = last;
            while (parent.getParent() != null) {
                parent = parent.getParent();
            }
            prev = parent;
            while (prev.getChildCount() > 0) {
                prev = prev.getChildAt(prev.getChildCount() - 1);
            }
        }
        if (prev == null) {
            return null;
        }
        if (TaskListView.isVisitable(prev)) {
            return prev;
        }
        return this.findPrevVisitable(prev, wrapAround);
    }

    protected final void prevTask() {
        Node currentlySelected = this.currentlySelected(false);
        Node prev = null;
        TreeNode prevVisitable = null;
        if (currentlySelected == null) {
            TreeNode root = Visualizer.findVisualizer((Node)this.getExplorerManager().getRootContext());
            if (TaskListView.isChildOf(this.prevCandidate, root)) {
                prevVisitable = TaskListView.isVisitable(this.prevCandidate) ? this.prevCandidate : this.findPrevVisitable(this.prevCandidate, this.wrapWarned);
            } else {
                Node[] all = this.getExplorerManager().getRootContext().getChildren().getNodes();
                if (all != null && all.length > 0) {
                    prevVisitable = Visualizer.findVisualizer((Node)all[all.length - 1]);
                }
            }
        } else {
            TreeNode curr;
            this.nextCandidate = curr = Visualizer.findVisualizer((Node)currentlySelected);
            prevVisitable = this.findPrevVisitable(curr, this.wrapWarned);
        }
        if (prevVisitable != null) {
            this.prevCandidate = this.findNextVisitable(prevVisitable, false);
            prev = Visualizer.findNode((Object)prevVisitable);
        } else {
            this.prevCandidate = null;
        }
        if (prev == null && !this.wrapWarned) {
            String msg = NbBundle.getBundle((Class)TaskListView.class).getString("MSG_AtFirstError");
            StatusDisplayer.getDefault().setStatusText(msg);
            Toolkit.getDefaultToolkit().beep();
            this.wrapWarned = true;
        } else {
            this.wrapWarned = false;
        }
        this.selectNode(prev);
    }

    protected TaskAnnotation getAnnotation(Task task) {
        return new TaskAnnotation(task, this);
    }

    protected void componentHidden() {
        this.hideTaskInEditor();
    }

    protected final boolean isExpanded(Node n) {
        return this.treeTable.isExpanded(n);
    }

    protected final void setExpanded(Node n, boolean expanded) {
        if (expanded) {
            this.treeTable.expandNode(n);
        } else {
            this.treeTable.collapseNode(n);
        }
    }

    public final Node getEffectiveRoot() {
        return this.getExplorerManager().getRootContext();
    }

    public void scheduleNodeExpansion(final Task target, final int hops) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Node n = TaskNode.find(TaskListView.this.getEffectiveRoot(), target);
                if (n != null) {
                    TaskListView.this.setExpanded(n, true);
                } else if (hops < 50) {
                    TaskListView.this.scheduleNodeExpansion(target, hops + 1);
                }
            }
        });
    }

    public void requestActive() {
        super.requestActive();
        if (this.treeTable != null) {
            this.treeTable.getTable().requestFocus();
        }
    }

    public final ColumnProperty[] getVisibleColumns() {
        TableColumnModel tcm = this.getTable().getColumnModel();
        ColumnProperty[] all = this.getColumns();
        ArrayList<ColumnProperty> ret = new ArrayList<ColumnProperty>();
        ret.add(all[0]);
        block0: for (int i = 0; i < tcm.getColumnCount(); ++i) {
            String title = tcm.getColumn(i).getHeaderValue().toString();
            for (int j = 1; j < all.length; ++j) {
                if (!title.equalsIgnoreCase(all[j].getDisplayName())) continue;
                ret.add(all[j]);
                continue block0;
            }
        }
        return ret.toArray(new ColumnProperty[ret.size()]);
    }

    static {
        $assertionsDisabled = !TaskListView.class.desiredAssertionStatus();
        LOGGER = TLUtils.getLogger(TaskListView.class);
        LOGGER.setLevel(Level.OFF);
        views = null;
        TOOLBAR_HEIGHT_ADJUSTMENT = 4;
        toolbarHeight = -1;
        DEFAULT_FILTER_NAME = NbBundle.getMessage((Class)TaskListView.class, (String)"default-filter-name");
        defColumns = new HashMap();
    }

    private final class PrevNextAction
    extends AbstractAction {
        private boolean prev;

        public PrevNextAction(boolean prev) {
            this.prev = prev;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.prev) {
                TaskListView.this.prevTask();
            } else {
                TaskListView.this.nextTask();
            }
        }
    }
}

