/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsdl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRef;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.core.ServiceInformation;
import org.netbeans.modules.websvc.wsdl.PortInformationHandler;
import org.netbeans.modules.websvc.wsdl.ServiceInformationImpl;
import org.netbeans.modules.websvc.wsdl.WsdlDataNode;
import org.netbeans.modules.websvc.wsdl.validator.ValidateXMLCookieImpl;
import org.netbeans.modules.websvc.wsdl.xmlutils.SAXParseError;
import org.netbeans.modules.websvc.wsdl.xmlutils.XMLJ2eeDataObject;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class WsdlDataObject
extends XMLJ2eeDataObject {
    private static final long serialVersionUID = 1871655333534008660L;
    public static final String WSDL_EXTENSION = "wsdl";
    public static final String WSCOMPILE_CONFIG_EXTENSION = "xml";
    private WeakReference portInformationHandlerRef = null;
    private boolean clientResolved;
    private boolean isClientWsdl;

    public WsdlDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException {
        super(pf, loader);
        this.init();
    }

    private void init() {
        ValidateXMLCookieImpl validateCookie = new ValidateXMLCookieImpl(this);
        this.getCookieSet().add((Node.Cookie)validateCookie);
    }

    public boolean isClientWsdl() {
        if (!this.clientResolved) {
            this.initClientWsdl();
            this.clientResolved = true;
        }
        return this.isClientWsdl;
    }

    private void initClientWsdl() {
        FileObject wsdlFolder;
        WebServicesClientSupport clientSupport;
        this.isClientWsdl = false;
        FileObject wsdlFO = this.getPrimaryFile();
        FileObject parentFO = wsdlFO.getParent();
        if (parentFO != null && (clientSupport = WebServicesClientSupport.getWebServicesClientSupport((FileObject)wsdlFO)) != null && (wsdlFolder = clientSupport.getWsdlFolder()) != null && wsdlFolder.equals(parentFO)) {
            FileObject mappingFile;
            this.isClientWsdl = true;
            FileObject ddFolder = wsdlFolder.getParent();
            if (ddFolder != null && (mappingFile = ddFolder.getFileObject(this.getName() + "-mapping", WSCOMPILE_CONFIG_EXTENSION)) != null) {
                this.isClientWsdl = false;
            }
        }
    }

    public boolean isRenameAllowed() {
        return !this.isClientWsdl();
    }

    public boolean isDeleteAllowed() {
        return true;
    }

    protected Node createNodeDelegate() {
        return new WsdlDataNode(this);
    }

    protected String getIconBaseForInvalidDocument() {
        return "org/netbeans/modules/websvc/wsdl/resources/wsdl_broken";
    }

    protected String getIconBaseForValidDocument() {
        return "org/netbeans/modules/websvc/wsdl/resources/wsdl16";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SAXParseError updateNode(InputSource is) throws IOException {
        PortInformationHandler handler = new PortInformationHandler();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(is, (DefaultHandler)handler);
            WsdlDataObject wsdlDataObject = this;
            synchronized (wsdlDataObject) {
                this.portInformationHandlerRef = new WeakReference<PortInformationHandler>(handler);
            }
        }
        catch (ParserConfigurationException ex) {
            handler = null;
            return new SAXParseError(new SAXParseException(ex.getMessage(), null, ex));
        }
        catch (SAXParseException ex) {
            handler = null;
            return new SAXParseError(ex);
        }
        catch (SAXException ex) {
            handler = null;
            return new SAXParseError(new SAXParseException(ex.getMessage(), null, ex));
        }
        catch (FileNotFoundException ex) {
            handler = null;
            return new SAXParseError(new SAXParseException(ex.getMessage(), null, ex));
        }
        catch (IOException ex) {
            handler = null;
            throw ex;
        }
        return null;
    }

    protected void handleDelete() throws IOException {
        if (this.isClientWsdl()) {
            FileObject configFO;
            WebServicesClientSupport clientSupport = null;
            clientSupport = WebServicesClientSupport.getWebServicesClientSupport((FileObject)this.getPrimaryFile());
            if (clientSupport == null) {
                String message = NbBundle.getMessage(WsdlDataObject.class, (String)"ERR_CannotFindServiceSupport", (Object)this.getName());
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)message, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                return;
            }
            String message = NbBundle.getMessage(WsdlDataObject.class, (String)"MSG_QueryRemoveServiceClient", (Object)this.getName());
            NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)message, 0, 3);
            if (!DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor).equals(NotifyDescriptor.YES_OPTION)) {
                return;
            }
            ServiceInformationImpl wsdlModel = new ServiceInformationImpl((DataObject)this);
            String[] serviceNames = wsdlModel.getServiceNames();
            if (serviceNames == null || serviceNames.length == 0) {
                message = NbBundle.getMessage(WsdlDataObject.class, (String)"ERR_CannotFindServiceName");
                descriptor = new NotifyDescriptor.Message((Object)message, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                return;
            }
            FileObject wsdlFileObject = this.getPrimaryFile();
            Project project = FileOwnerQuery.getOwner((FileObject)wsdlFileObject);
            J2eeModuleProvider j2eeMP = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            if (j2eeMP != null) {
                j2eeMP.getConfigSupport().ensureConfigurationReady();
                try {
                    boolean ddNeedsSave = false;
                    FileObject ddFO = clientSupport.getDeploymentDescriptor();
                    WebApp rootDD = DDProvider.getDefault().getDDRoot(ddFO);
                    if (rootDD instanceof WebApp) {
                        for (int i = 0; i < serviceNames.length; ++i) {
                            CommonDDBean bean = rootDD.findBeanByName("ServiceRef", "ServiceRefName", "service/" + serviceNames[i]);
                            if (!(bean instanceof ServiceRef)) continue;
                            WebApp webApp = rootDD;
                            webApp.removeServiceRef((ServiceRef)bean);
                            ddNeedsSave = true;
                        }
                    }
                    if (ddNeedsSave) {
                        rootDD.write(ddFO);
                    }
                }
                catch (VersionNotSupportedException ex) {
                    message = NbBundle.getMessage(WsdlDataObject.class, (String)"ERR_WrongJ2EEVersion");
                    descriptor = new NotifyDescriptor.Message((Object)message, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                    return;
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            clientSupport.removeServiceClient(wsdlFileObject.getName());
            FileObject parentFO = wsdlFileObject.getParent();
            if (parentFO != null && parentFO.isFolder() && (configFO = parentFO.getFileObject(wsdlFileObject.getName() + "-config", WSCOMPILE_CONFIG_EXTENSION)) != null) {
                configFO.delete();
            }
        }
        super.handleDelete();
    }

    public Node.Cookie getCookie(Class cls) {
        if (cls == ServiceInformation.class) {
            return new ServiceInformationImpl((DataObject)this);
        }
        return super.getCookie(cls);
    }
}

