/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.completion;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.java.JavaSyntaxSupport;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.netbeans.modules.websvc.editor.completion.Utils;
import org.openide.ErrorManager;

public class NNParser {
    private static final int INIT = 0;
    private static final int NN = 1;
    private static final int ERROR = 2;
    private static final int NNNAME = 3;
    private static final int INNN = 4;
    private static final int ATTRNAME = 5;
    private static final int EQ = 6;
    private static final int ATTRVALUE = 7;
    private JavaSyntaxSupport sup;

    public NNParser(BaseDocument bdoc) {
        SyntaxSupport ssup = bdoc.getSyntaxSupport();
        if (!(ssup instanceof JavaSyntaxSupport)) {
            throw new IllegalArgumentException("Only java files are supported!");
        }
        this.sup = (JavaSyntaxSupport)ssup;
    }

    public NN parseAnnotation(int offset) {
        int nnStart = this.findAnnotationStart(offset);
        if (nnStart == -1) {
            return null;
        }
        return this.parseAnnotationOnOffset(nnStart);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NN parseAnnotationOnOffset(int offset) {
        try {
            int parentCount = -1;
            int state = 0;
            TokenItem ti = this.sup.getTokenChain(offset, offset + 1);
            assert (ti.getTokenID() == JavaTokenContext.ANNOTATION);
            int nnstart = offset;
            int nnend = -1;
            String nnName = null;
            String currAttrName = null;
            String currAttrValue = null;
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            block34: do {
                int tid;
                if ((tid = ti.getTokenID().getNumericID()) == 5) {
                    ti = ti.getNext();
                    continue;
                }
                block1 : switch (state) {
                    case 0: {
                        switch (tid) {
                            case 123: {
                                state = 1;
                                break block1;
                            }
                        }
                        state = 2;
                        break;
                    }
                    case 1: {
                        switch (tid) {
                            case 6: {
                                state = 3;
                                nnName = ti.getImage();
                                break block1;
                            }
                        }
                        state = 2;
                        break;
                    }
                    case 3: {
                        switch (tid) {
                            case 53: {
                                state = 4;
                                break block1;
                            }
                        }
                        state = 2;
                        break;
                    }
                    case 4: {
                        switch (tid) {
                            case 6: {
                                currAttrName = ti.getImage();
                                state = 5;
                                break block1;
                            }
                        }
                        state = 2;
                        break;
                    }
                    case 5: {
                        switch (tid) {
                            case 17: {
                                state = 6;
                                break block1;
                            }
                        }
                        state = 2;
                        break;
                    }
                    case 6: {
                        switch (tid) {
                            case 10: {
                                state = 7;
                                currAttrValue = Utils.unquote(ti.getImage());
                                attrs.put(currAttrName, currAttrValue);
                                break;
                            }
                            case 123: {
                                NN nestedNN = this.parseAnnotationOnOffset(ti.getOffset());
                                attrs.put(currAttrName, nestedNN);
                                state = 7;
                                ti = this.sup.getTokenChain(nestedNN.getEndOffset(), nestedNN.getEndOffset() + 1);
                                continue block34;
                            }
                            default: {
                                state = 2;
                            }
                        }
                    }
                    case 7: {
                        switch (tid) {
                            case 49: {
                                state = 4;
                                break block1;
                            }
                            case 54: {
                                nnend = ti.getOffset() + ti.getImage().length();
                                return new NN(nnName, attrs, nnstart, nnend);
                            }
                        }
                    }
                }
                if (state == 2) break;
                ti = ti.getNext();
            } while (ti != null);
            if (nnName == null) return null;
            return new NN(nnName, attrs, nnstart, offset);
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify(16, (Throwable)e);
        }
        return null;
    }

    private int findAnnotationStart(int offset) {
        int parentCount = 0;
        try {
            for (TokenItem ti = this.sup.getTokenChain(offset - 1, offset); ti != null; ti = ti.getPrevious()) {
                if (ti.getTokenID() == JavaTokenContext.RPAREN) {
                    ++parentCount;
                    continue;
                }
                if (ti.getTokenID() == JavaTokenContext.LPAREN) {
                    --parentCount;
                    continue;
                }
                if (ti.getTokenID() != JavaTokenContext.ANNOTATION || parentCount != -1) continue;
                return ti.getOffset();
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify(16, (Throwable)e);
        }
        return -1;
    }

    public class NN {
        private String name;
        private Map attributes;
        private int startOffset;
        private int endOffset;

        public NN(String name, Map attributes, int startOffset, int endOffset) {
            this.name = name;
            this.attributes = attributes;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public String getName() {
            return this.name;
        }

        public Map getAttributes() {
            return this.attributes;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public String toString() {
            String text = "@" + this.getName() + " [" + this.getStartOffset() + " - " + this.getEndOffset() + "](";
            Iterator i = this.getAttributes().keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                Object value = this.getAttributes().get(key);
                text = text + key + "=" + value.toString() + (i.hasNext() ? "," : "");
            }
            text = text + ")";
            return text;
        }
    }
}

