/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.webservices.ui.panels;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.core.webservices.ui.WSHandlerDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class MessageHandlerPanel
extends JPanel {
    private Project project;
    private String[] handlerClasses;
    private boolean isJaxWS;
    private DefaultListModel listModel;
    private String componentName;
    private JButton addBtn;
    private JLabel classesLabel;
    private JScrollPane jScrollPane1;
    private JList messageHandlerList;
    private JButton removeBtn;

    public MessageHandlerPanel(Project project, String[] handlerClasses, boolean isJaxWS, String componentName) {
        this.project = project;
        this.handlerClasses = handlerClasses;
        this.isJaxWS = isJaxWS;
        this.componentName = componentName;
        this.initComponents();
        this.addBtn.addActionListener(new AddButtonActionListener());
        this.removeBtn.addActionListener(new RemoveButtonActionListener());
        this.listModel = new DefaultListModel();
        this.messageHandlerList.setModel(this.listModel);
        this.populateHandlers();
    }

    private void populateHandlers() {
        for (int i = 0; i < this.handlerClasses.length; ++i) {
            this.listModel.addElement(this.handlerClasses[i]);
        }
    }

    public DefaultListModel getListModel() {
        return this.listModel;
    }

    private int getSelectedRow() {
        ListSelectionModel lsm = this.messageHandlerList.getSelectionModel();
        if (lsm.isSelectionEmpty()) {
            return -1;
        }
        return lsm.getMinSelectionIndex();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.messageHandlerList = new JList();
        this.addBtn = new JButton();
        this.removeBtn = new JButton();
        this.classesLabel = new JLabel();
        this.messageHandlerList.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.messageHandlerList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.messageHandlerList);
        this.addBtn.setText(ResourceBundle.getBundle("org/netbeans/modules/websvc/core/webservices/ui/panels/Bundle").getString("Add_DotDotDot_label"));
        this.removeBtn.setText(ResourceBundle.getBundle("org/netbeans/modules/websvc/core/webservices/ui/panels/Bundle").getString("Remove_label"));
        this.classesLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/websvc/core/webservices/ui/panels/Bundle").getString("LBL_HANDLER_CLASSES"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(20, 20, 20).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.classesLabel).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1, -2, 271, -2).add(28, 28, 28).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.addBtn, -2, 112, -2).add((Component)this.removeBtn, -1, 112, Short.MAX_VALUE)))).addContainerGap(28, -2)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(101, 101, 101).add((Component)this.addBtn).add(28, 28, 28).add((Component)this.removeBtn)).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.classesLabel).addPreferredGap(0, 13, Short.MAX_VALUE).add((Component)this.jScrollPane1, -2, 269, -2))).addContainerGap()));
    }

    class HandlerListSelectionListener
    implements ListSelectionListener {
        HandlerListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
        }
    }

    class AddButtonActionListener
    implements ActionListener {
        DialogDescriptor dlgDesc = null;

        AddButtonActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            WSHandlerDialog wsHandlerDialog = new WSHandlerDialog(MessageHandlerPanel.this.project, MessageHandlerPanel.this.isJaxWS);
            wsHandlerDialog.show();
            if (wsHandlerDialog.okButtonPressed()) {
                Set<String> selectedClasses = wsHandlerDialog.getSelectedClasses();
                for (String selectedClass : selectedClasses) {
                    MessageHandlerPanel.this.listModel.addElement(selectedClass);
                }
            }
        }
    }

    class RemoveButtonActionListener
    implements ActionListener {
        RemoveButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int selectedRow = MessageHandlerPanel.this.getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            String className = (String)MessageHandlerPanel.this.listModel.getElementAt(selectedRow);
            if (this.confirmDeletion(className)) {
                MessageHandlerPanel.this.listModel.removeElementAt(selectedRow);
            }
        }

        private boolean confirmDeletion(String className) {
            NotifyDescriptor.Confirmation notifyDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(MessageHandlerPanel.class, (String)"MSG_CONFIRM_DELETE", (Object)className, (Object)MessageHandlerPanel.this.componentName), NbBundle.getMessage(MessageHandlerPanel.class, (String)"TTL_CONFIRM_DELETE"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDesc);
            return notifyDesc.getValue() == NotifyDescriptor.YES_OPTION;
        }
    }
}

