/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import java.awt.Dialog;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Binding;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelerFactory;
import org.netbeans.modules.websvc.core.jaxws.actions.JaxWsRefreshClientAction;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.BindingsHandler;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.BindingsHandlerChain;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.BindingsHandlerChains;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.BindingsHandlerClass;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.BindingsModel;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.BindingsModelFactory;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.DefinitionsBindings;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.GlobalBindings;
import org.netbeans.modules.websvc.core.jaxws.nodes.ClientHandlerButtonListener;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsClientChildren;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsNode;
import org.netbeans.modules.websvc.core.jaxws.nodes.RefreshClientDialog;
import org.netbeans.modules.websvc.core.webservices.action.ConfigureHandlerAction;
import org.netbeans.modules.websvc.core.webservices.action.ConfigureHandlerCookie;
import org.netbeans.modules.websvc.core.webservices.ui.panels.MessageHandlerPanel;
import org.netbeans.modules.websvc.core.wseditor.support.EditWSAttributesCookie;
import org.netbeans.modules.websvc.core.wseditor.support.EditWSAttributesCookieImpl;
import org.netbeans.modules.websvc.core.wseditor.support.WSEditAttributesAction;
import org.netbeans.modules.websvc.jaxws.api.JaxWsRefreshCookie;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.actions.OpenAction;
import org.openide.actions.OpenLocalExplorerAction;
import org.openide.actions.PropertiesAction;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class JaxWsClientNode
extends AbstractNode
implements OpenCookie,
JaxWsRefreshCookie,
ConfigureHandlerCookie {
    Client client;
    FileObject srcRoot;
    JaxWsModel jaxWsModel;
    InstanceContent content;
    private FileObject wsdlFileObject;
    boolean modelGenerationFinished;
    private static final Image WAITING_BADGE = org.openide.util.Utilities.loadImage((String)"org/netbeans/modules/websvc/core/webservices/ui/resources/waiting.png");
    private static final Image ERROR_BADGE = org.openide.util.Utilities.loadImage((String)"org/netbeans/modules/websvc/core/webservices/ui/resources/error-badge.gif");
    private static final Image SERVICE_BADGE = org.openide.util.Utilities.loadImage((String)"org/netbeans/modules/websvc/core/webservices/ui/resources/XMLServiceDataIcon.gif");

    public JaxWsClientNode(JaxWsModel jaxWsModel, Client client, FileObject srcRoot) {
        this(jaxWsModel, client, srcRoot, new InstanceContent());
    }

    private JaxWsClientNode(JaxWsModel jaxWsModel, Client client, FileObject srcRoot, InstanceContent content) {
        super((Children)new JaxWsClientChildren(client), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.jaxWsModel = jaxWsModel;
        this.client = client;
        this.srcRoot = srcRoot;
        this.content = content;
        this.setName(client.getName());
        this.setDisplayName(client.getName());
        content.add((Object)this);
        content.add((Object)client);
        content.add((Object)srcRoot);
        WsdlModeler modeler = this.getWsdlModeler();
        if (modeler != null) {
            this.changeIcon();
            modeler.generateWsdlModel(new WsdlModelListener(){

                public void modelCreated(WsdlModel model) {
                    JaxWsClientNode.this.modelGenerationFinished = true;
                    JaxWsClientNode.this.changeIcon();
                }
            });
        }
    }

    public String getShortDescription() {
        return this.client.getWsdlUrl();
    }

    public Image getIcon(int type) {
        if (((JaxWsClientChildren)this.getChildren()).getWsdlModel() != null) {
            return SERVICE_BADGE;
        }
        WsdlModeler wsdlModeler = this.getWsdlModeler();
        if (wsdlModeler != null && wsdlModeler.getCreationException() == null) {
            if (this.modelGenerationFinished) {
                return SERVICE_BADGE;
            }
            return org.openide.util.Utilities.mergeImages((Image)SERVICE_BADGE, (Image)WAITING_BADGE, (int)15, (int)8);
        }
        Image dirtyNodeImage = org.openide.util.Utilities.mergeImages((Image)SERVICE_BADGE, (Image)ERROR_BADGE, (int)6, (int)6);
        if (this.modelGenerationFinished) {
            return dirtyNodeImage;
        }
        return org.openide.util.Utilities.mergeImages((Image)dirtyNodeImage, (Image)WAITING_BADGE, (int)15, (int)8);
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public void open() {
        EditCookie ec = this.getEditCookie();
        if (ec != null) {
            ec.edit();
        }
    }

    void changeIcon() {
        this.fireIconChange();
    }

    public Node.Cookie getCookie(Class type) {
        if (type == EditWSAttributesCookie.class) {
            return new EditWSAttributesCookieImpl((Node)this, this.jaxWsModel);
        }
        return super.getCookie(type);
    }

    private EditCookie getEditCookie() {
        try {
            FileObject wsdlFo = JAXWSClientSupport.getJaxWsClientSupport((FileObject)this.srcRoot).getLocalWsdlFolderForClient(this.client.getName(), false).getFileObject(this.client.getLocalWsdlFile());
            assert (wsdlFo != null) : "Cannot find local WSDL file";
            if (wsdlFo != null) {
                DataObject dObj = DataObject.find((FileObject)wsdlFo);
                return (EditCookie)dObj.getCookie(EditCookie.class);
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().log(ex.getLocalizedMessage());
            return null;
        }
        return null;
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    public Action[] getActions(boolean context) {
        return new SystemAction[]{SystemAction.get(OpenAction.class), SystemAction.get(JaxWsRefreshClientAction.class), null, SystemAction.get(WSEditAttributesAction.class), null, SystemAction.get(ConfigureHandlerAction.class), null, SystemAction.get(DeleteAction.class), null, SystemAction.get(OpenLocalExplorerAction.class), null, SystemAction.get(PropertiesAction.class)};
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean canDestroy() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws IOException {
        String clientName = this.client.getName();
        NotifyDescriptor.Confirmation notifyDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(JaxWsClientNode.class, (String)"MSG_CONFIRM_DELETE", (Object)clientName));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDesc);
        if (notifyDesc.getValue() == NotifyDescriptor.YES_OPTION) {
            FileObject webInfClientFolder;
            JAXWSClientSupport support = JAXWSClientSupport.getJaxWsClientSupport((FileObject)this.srcRoot);
            FileObject localWsdlFolder = support.getLocalWsdlFolderForClient(clientName, false);
            if (localWsdlFolder != null) {
                FileObject clientArtifactsFolder = localWsdlFolder.getParent();
                FileLock lock = null;
                try {
                    lock = clientArtifactsFolder.lock();
                    clientArtifactsFolder.delete(lock);
                }
                finally {
                    if (lock != null) {
                        lock.releaseLock();
                    }
                }
            }
            Project project = FileOwnerQuery.getOwner((FileObject)this.srcRoot);
            if (this.client.getWsdlUrl().startsWith("file:") && project.getLookup().lookup(J2eeModuleProvider.class) != null && (webInfClientFolder = this.findWsdlFolderForClient(support, clientName)) != null) {
                FileObject webInfClientRootFolder = webInfClientFolder.getParent();
                FileLock lock = null;
                try {
                    lock = webInfClientFolder.lock();
                    webInfClientFolder.delete(lock);
                }
                finally {
                    if (lock != null) {
                        lock.releaseLock();
                    }
                }
                if (webInfClientRootFolder.getChildren().length == 0) {
                    try {
                        lock = webInfClientRootFolder.lock();
                        webInfClientRootFolder.delete(lock);
                    }
                    finally {
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
            }
            FileObject buildImplFo = project.getProjectDirectory().getFileObject("nbproject/build-impl.xml");
            try {
                ExecutorTask wsimportTask = ActionUtils.runTarget((FileObject)buildImplFo, (String[])new String[]{"wsimport-client-clean-" + clientName}, null);
                wsimportTask.waitFinished();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
            }
            catch (IllegalArgumentException ex) {
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
            }
            support.removeServiceClient(clientName);
            super.destroy();
        }
    }

    public void refreshService(boolean downloadWsdl) {
        if (downloadWsdl) {
            int result = RefreshClientDialog.open(this.client.getWsdlUrl());
            if (0 == result) {
                return;
            }
            if (2 == result) {
                this.removeWsdlFolderContents();
                ((JaxWsClientChildren)this.getChildren()).refreshKeys(true);
            } else {
                ((JaxWsClientChildren)this.getChildren()).refreshKeys(false);
            }
        } else {
            Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsClientNode.class, (String)"HINT_RefreshClient")));
            ((JaxWsClientChildren)this.getChildren()).refreshKeys(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeWsdlFolderContents() {
        FileObject wsdlFolder = this.getJAXWSClientSupport().getLocalWsdlFolderForClient(this.getName(), false);
        if (wsdlFolder != null) {
            FileLock lock = null;
            FileObject[] files = wsdlFolder.getChildren();
            for (int i = 0; i < files.length; ++i) {
                try {
                    FileObject file = files[i];
                    lock = file.lock();
                    file.delete(lock);
                    continue;
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                    continue;
                }
                finally {
                    if (lock != null) {
                        lock.releaseLock();
                        lock = null;
                    }
                }
            }
        }
    }

    public void configureHandler() {
        DefinitionsBindings db;
        GlobalBindings gb;
        Project project = FileOwnerQuery.getOwner((FileObject)this.srcRoot);
        ArrayList<String> handlerClasses = new ArrayList<String>();
        BindingsModel bindingsModel = this.getBindingsModel();
        if (bindingsModel != null && (gb = bindingsModel.getGlobalBindings()) != null && (db = gb.getDefinitionsBindings()) != null) {
            BindingsHandlerChains handlerChains = db.getHandlerChains();
            BindingsHandlerChain handlerChain = handlerChains.getHandlerChains().iterator().next();
            Collection<BindingsHandler> handlers = handlerChain.getHandlers();
            for (BindingsHandler handler : handlers) {
                BindingsHandlerClass handlerClass = handler.getHandlerClass();
                handlerClasses.add(handlerClass.getClassName());
            }
        }
        MessageHandlerPanel panel = new MessageHandlerPanel(project, handlerClasses.toArray(new String[handlerClasses.size()]), true, this.client.getName());
        String title = NbBundle.getMessage(JaxWsNode.class, (String)"TTL_MessageHandlerPanel");
        DialogDescriptor dialogDesc = new DialogDescriptor((Object)panel, title);
        dialogDesc.setButtonListener((ActionListener)new ClientHandlerButtonListener(panel, bindingsModel, this.client, (Node)this, this.jaxWsModel));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDesc);
        dialog.setVisible(true);
    }

    private BindingsModel getBindingsModel() {
        String handlerBindingFile = this.client.getHandlerBindingFile();
        BindingsModel bindingsModel = null;
        try {
            FileObject handlerBindingFO;
            JAXWSClientSupport support;
            FileObject bindingsFolder;
            if (handlerBindingFile != null && (bindingsFolder = (support = JAXWSClientSupport.getJaxWsClientSupport((FileObject)this.srcRoot)).getBindingsFolderForClient(this.getName(), false)) != null && (handlerBindingFO = bindingsFolder.getFileObject(handlerBindingFile)) != null) {
                ModelSource ms = Utilities.getModelSource((FileObject)handlerBindingFO, (boolean)true);
                bindingsModel = BindingsModelFactory.getDefault().getModel(ms);
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
        return bindingsModel;
    }

    WsdlModeler getWsdlModeler() {
        if (this.getLocalWsdl() != null) {
            try {
                WsdlModeler modeler = WsdlModelerFactory.getDefault().getWsdlModeler(this.wsdlFileObject.getURL());
                if (modeler != null) {
                    String packageName = this.client.getPackageName();
                    if (packageName != null && this.client.isPackageNameForceReplace()) {
                        modeler.setPackageName(packageName);
                    } else {
                        modeler.setPackageName(null);
                    }
                    modeler.setCatalog(this.getJAXWSClientSupport().getCatalog());
                    this.setBindings(modeler);
                    return modeler;
                }
            }
            catch (FileStateInvalidException ex) {
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
            }
        } else {
            ErrorManager.getDefault().log(65536, NbBundle.getMessage(JaxWsNode.class, (String)"ERR_missingLocalWsdl"));
        }
        return null;
    }

    FileObject getLocalWsdl() {
        FileObject localWsdlocalFolder;
        if (this.wsdlFileObject == null && (localWsdlocalFolder = this.getJAXWSClientSupport().getLocalWsdlFolderForClient(this.client.getName(), false)) != null) {
            this.wsdlFileObject = localWsdlocalFolder.getFileObject(this.client.getLocalWsdlFile());
        }
        return this.wsdlFileObject;
    }

    JAXWSClientSupport getJAXWSClientSupport() {
        return JAXWSClientSupport.getJaxWsClientSupport((FileObject)this.srcRoot);
    }

    private void setBindings(WsdlModeler wsdlModeler) {
        Binding[] extbindings = this.client.getBindings();
        if (extbindings == null || extbindings.length == 0) {
            wsdlModeler.setJAXBBindings(null);
            return;
        }
        String[] bindingFiles = new String[extbindings.length];
        for (int i = 0; i < extbindings.length; ++i) {
            bindingFiles[i] = extbindings[i].getFileName();
        }
        FileObject bindingsFolder = this.getJAXWSClientSupport().getBindingsFolderForClient(this.getName(), true);
        ArrayList<URL> list = new ArrayList<URL>();
        for (int i = 0; i < bindingFiles.length; ++i) {
            FileObject fo = bindingsFolder.getFileObject(bindingFiles[i]);
            try {
                list.add(fo.getURL());
                continue;
            }
            catch (FileStateInvalidException ex) {
                // empty catch block
            }
        }
        URL[] bindings = new URL[list.size()];
        list.toArray(bindings);
        wsdlModeler.setJAXBBindings(bindings);
    }

    void setModelGenerationFinished(boolean value) {
        this.modelGenerationFinished = value;
    }

    JaxWsModel getJaxWsModel() {
        return this.jaxWsModel;
    }

    private FileObject findWsdlFolderForClient(JAXWSClientSupport support, String name) throws IOException {
        FileObject globalWsdlFolder = support.getWsdlFolder(false);
        if (globalWsdlFolder != null) {
            return globalWsdlFolder.getFileObject("client/" + name);
        }
        return null;
    }
}

