/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKind;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.JMIGenerationUtil;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlParameter;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JaxWsUtils {
    private static int projectType;
    protected static final int JSE_PROJECT_TYPE = 0;
    protected static final int WEB_PROJECT_TYPE = 1;
    protected static final int EJB_PROJECT_TYPE = 2;
    private static boolean jwsdpSupported;
    private static boolean jsr109Supported;
    private static boolean wsitSupported;

    public static void generateJaxWsImplementationClass(Project project, FileObject targetFolder, String targetName, WsdlModel wsdlModel, Service service) throws Exception {
        WsdlService wsdlService = wsdlModel.getServiceByName(service.getServiceName());
        WsdlPort wsdlPort = null;
        if (wsdlService != null) {
            wsdlPort = wsdlService.getPortByName(service.getPortName());
        }
        if (wsdlService != null && wsdlPort != null) {
            String serviceID = service.getName();
            if (wsdlPort.isProvider()) {
                JaxWsUtils.generateProviderImplClass(project, targetFolder, targetName, wsdlService, wsdlPort, serviceID);
            } else {
                JaxWsUtils.generateJaxWsImplClass(project, targetFolder, targetName, null, wsdlService, wsdlPort, false, serviceID);
            }
        }
    }

    public static void generateJaxWsImplementationClass(Project project, FileObject targetFolder, String targetName, URL wsdlURL, WsdlService service, WsdlPort port) throws Exception {
        JaxWsUtils.generateJaxWsImplClass(project, targetFolder, targetName, wsdlURL, service, port, true, null);
    }

    public static void generateJaxWsArtifacts(Project project, FileObject targetFolder, String targetName, URL wsdlURL, String service, String port) throws Exception {
        JaxWsUtils.initProjectInfo(project);
        JAXWSSupport jaxWsSupport = JAXWSSupport.getJAXWSSupport((FileObject)project.getProjectDirectory());
        String artifactsPckg = "service." + targetName.toLowerCase();
        ClassPath classPath = ClassPath.getClassPath((FileObject)targetFolder, (String)"classpath/source");
        String serviceImplPath = classPath.getResourceName(targetFolder, '.', false);
        jaxWsSupport.addService(targetName, serviceImplPath + "." + targetName, wsdlURL.toExternalForm(), service, port, artifactsPckg, jsr109Supported && Util.isJavaEE5orHigher((Project)project));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateProviderImplClass(Project project, FileObject targetFolder, String targetName, WsdlService service, WsdlPort port, String serviceID) throws Exception {
        JaxWsUtils.initProjectInfo(project);
        JAXWSSupport jaxWsSupport = JAXWSSupport.getJAXWSSupport((FileObject)project.getProjectDirectory());
        String wsdlLocation = jaxWsSupport.getWsdlLocation(serviceID);
        JavaClass javaClass = null;
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            javaClass = JMIGenerationUtil.createClass((FileObject)targetFolder, (String)targetName);
            JMIUtils.addInterface((JavaClass)javaClass, (String)"javax.xml.ws.Provider<Source>");
            if (projectType == 2) {
                Annotation statelessAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.ejb.Stateless", (List)Collections.EMPTY_LIST);
                javaClass.getAnnotations().add(statelessAnnotation);
            }
            AttributeValue serviceModeValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"value", (String)"javax.xml.ws.Service.Mode", (String)"PAYLOAD");
            ArrayList<AttributeValue> attrList = new ArrayList<AttributeValue>();
            attrList.add(serviceModeValue);
            Annotation serviceModeAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.xml.ws.ServiceMode", attrList);
            javaClass.getAnnotations().add(serviceModeAnnotation);
            AttributeValue wsdlLocationValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"wsdlLocation", (String)wsdlLocation);
            AttributeValue serviceNameAttibuteValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"serviceName", (String)service.getName());
            AttributeValue targetNamespaceAttibuteValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"targetNamespace", (String)port.getNamespaceURI());
            AttributeValue portNameAttibuteValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"portName", (String)port.getName());
            attrList = new ArrayList();
            attrList.add(wsdlLocationValue);
            attrList.add(serviceNameAttibuteValue);
            attrList.add(targetNamespaceAttibuteValue);
            attrList.add(portNameAttibuteValue);
            Annotation serviceProviderAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.xml.ws.WebServiceProvider", attrList);
            javaClass.getAnnotations().add(serviceProviderAnnotation);
            String returnType = "javax.xml.transform.Source";
            String operationName = "invoke";
            Method op = JMIGenerationUtil.createMethod((Element)javaClass, (String)operationName, (int)1, (String)returnType);
            Parameter param = JMIGenerationUtil.createParameter((Element)javaClass, (String)"source", (String)returnType);
            op.getParameters().add(param);
            op.setBodyText("//TODO implement this method\nreturn null;");
            javaClass.getFeatures().add(op);
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
        FileObject fo = JavaModel.getFileObject((Resource)javaClass.getResource());
        DataObject dobj = DataObject.find((FileObject)fo);
        JaxWsUtils.openFileInEditor(dobj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateJaxWsImplClass(Project project, FileObject targetFolder, String targetName, URL wsdlURL, WsdlService service, WsdlPort port, boolean addService, String serviceID) throws Exception {
        JaxWsUtils.initProjectInfo(project);
        JavaClass javaClass = null;
        boolean rollback = true;
        JAXWSSupport jaxWsSupport = JAXWSSupport.getJAXWSSupport((FileObject)project.getProjectDirectory());
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            List operations;
            javaClass = JMIGenerationUtil.createClass((FileObject)targetFolder, (String)targetName);
            JMIUtils.addInterface((JavaClass)javaClass, (String)port.getJavaName());
            if (projectType == 2) {
                Annotation statelessAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.ejb.Stateless", (List)Collections.EMPTY_LIST);
                javaClass.getAnnotations().add(statelessAnnotation);
            }
            if ((operations = port.getOperations()) != null) {
                for (int i = 0; i < operations.size(); ++i) {
                    WsdlOperation operation = (WsdlOperation)operations.get(i);
                    List parameters = operation.getParameters();
                    String returnType = operation.getReturnTypeName();
                    List exceptions = operation.getExceptions();
                    Method op = JMIGenerationUtil.createMethod((Element)javaClass, (String)operation.getJavaName(), (int)1, (String)returnType);
                    JMIUtils.addExceptions((Method)op, (List)exceptions);
                    if (parameters != null) {
                        for (int j = 0; j < parameters.size(); ++j) {
                            WsdlParameter parameter = (WsdlParameter)parameters.get(j);
                            Parameter param = JMIGenerationUtil.createParameter((Element)javaClass, (String)parameter.getName(), (String)parameter.getTypeName());
                            op.getParameters().add(param);
                        }
                    }
                    Type type = JavaModel.getDefaultExtent().getType().resolve(returnType);
                    op.setBodyText(JaxWsUtils.createBody(type));
                    javaClass.getFeatures().add(op);
                }
            }
            rollback = false;
        }
        finally {
            JavaModel.getJavaRepository().endTrans(rollback);
        }
        FileObject fo = javaClass == null ? null : JavaModel.getFileObject((Resource)javaClass.getResource());
        ClassPath classPath = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        String serviceImplPath = classPath.getResourceName(fo, '.', false);
        String portJavaName = port.getJavaName();
        String artifactsPckg = portJavaName.substring(0, portJavaName.lastIndexOf("."));
        if (addService) {
            serviceID = jaxWsSupport.addService(targetName, serviceImplPath, wsdlURL.toString(), service.getName(), port.getName(), artifactsPckg, jsr109Supported && Util.isJavaEE5orHigher((Project)project));
        }
        String wsdlLocation = jaxWsSupport.getWsdlLocation(serviceID);
        rollback = true;
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            AttributeValue serviceNameAttibuteValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"serviceName", (String)service.getName());
            AttributeValue portNameAttibuteValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"portName", (String)port.getName());
            AttributeValue endPointInterfaceAttibuteValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"endpointInterface", (String)port.getJavaName());
            AttributeValue targetNamespaceAttibuteValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"targetNamespace", (String)port.getNamespaceURI());
            AttributeValue wsdlLocationAttibuteValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"wsdlLocation", (String)wsdlLocation);
            LinkedList<AttributeValue> attributes = new LinkedList<AttributeValue>();
            attributes.add(serviceNameAttibuteValue);
            attributes.add(portNameAttibuteValue);
            attributes.add(endPointInterfaceAttibuteValue);
            attributes.add(targetNamespaceAttibuteValue);
            attributes.add(wsdlLocationAttibuteValue);
            Annotation wsAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.jws.WebService", attributes);
            javaClass.getAnnotations().add(wsAnnotation);
            if (port.getSOAPVersion().equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
                AttributeValue bindingAttibuteValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"value", (String)"http://www.w3.org/2003/05/soap/bindings/HTTP/");
                attributes.clear();
                attributes.add(bindingAttibuteValue);
                Annotation bindingAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.xml.ws.BindingType", attributes);
                javaClass.getAnnotations().add(bindingAnnotation);
            }
            rollback = false;
        }
        finally {
            JavaModel.getJavaRepository().endTrans(rollback);
        }
        DataObject dobj = DataObject.find((FileObject)fo);
        JaxWsUtils.openFileInEditor(dobj);
    }

    private static void openFileInEditor(DataObject dobj) {
        final EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                ec.open();
            }
        }, 1000);
    }

    private static String createBody(Type type) {
        String initVal;
        if (type instanceof PrimitiveType) {
            PrimitiveTypeKind primitiveType = ((PrimitiveType)type).getKind();
            if (PrimitiveTypeKindEnum.BOOLEAN.equals((Object)primitiveType)) {
                initVal = "false";
            } else if (PrimitiveTypeKindEnum.CHAR.equals((Object)primitiveType)) {
                initVal = "'\\0'";
            } else {
                if (PrimitiveTypeKindEnum.VOID.equals((Object)primitiveType)) {
                    return "throw new UnsupportedOperationException(\"Not yet implemented\");";
                }
                initVal = "0";
            }
        } else if (type instanceof ClassDefinition) {
            initVal = "null";
        } else {
            throw new IllegalArgumentException("Type " + type.getClass());
        }
        return "return ".concat(initVal).concat(";");
    }

    private static void initProjectInfo(Project project) {
        J2eePlatform j2eePlatform;
        Map properties;
        String serverInstance;
        JAXWSSupport wss = JAXWSSupport.getJAXWSSupport((FileObject)project.getProjectDirectory());
        if (wss != null && (serverInstance = (String)(properties = wss.getAntProjectHelper().getStandardPropertyEvaluator().getProperties()).get("j2ee.server.instance")) != null && (j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstance)) != null) {
            jwsdpSupported = j2eePlatform.isToolSupported("jwsdp");
            jsr109Supported = j2eePlatform.isToolSupported("jsr109");
            wsitSupported = j2eePlatform.isToolSupported("wsit");
        }
        WebModule wm = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        EjbJar em = EjbJar.getEjbJar((FileObject)project.getProjectDirectory());
        projectType = em != null ? 2 : (wm != null ? 1 : 0);
    }

    public static boolean isProjectReferenceable(Project clientProject, Project targetProject) {
        AntArtifact jarArtifact;
        if (clientProject == targetProject) {
            return true;
        }
        ProjectClassPathExtender pce = (ProjectClassPathExtender)targetProject.getLookup().lookup(ProjectClassPathExtender.class);
        AntArtifactProvider antArtifactProvider = (AntArtifactProvider)clientProject.getLookup().lookup(AntArtifactProvider.class);
        return antArtifactProvider != null && (jarArtifact = JaxWsUtils.getJarArtifact(antArtifactProvider)) != null;
    }

    public static boolean addProjectReference(Project clientProject, Project targetProject) {
        block6: {
            try {
                assert (clientProject != null && targetProject != null);
                if (clientProject != targetProject) {
                    AntArtifact jarArtifact;
                    ProjectClassPathExtender pce = (ProjectClassPathExtender)targetProject.getLookup().lookup(ProjectClassPathExtender.class);
                    AntArtifactProvider antArtifactProvider = (AntArtifactProvider)clientProject.getLookup().lookup(AntArtifactProvider.class);
                    if (antArtifactProvider != null && (jarArtifact = JaxWsUtils.getJarArtifact(antArtifactProvider)) != null) {
                        URI[] artifactsUri = jarArtifact.getArtifactLocations();
                        for (int i = 0; i < artifactsUri.length; ++i) {
                            pce.addAntArtifact(jarArtifact, artifactsUri[i]);
                        }
                        return true;
                    }
                    break block6;
                }
                return true;
            }
            catch (IOException ex) {
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
            }
        }
        return false;
    }

    private static AntArtifact getJarArtifact(AntArtifactProvider antArtifactProvider) {
        AntArtifact[] artifacts = antArtifactProvider.getBuildArtifacts();
        for (int i = 0; i < artifacts.length; ++i) {
            if (!"jar".equals(artifacts[i].getType())) continue;
            return artifacts[i];
        }
        return null;
    }

    static {
        jwsdpSupported = false;
        jsr109Supported = false;
        wsitSupported = false;
    }

    public static class WsImportClientFailedMessage
    extends NotifyDescriptor.Message {
        public WsImportClientFailedMessage(Throwable ex) {
            super((Object)NbBundle.getMessage(JaxWsUtils.class, (String)"TXT_CannotGenerateClient", (Object)ex.getLocalizedMessage()), 0);
        }
    }

    public static class WsImportServiceFailedMessage
    extends NotifyDescriptor.Message {
        public WsImportServiceFailedMessage(Throwable ex) {
            super((Object)NbBundle.getMessage(JaxWsUtils.class, (String)"TXT_CannotGenerateService", (Object)ex.getLocalizedMessage()), 0);
        }
    }
}

