/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.client.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.DialogDescriptor;
import org.openide.util.NbBundle;

public class RefreshWsdlPanel
extends JPanel {
    public static final Color ErrorTextForegroundColor = new Color(89, 79, 191);
    private DialogDescriptor descriptor;
    private String wsdlSource;
    private boolean hasMultipleServices;
    private String[] serviceNames;
    private JLabel jLblDescription;
    private JLabel jLblError;
    private JLabel jLblMultipleServices;
    private JLabel jLblWsdlSource;
    private JTextField jTxtWsdlSource;

    public RefreshWsdlPanel(String wsdlSource, String[] supportedServices) {
        this.wsdlSource = wsdlSource;
        this.hasMultipleServices = supportedServices.length > 1;
        this.serviceNames = supportedServices;
        this.initComponents();
        this.initUserComponents();
    }

    private void initComponents() {
        this.jLblDescription = new JLabel();
        this.jLblWsdlSource = new JLabel();
        this.jTxtWsdlSource = new JTextField();
        this.jLblMultipleServices = new JLabel();
        this.jLblError = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jLblDescription.setText(NbBundle.getMessage(RefreshWsdlPanel.class, (String)"LBL_Description"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 11, 11, 11);
        this.add((Component)this.jLblDescription, gridBagConstraints);
        this.jLblWsdlSource.setLabelFor(this.jTxtWsdlSource);
        this.jLblWsdlSource.setText(NbBundle.getMessage(RefreshWsdlPanel.class, (String)"LBL_WsdlSource"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 11, 11, 0);
        this.add((Component)this.jLblWsdlSource, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 11, 11);
        this.add((Component)this.jTxtWsdlSource, gridBagConstraints);
        this.jLblMultipleServices.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 11, 0, 11);
        this.add((Component)this.jLblMultipleServices, gridBagConstraints);
        this.jLblError.setText("xxx");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 11, 11);
        this.add((Component)this.jLblError, gridBagConstraints);
    }

    private void initUserComponents() {
        this.jLblError.setForeground(ErrorTextForegroundColor);
        this.jTxtWsdlSource.setText(this.wsdlSource);
        this.jTxtWsdlSource.getDocument().addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent e) {
                RefreshWsdlPanel.this.updateWsdlSource();
            }

            public void insertUpdate(DocumentEvent e) {
                RefreshWsdlPanel.this.updateWsdlSource();
            }

            public void changedUpdate(DocumentEvent e) {
                RefreshWsdlPanel.this.updateWsdlSource();
            }
        });
        if (this.hasMultipleServices) {
            StringBuffer buf = new StringBuffer(16 + 16 * this.serviceNames.length);
            for (int i = 0; i < this.serviceNames.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(this.serviceNames[i]);
            }
            this.jLblMultipleServices.setText(NbBundle.getMessage(RefreshWsdlPanel.class, (String)"LBL_MultipleServiceWarning", (Object)buf.toString()));
        } else {
            this.jLblMultipleServices.setText(" ");
        }
    }

    public void addNotify() {
        super.addNotify();
        this.checkSettings();
    }

    private void updateWsdlSource() {
        this.wsdlSource = this.jTxtWsdlSource.getText();
        this.checkSettings();
    }

    public String getWsdlSource() {
        return this.wsdlSource;
    }

    public void setDescriptor(DialogDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    private boolean checkSettings() {
        String message = this.validateSettings();
        if (message != null) {
            this.jLblError.setText(message);
        } else {
            this.jLblError.setText(" ");
        }
        boolean isValid = message == null;
        this.descriptor.setValid(isValid);
        return isValid;
    }

    private String validateSettings() {
        String message = null;
        if (this.wsdlSource == null || this.wsdlSource.length() == 0) {
            message = NbBundle.getMessage(RefreshWsdlPanel.class, (String)"ERR_EnterSourceWsdlPath");
        } else if (this.wsdlSource.indexOf("://") != -1) {
            try {
                URL wsdlSourceUrl = new URL(this.wsdlSource);
            }
            catch (MalformedURLException ex) {
                message = NbBundle.getMessage(RefreshWsdlPanel.class, (String)"ERR_InvalidURL", (Object)ex.getLocalizedMessage());
            }
        } else {
            File wsdlSourceFile = new File(this.wsdlSource);
            if (!wsdlSourceFile.exists()) {
                message = NbBundle.getMessage(RefreshWsdlPanel.class, (String)"ERR_FileDoesNotExist");
            }
        }
        return message;
    }
}

