/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.client.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.Action;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.api.registry.WebServicesRegistryView;
import org.netbeans.modules.websvc.core.ServiceInformation;
import org.netbeans.modules.websvc.core.client.actions.RefreshServiceAction;
import org.netbeans.modules.websvc.core.client.nodes.ConfigureHandlerCookieImpl;
import org.netbeans.modules.websvc.core.webservices.action.ConfigureHandlerAction;
import org.netbeans.modules.websvc.core.webservices.action.ConfigureHandlerCookie;
import org.netbeans.modules.websvc.core.wseditor.support.EditWSAttributesCookie;
import org.netbeans.modules.websvc.core.wseditor.support.EditWSAttributesCookieImpl;
import org.netbeans.modules.websvc.core.wseditor.support.WSEditAttributesAction;
import org.netbeans.modules.websvc.wsdl.ServiceInformationImpl;
import org.openide.actions.DeleteAction;
import org.openide.actions.FindAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;

public class ServiceClientNode
extends FilterNode
implements PropertyChangeListener {
    private String serviceName;
    private Node registerNode;
    private DataObject dobj;

    public ServiceClientNode(Node wsdlNode, Node registerNode) {
        super(wsdlNode, (Children)(registerNode != null ? new FilterNode.Children(registerNode) : FilterNode.Children.LEAF));
        ServiceInformationImpl wsdlModel;
        String[] serviceNames;
        this.registerNode = registerNode;
        this.serviceName = null;
        this.dobj = (DataObject)wsdlNode.getCookie(DataObject.class);
        if (this.dobj != null && (serviceNames = (wsdlModel = new ServiceInformationImpl(this.dobj)).getServiceNames()) != null && serviceNames.length > 0) {
            this.serviceName = serviceNames[0];
        }
        WebServicesRegistryView registryView = (WebServicesRegistryView)Lookup.getDefault().lookup(WebServicesRegistryView.class);
        registryView.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void destroy() throws IOException {
        super.destroy();
        WebServicesRegistryView registryView = (WebServicesRegistryView)Lookup.getDefault().lookup(WebServicesRegistryView.class);
        registryView.removePropertyChangeListener((PropertyChangeListener)this);
    }

    public String getName() {
        return this.registerNode != null ? this.registerNode.getName() : super.getName();
    }

    public String getDisplayName() {
        return this.registerNode != null ? this.registerNode.getDisplayName() : super.getDisplayName();
    }

    public String getShortDescription() {
        return this.registerNode != null ? this.registerNode.getShortDescription() : "Unregistered service";
    }

    public Node.PropertySet[] getPropertySets() {
        return this.registerNode != null ? this.registerNode.getPropertySets() : new Node.PropertySet[]{};
    }

    public Image getIcon(int type) {
        Image wsdlIcon = super.getIcon(type);
        return this.registerNode != null ? this.registerNode.getIcon(type) : wsdlIcon;
    }

    public Image getOpenedIcon(int type) {
        Image wsdlOpenedIcon = super.getOpenedIcon(type);
        return this.registerNode != null ? this.registerNode.getOpenedIcon(type) : wsdlOpenedIcon;
    }

    public Action[] getActions(boolean context) {
        FileObject fo = this.dobj.getPrimaryFile();
        WebServicesClientSupport clientSupport = WebServicesClientSupport.getWebServicesClientSupport((FileObject)fo);
        if (clientSupport.getDeploymentDescriptor() == null) {
            return new Action[]{SystemAction.get(RefreshServiceAction.class), SystemAction.get(FindAction.class), null, SystemAction.get(DeleteAction.class), null, SystemAction.get(ToolsAction.class), null, SystemAction.get(PropertiesAction.class)};
        }
        return new Action[]{SystemAction.get(RefreshServiceAction.class), SystemAction.get(ConfigureHandlerAction.class), SystemAction.get(FindAction.class), null, SystemAction.get(WSEditAttributesAction.class), null, SystemAction.get(DeleteAction.class), null, SystemAction.get(ToolsAction.class), null, SystemAction.get(PropertiesAction.class)};
    }

    public Node.Cookie getCookie(Class type) {
        Node.Cookie result;
        if (type == ConfigureHandlerCookie.class) {
            FileObject fo = this.dobj.getPrimaryFile();
            Project project = FileOwnerQuery.getOwner((FileObject)fo);
            WebServicesClientSupport clientSupport = WebServicesClientSupport.getWebServicesClientSupport((FileObject)fo);
            if (clientSupport.getDeploymentDescriptor() != null) {
                return new ConfigureHandlerCookieImpl(this.serviceName, project, clientSupport, fo);
            }
        } else {
            if (type == EditWSAttributesCookie.class) {
                return new EditWSAttributesCookieImpl((Node)this, null);
            }
            if (type == ServiceInformation.class) {
                return new ServiceInformationImpl(this.dobj);
            }
        }
        if ((result = super.getCookie(type)) == null && this.registerNode != null) {
            result = this.registerNode.getCookie(type);
        }
        return result;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String removedServiceName;
        if ("webServiceAdded".equals(evt.getPropertyName())) {
            Node addedServiceNode;
            if (this.registerNode == null && this.serviceName != null && this.serviceName.equalsIgnoreCase((addedServiceNode = (Node)evt.getNewValue()).getName())) {
                this.registerNode = addedServiceNode;
                this.setChildren((Children)new FilterNode.Children(this.registerNode));
                this.fireIconChange();
            }
        } else if ("webServiceRemoved".equals(evt.getPropertyName()) && this.registerNode != null && this.serviceName != null && this.serviceName.equalsIgnoreCase(removedServiceName = (String)evt.getOldValue())) {
            this.registerNode = null;
            this.setChildren(FilterNode.Children.LEAF);
            this.fireIconChange();
        }
    }
}

