/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.client.actions;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.api.registry.WebServicesRegistryView;
import org.netbeans.modules.websvc.core.client.ui.DownloadWsdlPanel;
import org.netbeans.modules.websvc.core.client.ui.RefreshWsdlPanel;
import org.netbeans.modules.websvc.wsdl.ServiceInformationImpl;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class RefreshServiceAction
extends NodeAction {
    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return NbBundle.getMessage(RefreshServiceAction.class, (String)"LBL_RefreshWsdl");
    }

    protected void performAction(Node[] activatedNodes) {
        assert (activatedNodes != null && activatedNodes.length == 1);
        WebServicesClientSupport support = null;
        FileObject fo = null;
        DataObject dobj = (DataObject)activatedNodes[0].getLookup().lookup(DataObject.class);
        if (dobj != null) {
            fo = dobj.getPrimaryFile();
            support = WebServicesClientSupport.getWebServicesClientSupport((FileObject)fo);
        }
        final WebServicesClientSupport clientSupport = support;
        final FileObject wsdlFO = fo;
        if (clientSupport == null) {
            String mes = NbBundle.getMessage(RefreshServiceAction.class, (String)"ERR_NoClientSupport", (Object)activatedNodes[0]);
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            return;
        }
        ServiceInformationImpl wsdlModel = new ServiceInformationImpl(dobj);
        String[] supportedServices = wsdlModel.getServiceNames();
        final String wsdlName = dobj.getName();
        final String wsdlSource = clientSupport.getWsdlSource(wsdlName);
        final RefreshWsdlPanel refreshPanel = new RefreshWsdlPanel(wsdlSource, supportedServices);
        final DialogDescriptor descriptor = new DialogDescriptor((Object)refreshPanel, NbBundle.getMessage(RefreshServiceAction.class, (String)"LBL_RefreshWsdlForService"));
        refreshPanel.setDescriptor(descriptor);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                if (NotifyDescriptor.OK_OPTION.equals(descriptor.getValue())) {
                    String newWsdlSource = refreshPanel.getWsdlSource();
                    if (newWsdlSource.indexOf("://") != -1) {
                        RefreshServiceAction.this.refreshViaUrl(wsdlFO, newWsdlSource);
                    } else {
                        RefreshServiceAction.this.refreshViaFile(wsdlFO, newWsdlSource);
                    }
                    if (!newWsdlSource.equals(wsdlSource)) {
                        clientSupport.setWsdlSource(wsdlName, newWsdlSource);
                    }
                    WebServicesRegistryView registryView = (WebServicesRegistryView)Lookup.getDefault().lookup(WebServicesRegistryView.class);
                    registryView.registerService(wsdlFO, true);
                }
            }
        });
    }

    protected boolean asynchronous() {
        return false;
    }

    private void refreshViaUrl(FileObject wsdlFO, String url) {
        DownloadWsdlPanel downloadPanel = new DownloadWsdlPanel(url);
        DialogDescriptor descriptor = new DialogDescriptor((Object)downloadPanel, NbBundle.getMessage(RefreshServiceAction.class, (String)"LBL_DownloadWsdl"));
        downloadPanel.setDescriptor(descriptor);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        if (NotifyDescriptor.OK_OPTION.equals(descriptor.getValue())) {
            byte[] wsdlBuf = downloadPanel.getWsdl();
            FileObject tmpFO = this.writeTempWsdl(wsdlFO.getName(), wsdlBuf);
            if (tmpFO != null) {
                this.updateWsdl(wsdlFO, tmpFO);
                try {
                    tmpFO.delete();
                }
                catch (IOException ex) {
                    String message = NbBundle.getMessage(RefreshServiceAction.class, (String)"ERR_CannotDeleteTempWsdlFile", (Object)ex.getLocalizedMessage());
                    ErrorManager.getDefault().log(1, message);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject writeTempWsdl(String prefix, byte[] content) {
        FileObject tmpFO = null;
        try {
            tmpFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)File.createTempFile(prefix, "wsdl")));
            FileLock lock = tmpFO.lock();
            OutputStream out = null;
            try {
                out = tmpFO.getOutputStream(lock);
                try {
                    out.write(content);
                    out.flush();
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
            finally {
                lock.releaseLock();
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
        }
        return tmpFO;
    }

    private void refreshViaFile(FileObject wsdlFO, String path) {
        File normalizedFile = FileUtil.normalizeFile((File)new File(path));
        FileObject newWsdlFO = FileUtil.toFileObject((File)normalizedFile);
        if (newWsdlFO != null) {
            this.updateWsdl(wsdlFO, newWsdlFO);
        } else {
            String message = NbBundle.getMessage(RefreshServiceAction.class, (String)"ERR_CannotGetFileObject", (Object)normalizedFile.getPath());
            ErrorManager.getDefault().log(65536, message);
        }
    }

    private void updateWsdl(FileObject wsdlFO, FileObject newWsdlFO) {
        try {
            FileObject targetDir = wsdlFO.getParent();
            String name = wsdlFO.getName();
            String ext = wsdlFO.getExt();
            wsdlFO.delete();
            newWsdlFO.copy(targetDir, name, ext);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
        }
    }
}

