/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.util;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JPDAUtils {
    public static void printFeatures(VirtualMachine virtualMachine) {
        System.out.println("canAddMethod " + virtualMachine.canAddMethod());
        System.out.println("canGetBytecodes " + virtualMachine.canGetBytecodes());
        System.out.println("canGetCurrentContendedMonitor " + virtualMachine.canGetCurrentContendedMonitor());
        System.out.println("canGetMonitorInfo " + virtualMachine.canGetMonitorInfo());
        System.out.println("canGetOwnedMonitorInfo " + virtualMachine.canGetOwnedMonitorInfo());
        System.out.println("canGetSourceDebugExtension " + virtualMachine.canGetSourceDebugExtension());
        System.out.println("canGetSyntheticAttribute " + virtualMachine.canGetSyntheticAttribute());
        System.out.println("canPopFrames " + virtualMachine.canPopFrames());
        System.out.println("canRedefineClasses " + virtualMachine.canRedefineClasses());
        System.out.println("canRequestVMDeathEvent " + virtualMachine.canRequestVMDeathEvent());
        System.out.println("canUnrestrictedlyRedefineClasses " + virtualMachine.canUnrestrictedlyRedefineClasses());
        System.out.println("canUseInstanceFilters " + virtualMachine.canUseInstanceFilters());
        System.out.println("canWatchFieldAccess " + virtualMachine.canWatchFieldAccess());
        System.out.println("canWatchFieldModification " + virtualMachine.canWatchFieldModification());
    }

    public static void showMethods(ReferenceType rt) {
        System.out.println("  ============================================");
        System.out.println("  Methods for " + rt.name());
        List<Method> l = rt.methods();
        int k = l.size();
        for (int i = 0; i < k; ++i) {
            System.out.println(l.get(i).name() + " ; " + l.get(i).signature());
        }
        System.out.println("  ============================================");
    }

    public static void showLinesForClass(ReferenceType rt) {
        System.out.println("  ============================================");
        System.out.println("  Lines for " + rt.name());
        List<Location> l = null;
        try {
            l = rt.allLineLocations();
        }
        catch (AbsentInformationException e) {
            // empty catch block
        }
        int k = l.size();
        for (int i = 0; i < k; ++i) {
            System.out.println("   " + l.get(i).lineNumber() + " : " + l.get(i).codeIndex());
        }
        System.out.println("  ============================================");
    }

    public static void showRequests(EventRequestManager requestManager) {
        int i;
        System.out.println("  ============================================");
        List<EventRequest> l = requestManager.breakpointRequests();
        System.out.println("  Break request: " + l.size());
        int k = l.size();
        for (i = 0; i < k; ++i) {
            System.out.println("    " + l.get(i));
        }
        l = requestManager.classPrepareRequests();
        System.out.println("  Class prepare request: " + l.size());
        k = l.size();
        for (i = 0; i < k; ++i) {
            System.out.println("    " + l.get(i));
        }
        l = requestManager.accessWatchpointRequests();
        System.out.println("  Access watch request: " + l.size());
        k = l.size();
        for (i = 0; i < k; ++i) {
            System.out.println("    " + l.get(i));
        }
        l = requestManager.classUnloadRequests();
        System.out.println("  Class unload request: " + l.size());
        k = l.size();
        for (i = 0; i < k; ++i) {
            System.out.println("    " + l.get(i));
        }
        l = requestManager.exceptionRequests();
        System.out.println("  Exception request: " + l.size());
        k = l.size();
        for (i = 0; i < k; ++i) {
            System.out.println("    " + l.get(i));
        }
        l = requestManager.methodEntryRequests();
        System.out.println("  Method entry request: " + l.size());
        k = l.size();
        for (i = 0; i < k; ++i) {
            System.out.println("    " + l.get(i));
        }
        l = requestManager.methodExitRequests();
        System.out.println("  Method exit request: " + l.size());
        k = l.size();
        for (i = 0; i < k; ++i) {
            System.out.println("    " + l.get(i));
        }
        l = requestManager.modificationWatchpointRequests();
        System.out.println("  Modif watch request: " + l.size());
        k = l.size();
        for (i = 0; i < k; ++i) {
            System.out.println("    " + l.get(i));
        }
        l = requestManager.stepRequests();
        System.out.println("  Step request: " + l.size());
        k = l.size();
        for (i = 0; i < k; ++i) {
            System.out.println("    " + l.get(i));
        }
        l = requestManager.threadDeathRequests();
        System.out.println("  Thread death entry request: " + l.size());
        k = l.size();
        for (i = 0; i < k; ++i) {
            System.out.println("    " + l.get(i));
        }
        l = requestManager.threadStartRequests();
        System.out.println("  Thread start request: " + l.size());
        k = l.size();
        for (i = 0; i < k; ++i) {
            System.out.println("    " + l.get(i));
        }
        System.out.println("  ============================================");
    }

    public static void showConnectors(List l) {
        int k = l.size();
        for (int i = 0; i < k; ++i) {
            JPDAUtils.showConnector((Connector)l.get(i));
        }
    }

    public static void showConnector(Connector connector) {
        System.out.println("  ============================================");
        System.out.println("  Connector: " + connector);
        System.out.println("    name: " + connector.name());
        System.out.println("    description: " + connector.description());
        System.out.println("    transport: " + (connector.transport() != null ? connector.transport().name() : "null"));
        JPDAUtils.showProperties(connector.defaultArguments());
        System.out.println("  ============================================");
    }

    public static void showThread(ThreadReference tr) {
        System.out.println("  ============================================");
        try {
            System.out.println("  Thread: " + tr.name());
        }
        catch (Exception e) {
            System.out.println("  Thread: " + e);
        }
        try {
            System.out.println("    status: " + tr.status());
        }
        catch (Exception e) {
            System.out.println("    status: " + e);
        }
        try {
            System.out.println("    isSuspended: " + tr.isSuspended());
        }
        catch (Exception e) {
            System.out.println("    isSuspended: " + e);
        }
        try {
            System.out.println("    frameCount: " + tr.frameCount());
        }
        catch (Exception e) {
            System.out.println("    frameCount: " + e);
        }
        try {
            System.out.println("    location: " + tr.frame(0));
        }
        catch (Exception e) {
            System.out.println("    location: " + e);
        }
        System.out.println("  ============================================");
    }

    private static void showProperties(Map properties) {
        Iterator i = properties.keySet().iterator();
        while (i.hasNext()) {
            Object k = i.next();
            Connector.Argument a = (Connector.Argument)properties.get(k);
            System.out.println("    property: " + k + " > " + a.name());
            System.out.println("      desc: " + a.description());
            System.out.println("      mustSpecify: " + a.mustSpecify());
            System.out.println("      value: " + a.value());
        }
    }

    public static void listGroup(String s, ThreadGroupReference g) {
        int i;
        List<ObjectReference> l = g.threadGroups();
        int k = l.size();
        for (i = 0; i < k; ++i) {
            System.out.println(s + "Thread Group: " + l.get(i) + " : " + ((ThreadGroupReference)l.get(i)).name());
            JPDAUtils.listGroup(s + "  ", (ThreadGroupReference)l.get(i));
        }
        l = g.threads();
        k = l.size();
        for (i = 0; i < k; ++i) {
            System.out.println(s + "Thread: " + l.get(i) + " : " + ((ThreadReference)l.get(i)).name());
        }
    }

    private static void listGroups(List g) {
        System.out.println("  ============================================");
        int k = g.size();
        for (int i = 0; i < k; ++i) {
            System.out.println("Thread Group: " + g.get(i) + " : " + ((ThreadGroupReference)g.get(i)).name());
            JPDAUtils.listGroup("  ", (ThreadGroupReference)g.get(i));
        }
        System.out.println("  ============================================");
    }
}

