/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class ClassesTreeModel
implements TreeModel {
    private static boolean verbose = System.getProperty("netbeans.debugger.viewrefresh") != null && System.getProperty("netbeans.debugger.viewrefresh").indexOf(115) >= 0;
    private JPDADebuggerImpl debugger;
    private Listener listener;
    private Vector listeners = new Vector();
    private List classes = null;
    private List names = null;
    private HashMap cache = new HashMap();
    private Comparator comparator = new PackageComparator();
    private Comparator comparator1 = new ClassLoaderComparator();
    static final Integer NULL_CLASS_LOADER = new Integer(11);

    public ClassesTreeModel(ContextProvider lookupProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)lookupProvider.lookupFirst(null, JPDADebugger.class));
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object o, int from, int to) throws UnknownTypeException {
        try {
            Object[] r = null;
            if (o.equals("Root")) {
                r = this.getLoaders();
            } else if (o instanceof Object[]) {
                r = this.getChildren((Object[])o);
            } else if (o instanceof ClassLoaderReference) {
                r = this.getPackages((ClassLoaderReference)o);
            } else if (o == NULL_CLASS_LOADER) {
                r = this.getPackages(null);
            } else if (o instanceof ReferenceType) {
                r = ((ReferenceType)o).nestedTypes().toArray();
            } else {
                throw new UnknownTypeException(o);
            }
            to = Math.min(r.length, to);
            from = Math.min(r.length, from);
            Object[] rr = new Object[to - from];
            System.arraycopy(r, from, rr, 0, to - from);
            return rr;
        }
        catch (VMDisconnectedException ex) {
            return new Object[0];
        }
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        try {
            if (node.equals("Root")) {
                return this.getLoaders().length;
            }
            if (node instanceof Object[]) {
                return this.getChildren((Object[])node).length;
            }
            if (node instanceof ClassLoaderReference) {
                return this.getPackages((ClassLoaderReference)node).length;
            }
            if (node == NULL_CLASS_LOADER) {
                return this.getPackages(null).length;
            }
            if (node instanceof ReferenceType) {
                return ((ReferenceType)node).nestedTypes().size();
            }
            throw new UnknownTypeException(node);
        }
        catch (VMDisconnectedException ex) {
            return 0;
        }
    }

    public boolean isLeaf(Object o) throws UnknownTypeException {
        if (o.equals("Root")) {
            return false;
        }
        if (o instanceof Object[]) {
            return false;
        }
        if (o instanceof ReferenceType) {
            return false;
        }
        if (o instanceof ClassLoaderReference) {
            return false;
        }
        if (o == NULL_CLASS_LOADER) {
            return false;
        }
        throw new UnknownTypeException(o);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
        if (this.listener == null) {
            this.listener = new Listener(this, this.debugger);
        }
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
        if (this.listeners.size() == 0) {
            this.listener.destroy();
            this.listener = null;
        }
    }

    public void fireTreeChanged() {
        this.classes = null;
        this.names = null;
        this.cache = new HashMap();
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged(null);
        }
    }

    private List getNames() {
        if (this.classes == null) {
            VirtualMachine vm = this.debugger.getVirtualMachine();
            List<Object> referenceTypes = new ArrayList();
            if (vm != null) {
                referenceTypes = vm.allClasses();
            }
            int k = referenceTypes.size();
            this.names = new ArrayList();
            this.classes = new ArrayList();
            for (int i = 0; i < k; ++i) {
                ReferenceType rt = (ReferenceType)referenceTypes.get(i);
                if (rt instanceof ArrayType) continue;
                this.names.add(rt.name());
                this.classes.add(rt);
            }
        }
        return this.names;
    }

    private Object[] getLoaders() {
        Object[] ch = (Object[])this.cache.get(null);
        if (ch != null) {
            return ch;
        }
        List names = this.getNames();
        TreeSet<Object> loaders = new TreeSet<Object>(this.comparator1);
        int k = names.size();
        for (int i = 0; i < k; ++i) {
            try {
                String name = (String)names.get(i);
                ReferenceType rt = (ReferenceType)this.classes.get(i);
                ClassLoaderReference clr = rt.classLoader();
                if (clr == null) {
                    loaders.add(NULL_CLASS_LOADER);
                    continue;
                }
                if (clr.referenceType().name().equals("sun.reflect.DelegatingClassLoader")) continue;
                loaders.add(clr);
                continue;
            }
            catch (ObjectCollectedException ex) {
                // empty catch block
            }
        }
        ch = loaders.toArray();
        this.cache.put(null, ch);
        return ch;
    }

    private Object[] getPackages(ClassLoaderReference clr) {
        Object[] ch;
        Object[] objectArray = ch = clr == null ? (Object[])this.cache.get(NULL_CLASS_LOADER) : (Object[])this.cache.get(clr);
        if (ch != null) {
            return ch;
        }
        List names = this.getNames();
        TreeSet<Object> objects = new TreeSet<Object>(this.comparator);
        int k = names.size();
        for (int i = 0; i < k; ++i) {
            String name = (String)names.get(i);
            ReferenceType rt = (ReferenceType)this.classes.get(i);
            if (rt.classLoader() != clr) continue;
            int start = 0;
            int end = name.indexOf(46, start);
            if (end < 0) {
                if (name.indexOf(36, start) >= 0) continue;
                ReferenceType tr = (ReferenceType)this.classes.get(i);
                objects.add(tr);
                continue;
            }
            objects.add(new Object[]{name.substring(0, end), clr});
        }
        ch = objects.toArray();
        if (clr == null) {
            this.cache.put(NULL_CLASS_LOADER, ch);
        } else {
            this.cache.put(clr, ch);
        }
        return ch;
    }

    private Object[] getChildren(Object[] parent) {
        Object[] ch = (Object[])this.cache.get(parent);
        if (ch != null) {
            return ch;
        }
        List names = this.getNames();
        TreeSet<Object> objects = new TreeSet<Object>(this.comparator);
        int k = names.size();
        for (int i = 0; i < k; ++i) {
            String parentN;
            String name = (String)names.get(i);
            ReferenceType rt = (ReferenceType)this.classes.get(i);
            if (rt.classLoader() != parent[1] || !name.startsWith(parentN = (String)parent[0] + '.')) continue;
            int start = parentN.length();
            int end = name.indexOf(46, start);
            if (end < 0) {
                if (name.indexOf(36, start) >= 0) continue;
                objects.add(rt);
                continue;
            }
            objects.add(new Object[]{name.substring(0, end), rt.classLoader()});
        }
        ch = objects.toArray();
        this.cache.put(parent, ch);
        return ch;
    }

    JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    private static String shortName(String name) {
        int i = name.lastIndexOf(46);
        if (i < 0) {
            return name;
        }
        return name.substring(i + 1);
    }

    private static class ClassLoaderComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 == NULL_CLASS_LOADER) {
                if (o2 == NULL_CLASS_LOADER) {
                    return 0;
                }
                return -1;
            }
            if (o2 == NULL_CLASS_LOADER) {
                return 1;
            }
            return ((ClassLoaderReference)o1).toString().compareTo(((ClassLoaderReference)o2).toString());
        }
    }

    private static class PackageComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Object[]) {
                if (o2 instanceof Object[]) {
                    return ((String)((Object[])o1)[0]).compareTo(((Object[])o2)[0]);
                }
                return -1;
            }
            if (o2 instanceof Object[]) {
                return 1;
            }
            return ClassesTreeModel.shortName(((ReferenceType)o1).name()).compareTo(ClassesTreeModel.shortName(((ReferenceType)o2).name()));
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private JPDADebugger debugger;
        private WeakReference model;
        private RequestProcessor.Task task;

        public Listener(ClassesTreeModel tm, JPDADebugger debugger) {
            this.debugger = debugger;
            this.model = new WeakReference<ClassesTreeModel>(tm);
            debugger.addPropertyChangeListener((PropertyChangeListener)this);
        }

        void destroy() {
            this.debugger.removePropertyChangeListener((PropertyChangeListener)this);
            if (this.task != null) {
                this.task.cancel();
                if (verbose) {
                    System.out.println("ClTM cancel old task " + this.task);
                }
                this.task = null;
            }
        }

        private ClassesTreeModel getModel() {
            ClassesTreeModel tm = (ClassesTreeModel)this.model.get();
            if (tm == null) {
                this.destroy();
            }
            return tm;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void propertyChange(PropertyChangeEvent e) {
            block9: {
                block8: {
                    if (e.getPropertyName() == "currentCallStackFrame") break block8;
                    if (e.getPropertyName() != "state") break block9;
                }
                if (this.debugger.getState() == 3) {
                    final ClassesTreeModel ltm = this.getModel();
                    if (ltm == null) {
                        return;
                    }
                    if (this.task != null) {
                        this.task.cancel();
                        if (verbose) {
                            System.out.println("ClTM cancel old task " + this.task);
                        }
                        this.task = null;
                    }
                    this.task = RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            int n = Listener.this.debugger.getState();
                            Listener.this.debugger;
                            if (n != 3) {
                                if (verbose) {
                                    System.out.println("ClTM cancel started task " + Listener.this.task);
                                }
                                return;
                            }
                            if (verbose) {
                                System.out.println("ClTM do task " + Listener.this.task);
                            }
                            ltm.fireTreeChanged();
                        }
                    }, 500);
                    if (!verbose) return;
                    System.out.println("ClTM  create task " + this.task);
                    return;
                }
            }
            if (e.getPropertyName() != "state") return;
            if (this.debugger.getState() == 3) return;
            if (this.task == null) return;
            this.task.cancel();
            if (verbose) {
                System.out.println("ClTM cancel task " + this.task);
            }
            this.task = null;
        }
    }
}

