/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.Local;
import org.netbeans.modules.debugger.jpda.models.ThisVariable;

public class CallStackFrameImpl
implements CallStackFrame {
    private StackFrame sf;
    private int depth;
    private JPDADebuggerImpl debugger;
    private boolean valid;
    private Integer hashCode;

    public CallStackFrameImpl(StackFrame sf, int depth, JPDADebuggerImpl debugger) {
        this.sf = sf;
        this.depth = depth;
        this.debugger = debugger;
        this.valid = true;
    }

    public synchronized int getLineNumber(String struts) {
        if (!this.valid) {
            return 0;
        }
        try {
            return this.getStackFrame().location().lineNumber(struts);
        }
        catch (InvalidStackFrameException isfex) {
            this.valid = false;
            return 0;
        }
    }

    public synchronized String getMethodName() {
        if (!this.valid) {
            return "";
        }
        try {
            return this.getStackFrame().location().method().name();
        }
        catch (InvalidStackFrameException ex) {
            this.valid = false;
            return "";
        }
    }

    public synchronized String getClassName() {
        if (!this.valid) {
            return "";
        }
        try {
            return this.getStackFrame().location().declaringType().name();
        }
        catch (InvalidStackFrameException ex) {
            this.valid = false;
            return "";
        }
    }

    public synchronized String getDefaultStratum() {
        if (!this.valid) {
            return "";
        }
        try {
            return this.getStackFrame().location().declaringType().defaultStratum();
        }
        catch (InvalidStackFrameException ex) {
            this.valid = false;
            return "";
        }
    }

    public synchronized List getAvailableStrata() {
        if (!this.valid) {
            return Collections.EMPTY_LIST;
        }
        try {
            return this.getStackFrame().location().declaringType().availableStrata();
        }
        catch (InvalidStackFrameException ex) {
            this.valid = false;
            return Collections.EMPTY_LIST;
        }
    }

    public synchronized String getSourceName(String stratum) throws AbsentInformationException {
        if (!this.valid) {
            return "";
        }
        try {
            return this.getStackFrame().location().sourceName(stratum);
        }
        catch (InvalidStackFrameException ex) {
            this.valid = false;
            return "";
        }
    }

    public synchronized String getSourcePath(String stratum) throws AbsentInformationException {
        if (!this.valid) {
            return "";
        }
        try {
            return this.getStackFrame().location().sourcePath(stratum);
        }
        catch (InvalidStackFrameException ex) {
            this.valid = false;
            return "";
        }
    }

    public org.netbeans.api.debugger.jpda.LocalVariable[] getLocalVariables() throws AbsentInformationException {
        try {
            String className = this.getStackFrame().location().declaringType().name();
            List<LocalVariable> l = this.getStackFrame().visibleVariables();
            int n = l.size();
            org.netbeans.api.debugger.jpda.LocalVariable[] locals = new org.netbeans.api.debugger.jpda.LocalVariable[n];
            for (int i = 0; i < n; ++i) {
                LocalVariable lv = l.get(i);
                Value v = this.getStackFrame().getValue(lv);
                Local local = (Local)this.debugger.getLocalVariable(lv, v);
                local.setFrame(this);
                local.setInnerValue(v);
                local.setClassName(className);
                locals[i] = local;
            }
            return locals;
        }
        catch (NativeMethodException ex) {
            throw new AbsentInformationException("native method");
        }
        catch (InvalidStackFrameException ex) {
            throw new AbsentInformationException("thread is running");
        }
        catch (VMDisconnectedException ex) {
            return new org.netbeans.api.debugger.jpda.LocalVariable[0];
        }
    }

    public synchronized This getThisVariable() {
        ObjectReference thisR;
        if (!this.valid) {
            return null;
        }
        try {
            thisR = this.getStackFrame().thisObject();
        }
        catch (InvalidStackFrameException ex) {
            this.valid = false;
            return null;
        }
        if (thisR == null) {
            return null;
        }
        return new ThisVariable(this.debugger, thisR, "");
    }

    public void makeCurrent() {
        this.debugger.setCurrentCallStackFrame(this);
    }

    public synchronized boolean isObsolete() {
        return this.getStackFrame().location().method().isObsolete();
    }

    public boolean canPop() {
        if (!this.debugger.canPopFrames()) {
            return false;
        }
        ThreadReference t = this.getStackFrame().thread();
        try {
            if (t.frameCount() <= 1) {
                return false;
            }
            List<StackFrame> topFrames = t.frames(0, 2);
            if (topFrames.get(0).location().method().isNative() || topFrames.get(1).location().method().isNative()) {
                return false;
            }
        }
        catch (IncompatibleThreadStateException itsex) {
            return false;
        }
        return true;
    }

    public void popFrame() {
        this.debugger.popFrames(this.sf.thread(), this.getStackFrame());
    }

    public JPDAThread getThread() {
        return this.debugger.getThread(this.sf.thread());
    }

    public StackFrame getStackFrame() {
        return this.sf;
    }

    public int getFrameDepth() {
        return this.depth;
    }

    public boolean equals(Object o) {
        try {
            return o instanceof CallStackFrameImpl && this.sf.equals(((CallStackFrameImpl)o).sf);
        }
        catch (InvalidStackFrameException isfex) {
            return this.sf == ((CallStackFrameImpl)o).sf;
        }
    }

    public synchronized int hashCode() {
        if (this.hashCode == null) {
            try {
                this.hashCode = new Integer(this.sf.hashCode());
            }
            catch (InvalidStackFrameException isfex) {
                this.valid = false;
                this.hashCode = new Integer(super.hashCode());
            }
        }
        return this.hashCode;
    }
}

